/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.stream;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.recovery.CheckpointEnd;
import com.sleepycat.je.rep.impl.node.NameIdPair;
import com.sleepycat.je.rep.stream.MatchpointSearchResults;
import com.sleepycat.je.rep.stream.OutputWireRecord;
import com.sleepycat.je.rep.stream.VLSNReader;
import com.sleepycat.je.rep.vlsn.VLSNIndex;
import com.sleepycat.je.rep.vlsn.VLSNRange;
import com.sleepycat.je.txn.TxnCommit;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.VLSN;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ReplicaSyncupReader
extends VLSNReader {
    private boolean syncableSearch;
    private final LogEntry ckptEndLogEntry = LogEntryType.LOG_CKPT_END.getNewLogEntry();
    private final LogEntry commitLogEntry = LogEntryType.LOG_TXN_COMMIT.getNewLogEntry();
    private final MatchpointSearchResults searchResults;
    private final Logger logger;

    public ReplicaSyncupReader(EnvironmentImpl envImpl, VLSNIndex vlsnIndex, long endOfLogLsn, int readBufferSize, NameIdPair nameIdPair, VLSN startVLSN, long finishLsn, MatchpointSearchResults searchResults) throws IOException, DatabaseException {
        super(envImpl, vlsnIndex, false, endOfLogLsn, readBufferSize, nameIdPair, finishLsn);
        this.initScan(startVLSN, endOfLogLsn);
        this.searchResults = searchResults;
        this.logger = LoggerUtils.getLogger(this.getClass());
    }

    private void initScan(VLSN startVLSN, long endOfLogLsn) throws IOException {
        if (startVLSN.equals(VLSN.NULL_VLSN)) {
            throw EnvironmentFailureException.unexpectedState("ReplicaSyncupReader start can't be NULL_VLSN");
        }
        this.startLsn = endOfLogLsn;
        assert (this.startLsn != -1L);
        this.envImpl.getLogManager().flush();
        this.window.initAtFileStart(this.startLsn);
        this.currentEntryPrevOffset = this.window.getEndOffset();
        this.currentEntryOffset = this.window.getEndOffset();
        this.currentVLSN = startVLSN;
    }

    public OutputWireRecord scanBackwards(VLSN vlsn) throws DatabaseException {
        this.syncableSearch = false;
        VLSNRange range = this.vlsnIndex.getRange();
        if (vlsn.compareTo(range.getFirst()) < 0) {
            return null;
        }
        this.currentVLSN = vlsn;
        if (this.readNextEntry()) {
            return this.currentFeedRecord;
        }
        return null;
    }

    public OutputWireRecord findPrevSyncEntry() throws DatabaseException {
        this.currentFeedRecord = null;
        this.syncableSearch = true;
        this.currentVLSN = this.currentVLSN.getPrev();
        VLSNRange range = this.vlsnIndex.getRange();
        if (this.currentVLSN.compareTo(range.getFirst()) < 0) {
            return null;
        }
        if (!this.readNextEntry()) {
            return null;
        }
        assert (LogEntryType.isSyncPoint(this.currentFeedRecord.getEntryType())) : "Unexpected log type= " + this.currentFeedRecord;
        return this.currentFeedRecord;
    }

    private void checkForPassingTarget(int compareResult) {
        if (compareResult < 0) {
            throw EnvironmentFailureException.unexpectedState("want to read " + this.currentVLSN + " but reader at " + this.currentEntryHeader.getVLSN());
        }
    }

    protected boolean isTargetEntry() throws DatabaseException {
        if (this.logger.isLoggable(Level.FINEST)) {
            LoggerUtils.finest(this.logger, this.envImpl, " isTargetEntry " + this.currentEntryHeader);
        }
        ++this.nScanned;
        if (this.currentEntryHeader.isInvisible()) {
            return false;
        }
        byte currentType = this.currentEntryHeader.getType();
        if (this.entryIsReplicated()) {
            if (this.syncableSearch) {
                if (LogEntryType.isSyncPoint(currentType)) {
                    return true;
                }
                this.currentVLSN = this.currentEntryHeader.getVLSN().getPrev();
            } else {
                return true;
            }
        }
        return LogEntryType.LOG_CKPT_END.equalsType(currentType);
    }

    protected boolean processEntry(ByteBuffer entryBuffer) {
        byte currentType;
        if (this.logger.isLoggable(Level.FINEST)) {
            LoggerUtils.finest(this.logger, this.envImpl, " syncup reader saw " + this.currentEntryHeader);
        }
        if (LogEntryType.LOG_CKPT_END.equalsType(currentType = this.currentEntryHeader.getType())) {
            this.ckptEndLogEntry.readEntry(this.currentEntryHeader, entryBuffer, true);
            if (this.logger.isLoggable(Level.FINEST)) {
                LoggerUtils.finest(this.logger, this.envImpl, " syncup reader read " + this.currentEntryHeader + this.ckptEndLogEntry);
            }
            if (((CheckpointEnd)this.ckptEndLogEntry.getMainItem()).getCleanedFilesToDelete()) {
                this.searchResults.notePassedCheckpointEnd();
            }
            return false;
        }
        ByteBuffer buffer = entryBuffer.slice();
        buffer.limit(this.currentEntryHeader.getItemSize());
        this.currentFeedRecord = new OutputWireRecord(this.currentEntryHeader, buffer);
        if (LogEntryType.LOG_TXN_COMMIT.equalsType(currentType)) {
            this.commitLogEntry.readEntry(this.currentEntryHeader, entryBuffer, true);
            TxnCommit commit = (TxnCommit)this.commitLogEntry.getMainItem();
            this.searchResults.notePassedCommits(commit.getTime(), commit.getId(), this.currentEntryHeader.getVLSN(), this.getLastLsn());
            if (this.logger.isLoggable(Level.FINEST)) {
                LoggerUtils.finest(this.logger, this.envImpl, "syncup reader read " + this.currentEntryHeader + this.commitLogEntry);
            }
        } else {
            entryBuffer.position(entryBuffer.position() + this.currentEntryHeader.getItemSize());
        }
        if (this.syncableSearch) {
            return true;
        }
        int compareResult = this.currentEntryHeader.getVLSN().compareTo(this.currentVLSN);
        this.checkForPassingTarget(compareResult);
        return compareResult == 0;
    }
}

