/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.ssec.mcidas;

import edu.wisc.ssec.mcidas.AREAnav;
import edu.wisc.ssec.mcidas.McIDASUtil;

public final class RADRnav
extends AREAnav {
    private boolean isEastPositive = true;
    final double EARTH_RADIUS = 6371.23;
    final int MISS = -2139062144;
    int itype;
    double xrow;
    double xcol;
    double xlat;
    double xlon;
    double xrot;
    double xblat;
    double xblon;

    public RADRnav(int[] iparms) throws IllegalArgumentException {
        double xspace;
        if (iparms[0] != 1380009042) {
            throw new IllegalArgumentException("Invalid navigation type" + iparms[0]);
        }
        this.itype = 2;
        this.xrow = iparms[1];
        this.xcol = iparms[2];
        this.xlat = McIDASUtil.integerLatLonToDouble(iparms[3]);
        this.xlon = McIDASUtil.integerLatLonToDouble(iparms[4]);
        double yspace = xspace = (double)iparms[5] / 1000.0;
        if (iparms[7] != 0 && iparms[7] != -2139062144) {
            yspace = (double)iparms[7] / 1000.0;
        }
        this.xrot = -Math.PI / 180 * (double)iparms[6] / 1000.0;
        this.xblat = 111.19894090183831 / xspace;
        this.xblon = 111.19894090183831 / yspace;
    }

    public double[][] toLatLon(double[][] linele) {
        double[][] imglinele;
        int number = linele[0].length;
        double[][] latlon = imglinele = this.areaCoordToImageCoord(linele);
        for (int point = 0; point < number; ++point) {
            double xldif = this.xrow - imglinele[1][point];
            double xedif = this.xcol - imglinele[0][point];
            double xdis = Math.sqrt(xldif * xldif + xedif * xedif);
            if (xdis > 0.001) {
                double xangl = Math.atan2(xldif, xedif) - 1.5707963267948966;
                double xange = Math.atan2(xldif, xedif) + 1.5707963267948966;
                xldif = xdis * Math.cos(this.xrot + xangl);
                xedif = xdis * Math.sin(this.xrot + xange);
            }
            double ylat = this.xlat + xldif / this.xblat;
            double ylon = this.xlon + xedif / this.xblon / Math.cos(ylat * (Math.PI / 180));
            if (this.isEastPositive) {
                ylon = -ylon;
            }
            latlon[0][point] = ylat;
            latlon[1][point] = ylon;
        }
        return latlon;
    }

    public double[][] toLinEle(double[][] latlon) {
        int number = latlon[0].length;
        double[][] linele = new double[2][number];
        for (int point = 0; point < number; ++point) {
            double xrlon;
            double xedif;
            double xrlat;
            double xldif;
            double xdis;
            double zlon;
            if (Double.isNaN(latlon[0][point]) || Double.isNaN(latlon[1][point])) {
                linele[1][point] = Double.NaN;
                linele[0][point] = Double.NaN;
                continue;
            }
            double zlat = latlon[0][point];
            double d = zlon = this.isEastPositive ? -latlon[1][point] : latlon[1][point];
            if (zlon > 180.0) {
                zlon -= 360.0;
            }
            if (zlon < -180.0) {
                zlon += 360.0;
            }
            if ((xdis = Math.sqrt((xldif = this.xblat * (xrlat = zlat - this.xlat)) * xldif + (xedif = (xrlon = zlon - this.xlon) * this.xblon * Math.cos(zlat * (Math.PI / 180))) * xedif)) > 0.001) {
                double xangl = Math.atan2(xldif, xedif) - 1.5707963267948966;
                double xange = Math.atan2(xldif, xedif) + 1.5707963267948966;
                xldif = xdis * Math.cos(-this.xrot + xangl);
                xedif = xdis * Math.sin(-this.xrot + xange);
            }
            linele[1][point] = this.xrow - xldif;
            linele[0][point] = this.xcol - xedif;
        }
        return this.imageCoordToAreaCoord(linele, linele);
    }

    public float[][] toLatLon(float[][] linele) {
        float[][] imglinele;
        int number = linele[0].length;
        float[][] latlon = imglinele = this.areaCoordToImageCoord(linele);
        float[] lats = latlon[0];
        float[] lons = latlon[1];
        float[] lines = imglinele[1];
        float[] eles = imglinele[0];
        for (int point = 0; point < number; ++point) {
            double xldif = this.xrow - (double)lines[point];
            double xedif = this.xcol - (double)eles[point];
            double xdis = Math.sqrt(xldif * xldif + xedif * xedif);
            if (xdis > 0.001) {
                double xangl = Math.atan2(xldif, xedif) - 1.5707963267948966;
                double xange = Math.atan2(xldif, xedif) + 1.5707963267948966;
                xldif = xdis * Math.cos(this.xrot + xangl);
                xedif = xdis * Math.sin(this.xrot + xange);
            }
            double ylat = this.xlat + xldif / this.xblat;
            double ylon = this.xlon + xedif / this.xblon / Math.cos(ylat * (Math.PI / 180));
            if (this.isEastPositive) {
                ylon = -ylon;
            }
            lats[point] = (float)ylat;
            lons[point] = (float)ylon;
        }
        return latlon;
    }

    public float[][] toLinEle(float[][] latlon) {
        int number = latlon[0].length;
        float[][] linele = new float[2][number];
        float[] lines = linele[1];
        float[] eles = linele[0];
        float[] lats = latlon[0];
        float[] lons = latlon[1];
        for (int point = 0; point < number; ++point) {
            double xrlon;
            double xedif;
            double xrlat;
            double xldif;
            double xdis;
            double zlon;
            if (Float.isNaN(lats[point]) || Float.isNaN(lons[point])) {
                linele[1][point] = Float.NaN;
                linele[0][point] = Float.NaN;
                continue;
            }
            double zlat = lats[point];
            double d = zlon = this.isEastPositive ? (double)(-lons[point]) : (double)lons[point];
            if (zlon > 180.0) {
                zlon -= 360.0;
            }
            if (zlon < -180.0) {
                zlon += 360.0;
            }
            if ((xdis = Math.sqrt((xldif = this.xblat * (xrlat = zlat - this.xlat)) * xldif + (xedif = (xrlon = zlon - this.xlon) * this.xblon * Math.cos(zlat * (Math.PI / 180))) * xedif)) > 0.001) {
                double xangl = Math.atan2(xldif, xedif) - 1.5707963267948966;
                double xange = Math.atan2(xldif, xedif) + 1.5707963267948966;
                xldif = xdis * Math.cos(-this.xrot + xangl);
                xedif = xdis * Math.sin(-this.xrot + xange);
            }
            lines[point] = (float)(this.xrow - xldif);
            eles[point] = (float)(this.xcol - xedif);
        }
        return this.imageCoordToAreaCoord(linele, linele);
    }

    public boolean equals(Object o) {
        if (!(o instanceof RADRnav)) {
            return false;
        }
        RADRnav that = (RADRnav)o;
        return super.equals(o) && that.xlat == this.xlat && that.xlon == this.xlon && that.xrow == this.xrow && that.xcol == this.xcol;
    }
}

