/*
 * Decompiled with CFR 0.152.
 */
package ucar.multiarray;

import java.io.IOException;
import ucar.multiarray.AbstractAccessor;
import ucar.multiarray.MultiArray;
import ucar.multiarray.MultiArrayImpl;
import ucar.multiarray.MultiArrayProxy;
import ucar.multiarray.SliceMap;

public class StringCharAdapter
implements MultiArray {
    private final MultiArray delegate_;
    private final char fillValue_;
    private final int[] lengths_;
    private final int maxStringLen_;

    public StringCharAdapter(MultiArray delegate, char fillValue) {
        if (delegate.getComponentType() != Character.TYPE) {
            throw new IllegalArgumentException("Not a Character Array");
        }
        this.delegate_ = delegate;
        this.fillValue_ = fillValue;
        this.lengths_ = new int[this.delegate_.getRank() - 1];
        int[] dlengths = this.delegate_.getLengths();
        System.arraycopy(dlengths, 0, this.lengths_, 0, this.lengths_.length);
        this.maxStringLen_ = dlengths[this.lengths_.length];
    }

    public char getFillValue() {
        return this.fillValue_;
    }

    public Class getComponentType() {
        try {
            return Class.forName("java.lang.String");
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException("Implementation problem");
        }
    }

    public int getRank() {
        return this.lengths_.length;
    }

    public int[] getLengths() {
        if (this.isUnlimited()) {
            System.arraycopy(this.delegate_.getLengths(), 0, this.lengths_, 0, this.lengths_.length);
        }
        return (int[])this.lengths_.clone();
    }

    public boolean isUnlimited() {
        return this.delegate_.isUnlimited();
    }

    public boolean isScalar() {
        return 0 == this.getRank();
    }

    public Object get(int[] index) throws IOException {
        int ii;
        int[] dIndex = new int[this.lengths_.length + 1];
        System.arraycopy(index, 0, dIndex, 0, this.lengths_.length);
        char[] buf = new char[this.maxStringLen_];
        for (ii = 0; ii < this.maxStringLen_; ++ii) {
            dIndex[this.lengths_.length] = ii;
            buf[ii] = this.delegate_.getChar(dIndex);
            if (buf[ii] == this.fillValue_) break;
        }
        return new String(buf, 0, ii);
    }

    public boolean getBoolean(int[] index) {
        throw new IllegalArgumentException();
    }

    public char getChar(int[] index) throws IOException {
        if (index.length > this.lengths_.length) {
            return this.delegate_.getChar(index);
        }
        throw new IllegalArgumentException();
    }

    public byte getByte(int[] index) {
        throw new IllegalArgumentException();
    }

    public short getShort(int[] index) {
        throw new IllegalArgumentException();
    }

    public int getInt(int[] index) {
        throw new IllegalArgumentException();
    }

    public long getLong(int[] index) {
        throw new IllegalArgumentException();
    }

    public float getFloat(int[] index) {
        throw new IllegalArgumentException();
    }

    public double getDouble(int[] index) {
        throw new IllegalArgumentException();
    }

    public void set(int[] index, Object value) throws IOException {
        if (value instanceof String) {
            int[] dIndex = new int[this.lengths_.length + 1];
            System.arraycopy(index, 0, dIndex, 0, this.lengths_.length);
            String sValue = (String)value;
            int stringLen = ((String)value).length();
            for (int ii = 0; ii < this.maxStringLen_; ++ii) {
                dIndex[this.lengths_.length] = ii;
                if (ii >= stringLen) {
                    this.delegate_.setChar(dIndex, this.fillValue_);
                    continue;
                }
                this.delegate_.setChar(dIndex, ((String)value).charAt(ii));
            }
            return;
        }
        throw new IllegalArgumentException();
    }

    public void setBoolean(int[] index, boolean value) {
        throw new IllegalArgumentException();
    }

    public void setChar(int[] index, char value) {
        throw new IllegalArgumentException();
    }

    public void setByte(int[] index, byte value) {
        throw new IllegalArgumentException();
    }

    public void setShort(int[] index, short value) {
        throw new IllegalArgumentException();
    }

    public void setInt(int[] index, int value) {
        throw new IllegalArgumentException();
    }

    public void setLong(int[] index, long value) {
        throw new IllegalArgumentException();
    }

    public void setFloat(int[] index, float value) {
        throw new IllegalArgumentException();
    }

    public void setDouble(int[] index, double value) {
        throw new IllegalArgumentException();
    }

    public MultiArray copyout(int[] origin, int[] shape) throws IOException {
        int rank = this.getRank();
        if (origin.length != rank || shape.length != rank) {
            throw new IllegalArgumentException("Rank Mismatch");
        }
        MultiArrayImpl data = new MultiArrayImpl(this.getComponentType(), shape);
        AbstractAccessor.copyO(this, origin, data, shape);
        return data;
    }

    public void copyin(int[] origin, MultiArray data) throws IOException {
        int rank = this.getRank();
        if (origin.length != rank || data.getRank() != rank) {
            throw new IllegalArgumentException("Rank Mismatch");
        }
        if (data.getComponentType() != this.getComponentType()) {
            throw new ArrayStoreException();
        }
        AbstractAccessor.copy(data, data.getLengths(), this, origin);
    }

    public Object toArray() throws IOException {
        return this.toArray(null, null, null);
    }

    public Object getStorage() {
        return this.delegate_.getStorage();
    }

    public Object toArray(Object dst, int[] origin, int[] shape) throws IOException {
        int rank = this.getRank();
        if (origin == null) {
            origin = new int[rank];
        } else if (origin.length != rank) {
            throw new IllegalArgumentException("Rank Mismatch");
        }
        int[] shp = null;
        if (shape == null) {
            shp = this.getLengths();
        } else if (shape.length == rank) {
            shp = (int[])shape.clone();
        } else {
            throw new IllegalArgumentException("Rank Mismatch");
        }
        int[] products = new int[rank];
        int length = MultiArrayImpl.numberOfElements(shp, products);
        dst = MultiArrayImpl.fixDest(dst, length, this.getComponentType());
        MultiArrayImpl data = new MultiArrayImpl(shp, products, dst);
        AbstractAccessor.copyO(this, origin, data, shp);
        return dst;
    }

    private static String MultiArrayToString(MultiArray ma) {
        StringBuffer buf = new StringBuffer();
        int rank = ma.getRank();
        if (rank > 0) {
            buf.append("{\n\t");
            int[] dims = ma.getLengths();
            int last = dims[0] - 1;
            for (int ii = 0; ii <= last; ++ii) {
                MultiArrayProxy inner = new MultiArrayProxy(ma, new SliceMap(0, ii));
                buf.append(StringCharAdapter.MultiArrayToString(inner));
                if (ii == last) continue;
                buf.append(", ");
            }
            buf.append("\n}");
        } else {
            try {
                buf.append(ma.get(null));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return buf.toString();
    }

    public static void main(String[] args) {
        MultiArrayImpl cha = new MultiArrayImpl(Character.TYPE, new int[]{4, 5});
        StringCharAdapter sta = new StringCharAdapter(cha, '\u0000');
        int[] index = new int[]{0};
        try {
            sta.set(index, "KDEN");
            index[0] = index[0] + 1;
            sta.set(index, "KBOU");
            index[0] = index[0] + 1;
            sta.set(index, "KABQ");
            index[0] = index[0] + 1;
            sta.set(index, "KPHX");
            System.out.println(StringCharAdapter.MultiArrayToString(sta));
            System.out.println(StringCharAdapter.MultiArrayToString(cha));
        }
        catch (Exception ee) {
            // empty catch block
        }
    }
}

