/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.vlsn;

import com.sleepycat.je.log.LogItem;
import com.sleepycat.je.utilint.VLSN;
import java.lang.ref.SoftReference;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LogItemCache {
    private final int cacheSize;
    private final int sizeMask;
    private volatile SoftReference<AtomicReference<LogItem>[]> cacheReference = new SoftReference<Object>(null);

    LogItemCache(int cacheSize) {
        if (Integer.bitCount(cacheSize) != 1) {
            throw new IllegalArgumentException("Bad cache size: " + cacheSize + "; it must be a power of 2");
        }
        this.cacheSize = cacheSize;
        this.sizeMask = cacheSize - 1;
    }

    void put(VLSN vlsn, LogItem logItem) {
        this.getArray()[(int)vlsn.getSequence() & this.sizeMask].set(logItem);
    }

    LogItem get(VLSN vlsn) {
        LogItem item = this.getArray()[(int)vlsn.getSequence() & this.sizeMask].get();
        return item != null && item.getHeader().getVLSN().equals(vlsn) ? item : null;
    }

    void clear() {
        for (AtomicReference<LogItem> element : this.getArray()) {
            element.set(null);
        }
    }

    private final AtomicReference<LogItem>[] getArray() {
        AtomicReference<LogItem>[] array = this.cacheReference.get();
        if (array == null) {
            array = new AtomicReference[this.cacheSize];
            for (int i = 0; i < array.length; ++i) {
                array[i] = new AtomicReference();
            }
            this.cacheReference = new SoftReference<AtomicReference<LogItem>[]>(array);
        }
        return array;
    }
}

