/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.vis5d;

import java.io.IOException;
import java.util.Date;
import java.util.Hashtable;
import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.ma2.ArrayFloat;
import ucar.ma2.ArrayInt;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.iosp.AbstractIOServiceProvider;
import ucar.nc2.iosp.grid.GridDefRecord;
import ucar.nc2.iosp.grid.GridHorizCoordSys;
import ucar.nc2.iosp.grid.GridParameter;
import ucar.nc2.iosp.grid.GridRecord;
import ucar.nc2.iosp.grid.GridTableLookup;
import ucar.nc2.iosp.vis5d.V5DStruct;
import ucar.nc2.iosp.vis5d.Vis5DGridDefRecord;
import ucar.nc2.util.CancelTask;
import ucar.unidata.io.RandomAccessFile;
import visad.Set;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.vis5d.Vis5DCoordinateSystem;
import visad.data.vis5d.Vis5DVerticalSystem;

public class Vis5DIosp
extends AbstractIOServiceProvider {
    private V5DStruct v5dstruct;
    private static final String V5D = "V5D";
    private static final int MAXVARS = 200;
    private static final int MAXTIMES = 400;
    private static final int MAXROWS = 400;
    private static final int MAXCOLUMNS = 400;
    private static final int MAXLEVELS = 400;
    private static final String ROW = "row";
    private static final String COLUMN = "col";
    private static final String LEVEL = "lev";
    private static final String TIME = "time";
    private static final String LAT = "lat";
    private static final String LON = "lon";
    private final int MAXPROJARGS = 801;
    private final int MAXVERTARGS = 401;
    private static Hashtable<String, String> unitTable = null;
    private static Hashtable<Variable, Integer> varTable;

    @Override
    public boolean isValidFile(RandomAccessFile raf) throws IOException {
        V5DStruct vv;
        raf.order(0);
        raf.seek(0L);
        String got = raf.readString(V5D.length());
        if (got.equals(V5D)) {
            return true;
        }
        try {
            vv = V5DStruct.v5dOpenFile(raf);
        }
        catch (BadFormException bfe) {
            vv = null;
        }
        return vv != null;
    }

    @Override
    public String getFileTypeId() {
        return "Vis5D";
    }

    @Override
    public String getFileTypeDescription() {
        return "Vis5D grid file";
    }

    @Override
    public void open(RandomAccessFile raf, NetcdfFile ncfile, CancelTask cancelTask) throws IOException {
        super.open(raf, ncfile, cancelTask);
        if (unitTable == null) {
            Vis5DIosp.initUnitTable();
        }
        if (this.v5dstruct == null) {
            this.makeFile(raf, ncfile, cancelTask);
        }
    }

    private void makeFile(RandomAccessFile raf, NetcdfFile ncfile, CancelTask cancelTask) throws IOException {
        ncfile.empty();
        int[] sizes = new int[5];
        int[] map_proj = new int[1];
        String[] varnames = new String[200];
        String[] varunits = new String[200];
        int[] n_levels = new int[200];
        int[] vert_sys = new int[1];
        float[] vertargs = new float[401];
        double[] times = new double[400];
        float[] projargs = new float[801];
        try {
            this.v5dstruct = V5DStruct.v5d_open(raf, sizes, n_levels, varnames, varunits, map_proj, projargs, vert_sys, vertargs, times);
        }
        catch (BadFormException bfe) {
            throw new IOException("Vis5DIosp.makeFile: bad file " + bfe.getMessage());
        }
        if (sizes[0] < 1) {
            throw new IOException("Vis5DIosp.makeFile: bad file");
        }
        int nr = sizes[0];
        int nc = sizes[1];
        int nl = sizes[2];
        int ntimes = sizes[3];
        int nvars = sizes[4];
        Dimension time = new Dimension(TIME, ntimes, true);
        Dimension row = new Dimension(ROW, nr, true);
        Dimension col = new Dimension(COLUMN, nc, true);
        ncfile.addDimension(null, time);
        ncfile.addDimension(null, row);
        ncfile.addDimension(null, col);
        Variable timeVar = new Variable(ncfile, null, null, TIME);
        timeVar.setDataType(DataType.DOUBLE);
        timeVar.setDimensions(TIME);
        timeVar.addAttribute(new Attribute("units", "seconds since 1900-01-01 00:00:00"));
        timeVar.addAttribute(new Attribute("long_name", TIME));
        timeVar.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Time.toString()));
        Array varArray = new ArrayDouble.D1(ntimes);
        for (int i = 0; i < ntimes; ++i) {
            varArray.set(i, times[i]);
        }
        timeVar.setCachedData(varArray, false);
        ncfile.addVariable(null, timeVar);
        Variable rowVar = new Variable(ncfile, null, null, ROW);
        rowVar.setDataType(DataType.INT);
        rowVar.setDimensions(ROW);
        varArray = new ArrayInt.D1(nr);
        for (int i = 0; i < nr; ++i) {
            ((ArrayInt.D1)varArray).set(i, i);
        }
        rowVar.setCachedData(varArray, false);
        ncfile.addVariable(null, rowVar);
        Variable colVar = new Variable(ncfile, null, null, COLUMN);
        colVar.setDataType(DataType.INT);
        colVar.setDimensions(COLUMN);
        varArray = new ArrayInt.D1(nc);
        for (int i = 0; i < nc; ++i) {
            ((ArrayInt.D1)varArray).set(i, i);
        }
        colVar.setCachedData(varArray, false);
        ncfile.addVariable(null, colVar);
        Hashtable<Integer, Object> var_table = new Hashtable<Integer, Object>();
        boolean have3D = false;
        for (int i = 0; i < nvars; ++i) {
            int nlevs = n_levels[i];
            if (!have3D && nlevs > 1) {
                have3D = true;
            }
            var_table.put(nlevs, new Object());
        }
        int n_var_groups = var_table.size();
        if (n_var_groups > 2) {
            throw new IOException("Vis5DIosp.makeFile: more than two variable groups by n_levels");
        }
        if (n_var_groups == 0) {
            throw new IOException("Vis5DIosp.makeFile: number of variable groups == 0");
        }
        Variable vert = null;
        if (have3D) {
            Dimension lev = new Dimension(LEVEL, nl, true);
            ncfile.addDimension(null, lev);
            vert = this.makeVerticalVariable(vert_sys[0], nl, vertargs);
            if (vert != null) {
                ncfile.addVariable(null, vert);
            }
        }
        varTable = new Hashtable();
        String dim3D = "time lev col row";
        String dim2D = "time col row";
        String coords3D = "unknown";
        if (vert != null) {
            coords3D = "time Height lat lon";
        }
        String coords2D = "time lat lon";
        for (int i = 0; i < nvars; ++i) {
            Variable v = new Variable(ncfile, null, null, varnames[i]);
            if (n_levels[i] > 1) {
                v.setDimensions(dim3D);
                v.addAttribute(new Attribute("coordinates", coords3D));
            } else {
                v.setDimensions(dim2D);
                v.addAttribute(new Attribute("coordinates", coords2D));
            }
            v.setDataType(DataType.FLOAT);
            String units = varunits[i].trim();
            if (units.equals("")) {
                String key = varnames[i].trim().toLowerCase();
                units = unitTable.get(key);
            }
            if (units != null) {
                v.addAttribute(new Attribute("units", units));
            }
            if (varTable.get(v) != null) continue;
            varTable.put(v, i);
            ncfile.addVariable(null, v);
        }
        double[][] proj_args = Set.floatToDouble(new float[][]{projargs});
        this.addLatLonVariables(map_proj[0], proj_args[0], nr, nc);
        ncfile.addAttribute(null, new Attribute("Conventions", "CF-1.0"));
        ncfile.finish();
    }

    @Override
    public Array readData(Variable v2, Section section) throws IOException, InvalidRangeException {
        Integer varIdx = varTable.get(v2);
        if (varIdx == null) {
            throw new IOException("unable to find variable index");
        }
        int count = 0;
        int[] shape = v2.getShape();
        boolean haveZ = shape.length == 4;
        int nt = shape[count++];
        int nz = haveZ ? shape[count++] : 1;
        int ny = shape[count++];
        int nx = shape[count];
        count = 0;
        Array dataArray = Array.factory(DataType.FLOAT, section.getShape());
        Range timeRange = section.getRange(count++);
        Range zRange = haveZ ? section.getRange(count++) : null;
        Range yRange = section.getRange(count++);
        Range xRange = section.getRange(count);
        int grid_size = nx * ny * nz;
        IndexIterator ii = dataArray.getIndexIterator();
        for (int timeIdx = timeRange.first(); timeIdx <= timeRange.last(); timeIdx += timeRange.stride()) {
            int cnt;
            float[] data = new float[grid_size];
            float[] ranges = new float[2];
            try {
                this.v5dstruct.v5d_read(timeIdx, varIdx, ranges, data);
            }
            catch (BadFormException bfe) {
                throw new IOException("Vis5DIosp.readData: " + bfe.getMessage());
            }
            if (!((double)ranges[0] >= 9.9E29 && (double)ranges[1] <= -9.9E29 || !(ranges[0] > ranges[1]))) {
                throw new IOException("Vis5DIosp.readData: bad read " + v2.getFullName());
            }
            float[] tmp_data = new float[grid_size];
            if (zRange == null) {
                cnt = 0;
                for (int mm = 0; mm < ny; ++mm) {
                    int start = (mm + 1) * nx - 1;
                    for (int nn = 0; nn < nx; ++nn) {
                        tmp_data[cnt++] = data[start--];
                    }
                }
            } else {
                cnt = 0;
                for (int ll = 0; ll < nz; ++ll) {
                    for (int mm = 0; mm < ny; ++mm) {
                        int start = (mm + 1) * nx - 1 + nx * ny * ll;
                        for (int nn = 0; nn < nx; ++nn) {
                            tmp_data[cnt++] = data[start--];
                        }
                    }
                }
            }
            data = tmp_data;
            if (zRange != null) {
                for (int z = zRange.first(); z <= zRange.last(); z += zRange.stride()) {
                    for (int y = yRange.first(); y <= yRange.last(); y += yRange.stride()) {
                        for (int x = xRange.first(); x <= xRange.last(); x += xRange.stride()) {
                            int index = z * nx * ny + y * nx + x;
                            ii.setFloatNext(data[index]);
                        }
                    }
                }
                continue;
            }
            for (int y = yRange.first(); y <= yRange.last(); y += yRange.stride()) {
                for (int x = xRange.first(); x <= xRange.last(); x += xRange.stride()) {
                    int index = y * nx + x;
                    ii.setFloatNext(data[index]);
                }
            }
        }
        return dataArray;
    }

    @Override
    public void close() throws IOException {
        if (this.v5dstruct != null) {
            this.v5dstruct = null;
        }
        super.close();
    }

    private static void initUnitTable() {
        unitTable = new Hashtable();
        unitTable.put("t", "K");
        unitTable.put("td", "K");
        unitTable.put("thte", "K");
        unitTable.put("u", "m/s");
        unitTable.put("v", "m/s");
        unitTable.put("w", "m/s");
        unitTable.put("p", "hPa");
        unitTable.put("mmsl", "hPa");
        unitTable.put("rh", "%");
        unitTable.put("rhfz", "%");
        unitTable.put("zagl", "m");
    }

    private Variable makeVerticalVariable(int vert_sys, int n_levels, float[] vert_args) throws IOException {
        String vert_type;
        String vert_unit = null;
        ArrayFloat.D1 data = new ArrayFloat.D1(n_levels);
        AxisType axisType = null;
        switch (vert_sys) {
            case 0: {
                vert_unit = null;
                vert_type = "height";
                break;
            }
            case 1: 
            case 2: {
                vert_unit = "km";
                vert_type = "altitude";
                axisType = AxisType.Height;
                break;
            }
            case 3: {
                vert_unit = "mbar";
                vert_type = "pressure";
                axisType = AxisType.Pressure;
                break;
            }
            default: {
                throw new IOException("vert_sys unknown");
            }
        }
        Variable vertVar = new Variable(this.ncfile, null, null, vert_type);
        vertVar.setDimensions(LEVEL);
        vertVar.setDataType(DataType.FLOAT);
        if (vert_unit != null) {
            vertVar.addAttribute(new Attribute("units", vert_unit));
        }
        if (axisType != null) {
            vertVar.addAttribute(new Attribute("_CoordinateAxisType", axisType.toString()));
        }
        switch (vert_sys) {
            case 0: 
            case 1: {
                for (int i = 0; i < n_levels; ++i) {
                    data.set(i, vert_args[0] + vert_args[1] * (float)i);
                }
                break;
            }
            case 2: {
                for (int i = 0; i < n_levels; ++i) {
                    data.set(i, vert_args[i]);
                }
                break;
            }
            case 3: {
                try {
                    Vis5DVerticalSystem.Vis5DVerticalCoordinateSystem vert_cs = new Vis5DVerticalSystem.Vis5DVerticalCoordinateSystem();
                    float[][] pressures = new float[1][n_levels];
                    System.arraycopy(vert_args, 0, pressures[0], 0, n_levels);
                    int i = 0;
                    while (i < n_levels) {
                        float[] fArray = pressures[0];
                        int n = i++;
                        fArray[n] = fArray[n] * 1000.0f;
                    }
                    pressures = vert_cs.fromReference(pressures);
                    for (i = 0; i < n_levels; ++i) {
                        data.set(i, pressures[0][i]);
                    }
                    break;
                }
                catch (VisADException ve) {
                    throw new IOException("unable to make vertical system");
                }
            }
        }
        vertVar.setCachedData(data, false);
        return vertVar;
    }

    private void addLatLonVariables(int map_proj, double[] proj_args, int nr, int nc) throws IOException {
        Vis5DGridDefRecord vgd = new Vis5DGridDefRecord(map_proj, proj_args, nr, nc);
        GridHorizCoordSys ghc = new GridHorizCoordSys(vgd, new Vis5DLookup(), null);
        try {
            Vis5DCoordinateSystem coord_sys = new Vis5DCoordinateSystem(map_proj, proj_args, nr, nc);
            Variable lat = new Variable(this.ncfile, null, null, LAT);
            lat.setDimensions("col row");
            lat.setDataType(DataType.DOUBLE);
            lat.addAttribute(new Attribute("long_name", "latitude"));
            lat.addAttribute(new Attribute("units", "degrees_north"));
            lat.addAttribute(new Attribute("standard_name", "latitude"));
            lat.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lat.toString()));
            this.ncfile.addVariable(null, lat);
            Variable lon = new Variable(this.ncfile, null, null, LON);
            lon.setDimensions("col row");
            lon.setDataType(DataType.DOUBLE);
            lon.addAttribute(new Attribute("units", "degrees_east"));
            lon.addAttribute(new Attribute("long_name", "longitude"));
            lon.addAttribute(new Attribute("standard_name", "longitude"));
            lon.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lon.toString()));
            this.ncfile.addVariable(null, lon);
            int[] shape = new int[]{nc, nr};
            Array latArray = Array.factory(DataType.DOUBLE, shape);
            Array lonArray = Array.factory(DataType.DOUBLE, shape);
            double[][] rowcol = new double[2][nr * nc];
            for (int x = 0; x < nc; ++x) {
                for (int y = 0; y < nr; ++y) {
                    int index = x * nr + y;
                    rowcol[0][index] = y;
                    rowcol[1][index] = x;
                }
            }
            double[][] latlon = coord_sys.toReference(rowcol);
            Index latIndex = latArray.getIndex();
            Index lonIndex = lonArray.getIndex();
            for (int x = 0; x < nc; ++x) {
                for (int y = 0; y < nr; ++y) {
                    int index = x * nr + y;
                    latArray.setDouble(index, latlon[0][index]);
                    lonArray.setDouble(index, latlon[1][index]);
                }
            }
            lat.setCachedData(latArray, false);
            lon.setCachedData(lonArray, false);
        }
        catch (VisADException ve) {
            throw new IOException("Vis5DIosp.addLatLon: " + ve.getMessage());
        }
    }

    public static class Vis5DLookup
    implements GridTableLookup {
        @Override
        public String getShapeName(GridDefRecord gds) {
            return "Spherical";
        }

        @Override
        public final String getGridName(GridDefRecord gds) {
            return gds.toString();
        }

        @Override
        public final GridParameter getParameter(GridRecord gr) {
            return null;
        }

        @Override
        public final String getDisciplineName(GridRecord gr) {
            return "Meteorological Products";
        }

        @Override
        public final String getCategoryName(GridRecord gr) {
            return "Meteorological Parameters";
        }

        @Override
        public final String getLevelName(GridRecord gr) {
            return null;
        }

        @Override
        public final String getLevelDescription(GridRecord gr) {
            return null;
        }

        @Override
        public final String getLevelUnit(GridRecord gr) {
            return null;
        }

        @Override
        public final String getTimeRangeUnitName(int tunit) {
            return "second";
        }

        @Override
        public final Date getFirstBaseTime() {
            return new Date();
        }

        @Override
        public final boolean isLatLon(GridDefRecord gds) {
            return this.getProjectionName(gds).equals("GENERIC") || this.getProjectionName(gds).equals("LINEAR") || this.getProjectionName(gds).equals("CYLINDRICAL") || this.getProjectionName(gds).equals("SPHERICAL");
        }

        @Override
        public final int getProjectionType(GridDefRecord gds) {
            String name;
            switch (name = this.getProjectionName(gds).trim()) {
                case "LAMBERT": {
                    return 2;
                }
                case "STEREO": {
                    return 1;
                }
            }
            return -1;
        }

        @Override
        public final boolean isVerticalCoordinate(GridRecord gr) {
            return false;
        }

        @Override
        public final boolean isPositiveUp(GridRecord gr) {
            return false;
        }

        @Override
        public final float getFirstMissingValue() {
            return -9999.0f;
        }

        @Override
        public boolean isLayer(GridRecord gr) {
            return false;
        }

        private String getProjectionName(GridDefRecord gds) {
            return gds.getParam("ProjFlag");
        }

        @Override
        public final String getTitle() {
            return "GRID data";
        }

        @Override
        public String getInstitution() {
            return null;
        }

        @Override
        public final String getSource() {
            return null;
        }

        @Override
        public final String getComment() {
            return null;
        }

        @Override
        public String getGridType() {
            return "Vis5D";
        }
    }
}

