/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.lang;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class Coerce {
    static final Set CAN_COERCE;

    public static boolean canCoerce(Class cl) {
        return CAN_COERCE.contains(cl);
    }

    public static boolean canCoerce(Object o) {
        return Coerce.canCoerce(o.getClass());
    }

    public static int toInt(String s2) {
        try {
            return Integer.parseInt(s2);
        }
        catch (NumberFormatException e) {
            return (int)Double.parseDouble(s2);
        }
    }

    public static long toLong(String s2) {
        try {
            return Long.parseLong(s2);
        }
        catch (NumberFormatException e) {
            return (long)Double.parseDouble(s2);
        }
    }

    public static float toFloat(String s2) {
        return Float.parseFloat(s2);
    }

    public static double toDouble(String s2) {
        return Double.parseDouble(s2);
    }

    public static byte toByte(String s2) {
        return (byte)Coerce.toInt(s2);
    }

    public static short toShort(String s2) {
        return (short)Coerce.toInt(s2);
    }

    public static boolean toBoolean(String s2) {
        return Boolean.valueOf(s2);
    }

    public static char toChar(String s2) {
        if ((s2 = s2.trim()).length() == 1) {
            return s2.charAt(0);
        }
        return (char)Coerce.toInt(s2);
    }

    public static Object toObject(String s2, Class type) {
        if (type == Byte.TYPE) {
            type = Byte.class;
        } else if (type == Boolean.TYPE) {
            type = Boolean.class;
        } else if (type == Character.TYPE) {
            type = Character.class;
        } else if (type == Short.TYPE) {
            type = Short.class;
        } else if (type == Integer.TYPE) {
            type = Integer.class;
        } else if (type == Long.TYPE) {
            type = Long.class;
        } else if (type == Float.TYPE) {
            type = Float.class;
        } else if (type == Double.TYPE) {
            type = Double.class;
        }
        if (type == String.class) {
            return s2;
        }
        if (type == Byte.class) {
            return new Byte(Coerce.toByte(s2));
        }
        if (type == Boolean.class) {
            return Boolean.valueOf(s2);
        }
        if (type == Character.class) {
            return new Character(Coerce.toChar(s2));
        }
        if (type == Short.class) {
            return new Short(Coerce.toShort(s2));
        }
        if (type == Integer.class) {
            return new Integer(s2);
        }
        if (type == Long.class) {
            return new Long(s2);
        }
        if (type == Float.class) {
            return new Float(s2);
        }
        if (type == Double.class) {
            return new Double(s2);
        }
        throw new IllegalArgumentException("Cannot coerce to type: " + type.getName());
    }

    private Coerce() {
    }

    static {
        Class[] classes = new Class[]{Byte.TYPE, Boolean.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, String.class, Byte.class, Boolean.class, Character.class, Short.class, Integer.class, Long.class, Float.class, Double.class};
        HashSet<Class> tmp = new HashSet<Class>();
        tmp.addAll(Arrays.asList(classes));
        CAN_COERCE = Collections.unmodifiableSet(tmp);
    }
}

