/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.log;

import com.mchange.lang.ThrowableUtils;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public final class FallbackMLog
extends MLog {
    static final MLevel DEFAULT_CUTOFF_LEVEL;
    MLogger logger = new FallbackMLogger();

    public synchronized MLogger getMLogger(String name) {
        return this.logger;
    }

    public MLogger getMLogger(Class cl) {
        return FallbackMLog.getLogger(cl.getName());
    }

    public MLogger getMLogger() {
        return this.logger;
    }

    static {
        MLevel dflt = null;
        String dfltName = MLog.CONFIG.getProperty("com.mchange.v2.log.FallbackMLog.DEFAULT_CUTOFF_LEVEL");
        if (dfltName != null) {
            dflt = MLevel.fromSeverity(dfltName);
        }
        if (dflt == null) {
            dflt = MLevel.INFO;
        }
        DEFAULT_CUTOFF_LEVEL = dflt;
    }

    private static final class FallbackMLogger
    implements MLogger {
        MLevel cutoffLevel = DEFAULT_CUTOFF_LEVEL;

        private FallbackMLogger() {
        }

        private void formatrb(MLevel l, String srcClass, String srcMeth, String rbname, String msg, Object[] params, Throwable t) {
            String check;
            ResourceBundle rb = ResourceBundle.getBundle(rbname);
            if (msg != null && rb != null && (check = rb.getString(msg)) != null) {
                msg = check;
            }
            this.format(l, srcClass, srcMeth, msg, params, t);
        }

        private void format(MLevel l, String srcClass, String srcMeth, String msg, Object[] params, Throwable t) {
            System.err.println(this.formatString(l, srcClass, srcMeth, msg, params, t));
        }

        private String formatString(MLevel l, String srcClass, String srcMeth, String msg, Object[] params, Throwable t) {
            boolean add_parens = srcMeth != null && !srcMeth.endsWith(")");
            StringBuffer sb = new StringBuffer(256);
            sb.append(l.getLineHeader());
            sb.append(' ');
            if (srcClass != null && srcMeth != null) {
                sb.append('[');
                sb.append(srcClass);
                sb.append('.');
                sb.append(srcMeth);
                if (add_parens) {
                    sb.append("()");
                }
                sb.append(']');
            } else if (srcClass != null) {
                sb.append('[');
                sb.append(srcClass);
                sb.append(']');
            } else if (srcMeth != null) {
                sb.append('[');
                sb.append(srcMeth);
                if (add_parens) {
                    sb.append("()");
                }
                sb.append(']');
            }
            if (msg == null) {
                if (params != null) {
                    sb.append("params: ");
                    int len = params.length;
                    for (int i = 0; i < len; ++i) {
                        if (i != 0) {
                            sb.append(", ");
                        }
                        sb.append(params[i]);
                    }
                }
            } else if (params == null) {
                sb.append(msg);
            } else {
                MessageFormat mfmt = new MessageFormat(msg);
                sb.append(mfmt.format(params));
            }
            if (t != null) {
                sb.append(ThrowableUtils.extractStackTrace(t));
            }
            return sb.toString();
        }

        public ResourceBundle getResourceBundle() {
            return null;
        }

        public String getResourceBundleName() {
            return null;
        }

        public void setFilter(Object java14Filter) throws SecurityException {
            this.warning("Using FallbackMLog -- Filters not supported!");
        }

        public Object getFilter() {
            return null;
        }

        public void log(MLevel l, String msg) {
            if (this.isLoggable(l)) {
                this.format(l, null, null, msg, null, null);
            }
        }

        public void log(MLevel l, String msg, Object param) {
            if (this.isLoggable(l)) {
                this.format(l, null, null, msg, new Object[]{param}, null);
            }
        }

        public void log(MLevel l, String msg, Object[] params) {
            if (this.isLoggable(l)) {
                this.format(l, null, null, msg, params, null);
            }
        }

        public void log(MLevel l, String msg, Throwable t) {
            if (this.isLoggable(l)) {
                this.format(l, null, null, msg, null, t);
            }
        }

        public void logp(MLevel l, String srcClass, String srcMeth, String msg) {
            if (this.isLoggable(l)) {
                this.format(l, srcClass, srcMeth, msg, null, null);
            }
        }

        public void logp(MLevel l, String srcClass, String srcMeth, String msg, Object param) {
            if (this.isLoggable(l)) {
                this.format(l, srcClass, srcMeth, msg, new Object[]{param}, null);
            }
        }

        public void logp(MLevel l, String srcClass, String srcMeth, String msg, Object[] params) {
            if (this.isLoggable(l)) {
                this.format(l, srcClass, srcMeth, msg, params, null);
            }
        }

        public void logp(MLevel l, String srcClass, String srcMeth, String msg, Throwable t) {
            if (this.isLoggable(l)) {
                this.format(l, srcClass, srcMeth, msg, null, t);
            }
        }

        public void logrb(MLevel l, String srcClass, String srcMeth, String rb, String msg) {
            if (this.isLoggable(l)) {
                this.formatrb(l, srcClass, srcMeth, rb, msg, null, null);
            }
        }

        public void logrb(MLevel l, String srcClass, String srcMeth, String rb, String msg, Object param) {
            if (this.isLoggable(l)) {
                this.formatrb(l, srcClass, srcMeth, rb, msg, new Object[]{param}, null);
            }
        }

        public void logrb(MLevel l, String srcClass, String srcMeth, String rb, String msg, Object[] params) {
            if (this.isLoggable(l)) {
                this.formatrb(l, srcClass, srcMeth, rb, msg, params, null);
            }
        }

        public void logrb(MLevel l, String srcClass, String srcMeth, String rb, String msg, Throwable t) {
            if (this.isLoggable(l)) {
                this.formatrb(l, srcClass, srcMeth, rb, msg, null, t);
            }
        }

        public void entering(String srcClass, String srcMeth) {
            if (this.isLoggable(MLevel.FINER)) {
                this.format(MLevel.FINER, srcClass, srcMeth, "Entering method.", null, null);
            }
        }

        public void entering(String srcClass, String srcMeth, Object param) {
            if (this.isLoggable(MLevel.FINER)) {
                this.format(MLevel.FINER, srcClass, srcMeth, "Entering method with argument " + param, null, null);
            }
        }

        public void entering(String srcClass, String srcMeth, Object[] params) {
            if (this.isLoggable(MLevel.FINER)) {
                if (params == null) {
                    this.entering(srcClass, srcMeth);
                } else {
                    StringBuffer sb = new StringBuffer(128);
                    sb.append("( ");
                    int len = params.length;
                    for (int i = 0; i < len; ++i) {
                        if (i != 0) {
                            sb.append(", ");
                        }
                        sb.append(params[i]);
                    }
                    sb.append(" )");
                    this.format(MLevel.FINER, srcClass, srcMeth, "Entering method with arguments " + sb.toString(), null, null);
                }
            }
        }

        public void exiting(String srcClass, String srcMeth) {
            if (this.isLoggable(MLevel.FINER)) {
                this.format(MLevel.FINER, srcClass, srcMeth, "Exiting method.", null, null);
            }
        }

        public void exiting(String srcClass, String srcMeth, Object result) {
            if (this.isLoggable(MLevel.FINER)) {
                this.format(MLevel.FINER, srcClass, srcMeth, "Exiting method with result " + result, null, null);
            }
        }

        public void throwing(String srcClass, String srcMeth, Throwable t) {
            if (this.isLoggable(MLevel.FINE)) {
                this.format(MLevel.FINE, srcClass, srcMeth, "Throwing exception.", null, t);
            }
        }

        public void severe(String msg) {
            if (this.isLoggable(MLevel.SEVERE)) {
                this.format(MLevel.SEVERE, null, null, msg, null, null);
            }
        }

        public void warning(String msg) {
            if (this.isLoggable(MLevel.WARNING)) {
                this.format(MLevel.WARNING, null, null, msg, null, null);
            }
        }

        public void info(String msg) {
            if (this.isLoggable(MLevel.INFO)) {
                this.format(MLevel.INFO, null, null, msg, null, null);
            }
        }

        public void config(String msg) {
            if (this.isLoggable(MLevel.CONFIG)) {
                this.format(MLevel.CONFIG, null, null, msg, null, null);
            }
        }

        public void fine(String msg) {
            if (this.isLoggable(MLevel.FINE)) {
                this.format(MLevel.FINE, null, null, msg, null, null);
            }
        }

        public void finer(String msg) {
            if (this.isLoggable(MLevel.FINER)) {
                this.format(MLevel.FINER, null, null, msg, null, null);
            }
        }

        public void finest(String msg) {
            if (this.isLoggable(MLevel.FINEST)) {
                this.format(MLevel.FINEST, null, null, msg, null, null);
            }
        }

        public void setLevel(MLevel l) throws SecurityException {
            this.cutoffLevel = l;
        }

        public synchronized MLevel getLevel() {
            return this.cutoffLevel;
        }

        public synchronized boolean isLoggable(MLevel l) {
            return l.intValue() >= this.cutoffLevel.intValue();
        }

        public String getName() {
            return "global";
        }

        public void addHandler(Object h2) throws SecurityException {
            this.warning("Using FallbackMLog -- Handlers not supported.");
        }

        public void removeHandler(Object h2) throws SecurityException {
            this.warning("Using FallbackMLog -- Handlers not supported.");
        }

        public Object[] getHandlers() {
            this.warning("Using FallbackMLog -- Handlers not supported.");
            return new Object[0];
        }

        public void setUseParentHandlers(boolean uph) {
            this.warning("Using FallbackMLog -- Handlers not supported.");
        }

        public boolean getUseParentHandlers() {
            return false;
        }
    }
}

