/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.jmx.plugin;

import com.sleepycat.je.jmx.plugin.JEStats;
import com.sleepycat.je.jmx.plugin.StatsSwingWorker;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.ToolTipManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import sun.tools.jconsole.Plotter;
import sun.tools.jconsole.PlotterPanel;
import sun.tools.jconsole.TimeComboBox;

public abstract class Stats
extends JPanel {
    private static final long serialVersionUID = 6041540234044035106L;
    private static final String STATS_COLLECTOR = "JEMonitor Stats Collector";
    private boolean hideZeroValue = false;
    private boolean doLog = false;
    private int mBeansNum;
    private int selectedRow = -1;
    private long statsIntervalMillis = 10000L;
    private Map<ObjectName, LogObject> logMap;
    private Map<String, Boolean> shownStats;
    private Map<ObjectName, Map<String, String>> valueStore;
    private List<GraphFrame> frameList;
    protected TreeMap<String, ObjectName> comboToObjects;
    private Map<ObjectName, Map<String, String>> savedStats;
    private volatile List<ObjectName> savedObjectNames;
    private final int mBeanComboBoxLength = 50;
    private JComboBox mBeansComboBox;
    private ActionListener mBeanComboBoxListener;
    private JCheckBox hideZeroValueBox;
    private JCheckBox cumulativeStatsBox;
    private JTextField statsIntervalText;
    private JButton saveLogButton;
    private JButton startLogButton;
    private JButton stopLogButton;
    private SaveLogFileChooser fileChooser;
    private JTable statsTable;
    private StatsTableModel statsModel;
    private JPopupMenu popup;
    private JCheckBoxMenuItem logMenuItem;
    private JMenuItem graphMenuItem;
    private final Object[] envStatParams = new Object[]{true, true};
    private final String[] signature = new String[]{"java.lang.boolean", "java.lang.boolean"};
    protected static MBeanServerConnection connection;
    protected String[] statsTitles;
    protected String opName;
    protected String mBeanNamePrefix;
    protected ObjectName objName;
    protected Map<String, String> tips;
    private Timer statsCollector;

    public Stats(MBeanServerConnection connection) {
        Stats.connection = connection;
        this.setLayout(new FlowLayout());
        ToolTipManager.sharedInstance().setDismissDelay(10000);
        this.initVariables();
        this.initContainers();
        this.initGUIs();
        this.statsCollector = new Timer(STATS_COLLECTOR);
        this.statsCollector.scheduleAtFixedRate((TimerTask)new StatsCollectionTask(), 0L, this.statsIntervalMillis);
    }

    public StatsTableModel getTModel() {
        return this.statsModel;
    }

    protected abstract void initVariables();

    protected abstract void generateTips();

    private void initContainers() {
        this.valueStore = new HashMap<ObjectName, Map<String, String>>();
        this.logMap = new HashMap<ObjectName, LogObject>();
        this.shownStats = new HashMap<String, Boolean>();
        this.comboToObjects = new TreeMap();
        this.frameList = new ArrayList<GraphFrame>();
        this.savedStats = new ConcurrentHashMap<ObjectName, Map<String, String>>();
        this.savedObjectNames = new ArrayList<ObjectName>();
        for (ObjectName name : this.getBeansNames()) {
            LinkedHashMap<String, String> storeMap = new LinkedHashMap<String, String>();
            Map<String, String> map = this.generateStats(name);
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String key = entry.getKey();
                if (key.contains(":")) {
                    storeMap.put(key.substring(0, key.indexOf(":")), "0");
                    continue;
                }
                storeMap.put(key, "0");
            }
            this.valueStore.put(name, storeMap);
            this.logMap.put(name, new LogObject());
            this.comboToObjects.put(this.getMBeanComboBoxString(name), name);
        }
        for (int i = 0; i < this.statsTitles.length; ++i) {
            this.shownStats.put(this.statsTitles[i], true);
        }
        this.objName = this.getFirstObjectName();
        this.mBeansNum = this.logMap.size();
        this.generateTips();
    }

    private ObjectName getFirstObjectName() {
        return this.comboToObjects.firstEntry().getValue();
    }

    protected void updateTips() {
        for (Map.Entry<String, String> entry : this.tips.entrySet()) {
            String value = entry.getValue();
            String formatStr = new String();
            boolean stop = false;
            while (!stop) {
                if (value.length() <= 80) {
                    stop = true;
                    formatStr = formatStr + value;
                    continue;
                }
                int endIndex = 79;
                String phrase = value.substring(0, endIndex);
                if (!phrase.endsWith(" ")) {
                    endIndex = phrase.lastIndexOf(" ");
                }
                formatStr = formatStr + value.substring(0, endIndex) + "<br>";
                value = value.substring(endIndex, value.length());
            }
            formatStr = "<html>" + formatStr + "</html>";
            this.tips.put(entry.getKey(), formatStr);
        }
    }

    private void initGUIs() {
        JPanel mBeanPanel = this.createMBeanPanel();
        JPanel setPanel = this.createSettingPanel();
        JPanel logPanel = this.createLogPanel();
        JPanel statsPanel = this.createStatsPanel();
        this.createMenu();
        this.add(mBeanPanel);
        this.add(setPanel);
        this.add(logPanel);
        this.add(statsPanel);
    }

    private JPanel createMBeanPanel() {
        this.mBeansComboBox = new JComboBox();
        this.mBeansComboBox.setPrototypeDisplayValue(this.generateString());
        this.mBeanComboBoxListener = new BeanComboBoxListener();
        this.initMBeanComboBox(this.getBeansNames());
        return this.generatePanel(new JComponent[]{new JLabel("Choose JE Environment:"), this.mBeansComboBox}, new FlowLayout(), "Choose JE MBean");
    }

    private String generateString() {
        String length = new String();
        for (int i = 0; i < 50; ++i) {
            length = length + "X";
        }
        return length;
    }

    private void initMBeanComboBox(List<ObjectName> names) {
        if (names.size() != this.comboToObjects.size()) {
            this.comboToObjects = new TreeMap();
            for (ObjectName objectName : names) {
                this.comboToObjects.put(this.getMBeanComboBoxString(objectName), objectName);
            }
        }
        for (Map.Entry entry : this.comboToObjects.entrySet()) {
            this.mBeansComboBox.addItem(entry.getKey());
        }
        this.mBeansComboBox.setSelectedIndex(0);
        this.mBeansComboBox.addActionListener(this.mBeanComboBoxListener);
    }

    private String getMBeanComboBoxString(ObjectName name) {
        String envHome = name.toString().substring(name.toString().indexOf("(") + 1, name.toString().length() - 1);
        if (envHome.length() > 40) {
            envHome = envHome.substring(0, 19) + "..." + envHome.substring(envHome.length() - 20, envHome.length());
        }
        return envHome;
    }

    private JPanel createSettingPanel() {
        this.cumulativeStatsBox = new JCheckBox("Display cumulative stats", false);
        this.cumulativeStatsBox.addActionListener(new ClearStatsBoxListener());
        this.hideZeroValueBox = new JCheckBox("Hide zero values", false);
        this.hideZeroValueBox.addActionListener(new HideZeroValueBoxListener());
        this.statsIntervalText = new JTextField("10", 4);
        this.statsIntervalText.addKeyListener(new StatsIntervalListener());
        return this.generatePanel(new JComponent[]{new JLabel("Collection interval (secs):"), this.statsIntervalText, this.cumulativeStatsBox, this.hideZeroValueBox}, new FlowLayout(), "Settings");
    }

    private JPanel createLogPanel() {
        this.startLogButton = this.createButton("Start Recording", new StartLogListener());
        this.startLogButton.setEnabled(false);
        this.stopLogButton = this.createButton("Stop Recording", new StopLogListener());
        this.stopLogButton.setEnabled(false);
        this.saveLogButton = this.createButton("Record Statistics To ...", new SaveLogListener(this));
        return this.generatePanel(new JComponent[]{this.startLogButton, this.stopLogButton, this.saveLogButton}, new FlowLayout(), "Record Statistics");
    }

    private JPanel createStatsPanel() {
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new GridLayout(15, 1));
        leftPanel.add(new JLabel("  Stats to Display"));
        for (int i = 0; i < this.statsTitles.length; ++i) {
            this.createCheckBox(this.statsTitles[i], leftPanel);
        }
        JScrollPane left = new JScrollPane(leftPanel);
        this.statsModel = new StatsTableModel();
        this.statsTable = new JTable(this.statsModel);
        this.statsTable.setSelectionMode(0);
        this.statsTable.setDefaultRenderer(String.class, new StringRenderer());
        this.statsTable.setIntercellSpacing(new Dimension(6, 3));
        this.statsTable.setRowHeight(this.statsTable.getRowHeight() + 4);
        this.statsTable.addMouseListener(new TableMouseListener());
        this.statsTable.addMouseMotionListener(new TableMouseMotionListener());
        JScrollPane right = new JScrollPane(this.statsTable);
        right.setAlignmentX(0.5f);
        JSplitPane splitPane = new JSplitPane(1, left, right);
        splitPane.setOneTouchExpandable(true);
        splitPane.setResizeWeight(0.3);
        return this.generatePanel(new JComponent[]{splitPane}, new FlowLayout(), "JE Stats Table");
    }

    private void createMenu() {
        this.popup = new JPopupMenu();
        this.logMenuItem = new JCheckBoxMenuItem("Log This Stat");
        this.logMenuItem.addActionListener(new LogMenuListener());
        this.popup.add(this.logMenuItem);
        this.graphMenuItem = new JMenuItem("Graph This Stat");
        this.graphMenuItem.addActionListener(new GraphMenuListener());
        this.popup.add(this.graphMenuItem);
    }

    private void createCheckBox(String title, JPanel container) {
        JCheckBox checkBox = new JCheckBox(title, true);
        checkBox.addActionListener(new StatsTypeListener());
        container.add(checkBox);
    }

    private JButton createButton(String text, ActionListener listener) {
        JButton button = new JButton(text);
        button.addActionListener(listener);
        return button;
    }

    private JPanel generatePanel(JComponent[] components, LayoutManager layout, String panelName) {
        JPanel panel = new JPanel(layout);
        for (JComponent component : components) {
            panel.add(component);
        }
        if (!"none".equals(panelName)) {
            panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(panelName), BorderFactory.createEmptyBorder(0, 0, 0, 0)));
        }
        return panel;
    }

    public void setConnection(MBeanServerConnection connection) {
        Stats.connection = connection;
    }

    public static MBeanServerConnection getConnection() {
        return connection;
    }

    public void removeGraphFrame(ObjectName beanName, String graphStats) {
        CopyOnWriteArrayList<GraphFrame> list = new CopyOnWriteArrayList<GraphFrame>(this.frameList);
        for (GraphFrame frame : list) {
            if (!frame.getBeanName().equals(beanName) || !frame.getStatsName().equals(graphStats)) continue;
            this.frameList.remove(frame);
            frame = null;
        }
    }

    public synchronized List<Map.Entry<String, String>> getResultsList() {
        if (this.savedObjectNames == null || this.savedObjectNames.size() == 0) {
            return null;
        }
        this.repaintComboBox(this.savedObjectNames);
        Map<String, String> displayStats = this.savedStats.get(this.objName);
        if (displayStats == null || displayStats.size() == 0) {
            return null;
        }
        this.removeUnShownTypeStats(displayStats);
        if (this.hideZeroValue) {
            this.hideZeroValues(displayStats);
        }
        if (displayStats.size() == 0) {
            displayStats.put("No Stats", "");
        }
        ArrayList<Map.Entry<String, String>> list = new ArrayList<Map.Entry<String, String>>(displayStats.entrySet());
        return list;
    }

    private void removeUnShownTypeStats(Map<String, String> map) {
        Object[] keys = map.keySet().toArray();
        for (Map.Entry<String, Boolean> stats : this.shownStats.entrySet()) {
            if (stats.getValue().booleanValue()) continue;
            for (Object key : keys) {
                if (!key.toString().contains(stats.getKey())) continue;
                map.remove(key.toString());
            }
        }
        Stats.emptyArray(keys);
        keys = null;
    }

    private static void emptyArray(Object[] array) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = null;
        }
    }

    private void hideZeroValues(Map<String, String> map) {
        Object[] keys = map.keySet().toArray();
        for (Map.Entry<String, Boolean> entry : this.shownStats.entrySet()) {
            boolean deleteAll = true;
            for (Object key : keys) {
                String value = map.get(key.toString());
                if (!key.toString().contains(entry.getKey()) || value == null || value.equals("")) continue;
                if (value.equals("0")) {
                    map.remove(key.toString());
                    continue;
                }
                deleteAll = false;
            }
            if (!deleteAll) continue;
            map.remove(entry.getKey());
        }
        Stats.emptyArray(keys);
        keys = null;
    }

    private synchronized Map<String, String> generateStats(ObjectName name) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        try {
            if (connection != null && connection.queryNames(name, null) != null) {
                String status = (String)connection.invoke(name, this.opName, this.envStatParams, this.signature);
                StringTokenizer st1 = new StringTokenizer(status, "\n");
                String title = null;
                while (st1.hasMoreTokens()) {
                    StringTokenizer st2;
                    String expression = st1.nextToken();
                    if (expression == null) continue;
                    if (expression.indexOf("=") < 0) {
                        st2 = new StringTokenizer(expression, ":");
                        title = st2.nextToken();
                        map.put(title, "");
                        continue;
                    }
                    st2 = new StringTokenizer(expression, "=");
                    String stats = "    " + st2.nextToken();
                    String value = st2.nextToken().trim();
                    map.put(stats + ":" + title, value);
                }
            }
        }
        catch (InstanceNotFoundException e) {
            this.forceClose();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    private void forceClose() {
        this.setConnection(null);
        for (Map.Entry<ObjectName, LogObject> item : this.logMap.entrySet()) {
            item.getValue().closeFileWriter();
        }
    }

    private synchronized ArrayList<ObjectName> getBeansNames() {
        if (connection == null) {
            return null;
        }
        ArrayList<ObjectName> names = null;
        try {
            ObjectName name = new ObjectName(this.mBeanNamePrefix);
            if (connection.queryNames(name, null).size() != 0) {
                names = new ArrayList<ObjectName>(connection.queryNames(name, null));
            }
        }
        catch (RemoteException e) {
            this.forceClose();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return names;
    }

    private void repaintComboBox(List<ObjectName> names) {
        if (names == null) {
            return;
        }
        try {
            if (names.size() != this.mBeansNum && names.size() != 0) {
                this.mBeansComboBox.removeActionListener(this.mBeanComboBoxListener);
                this.mBeansComboBox.removeAllItems();
                this.initMBeanComboBox(names);
                for (Map.Entry<ObjectName, LogObject> entry : this.logMap.entrySet()) {
                    boolean find = false;
                    for (ObjectName name : names) {
                        if (!name.equals(entry.getKey())) continue;
                        find = true;
                        break;
                    }
                    if (find) continue;
                    this.logMap.get(entry.getKey()).closeFileWriter();
                    this.logMap.remove(entry.getKey());
                    this.valueStore.remove(entry.getKey());
                    break;
                }
                this.objName = this.getFirstObjectName();
                this.mBeansNum = names.size();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void writeToLog(Map<String, String> map, ObjectName currentName) {
        try {
            if (map == null) {
                return;
            }
            LogObject item = this.logMap.get(currentName);
            if (item.getLogName() == null) {
                return;
            }
            StringBuffer buffer = new StringBuffer();
            this.getCSVOutput(buffer, map, false, currentName);
            buffer.append("\n");
            item.writeLog(buffer.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void getCSVOutput(StringBuffer buffer, Map<String, String> map, boolean init, ObjectName name) {
        LogObject item = this.logMap.get(name);
        if (map == null || map.size() == 0) {
            return;
        }
        if (item != null) {
            Object[] keys = map.keySet().toArray();
            for (String string : item.getTurnOff()) {
                for (Object key : keys) {
                    if (!key.toString().contains(string)) continue;
                    map.remove(key.toString());
                }
            }
            Stats.emptyArray(keys);
            keys = null;
        }
        item = null;
        if (!init) {
            buffer.append(System.currentTimeMillis());
        } else {
            buffer.append("TIME");
        }
        for (int i = 0; i < this.statsTitles.length; ++i) {
            map.remove(this.statsTitles[i]);
        }
        if (map.size() > 0) {
            buffer.append(",");
            int count = 1;
            for (Map.Entry entry : map.entrySet()) {
                String title = ((String)entry.getKey()).substring(0, ((String)entry.getKey()).indexOf(":")).trim();
                if (!init) {
                    title = "\"" + (String)entry.getValue() + "\"";
                }
                if (count < map.size()) {
                    title = title + ",";
                }
                buffer.append(title);
                ++count;
            }
        }
    }

    private SwingWorker<?, ?> newSwingWorker() {
        ArrayList<Stats> list = new ArrayList<Stats>();
        list.add(this);
        return new StatsSwingWorker(list);
    }

    private void writeLogAndGraphing(ObjectName objectName, Map<String, String> values) {
        if (values == null || values.size() == 0) {
            return;
        }
        if (this.frameList.size() > 0) {
            for (GraphFrame frame : this.frameList) {
                if (!frame.getBeanName().equals(objectName)) continue;
                frame.writeData(values);
            }
        }
        if (this.doLog) {
            this.writeToLog(values, objectName);
        }
    }

    private void enableComponent(JComponent[] components, boolean enabled) {
        for (JComponent component : components) {
            component.setEnabled(enabled);
        }
    }

    private boolean isTitleEqual(String title) {
        boolean equal = false;
        for (int i = 0; i < this.statsTitles.length; ++i) {
            if (!this.statsTitles[i].equals(title)) continue;
            equal = true;
            break;
        }
        return equal;
    }

    private String getParsedValue(String value) {
        if (value.indexOf(",") > 0) {
            StringTokenizer st = new StringTokenizer(value, ",");
            value = new String();
            while (st.hasMoreTokens()) {
                value = value + st.nextToken();
            }
        }
        return value;
    }

    private class StatsCollectionTask
    extends TimerTask {
        private StatsCollectionTask() {
        }

        @Override
        public void run() {
            ArrayList objectNames = Stats.this.getBeansNames();
            if (objectNames == null || objectNames.size() == 0) {
                return;
            }
            Stats.this.savedObjectNames = objectNames;
            for (ObjectName objectName : objectNames) {
                Map statValues = Stats.this.generateStats(objectName);
                LinkedHashMap copiedStats = new LinkedHashMap();
                copiedStats.putAll(statValues);
                Stats.this.savedStats.put(objectName, copiedStats);
                Stats.this.writeLogAndGraphing(objectName, statValues);
            }
            Stats.this.newSwingWorker().execute();
        }
    }

    private class GraphFrame
    extends JFrame {
        private static final long serialVersionUID = 8921577524698094123L;
        private final Color statsColor;
        private PlotterPanel plotterPanel;
        private final ObjectName bean;
        private final String stats;

        public GraphFrame(ObjectName beanName, String statsName) {
            super(statsName.trim() + " for " + beanName.toString());
            this.statsColor = Color.blue.darker();
            this.bean = beanName;
            this.stats = statsName.trim();
            this.setLayout(new BorderLayout(0, 0));
            this.setSize(800, 400);
            JPanel topPanel = new JPanel(new BorderLayout());
            JPanel controlPanel = new JPanel(new FlowLayout(1, 20, 5));
            controlPanel.add(new JLabel("Time Range:"));
            this.plotterPanel = new PlotterPanel(this.stats, Plotter.Unit.NONE, false);
            this.plotterPanel.getPlotter().createSequence(this.stats, this.stats, this.statsColor, true);
            TimeComboBox timeComboBox = new TimeComboBox(this.plotterPanel.getPlotter());
            controlPanel.add(timeComboBox);
            topPanel.add((Component)controlPanel, "Center");
            this.add((Component)topPanel, "North");
            this.add((Component)this.plotterPanel, "Center");
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent evt) {
                    GraphFrame.this.setVisible(false);
                    GraphFrame.this.dispose();
                    if (JEStats.getConnection() != null) {
                        Stats.this.removeGraphFrame(GraphFrame.this.bean, GraphFrame.this.stats);
                    }
                }
            });
            this.setVisible(true);
        }

        public ObjectName getBeanName() {
            return this.bean;
        }

        public String getStatsName() {
            return this.stats;
        }

        public void writeData(Map<String, String> map) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String realKey;
                if (entry.getKey().indexOf(":") <= 0 || !this.stats.equals(realKey = entry.getKey().substring(0, entry.getKey().indexOf(":")).trim())) continue;
                String value = Stats.this.getParsedValue(entry.getValue());
                this.plotterPanel.getPlotter().addValues(System.currentTimeMillis(), Long.valueOf(value));
            }
        }
    }

    private class StatsIntervalListener
    implements KeyListener {
        private StatsIntervalListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                String newIntervalText = Stats.this.statsIntervalText.getText();
                try {
                    long statsIntervalSeconds = new Long(newIntervalText);
                    Stats.this.statsIntervalMillis = statsIntervalSeconds * 1000L;
                }
                catch (Exception exception) {
                    System.err.println("\"" + newIntervalText + "\" is not a valid interval. " + exception);
                }
                Stats.this.statsCollector.cancel();
                Stats.this.statsCollector = new Timer(Stats.STATS_COLLECTOR);
                Stats.this.statsCollector.scheduleAtFixedRate((TimerTask)new StatsCollectionTask(), 0L, Stats.this.statsIntervalMillis);
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }
    }

    private class TableMouseMotionListener
    implements MouseMotionListener {
        private TableMouseMotionListener() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            int row = Stats.this.statsTable.rowAtPoint(e.getPoint());
            if (row >= 0) {
                String stats = ((String)Stats.this.statsTable.getValueAt(row, 0)).trim();
                Stats.this.statsTable.setToolTipText(Stats.this.tips.get(stats));
            }
        }
    }

    private class TableMouseListener
    implements MouseListener {
        private TableMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getButton() == 3) {
                int row = Stats.this.statsTable.rowAtPoint(e.getPoint());
                if (row >= 0) {
                    Stats.this.statsTable.setRowSelectionInterval(row, row);
                    String statName = Stats.this.statsTable.getValueAt(row, 0).toString().trim();
                    if (((LogObject)Stats.this.logMap.get(Stats.this.objName)).getTurnOff().contains(statName)) {
                        Stats.this.logMenuItem.setState(false);
                    } else {
                        Stats.this.logMenuItem.setState(true);
                    }
                    try {
                        String statValue = Stats.this.getParsedValue(Stats.this.statsTable.getValueAt(row, 1).toString().trim());
                        Long.parseLong(statValue);
                        Stats.this.graphMenuItem.setEnabled(true);
                    }
                    catch (NumberFormatException exception) {
                        Stats.this.graphMenuItem.setEnabled(false);
                    }
                    Stats.this.selectedRow = row;
                }
                Stats.this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }

    private class GraphMenuListener
    implements ActionListener {
        private GraphMenuListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String graphStats;
            if (Stats.this.selectedRow > -1 && !Stats.this.isTitleEqual(graphStats = Stats.this.statsTable.getValueAt(Stats.this.selectedRow, 0).toString().trim())) {
                boolean initialized = false;
                for (GraphFrame frame : Stats.this.frameList) {
                    if (!frame.getBeanName().equals(Stats.this.objName) || !frame.getStatsName().equals(graphStats)) continue;
                    initialized = true;
                    break;
                }
                if (!initialized) {
                    Stats.this.frameList.add(new GraphFrame(Stats.this.objName, graphStats));
                }
            }
        }
    }

    private class LogMenuListener
    implements ActionListener {
        private LogMenuListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LogObject currentBean = (LogObject)Stats.this.logMap.get(Stats.this.objName);
            if (Stats.this.selectedRow > -1) {
                String title = Stats.this.statsTable.getValueAt(Stats.this.selectedRow, 0).toString().trim();
                if (!Stats.this.logMenuItem.getState() && !currentBean.getTurnOff().contains(title)) {
                    currentBean.addTurnOff(title);
                }
                if (Stats.this.logMenuItem.getState() && currentBean.getTurnOff().contains(title)) {
                    currentBean.getTurnOff().remove(title);
                }
            }
        }
    }

    private class StatsTypeListener
    implements ActionListener {
        private StatsTypeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Stats.this.shownStats.put(((JCheckBox)e.getSource()).getText(), ((JCheckBox)e.getSource()).isSelected());
            Stats.this.newSwingWorker().execute();
        }
    }

    private class BeanComboBoxListener
    implements ActionListener {
        private BeanComboBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Stats.this.objName = Stats.this.comboToObjects.get(Stats.this.mBeansComboBox.getSelectedItem());
            Stats.this.newSwingWorker().execute();
        }
    }

    private class SaveLogListener
    implements ActionListener {
        JPanel shownPanel;

        public SaveLogListener(JPanel shownPanel) {
            this.shownPanel = shownPanel;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int ret;
            if (Stats.this.fileChooser == null) {
                Stats.this.fileChooser = new SaveLogFileChooser();
            }
            if ((ret = Stats.this.fileChooser.showSaveDialog(this.shownPanel)) == 0) {
                ((LogObject)Stats.this.logMap.get(Stats.this.objName)).setLogName(Stats.this.fileChooser.getSelectedFile().getAbsolutePath());
                Stats.this.startLogButton.setEnabled(true);
                Stats.this.stopLogButton.setEnabled(true);
            }
        }
    }

    private class StopLogListener
    implements ActionListener {
        private StopLogListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Stats.this.enableComponent(new JComponent[]{Stats.this.saveLogButton, Stats.this.logMenuItem}, true);
            Stats.this.doLog = false;
            Stats.this.startLogButton.setEnabled(false);
            Stats.this.stopLogButton.setEnabled(false);
            Stats.this.saveLogButton.setEnabled(true);
        }
    }

    private class StartLogListener
    implements ActionListener {
        private StartLogListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (Map.Entry entry : Stats.this.logMap.entrySet()) {
                ((LogObject)entry.getValue()).initCSVOutput((ObjectName)entry.getKey());
            }
            Stats.this.enableComponent(new JComponent[]{Stats.this.saveLogButton, Stats.this.startLogButton, Stats.this.logMenuItem}, false);
            Stats.this.doLog = true;
        }
    }

    private class HideZeroValueBoxListener
    implements ActionListener {
        private HideZeroValueBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Stats.this.hideZeroValue = Stats.this.hideZeroValueBox.isSelected();
            Stats.this.newSwingWorker().execute();
        }
    }

    private class ClearStatsBoxListener
    implements ActionListener {
        private ClearStatsBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ((Stats)Stats.this).envStatParams[0] = !Stats.this.cumulativeStatsBox.isSelected();
            Stats.this.newSwingWorker().execute();
        }
    }

    private class SaveLogFileChooser
    extends JFileChooser {
        private static final long serialVersionUID = -3035086973026766211L;

        public SaveLogFileChooser() {
            this.setFileFilter(new FileNameExtensionFilter("CSV files", "csv"));
        }

        @Override
        public void approveSelection() {
            File file = this.getSelectedFile();
            if (file != null) {
                FileFilter filter = this.getFileFilter();
                if (filter != null && filter instanceof FileNameExtensionFilter) {
                    boolean goodExt;
                    String[] extensions = ((FileNameExtensionFilter)filter).getExtensions();
                    boolean bl = goodExt = extensions.length > 0;
                    if (!goodExt) {
                        file = new File(file.getParent(), file.getName() + "." + extensions[0]);
                    }
                }
                if (file.exists()) {
                    String okStr = "ok";
                    String cancelStr = "cancel";
                    int ret = JOptionPane.showOptionDialog(this, "File " + file.getName() + " already exists!", "Save File", 2, 2, null, new Object[]{okStr, cancelStr}, okStr);
                    if (ret != 0) {
                        return;
                    }
                }
                this.setSelectedFile(file);
            }
            super.approveSelection();
        }
    }

    private class StringRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 480362177240428265L;

        public StringRenderer() {
            this.setHorizontalAlignment(2);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component cell = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (column == 1) {
                String newValue = (String)((Map)Stats.this.valueStore.get(Stats.this.objName)).get(table.getValueAt(row, 0));
                if (newValue != null && !newValue.equals(table.getValueAt(row, 1))) {
                    ((Map)Stats.this.valueStore.get(Stats.this.objName)).put(table.getValueAt(row, 0).toString(), table.getValueAt(row, 1).toString().trim());
                    cell.setForeground(Color.RED);
                }
            } else {
                cell.setForeground(Color.BLACK);
            }
            return cell;
        }
    }

    public class StatsTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -2478788160419123718L;
        private String[] columnNames = new String[]{"Stat Name", "Value"};
        private List<Map.Entry<String, String>> list = new ArrayList<Map.Entry<String, String>>();

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.list == null ? 0 : this.list.size();
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            Map.Entry<String, String> value = this.list.get(row);
            switch (col) {
                case 0: {
                    if (value.getKey().indexOf(":") < 0) {
                        return value.getKey().trim();
                    }
                    return value.getKey().substring(0, value.getKey().indexOf(":"));
                }
                case 1: {
                    return value.getValue();
                }
            }
            return null;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        public void setList(List<Map.Entry<String, String>> list) {
            this.list = list;
        }
    }

    private class LogObject {
        private String logName;
        private FileWriter csvOutput = null;
        private ArrayList<String> turnOffIndex = new ArrayList();

        private LogObject() {
        }

        public void setLogName(String logName) {
            this.logName = logName.contains(".csv") ? logName : logName + ".csv";
        }

        public String getLogName() {
            return this.logName;
        }

        public void addTurnOff(String title) {
            this.turnOffIndex.add(title);
        }

        public ArrayList<String> getTurnOff() {
            return this.turnOffIndex;
        }

        public void initCSVOutput(ObjectName objectName) {
            if (this.logName != null) {
                try {
                    this.csvOutput = new FileWriter(new File(this.logName), true);
                    StringBuffer buffer = new StringBuffer();
                    Map map = Stats.this.generateStats(objectName);
                    Stats.this.getCSVOutput(buffer, map, true, objectName);
                    this.csvOutput.append(buffer.toString() + "\n");
                    this.csvOutput.flush();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        public void writeLog(String stats) {
            try {
                if (this.csvOutput != null) {
                    this.csvOutput.append(stats);
                    this.csvOutput.flush();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void closeFileWriter() {
            try {
                if (this.csvOutput != null) {
                    this.csvOutput.close();
                }
                this.csvOutput = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

