/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.cleaner;

import com.sleepycat.bind.tuple.SortedPackedLongBinding;
import com.sleepycat.bind.tuple.TupleBase;
import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.je.CacheMode;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DatabaseNotFoundException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Durability;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.EnvironmentMutableConfig;
import com.sleepycat.je.Get;
import com.sleepycat.je.JEVersion;
import com.sleepycat.je.LockConflictException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationFailureException;
import com.sleepycat.je.ReadOptions;
import com.sleepycat.je.ScanFilter;
import com.sleepycat.je.ThreadInterruptedException;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.cleaner.LocalUtilizationTracker;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.DbType;
import com.sleepycat.je.dbi.DupKeyData;
import com.sleepycat.je.dbi.EnvConfigObserver;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.PutMode;
import com.sleepycat.je.dbi.SortedLSNTreeWalker;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.ReplicationContext;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.tree.Tree;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.LockerFactory;
import com.sleepycat.je.txn.Txn;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.StoppableThreadFactory;
import com.sleepycat.je.utilint.TestHook;
import com.sleepycat.je.utilint.TestHookExecute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ExtinctionScanner
implements EnvConfigObserver {
    private static final int RECORD_EXTINCTION = 0;
    private static final int DATABASE_EXTINCTION = 1;
    private static final JEVersion MIN_JE_VERSION = new JEVersion("18.1.7");
    public static JEVersion TEST_MIN_JE_VERSION = null;
    private static final ReadOptions NOLOCK_UNCHANGED = new ReadOptions().setCacheMode(CacheMode.UNCHANGED).setLockMode(LockMode.READ_UNCOMMITTED);
    private static final TransactionConfig NO_SYNC_TXN = new TransactionConfig().setLocalWrite(false).setDurability(Durability.COMMIT_NO_SYNC);
    private static final int COMMIT_LOCK_TIMEOUT_MS = 500;
    private final @NonNull EnvironmentImpl envImpl;
    private final @NonNull Logger logger;
    private @Nullable DatabaseImpl scanDb;
    private final @Nullable ThreadPoolExecutor threadPool;
    private final AtomicLong lastRepScanID = new AtomicLong();
    private final AtomicLong lastNonRepScanID = new AtomicLong();
    private final Map<Long, RecordExtinction> activeRecordTasks = Collections.synchronizedMap(new HashMap());
    private final Set<Long> completedRecordScans = Collections.synchronizedSet(new HashSet());
    private final boolean enabled;
    private final int batchSize;
    private final int batchDelayMs;
    private final long flushObsoleteBytes;
    private volatile boolean shutdownRequested;
    private int terminateMillis;
    private volatile List<ExtinctionTask> recoveredTasks = new ArrayList<ExtinctionTask>();
    TestHook beforeScan1Hook;
    TestHook beforeScan1FlushHook;
    TestHook beforeScan2Hook;
    public TestHook<?> dbBeforeWriteTaskHook;
    TestHook<?> dbBeforeExecTaskHook;
    TestHook<?> dbBeforeDeleteMapLNHook;
    TestHook<?> dbBeforeDeleteTaskLNHook;

    public static JEVersion getMinJEVersion() {
        if (TEST_MIN_JE_VERSION != null) {
            return TEST_MIN_JE_VERSION;
        }
        return MIN_JE_VERSION;
    }

    public ExtinctionScanner(@NonNull EnvironmentImpl envImpl) {
        this.envImpl = envImpl;
        this.logger = LoggerUtils.getLogger(this.getClass());
        DbConfigManager configManager = envImpl.getConfigManager();
        this.enabled = configManager.getBoolean(EnvironmentParams.ENV_RUN_EXTINCT_RECORD_SCANNER);
        this.batchSize = configManager.getInt(EnvironmentParams.CLEANER_EXTINCT_SCAN_BATCH_SIZE);
        this.batchDelayMs = configManager.getDuration(EnvironmentParams.CLEANER_EXTINCT_SCAN_BATCH_DELAY);
        this.flushObsoleteBytes = configManager.getLong(EnvironmentParams.CLEANER_FLUSH_EXTINCT_OBSOLETE);
        this.terminateMillis = configManager.getDuration(EnvironmentParams.EVICTOR_TERMINATE_TIMEOUT);
        envImpl.addConfigObserver(this);
        this.threadPool = envImpl.isReadOnly() ? null : new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new StoppableThreadFactory(envImpl, "JEExtinctRecordScanner", this.logger));
    }

    public void shutdown() {
        if (this.threadPool == null) {
            return;
        }
        this.shutdownRequested = true;
        this.threadPool.shutdown();
        boolean shutdownFinished = false;
        try {
            shutdownFinished = this.threadPool.awaitTermination(this.terminateMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            if (!shutdownFinished) {
                this.threadPool.shutdownNow();
            }
        }
    }

    public void requestShutdown() {
        if (this.threadPool == null) {
            return;
        }
        this.shutdownRequested = true;
        this.threadPool.shutdown();
    }

    @Override
    public void envConfigUpdate(DbConfigManager configManager, EnvironmentMutableConfig ignore) {
        this.terminateMillis = configManager.getDuration(EnvironmentParams.EVICTOR_TERMINATE_TIMEOUT);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isEmpty() {
        assert (this.threadPool != null);
        return this.threadPool.getQueue().isEmpty() && this.threadPool.getActiveCount() == 0;
    }

    public long getLastLocalId() {
        return this.lastNonRepScanID.get();
    }

    public long getLastReplicatedId() {
        return this.lastRepScanID.get();
    }

    public void setLastIds(long lastRepScanID, long lastNonRepScanID) {
        this.lastRepScanID.set(Math.min(this.lastRepScanID.get(), lastRepScanID));
        this.lastNonRepScanID.set(Math.max(this.lastNonRepScanID.get(), lastNonRepScanID));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void openDb() {
        if (this.scanDb != null) {
            return;
        }
        DbTree dbTree = this.envImpl.getDbTree();
        TransactionConfig txnConfig = new TransactionConfig();
        Txn locker = Txn.createLocalAutoTxn(this.envImpl, txnConfig);
        try {
            this.scanDb = dbTree.getDb(locker, DbType.EXTINCT_SCANS.getInternalName(), null, false);
        }
        finally {
            ((Locker)locker).operationEnd(true);
        }
        if (this.scanDb != null) {
            return;
        }
        if (this.envImpl.isReadOnly()) {
            throw EnvironmentFailureException.unexpectedState();
        }
        DatabaseConfig dbConfig = new DatabaseConfig();
        dbConfig.setReplicated(true);
        dbConfig.setTransactional(true);
        ReplicationContext repContext = this.envImpl.isReplicated() ? ReplicationContext.MASTER : ReplicationContext.NO_REPLICATE;
        txnConfig.setDurability(Durability.COMMIT_WRITE_NO_SYNC);
        txnConfig.setConsistencyPolicy(this.envImpl.getConsistencyPolicy("NoConsistencyRequiredPolicy"));
        locker = Txn.createAutoTxn(this.envImpl, txnConfig, repContext);
        boolean success = false;
        try {
            this.scanDb = dbTree.createInternalDb(locker, DbType.EXTINCT_SCANS.getInternalName(), dbConfig);
            success = true;
        }
        finally {
            ((Locker)locker).operationEnd(success);
        }
    }

    /*
     * Loose catch block
     */
    public boolean isScanTaskActive(long id) {
        try {
            this.openDb();
        }
        catch (OperationFailureException e) {
            if (e.isReplicaWrite()) {
                return true;
            }
            throw e;
        }
        DatabaseEntry keyEntry = new DatabaseEntry();
        ExtinctionScanner.serializeKey(id, keyEntry);
        BasicLocker locker = BasicLocker.createBasicLocker(this.envImpl, false);
        try {
            try (Cursor cursor = DbInternal.makeCursor(this.scanDb, (Locker)locker, null);){
                boolean bl = cursor.get(keyEntry, null, Get.SEARCH, null) != null;
                return bl;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            locker.operationEnd();
        }
    }

    private void assertOrWarn(String msg) {
        assert (false) : msg;
        LoggerUtils.warning(this.logger, this.envImpl, msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteTask(long id) {
        if (id == 0L) {
            return;
        }
        Txn locker = Txn.createLocalAutoTxn(this.envImpl, NO_SYNC_TXN);
        boolean success = false;
        try (Cursor cursor = DbInternal.makeCursor(this.scanDb, (Locker)locker, null);){
            DatabaseEntry keyEntry = new DatabaseEntry();
            ExtinctionScanner.serializeKey(id, keyEntry);
            if (cursor.get(keyEntry, null, Get.SEARCH, LockMode.RMW.toReadOptions()) == null) {
                this.assertOrWarn("Completed extinction task not found in DB, id=" + id);
                return;
            }
            DbInternal.deleteWithRepContext(cursor, ReplicationContext.NO_REPLICATE);
            success = true;
        }
        finally {
            ((Locker)locker).operationEnd(success);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recoverIncompleteTasks() {
        assert (this.recoveredTasks != null);
        if (this.envImpl.isReadOnly() || !this.enabled) {
            return;
        }
        try {
            this.openDb();
        }
        catch (OperationFailureException e) {
            if (e.isReplicaWrite()) {
                return;
            }
            throw e;
        }
        DatabaseEntry keyEntry = new DatabaseEntry();
        DatabaseEntry dataEntry = new DatabaseEntry();
        BasicLocker locker = BasicLocker.createBasicLocker(this.envImpl, false);
        try (Cursor cursor = DbInternal.makeCursor(this.scanDb, (Locker)locker, null);){
            while (cursor.get(keyEntry, dataEntry, Get.NEXT, null) != null) {
                ExtinctionTask task = this.materializeTask(keyEntry, dataEntry);
                if (task instanceof RecordExtinction) {
                    RecordExtinction rTask = (RecordExtinction)task;
                    this.activeRecordTasks.put(rTask.id, rTask);
                }
                this.recoveredTasks.add(task);
            }
        }
        finally {
            locker.operationEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void executeRecoveredTasks() {
        if (this.envImpl.isReadOnly() || !this.enabled) {
            return;
        }
        assert (this.threadPool != null);
        ExtinctionScanner extinctionScanner = this;
        synchronized (extinctionScanner) {
            if (this.recoveredTasks == null) {
                return;
            }
            for (ExtinctionTask task : this.recoveredTasks) {
                this.threadPool.execute(task);
            }
            this.recoveredTasks = null;
        }
    }

    public void replay(byte[] scanKey, byte[] scanData) {
        assert (!this.envImpl.isReadOnly());
        assert (this.threadPool != null);
        if (!this.enabled) {
            return;
        }
        ExtinctionTask task = this.materializeTask(new DatabaseEntry(scanKey), new DatabaseEntry(scanData));
        if (task instanceof RecordExtinction) {
            RecordExtinction rTask = (RecordExtinction)task;
            this.activeRecordTasks.put(rTask.id, rTask);
        }
        this.threadPool.execute(() -> {
            this.openDb();
            task.run();
        });
    }

    private ExtinctionTask materializeTask(DatabaseEntry keyEntry, DatabaseEntry dataEntry) {
        long id = ExtinctionScanner.materializeKey(keyEntry);
        if (id < 0L) {
            if (this.lastRepScanID.get() > id) {
                this.lastRepScanID.set(id);
            }
        } else if (this.lastNonRepScanID.get() < id) {
            this.lastNonRepScanID.set(id);
        }
        TupleInput in = TupleBase.entryToInput(dataEntry);
        switch (in.readPackedInt()) {
            case 0: {
                return new RecordExtinction(id, in);
            }
            case 1: {
                return new DatabaseExtinction(id, in);
            }
        }
        throw EnvironmentFailureException.unexpectedState();
    }

    private static void serializeKey(long id, DatabaseEntry keyEntry) {
        SortedPackedLongBinding.longToEntry(id, keyEntry);
    }

    public static long materializeKey(DatabaseEntry keyEntry) {
        return SortedPackedLongBinding.entryToLong(keyEntry);
    }

    private static TupleOutput serializeType(int taskType) {
        TupleOutput out = new TupleOutput();
        out.writePackedInt(taskType);
        return out;
    }

    public long discardExtinctRecords(@NonNull Locker locker, @NonNull Set<String> dbNames, @Nullable DatabaseEntry beginKey, @Nullable DatabaseEntry endKey, @Nullable ScanFilter filter, @NonNull String label) {
        assert (this.enabled);
        assert (this.threadPool != null);
        this.openDb();
        long id = this.envImpl.isReplicated() ? this.lastRepScanID.decrementAndGet() : this.lastNonRepScanID.incrementAndGet();
        RecordExtinction task = new RecordExtinction(id, this.dbNamesToIds(dbNames), beginKey, endKey, filter, label);
        task.writeTask(0L, null, locker, true);
        this.activeRecordTasks.put(id, task);
        this.threadPool.execute(task);
        return task.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NavigableSet<Long> dbNamesToIds(Set<String> dbNames) {
        DbTree dbTree = this.envImpl.getDbTree();
        TreeSet<Long> dbIds = new TreeSet<Long>();
        for (String dbName : dbNames) {
            BasicLocker locker = BasicLocker.createBasicLocker(this.envImpl);
            try {
                DatabaseId id = dbTree.getDbIdFromName(locker, dbName, null, false);
                if (id == null) {
                    throw new DatabaseNotFoundException("DB does not exist: " + dbName);
                }
                dbIds.add(id.getId());
            }
            finally {
                locker.operationEnd();
            }
        }
        return dbIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isRecordExtinctionIncomplete(DatabaseImpl dbImpl, byte[] key) {
        Map<Long, RecordExtinction> map = this.activeRecordTasks;
        synchronized (map) {
            for (RecordExtinction task : this.activeRecordTasks.values()) {
                if (!task.isKeyTargeted(dbImpl, key)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Long> getCompletedRecordScans() {
        Set<Long> set = this.completedRecordScans;
        synchronized (set) {
            return new HashSet<Long>(this.completedRecordScans);
        }
    }

    public void deleteCompletedRecordScans(Set<Long> scanIds) {
        if (scanIds.isEmpty()) {
            return;
        }
        assert (this.scanDb != null);
        for (long id : scanIds) {
            this.deleteTask(id);
        }
        this.completedRecordScans.removeAll(scanIds);
        this.activeRecordTasks.keySet().removeAll(scanIds);
        LoggerUtils.info(this.logger, this.envImpl, "Deleted complete extinct record scans after checkpoint, ids=" + scanIds);
    }

    private static int compareMainKey(byte[] key1, byte[] key2, DatabaseImpl dbImpl) {
        return dbImpl.getSortedDuplicates() ? DupKeyData.compareMainKey(key1, key2, dbImpl.getBtreeComparator()) : Key.compareKeys(key1, key2, dbImpl.getBtreeComparator());
    }

    public void prepareForDbExtinction(ReplicationContext repContext) {
        try {
            this.openDb();
        }
        catch (OperationFailureException e) {
            if (e.isReplicaWrite() && !repContext.inReplicationStream()) {
                return;
            }
            throw e;
        }
    }

    public void startDbExtinction(DatabaseImpl dbImpl) throws DatabaseException {
        assert (dbImpl.isDeleting());
        assert (!dbImpl.isDeleteFinished());
        assert (this.threadPool != null);
        assert (TestHookExecute.doHookIfSet(this.dbBeforeWriteTaskHook));
        if (this.scanDb == null) {
            DatabaseExtinction task = new DatabaseExtinction(0L, dbImpl);
            task.run();
        } else {
            DatabaseExtinction task = new DatabaseExtinction(this.lastNonRepScanID.incrementAndGet(), dbImpl);
            task.writeTask();
            if (this.recoveredTasks == null) {
                this.threadPool.execute(task);
            } else {
                this.recoveredTasks.add(task);
            }
        }
    }

    public void ensureDbExtinction(DatabaseImpl dbImpl) {
        assert (this.recoveredTasks != null);
        DatabaseId dbId = dbImpl.getId();
        for (ExtinctionTask task : this.recoveredTasks) {
            if (!task.isExtinctionForDb(dbId)) continue;
            this.envImpl.getDbTree().releaseDb(dbImpl);
            return;
        }
        dbImpl.setDeleteStarted();
        this.startDbExtinction(dbImpl);
    }

    private class ObsoleteProcessor
    implements SortedLSNTreeWalker.TreeNodeProcessor {
        private final LocalUtilizationTracker tracker;
        private final boolean isLnImmediatelyObsolete;
        private final DatabaseImpl dbImpl;
        private final long id;
        private long scannedRecords;

        ObsoleteProcessor(DatabaseImpl dbImpl, LocalUtilizationTracker tracker, long id) {
            this.dbImpl = dbImpl;
            this.tracker = tracker;
            this.id = id;
            this.isLnImmediatelyObsolete = dbImpl.isLNImmediatelyObsolete();
        }

        @Override
        public void processLSN(long childLsn, LogEntryType childType, Node node, byte[] lnKey, int lastLoggedSize, boolean isEmbedded) {
            if (isEmbedded || DbLsn.isTransientOrNull(childLsn)) {
                return;
            }
            int size = 0;
            if (lnKey != null && childType.isLNType()) {
                if (this.isLnImmediatelyObsolete) {
                    return;
                }
                size = lastLoggedSize;
            }
            this.tracker.countObsoleteNodeInexact(childLsn, childType, size);
            this.noteScanned();
        }

        @Override
        public void processDirtyDeletedLN(long childLsn, LN ln, byte[] lnKey) {
            assert (ln != null);
            this.tracker.countObsoleteNodeInexact(childLsn, ln.getGenericLogType(), 0);
            this.noteScanned();
        }

        private void noteScanned() {
            ++this.scannedRecords;
            if (this.scannedRecords % (long)ExtinctionScanner.this.batchSize != 0L) {
                return;
            }
            if (ExtinctionScanner.this.batchDelayMs <= 0) {
                return;
            }
            try {
                Thread.sleep(ExtinctionScanner.this.batchDelayMs);
            }
            catch (InterruptedException e) {
                LoggerUtils.warning(ExtinctionScanner.this.logger, ExtinctionScanner.this.envImpl, "DB remove/truncate scan interrupted, id=" + this.id + " dbId=" + this.dbImpl.getId() + " dbName=" + this.dbImpl.getName());
                throw new ThreadInterruptedException(ExtinctionScanner.this.envImpl, (Throwable)e);
            }
        }

        @Override
        public void noteMemoryExceeded() {
        }
    }

    private static class ObsoleteTreeWalker
    extends SortedLSNTreeWalker {
        private final IN rootIN;

        private ObsoleteTreeWalker(DatabaseImpl dbImpl, long rootLsn, boolean fetchLNSize, SortedLSNTreeWalker.TreeNodeProcessor callback, IN rootIN) throws DatabaseException {
            super(new DatabaseImpl[]{dbImpl}, new long[]{rootLsn}, callback, null, null);
            this.accumulateLNs = fetchLNSize;
            this.rootIN = rootIN;
            this.setInternalMemoryLimit(0x3200000L);
        }

        @Override
        public IN getResidentRootIN(DatabaseImpl ignore) {
            if (this.rootIN != null) {
                this.rootIN.latchShared();
            }
            return this.rootIN;
        }
    }

    private class DatabaseExtinction
    implements ExtinctionTask {
        private final long id;
        private final DatabaseId dbId;
        private DatabaseImpl dbImpl;

        DatabaseExtinction(long id, DatabaseImpl dbImpl) {
            this.id = id;
            this.dbId = dbImpl.getId();
            this.dbImpl = dbImpl;
        }

        DatabaseExtinction(long id, TupleInput in) {
            this.id = id;
            in.readPackedInt();
            this.dbId = new DatabaseId(in.readPackedLong());
        }

        void serializeData(TupleOutput out) {
            out.writePackedInt(0);
            out.writePackedLong(this.dbId.getId());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void writeTask() {
            assert (ExtinctionScanner.this.scanDb != null);
            assert (this.id >= 0L);
            DatabaseEntry keyEntry = new DatabaseEntry();
            DatabaseEntry dataEntry = new DatabaseEntry();
            ExtinctionScanner.serializeKey(this.id, keyEntry);
            TupleOutput out = ExtinctionScanner.serializeType(1);
            this.serializeData(out);
            TupleBase.outputToEntry(out, dataEntry);
            Txn locker = Txn.createLocalAutoTxn(ExtinctionScanner.this.envImpl, NO_SYNC_TXN);
            boolean success = false;
            try (Cursor cursor = DbInternal.makeCursor(ExtinctionScanner.this.scanDb, (Locker)locker, null);){
                if (DbInternal.putWithRepContext(cursor, keyEntry, dataEntry, PutMode.NO_OVERWRITE, ReplicationContext.NO_REPLICATE) == null) {
                    throw EnvironmentFailureException.unexpectedState();
                }
                success = true;
            }
            finally {
                ((Locker)locker).operationEnd(success);
            }
        }

        @Override
        public boolean isExtinctionForDb(DatabaseId dbId) {
            return dbId.equals(this.dbId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            assert (TestHookExecute.doHookIfSet(ExtinctionScanner.this.dbBeforeExecTaskHook));
            DbTree dbTree = ExtinctionScanner.this.envImpl.getDbTree();
            if (this.dbImpl == null) {
                this.dbImpl = dbTree.getDb(this.dbId);
                if (this.dbImpl == null) {
                    ExtinctionScanner.this.deleteTask(this.id);
                    return;
                }
                this.dbImpl.setDeleteStarted();
            } else {
                assert (this.dbImpl.isInUse());
                assert (this.dbImpl.isDeleting());
                assert (!this.dbImpl.isDeleteFinished());
            }
            try {
                Tree tree = this.dbImpl.getTree();
                long rootLsn = tree.getRootLsn();
                IN rootIN = tree.getResidentRootIN(false);
                LocalUtilizationTracker tracker = new LocalUtilizationTracker(ExtinctionScanner.this.envImpl);
                if (rootLsn != -1L) {
                    tracker.countObsoleteNodeInexact(rootLsn, LogEntryType.LOG_IN, 0);
                }
                boolean fetchLNSize = ExtinctionScanner.this.envImpl.getCleaner().getFetchObsoleteSize(this.dbImpl);
                ObsoleteProcessor obsoleteProcessor = new ObsoleteProcessor(this.dbImpl, tracker, this.id);
                ObsoleteTreeWalker walker = new ObsoleteTreeWalker(this.dbImpl, rootLsn, fetchLNSize, obsoleteProcessor, rootIN);
                LoggerUtils.info(ExtinctionScanner.this.logger, ExtinctionScanner.this.envImpl, "Start DB remove/truncate scan, id=" + this.id + " dbId=" + this.dbImpl.getId() + " dbName=" + this.dbImpl.getName());
                walker.walk();
                LoggerUtils.info(ExtinctionScanner.this.logger, ExtinctionScanner.this.envImpl, "End DB remove/truncate scan, id=" + this.id + " scanned=" + obsoleteProcessor.scannedRecords + " dbId=" + this.dbImpl.getId() + " dbName=" + this.dbImpl.getName());
                ExtinctionScanner.this.envImpl.getUtilizationProfile().flushLocalTracker(tracker);
                assert (TestHookExecute.doHookIfSet(ExtinctionScanner.this.dbBeforeDeleteMapLNHook));
                dbTree.deleteMapLN(this.dbImpl.getId());
                ExtinctionScanner.this.envImpl.getLogManager().flushNoSync();
                assert (TestHookExecute.doHookIfSet(ExtinctionScanner.this.dbBeforeDeleteTaskLNHook));
                ExtinctionScanner.this.deleteTask(this.id);
                this.removeFromINList();
                this.dbImpl.setDeleteFinished();
            }
            finally {
                dbTree.releaseDb(this.dbImpl);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeFromINList() {
            long memoryChange = 0L;
            try {
                Iterator<IN> iter = ExtinctionScanner.this.envImpl.getInMemoryINs().iterator();
                while (iter.hasNext()) {
                    IN in = iter.next();
                    if (in.getDatabase() != this.dbImpl) continue;
                    iter.remove();
                    memoryChange -= in.getBudgetedMemorySize();
                }
            }
            finally {
                ExtinctionScanner.this.envImpl.getMemoryBudget().updateTreeMemoryUsage(memoryChange);
            }
        }
    }

    private class RecordExtinction
    implements ExtinctionTask {
        private final long id;
        private final NavigableSet<Long> dbIds;
        private final byte[] beginKey;
        private final byte[] endKey;
        private final ScanFilter filter;
        private final String label;
        private boolean countComplete;
        private final long flushAtLastDb;
        private final byte[] flushAtLastKey;
        private LocalUtilizationTracker tracker;
        private long unflushedBytes;
        private boolean countLNsThisDB;
        private boolean checkFlushKeyThisDB;
        private long scannedRecords;
        private long extinctRecords;

        RecordExtinction(long id, NavigableSet<Long> dbIds, DatabaseEntry beginKey, DatabaseEntry endKey, ScanFilter filter, String label) {
            this.tracker = new LocalUtilizationTracker(ExtinctionScanner.this.envImpl);
            this.id = id;
            this.dbIds = dbIds;
            this.beginKey = beginKey != null ? LN.copyEntryData(beginKey) : null;
            this.endKey = endKey != null ? LN.copyEntryData(endKey) : null;
            this.filter = filter;
            this.label = label;
            this.countComplete = false;
            this.flushAtLastDb = 0L;
            this.flushAtLastKey = null;
        }

        RecordExtinction(long id, TupleInput in) {
            this.tracker = new LocalUtilizationTracker(ExtinctionScanner.this.envImpl);
            this.id = id;
            in.readPackedInt();
            this.countComplete = in.readBoolean();
            int nDbs = in.readPackedInt();
            this.dbIds = new TreeSet<Long>();
            long prevDbId = 0L;
            for (int i = 0; i < nDbs; ++i) {
                this.dbIds.add(prevDbId += in.readPackedLong());
            }
            int len = in.readPackedInt();
            if (len == 0) {
                this.beginKey = null;
            } else {
                this.beginKey = new byte[len];
                in.read(this.beginKey);
            }
            len = in.readPackedInt();
            if (len == 0) {
                this.endKey = null;
            } else {
                this.endKey = new byte[len];
                in.read(this.endKey);
            }
            len = in.readPackedInt();
            if (len == 0) {
                this.filter = null;
            } else {
                byte[] bytes = new byte[len];
                in.read(bytes);
                this.filter = (ScanFilter)DatabaseImpl.bytesToObject(bytes, "ScanFilter", ExtinctionScanner.this.envImpl.getClassLoader());
            }
            this.label = in.readString();
            this.flushAtLastDb = in.readPackedLong();
            len = in.readPackedInt();
            if (len == 0) {
                this.flushAtLastKey = null;
            } else {
                this.flushAtLastKey = new byte[len];
                in.read(this.flushAtLastKey);
            }
        }

        void serializeData(long flushedDbId, byte[] flushedKey, TupleOutput out) {
            out.writePackedInt(0);
            out.writeBoolean(this.countComplete);
            out.writePackedInt(this.dbIds.size());
            long prevDbId = 0L;
            for (long id : this.dbIds) {
                out.writePackedLong(id - prevDbId);
                prevDbId = id;
            }
            if (this.beginKey == null) {
                out.writePackedInt(0);
            } else {
                out.writePackedInt(this.beginKey.length);
                out.write(this.beginKey);
            }
            if (this.endKey == null) {
                out.writePackedInt(0);
            } else {
                out.writePackedInt(this.endKey.length);
                out.write(this.endKey);
            }
            if (this.filter == null) {
                out.writePackedInt(0);
            } else {
                byte[] bytes = DatabaseImpl.objectToBytes(this.filter, "ScanFilter");
                out.writePackedInt(bytes.length);
                out.write(bytes);
            }
            out.writeString(this.label);
            out.writePackedLong(flushedDbId);
            if (flushedKey == null) {
                out.writePackedInt(0);
            } else {
                out.writePackedInt(flushedKey.length);
                out.write(flushedKey);
            }
        }

        void writeTask(long flushedDbId, byte[] flushedKey, Locker locker, boolean insert) {
            assert (!ExtinctionScanner.this.envImpl.isReplicated() || insert == locker.isReplicated());
            assert (ExtinctionScanner.this.scanDb != null);
            DatabaseEntry keyEntry = new DatabaseEntry();
            DatabaseEntry dataEntry = new DatabaseEntry();
            ExtinctionScanner.serializeKey(this.id, keyEntry);
            TupleOutput out = ExtinctionScanner.serializeType(0);
            this.serializeData(flushedDbId, flushedKey, out);
            TupleBase.outputToEntry(out, dataEntry);
            try (Cursor cursor = DbInternal.makeCursor(ExtinctionScanner.this.scanDb, locker, null);){
                if (DbInternal.putWithRepContext(cursor, keyEntry, dataEntry, insert ? PutMode.NO_OVERWRITE : PutMode.OVERWRITE, locker.isReplicated() ? ExtinctionScanner.this.scanDb.getRepContext() : ReplicationContext.NO_REPLICATE) == null) {
                    throw EnvironmentFailureException.unexpectedState();
                }
            }
        }

        @Override
        public boolean isExtinctionForDb(DatabaseId dbId) {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private boolean isTaskCommitted() {
            BasicLocker locker = BasicLocker.createBasicLocker(ExtinctionScanner.this.envImpl, false);
            locker.setLockTimeout(500L);
            DatabaseEntry keyEntry = new DatabaseEntry();
            ExtinctionScanner.serializeKey(this.id, keyEntry);
            try {
                boolean bl;
                Throwable throwable;
                Cursor cursor;
                block25: {
                    block26: {
                        block22: {
                            boolean bl2;
                            block23: {
                                block24: {
                                    cursor = DbInternal.makeCursor(ExtinctionScanner.this.scanDb, (Locker)locker, null);
                                    throwable = null;
                                    if (cursor.get(keyEntry, null, Get.SEARCH, null) == null) break block22;
                                    bl2 = true;
                                    if (cursor == null) break block23;
                                    if (throwable == null) break block24;
                                    try {
                                        cursor.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    break block23;
                                }
                                cursor.close();
                            }
                            return bl2;
                        }
                        ExtinctionScanner.this.activeRecordTasks.remove(this.id);
                        bl = false;
                        if (cursor == null) break block25;
                        if (throwable == null) break block26;
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        break block25;
                    }
                    cursor.close();
                }
                return bl;
                catch (Throwable throwable4) {
                    try {
                        try {
                            throwable = throwable4;
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (cursor != null) {
                                if (throwable != null) {
                                    try {
                                        cursor.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    cursor.close();
                                }
                            }
                            throw throwable5;
                        }
                    }
                    catch (LockConflictException e) {
                        LoggerUtils.info(ExtinctionScanner.this.logger, ExtinctionScanner.this.envImpl, "Delaying extinct record scan, discardExtinctRecord txn is still open, id=" + this.id + " label=" + this.label);
                        assert (ExtinctionScanner.this.threadPool != null);
                        ExtinctionScanner.this.threadPool.execute(this);
                        boolean bl3 = false;
                        return bl3;
                    }
                }
            }
            finally {
                locker.operationEnd();
            }
        }

        @Override
        public void run() {
            assert (!ExtinctionScanner.this.completedRecordScans.contains(this.id));
            try {
                long pass1Extinct;
                long pass1Scanned;
                if (!this.isTaskCommitted()) {
                    return;
                }
                LoggerUtils.info(ExtinctionScanner.this.logger, ExtinctionScanner.this.envImpl, "Start extinct record scan, id=" + this.id + " label=" + this.label);
                if (!this.countComplete) {
                    if (ExtinctionScanner.this.beforeScan1Hook != null) {
                        ExtinctionScanner.this.beforeScan1Hook.doHook();
                    }
                    for (long dbId : this.dbIds) {
                        if (ExtinctionScanner.this.shutdownRequested) {
                            return;
                        }
                        this.scanDb(dbId);
                    }
                    if (ExtinctionScanner.this.beforeScan1FlushHook != null) {
                        ExtinctionScanner.this.beforeScan1FlushHook.doHook();
                    }
                    this.countComplete = true;
                    this.flushUtilization(0L, null);
                    pass1Scanned = this.scannedRecords;
                    pass1Extinct = this.extinctRecords;
                    this.scannedRecords = 0L;
                    this.extinctRecords = 0L;
                } else {
                    pass1Scanned = 0L;
                    pass1Extinct = 0L;
                }
                if (ExtinctionScanner.this.beforeScan2Hook != null) {
                    ExtinctionScanner.this.beforeScan2Hook.doHook();
                }
                for (long dbId : this.dbIds) {
                    if (ExtinctionScanner.this.shutdownRequested) {
                        return;
                    }
                    this.scanDb(dbId);
                }
                ExtinctionScanner.this.completedRecordScans.add(this.id);
                LoggerUtils.info(ExtinctionScanner.this.logger, ExtinctionScanner.this.envImpl, "End extinct record scan, wait for checkpoint, id=" + this.id + " pass1Scanned=" + pass1Scanned + " pass1Extinct=" + pass1Extinct + " pass2Scanned=" + this.scannedRecords + " pass2Extinct=" + this.extinctRecords + " label=" + this.label);
            }
            catch (Exception e) {
                LoggerUtils.warning(ExtinctionScanner.this.logger, ExtinctionScanner.this.envImpl, "Fatal exception during extinct record scan, id=" + this.id + " label=" + this.label + ": " + e);
                throw e;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void scanDb(long dbId) {
            DbTree dbTree = ExtinctionScanner.this.envImpl.getDbTree();
            DatabaseEntry keyEntry = new DatabaseEntry();
            DatabaseEntry dataEntry = null;
            boolean firstBatch = true;
            while (true) {
                ExtinctionScanner.this.envImpl.checkOpen();
                if (ExtinctionScanner.this.shutdownRequested) {
                    return;
                }
                DatabaseImpl dbImpl = dbTree.getDb(new DatabaseId(dbId));
                try {
                    if (dbImpl == null || dbImpl.isDeleting()) {
                        LoggerUtils.warning(ExtinctionScanner.this.logger, ExtinctionScanner.this.envImpl, "DB=" + dbId + " deleted during extinct record scan, id=" + this.id + " label=" + this.label);
                        return;
                    }
                    if (firstBatch) {
                        if (this.countComplete) {
                            this.countLNsThisDB = false;
                            this.checkFlushKeyThisDB = false;
                        } else {
                            boolean bl = this.countLNsThisDB = !dbImpl.isLNImmediatelyObsolete() && (this.flushAtLastKey == null || dbId >= this.flushAtLastDb);
                            if (!this.countLNsThisDB) {
                                return;
                            }
                            boolean bl2 = this.checkFlushKeyThisDB = this.flushAtLastKey != null && dbId == this.flushAtLastDb;
                        }
                        if (this.beginKey != null) {
                            keyEntry.setData(this.beginKey);
                        }
                        if (dbImpl.getSortedDuplicates()) {
                            dataEntry = new DatabaseEntry();
                        }
                    }
                    if (!this.scanBatch(dbImpl, keyEntry, dataEntry, firstBatch)) {
                        return;
                    }
                    firstBatch = false;
                }
                finally {
                    dbTree.releaseDb(dbImpl);
                }
                if (ExtinctionScanner.this.batchDelayMs <= 0) continue;
                try {
                    Thread.sleep(ExtinctionScanner.this.batchDelayMs);
                }
                catch (InterruptedException e) {
                    LoggerUtils.warning(ExtinctionScanner.this.logger, ExtinctionScanner.this.envImpl, "Extinct record scan interrupted, id=" + this.id + " label=" + this.label);
                    throw new ThreadInterruptedException(ExtinctionScanner.this.envImpl, (Throwable)e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean scanBatch(DatabaseImpl dbImpl, DatabaseEntry keyEntry, DatabaseEntry dataEntry, boolean firstBatch) {
            Locker locker = LockerFactory.getInternalReadOperationLocker(ExtinctionScanner.this.envImpl);
            try (Cursor cursor = DbInternal.makeCursor(dbImpl, locker, null, false);){
                DbInternal.excludeFromOpStats(cursor);
                cursor.setCacheMode(CacheMode.UNCHANGED);
                if (cursor.get(keyEntry, dataEntry, keyEntry.getData() == null ? Get.FIRST : (firstBatch ? Get.SEARCH_GTE : Get.SEARCH_ANY_GTE), NOLOCK_UNCHANGED) == null) {
                    boolean bl = false;
                    return bl;
                }
                long prevScanned = this.scannedRecords;
                while (true) {
                    if (ExtinctionScanner.this.shutdownRequested) {
                        boolean bl = false;
                        return bl;
                    }
                    CursorImpl cursorImpl = DbInternal.getCursorImpl(cursor);
                    cursorImpl.latchBIN();
                    try {
                        BIN bin = cursorImpl.getBIN();
                        bin.mutateToFullBIN(false);
                        if (!this.scanBIN(bin, cursorImpl.getIndex())) {
                            boolean bl = false;
                            return bl;
                        }
                        cursorImpl.setIndex(bin.getNEntries() - 1);
                    }
                    finally {
                        cursorImpl.releaseBIN();
                    }
                    if (cursor.get(keyEntry, dataEntry, Get.NEXT, NOLOCK_UNCHANGED) == null) {
                        boolean bl = false;
                        return bl;
                    }
                    if (this.unflushedBytes >= ExtinctionScanner.this.flushObsoleteBytes) {
                        this.unflushedBytes = 0L;
                    }
                    if (this.scannedRecords - prevScanned >= (long)ExtinctionScanner.this.batchSize) {
                        boolean bl = true;
                        return bl;
                    }
                    continue;
                    break;
                }
            }
            finally {
                locker.operationEnd();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void flushUtilization(long currentDbId, byte[] currentKey) {
            ExtinctionScanner.this.envImpl.getUtilizationProfile().flushLocalTracker(this.tracker);
            this.tracker = new LocalUtilizationTracker(ExtinctionScanner.this.envImpl);
            Txn locker = Txn.createLocalAutoTxn(ExtinctionScanner.this.envImpl, NO_SYNC_TXN);
            boolean success = false;
            try {
                this.writeTask(currentDbId, currentKey, locker, false);
                success = true;
            }
            finally {
                ((Locker)locker).operationEnd(success);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private boolean scanBIN(BIN bin, int startIndex) {
            boolean checkFlushKeyThisBIN;
            DatabaseImpl dbImpl = bin.getDatabase();
            int nEntries = bin.getNEntries();
            boolean checkEndKeyThisBIN = this.endKey != null;
            boolean countLNsThisBIN = this.countLNsThisDB;
            boolean bl = checkFlushKeyThisBIN = countLNsThisBIN && this.checkFlushKeyThisDB;
            if (nEntries - startIndex > 3 && (checkEndKeyThisBIN || checkFlushKeyThisBIN)) {
                byte[] lastBinKey = bin.getKey(nEntries - 1);
                if (checkEndKeyThisBIN && !this.passedEndKey(lastBinKey, dbImpl)) {
                    checkEndKeyThisBIN = false;
                }
                if (checkFlushKeyThisBIN && Key.compareKeys(lastBinKey, this.flushAtLastKey, dbImpl.getKeyComparator()) <= 0) {
                    countLNsThisBIN = false;
                    checkFlushKeyThisBIN = false;
                }
            }
            boolean moreKeys = true;
            boolean addToCompressorQueue = false;
            block6: for (int i = startIndex; i < nEntries && moreKeys; ++i) {
                long lsn;
                ++this.scannedRecords;
                byte[] slotKey = null;
                if (checkEndKeyThisBIN && this.passedEndKey(slotKey = bin.getKey(i), dbImpl)) {
                    moreKeys = false;
                    break;
                }
                if (this.filter != null) {
                    if (slotKey == null) {
                        slotKey = bin.getKey(i);
                    }
                    byte[] priKey = dbImpl.getSortedDuplicates() ? DupKeyData.getData(slotKey, 0, slotKey.length) : slotKey;
                    switch (this.filter.checkKey(priKey)) {
                        case INCLUDE: {
                            break;
                        }
                        case EXCLUDE: {
                            continue block6;
                        }
                        case INCLUDE_STOP: {
                            moreKeys = false;
                            break;
                        }
                        case EXCLUDE_STOP: {
                            moreKeys = false;
                            continue block6;
                        }
                    }
                }
                ++this.extinctRecords;
                if (this.countComplete) {
                    bin.setKnownDeleted(i);
                    addToCompressorQueue = true;
                }
                if (!countLNsThisBIN || bin.isEmbeddedLN(i) || bin.isDefunct(i) || DbLsn.isTransientOrNull(lsn = bin.getLsn(i))) continue;
                if (checkFlushKeyThisBIN) {
                    if (slotKey == null) {
                        slotKey = bin.getKey(i);
                    }
                    if (Key.compareKeys(slotKey, this.flushAtLastKey, dbImpl.getKeyComparator()) < 0) continue;
                    checkFlushKeyThisBIN = false;
                    this.checkFlushKeyThisDB = false;
                }
                int size = bin.getLastLoggedSize(i);
                this.tracker.countObsolete(lsn, null, size, false, false);
                this.unflushedBytes += (long)size;
            }
            if (addToCompressorQueue) {
                bin.setProhibitNextDelta(true);
                ExtinctionScanner.this.envImpl.addToCompressorQueue(bin);
            }
            return moreKeys;
        }

        private boolean passedEndKey(byte[] binKey, DatabaseImpl dbImpl) {
            return dbImpl.getSortedDuplicates() ? DupKeyData.compareMainKey(binKey, this.endKey, 0, this.endKey.length, dbImpl.getBtreeComparator()) >= 0 : Key.compareKeys(binKey, this.endKey, dbImpl.getBtreeComparator()) >= 0;
        }

        private boolean isKeyTargeted(DatabaseImpl dbImpl, byte[] key) {
            if (!this.dbIds.contains(dbImpl.getId().getId())) {
                return false;
            }
            if (this.beginKey != null && ExtinctionScanner.compareMainKey(key, this.beginKey, dbImpl) < 0) {
                return false;
            }
            if (this.endKey != null && ExtinctionScanner.compareMainKey(key, this.endKey, dbImpl) > 0) {
                return false;
            }
            return this.filter == null || this.filter.checkKey(key).getInclude();
        }
    }

    private static interface ExtinctionTask
    extends Runnable {
        public boolean isExtinctionForDb(DatabaseId var1);
    }
}

