/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import visad.Delaunay;
import visad.SetException;
import visad.VisADException;

public class DelaunayOverlap
extends Delaunay {
    private boolean sig;
    private static final float[][] m_samples = new float[][]{{65.0f, 142.0f, 215.0f, 315.0f, 373.0f, 435.0f, 39.0f, 118.0f, 202.0f, 320.0f, 373.0f, 455.0f, 40.0f, 114.0f, 206.0f, 307.0f, 384.0f, 457.0f, 66.0f, 128.0f, 208.0f, 308.0f, 380.0f, 436.0f, 83.0f, 144.0f, 201.0f, 293.0f, 354.0f, 433.0f, 60.0f, 135.0f, 202.0f, 285.0f, 355.0f, 456.0f, 59.0f, 136.0f, 204.0f, 284.0f, 362.0f, 456.0f, 75.0f, 138.0f, 207.0f, 285.0f, 363.0f, 438.0f, 90.0f, 153.0f, 217.0f, 292.0f, 358.0f, 441.0f, 61.0f, 145.0f, 216.0f, 292.0f, 366.0f, 452.0f, 55.0f, 143.0f, 213.0f, 295.0f, 373.0f, 463.0f, 80.0f, 148.0f, 217.0f, 295.0f, 375.0f, 444.0f}, {67.0f, 87.0f, 103.0f, 104.0f, 72.0f, 42.0f, 122.0f, 148.0f, 160.0f, 165.0f, 156.0f, 109.0f, 212.0f, 211.0f, 203.0f, 200.0f, 204.0f, 211.0f, 282.0f, 263.0f, 248.0f, 243.0f, 256.0f, 287.0f, 166.0f, 187.0f, 201.0f, 207.0f, 185.0f, 155.0f, 230.0f, 235.0f, 240.0f, 241.0f, 235.0f, 210.0f, 283.0f, 275.0f, 270.0f, 267.0f, 273.0f, 280.0f, 338.0f, 310.0f, 299.0f, 297.0f, 305.0f, 331.0f, 247.0f, 270.0f, 277.0f, 276.0f, 265.0f, 233.0f, 295.0f, 319.0f, 325.0f, 322.0f, 306.0f, 281.0f, 368.0f, 371.0f, 368.0f, 362.0f, 372.0f, 376.0f, 464.0f, 431.0f, 417.0f, 418.0f, 424.0f, 455.0f}};
    private static final int m_lenx = 6;
    private static final int m_leny = 4;
    private static final int m_numgrids = 3;
    private static final Color[] m_col = new Color[]{Color.black, Color.gray, Color.blue};
    private static DelaunayOverlap delO = null;

    public DelaunayOverlap(float[][] samples, int lenx, int leny) throws VisADException {
        int i;
        int curpt;
        int curgrid;
        if (samples.length < 2) {
            throw new SetException("DelaunayOverlap: bad dimension");
        }
        if (lenx < 2 || leny < 2) {
            throw new SetException("DelaunayOverlap: must have at least two points per dimension");
        }
        if (samples[0].length < lenx * leny) {
            throw new SetException("DelaunayOverlap: not enough samples");
        }
        int lenp = lenx * leny;
        int leng = (lenx - 1) * (leny - 1);
        int numgrids = samples[0].length / lenp;
        if (numgrids < 2) {
            throw new SetException("DelaunayOverlap: not enough grids (try Gridded2DSet instead)");
        }
        this.sig = (samples[0][1] - samples[0][0]) * (samples[1][lenx + 1] - samples[1][1]) - (samples[1][1] - samples[1][0]) * (samples[0][lenx + 1] - samples[0][1]) > 0.0f;
        for (int curgrid2 = 0; curgrid2 < numgrids; ++curgrid2) {
            for (int gy = 0; gy < leny - 1; ++gy) {
                for (int gx = 0; gx < lenx - 1; ++gx) {
                    int q = curgrid2 * lenp + gy * lenx + gx;
                    float v00x = samples[0][q];
                    float v00y = samples[1][q];
                    float v10x = samples[0][q + 1];
                    float v10y = samples[1][q + 1];
                    float v01x = samples[0][q + lenx];
                    float v01y = samples[1][q + lenx];
                    float v11y = samples[1][q + lenx + 1];
                    float v11x = samples[0][q + lenx + 1];
                    if ((v10x - v00x) * (v11y - v10y) - (v10y - v00y) * (v11x - v10x) > 0.0f == this.sig && (v11x - v10x) * (v01y - v11y) - (v11y - v10y) * (v01x - v11x) > 0.0f == this.sig && (v01x - v11x) * (v00y - v01y) - (v01y - v11y) * (v00x - v01x) > 0.0f == this.sig && (v00x - v01x) * (v10y - v00y) - (v00y - v01y) * (v10x - v00x) > 0.0f == this.sig) continue;
                    throw new SetException("DelaunayOverlap: samples from grid " + curgrid2 + " do not form a valid grid " + "(" + gx + "," + gy + ")");
                }
            }
        }
        int ngrid = (numgrids - 1) * (lenx - 1) * (leny - 1);
        int[][] grid = new int[ngrid][5];
        int[] gsize = new int[ngrid];
        int[] glen = new int[ngrid];
        for (int g2 = 0; g2 < numgrids - 1; ++g2) {
            for (int gy = 0; gy < leny - 1; ++gy) {
                for (int gx = 0; gx < lenx - 1; ++gx) {
                    int qg = leng * g2 + (lenx - 1) * gy + gx;
                    gsize[qg] = 4;
                    glen[qg] = 0;
                }
            }
        }
        int[][] broken = new int[numgrids][lenx + 1];
        for (int g3 = 0; g3 < numgrids; ++g3) {
            for (int pix = 0; pix < lenx + 1; ++pix) {
                broken[g3][pix] = -1;
            }
        }
        int[] leftedge = new int[numgrids * leny];
        int ledges = 0;
        int[] rightedge = new int[numgrids * leny];
        int redges = 0;
        int[] ltrinum = new int[numgrids * leny];
        int[] ltriedge = new int[numgrids * leny];
        int[] rtrinum = new int[numgrids * leny];
        int[] rtriedge = new int[numgrids * leny];
        boolean[] ptfell = new boolean[numgrids * lenx * leny];
        for (int g4 = 0; g4 < numgrids; ++g4) {
            for (int line = 0; line < leny; ++line) {
                for (int pix = 0; pix < lenx; ++pix) {
                    ptfell[lenp * g4 + lenx * line + pix] = false;
                }
            }
        }
        int[] bottom = new int[lenx - 1];
        for (int i2 = 0; i2 < lenx - 1; ++i2) {
            bottom[i2] = -1;
        }
        int[][] tlr = new int[leng][3];
        boolean[] istwo = new boolean[leng];
        int trisize = 0;
        int trilen = 0;
        int prevgrid = 0;
        int[] foundx = new int[numgrids];
        int[] foundy = new int[numgrids];
        int cenx = lenx / 2 - 1;
        int ceny = leny / 2 - 1;
        for (curgrid = 1; curgrid < numgrids; ++curgrid) {
            for (int g5 = 0; g5 < numgrids; ++g5) {
                foundx[g5] = cenx;
                foundy[g5] = ceny;
            }
            int gfound = curgrid;
            for (int line = 0; line < leny; ++line) {
                int lfound = curgrid;
                block41: for (int pix = 0; pix < lenx; ++pix) {
                    curpt = lenp * curgrid + lenx * line + pix;
                    float x = samples[0][curpt];
                    float y = samples[1][curpt];
                    boolean found = false;
                    for (int g6 = prevgrid; g6 < curgrid; ++g6) {
                        int gx = foundx[g6];
                        int gy = foundy[g6];
                        while (!found) {
                            int q = lenp * g6 + lenx * gy + gx;
                            float ax = samples[0][q];
                            float ay = samples[1][q];
                            float bx = samples[0][q + 1];
                            float by = samples[1][q + 1];
                            float cx = samples[0][q + lenx];
                            float cy = samples[1][q + lenx];
                            float dx = samples[0][q + lenx + 1];
                            float dy = samples[1][q + lenx + 1];
                            int ogx = gx;
                            int ogy = gy;
                            switch (((ax - bx) * (y - by) - (ay - by) * (x - bx) < 0.0f == this.sig ? 0 : 1) + ((bx - dx) * (y - dy) - (by - dy) * (x - dx) < 0.0f == this.sig ? 0 : 2) + ((dx - cx) * (y - cy) - (dy - cy) * (x - cx) < 0.0f == this.sig ? 0 : 4) + ((cx - ax) * (y - ay) - (cy - ay) * (x - ax) < 0.0f == this.sig ? 0 : 8)) {
                                case 0: {
                                    int qg = leng * g6 + (lenx - 1) * gy + gx;
                                    found = true;
                                    if (lfound > g6) {
                                        lfound = g6;
                                    }
                                    if (gfound > g6) {
                                        gfound = g6;
                                    }
                                    foundx[g6] = gx;
                                    foundy[g6] = gy;
                                    int n = qg;
                                    int n2 = glen[n];
                                    glen[n] = n2 + 1;
                                    grid[qg][n2] = curpt;
                                    if (glen[qg] > gsize[qg]) {
                                        int[] newg = new int[gsize[q] + gsize[q] + 1];
                                        System.arraycopy(grid[qg], 0, newg, 0, gsize[qg]);
                                        grid[qg] = newg;
                                        int n3 = qg;
                                        gsize[n3] = gsize[n3] + gsize[qg];
                                    }
                                    ptfell[curpt] = true;
                                    if (broken[curgrid][pix] < line) {
                                        broken[curgrid][pix] = line;
                                    }
                                    if (broken[curgrid][pix + 1] >= line) break;
                                    broken[curgrid][pix + 1] = line;
                                    break;
                                }
                                case 1: 
                                case 11: {
                                    --gy;
                                    break;
                                }
                                case 2: 
                                case 7: {
                                    ++gx;
                                    break;
                                }
                                case 3: {
                                    ++gx;
                                    --gy;
                                    break;
                                }
                                case 4: 
                                case 14: {
                                    ++gy;
                                    break;
                                }
                                case 6: {
                                    ++gx;
                                    ++gy;
                                    break;
                                }
                                case 8: 
                                case 13: {
                                    --gx;
                                    break;
                                }
                                case 9: {
                                    --gx;
                                    --gy;
                                    break;
                                }
                                case 12: {
                                    --gx;
                                    ++gy;
                                    break;
                                }
                                default: {
                                    throw new SetException("DelaunayOverlap: pathological grid");
                                }
                            }
                            if (gx > lenx - 2) {
                                gx = lenx - 2;
                            }
                            if (gx < 0) {
                                gx = 0;
                            }
                            if (gy > leny - 2) {
                                gy = leny - 2;
                            }
                            if (gy < 0) {
                                gy = 0;
                            }
                            if (ogx != gx || ogy != gy || found) continue;
                        }
                        if (found) continue block41;
                    }
                }
                prevgrid = lfound;
            }
            prevgrid = gfound;
        }
        int z = lenp - lenx;
        for (int g7 = 0; g7 < numgrids; ++g7) {
            foundx[g7] = cenx;
            foundy[g7] = ceny;
        }
        for (curgrid = 0; curgrid < numgrids - 1; ++curgrid) {
            for (int pix = 0; pix < lenx; ++pix) {
                curpt = lenp * curgrid + z + pix;
                float x = samples[0][curpt];
                float y = samples[1][curpt];
                int g8 = curgrid + 1;
                int gx = foundx[g8];
                int gy = foundy[g8];
                boolean found = false;
                while (!found) {
                    int q = lenp * g8 + lenx * gy + gx;
                    float ax = samples[0][q];
                    float ay = samples[1][q];
                    float bx = samples[0][q + 1];
                    float by = samples[1][q + 1];
                    float cx = samples[0][q + lenx];
                    float cy = samples[1][q + lenx];
                    float dx = samples[0][q + lenx + 1];
                    float dy = samples[1][q + lenx + 1];
                    int ogx = gx;
                    int ogy = gy;
                    switch (((ax - bx) * (y - by) - (ay - by) * (x - bx) < 0.0f == this.sig ? 0 : 1) + ((bx - dx) * (y - dy) - (by - dy) * (x - dx) < 0.0f == this.sig ? 0 : 2) + ((dx - cx) * (y - cy) - (dy - cy) * (x - cx) < 0.0f == this.sig ? 0 : 4) + ((cx - ax) * (y - ay) - (cy - ay) * (x - ax) < 0.0f == this.sig ? 0 : 8)) {
                        case 0: {
                            found = true;
                            foundx[g8] = gx;
                            foundy[g8] = gy;
                            if (broken[g8][gx + 1] >= gy) break;
                            broken[g8][gx + 1] = gy;
                            break;
                        }
                        case 1: 
                        case 11: {
                            --gy;
                            break;
                        }
                        case 2: 
                        case 7: {
                            ++gx;
                            break;
                        }
                        case 3: {
                            ++gx;
                            --gy;
                            break;
                        }
                        case 4: 
                        case 14: {
                            ++gy;
                            break;
                        }
                        case 6: {
                            ++gx;
                            ++gy;
                            break;
                        }
                        case 8: 
                        case 13: {
                            --gx;
                            break;
                        }
                        case 9: {
                            --gx;
                            --gy;
                            break;
                        }
                        case 12: {
                            --gx;
                            ++gy;
                            break;
                        }
                        default: {
                            throw new SetException("DelaunayOverlap: pathological grid");
                        }
                    }
                    if (gx > lenx - 2) {
                        gx = lenx - 2;
                    }
                    if (gx < 0) {
                        gx = 0;
                    }
                    if (gy > leny - 2) {
                        gy = leny - 2;
                    }
                    if (gy < 0) {
                        gy = 0;
                    }
                    if (ogx != gx || ogy != gy || found) continue;
                }
            }
        }
        leftedge[0] = 0;
        for (i = 1; i < leny; ++i) {
            leftedge[i] = leftedge[i - 1] + lenx;
        }
        ledges += leny;
        rightedge[0] = lenx - 1;
        for (i = 1; i < leny; ++i) {
            rightedge[i] = rightedge[i - 1] + lenx;
        }
        redges += leny;
        for (curgrid = 0; curgrid < numgrids; ++curgrid) {
            for (int gy = 0; gy < leny - 1; ++gy) {
                for (int gx = 0; gx < lenx - 1; ++gx) {
                    int npts = curgrid == numgrids - 1 ? 0 : glen[leng * curgrid + (lenx - 1) * gy + gx];
                    trisize += 2 * npts + 2;
                }
            }
        }
        int[][] tri = new int[(trisize += 2 * leny * numgrids) + 2][3];
        int[][] walk = new int[trisize + 2][3];
        for (i = 0; i < trisize + 2; ++i) {
            walk[i][0] = -1;
            walk[i][1] = -1;
            walk[i][2] = -1;
        }
        for (curgrid = 0; curgrid < numgrids; ++curgrid) {
            int x;
            int i3;
            int oneUp1y;
            int oneUp1x;
            int i4;
            int end1;
            int end2;
            int start1;
            int start2;
            int pt;
            int min2;
            boolean sig;
            int[] old_bottom = bottom;
            bottom = new int[lenx - 1];
            for (i = 0; i < lenx - 1; ++i) {
                bottom[i] = -1;
            }
            for (int gx = 0; gx < lenx - 1; ++gx) {
                block57: for (int gy = broken[curgrid][gx + 1] + 1; gy < leny - 1; ++gy) {
                    int q = lenp * curgrid + lenx * gy + gx;
                    int qmg = (lenx - 1) * gy + gx;
                    int qg = leng * curgrid + qmg;
                    int A2 = q;
                    int B = q + 1;
                    int C2 = q + lenx;
                    int D = q + lenx + 1;
                    switch (curgrid == numgrids - 1 ? 0 : glen[qg]) {
                        case 0: {
                            float ax = samples[0][A2];
                            float ay = samples[1][A2];
                            float bx = samples[0][B];
                            float by = samples[1][B];
                            float cx = samples[0][C2];
                            float cy = samples[1][C2];
                            float dx = samples[0][D];
                            float dy = samples[1][D];
                            float abx = ax - bx;
                            float aby = ay - by;
                            float acx = ax - cx;
                            float acy = ay - cy;
                            float dbx = dx - bx;
                            float dby = dy - by;
                            float dcx = dx - cx;
                            float dcy = dy - cy;
                            float Q = abx * acx + aby * acy;
                            float R = dbx * abx + dby * aby;
                            float S = acx * dcx + acy * dcy;
                            float T = dbx * dcx + dby * dcy;
                            boolean diag = Q < 0.0f && T < 0.0f || R > 0.0f && S > 0.0f ? true : (R < 0.0f && S < 0.0f || Q > 0.0f && T > 0.0f ? false : (Q < 0.0f ? Q : T) < (R < 0.0f ? R : S));
                            if (diag) {
                                tri[trilen][0] = B;
                                tri[trilen][1] = D;
                                tri[trilen][2] = A2;
                                walk[trilen][2] = bottom[gx];
                                if (bottom[gx] >= 0) {
                                    walk[bottom[gx]][1] = trilen;
                                }
                                walk[trilen][1] = trilen + 1;
                                tri[++trilen][0] = A2;
                                tri[trilen][1] = D;
                                tri[trilen][2] = C2;
                                if (gx > 0 && broken[curgrid][gx] < gy) {
                                    walk[trilen][2] = tlr[qmg - 1][2];
                                    walk[tlr[qmg - 1][2]][0] = trilen;
                                } else {
                                    walk[trilen][2] = -1;
                                }
                                walk[trilen][0] = trilen - 1;
                                bottom[gx] = ++trilen - 1;
                                tlr[qmg][0] = trilen - 2;
                                tlr[qmg][1] = trilen - 1;
                                tlr[qmg][2] = trilen - 2;
                                istwo[qmg] = true;
                                continue block57;
                            }
                            tri[trilen][0] = A2;
                            tri[trilen][1] = B;
                            tri[trilen][2] = C2;
                            walk[trilen][0] = bottom[gx];
                            if (bottom[gx] >= 0) {
                                walk[bottom[gx]][1] = trilen;
                            }
                            if (gx > 0 && broken[curgrid][gx] < gy) {
                                walk[trilen][2] = tlr[qmg - 1][2];
                                walk[tlr[qmg - 1][2]][0] = trilen;
                            } else {
                                walk[trilen][2] = -1;
                            }
                            walk[trilen][1] = trilen + 1;
                            tri[++trilen][0] = B;
                            tri[trilen][1] = D;
                            tri[trilen][2] = C2;
                            walk[trilen][2] = trilen - 1;
                            bottom[gx] = ++trilen - 1;
                            tlr[qmg][0] = trilen - 2;
                            tlr[qmg][1] = trilen - 2;
                            tlr[qmg][2] = trilen - 1;
                            istwo[qmg] = false;
                            continue block57;
                        }
                        case 1: {
                            int G1 = grid[qg][0];
                            tri[trilen][0] = B;
                            tri[trilen][1] = G1;
                            tri[trilen][2] = A2;
                            walk[trilen][2] = bottom[gx];
                            if (bottom[gx] >= 0) {
                                walk[bottom[gx]][1] = trilen;
                            }
                            walk[trilen][0] = trilen + 1;
                            walk[trilen][1] = trilen + 3;
                            tri[++trilen][0] = B;
                            tri[trilen][1] = D;
                            tri[trilen][2] = G1;
                            walk[trilen][1] = trilen + 1;
                            walk[trilen][2] = trilen - 1;
                            tri[++trilen][0] = G1;
                            tri[trilen][1] = D;
                            tri[trilen][2] = C2;
                            walk[trilen][0] = trilen - 1;
                            walk[trilen][2] = trilen + 1;
                            tri[++trilen][0] = A2;
                            tri[trilen][1] = G1;
                            tri[trilen][2] = C2;
                            if (gx > 0 && broken[curgrid][gx] < gy) {
                                walk[trilen][2] = tlr[qmg - 1][2];
                                walk[tlr[qmg - 1][2]][0] = trilen;
                            } else {
                                walk[trilen][2] = -1;
                            }
                            walk[trilen][0] = trilen - 3;
                            walk[trilen][1] = trilen - 1;
                            bottom[gx] = ++trilen - 2;
                            tlr[qmg][0] = trilen - 4;
                            tlr[qmg][1] = trilen - 1;
                            tlr[qmg][2] = trilen - 3;
                            istwo[qmg] = true;
                            continue block57;
                        }
                        default: {
                            float Qy2;
                            float Qx2;
                            float Qy1;
                            float Qx1;
                            float val2;
                            int G1 = grid[qg][0];
                            int G2 = grid[qg][1];
                            float Gdx = samples[0][G2] - samples[0][G1];
                            float Gdy = samples[1][G2] - samples[1][G1];
                            float ax = samples[0][A2];
                            float ay = samples[1][A2];
                            float bx = samples[0][B];
                            float by = samples[1][B];
                            float cx = samples[0][C2];
                            float cy = samples[1][C2];
                            float dx = samples[0][D];
                            float dy = samples[1][D];
                            float val1 = Gdx * (ax - dx) + Gdy * (ay - dy);
                            if (val1 < 0.0f) {
                                val1 = -val1;
                            }
                            if ((val2 = Gdx * (bx - cx) + Gdy * (by - cy)) < 0.0f) {
                                val2 = -val2;
                            }
                            if (val1 > val2) {
                                Qx1 = ax - samples[0][G1];
                                Qy1 = ay - samples[1][G1];
                                Qx2 = ax - samples[0][G2];
                                Qy2 = ay - samples[1][G2];
                                if (Qx1 * Qx1 + Qy1 * Qy1 < Qx2 * Qx2 + Qy2 * Qy2) {
                                    tri[trilen][0] = B;
                                    tri[trilen][1] = G1;
                                    tri[trilen][2] = A2;
                                    walk[trilen][2] = bottom[gx];
                                    if (bottom[gx] >= 0) {
                                        walk[bottom[gx]][1] = trilen;
                                    }
                                    walk[trilen][0] = trilen + 5;
                                    walk[trilen][1] = trilen + 1;
                                    tri[++trilen][0] = A2;
                                    tri[trilen][1] = G1;
                                    tri[trilen][2] = C2;
                                    if (gx > 0 && broken[curgrid][gx] < gy) {
                                        walk[trilen][2] = tlr[qmg - 1][2];
                                        walk[tlr[qmg - 1][2]][0] = trilen;
                                    } else {
                                        walk[trilen][2] = -1;
                                    }
                                    walk[trilen][0] = trilen - 1;
                                    walk[trilen][1] = trilen + 3;
                                    tri[++trilen][0] = G2;
                                    tri[trilen][1] = D;
                                    tri[trilen][2] = C2;
                                    walk[trilen][0] = trilen + 1;
                                    walk[trilen][2] = trilen + 2;
                                    tri[++trilen][0] = B;
                                    tri[trilen][1] = D;
                                    tri[trilen][2] = G2;
                                    walk[trilen][1] = trilen - 1;
                                    walk[trilen][2] = trilen + 2;
                                    tri[++trilen][0] = C2;
                                    tri[trilen][1] = G1;
                                    tri[trilen][2] = G2;
                                    walk[trilen][0] = trilen - 3;
                                    walk[trilen][1] = trilen + 1;
                                    walk[trilen][2] = trilen - 2;
                                    tri[++trilen][0] = B;
                                    tri[trilen][1] = G2;
                                    tri[trilen][2] = G1;
                                    walk[trilen][0] = trilen - 2;
                                    walk[trilen][1] = trilen - 1;
                                    walk[trilen][2] = trilen - 5;
                                    bottom[gx] = ++trilen - 4;
                                    tlr[qmg][0] = trilen - 6;
                                    tlr[qmg][1] = trilen - 5;
                                    tlr[qmg][2] = trilen - 3;
                                    istwo[qmg] = true;
                                } else {
                                    tri[trilen][0] = B;
                                    tri[trilen][1] = G2;
                                    tri[trilen][2] = A2;
                                    walk[trilen][2] = bottom[gx];
                                    if (bottom[gx] >= 0) {
                                        walk[bottom[gx]][1] = trilen;
                                    }
                                    walk[trilen][0] = trilen + 5;
                                    walk[trilen][1] = trilen + 1;
                                    tri[++trilen][0] = A2;
                                    tri[trilen][1] = G2;
                                    tri[trilen][2] = C2;
                                    if (gx > 0 && broken[curgrid][gx] < gy) {
                                        walk[trilen][2] = tlr[qmg - 1][2];
                                        walk[tlr[qmg - 1][2]][0] = trilen;
                                    } else {
                                        walk[trilen][2] = -1;
                                    }
                                    walk[trilen][0] = trilen - 1;
                                    walk[trilen][1] = trilen + 3;
                                    tri[++trilen][0] = G1;
                                    tri[trilen][1] = D;
                                    tri[trilen][2] = C2;
                                    walk[trilen][0] = trilen + 1;
                                    walk[trilen][2] = trilen + 2;
                                    tri[++trilen][0] = B;
                                    tri[trilen][1] = D;
                                    tri[trilen][2] = G1;
                                    walk[trilen][1] = trilen - 1;
                                    walk[trilen][2] = trilen + 2;
                                    tri[++trilen][0] = C2;
                                    tri[trilen][1] = G2;
                                    tri[trilen][2] = G1;
                                    walk[trilen][0] = trilen - 3;
                                    walk[trilen][1] = trilen + 1;
                                    walk[trilen][2] = trilen - 2;
                                    tri[++trilen][0] = B;
                                    tri[trilen][1] = G1;
                                    tri[trilen][2] = G2;
                                    walk[trilen][0] = trilen - 2;
                                    walk[trilen][1] = trilen - 1;
                                    walk[trilen][2] = trilen - 5;
                                    bottom[gx] = ++trilen - 4;
                                    tlr[qmg][0] = trilen - 6;
                                    tlr[qmg][1] = trilen - 5;
                                    tlr[qmg][2] = trilen - 3;
                                    istwo[qmg] = true;
                                }
                            } else {
                                Qx1 = bx - samples[0][G1];
                                Qy1 = by - samples[1][G1];
                                Qx2 = bx - samples[0][G2];
                                Qy2 = by - samples[1][G2];
                                if (Qx1 * Qx1 + Qy1 * Qy1 < Qx2 * Qx2 + Qy2 * Qy2) {
                                    tri[trilen][0] = B;
                                    tri[trilen][1] = G1;
                                    tri[trilen][2] = A2;
                                    walk[trilen][2] = bottom[gx];
                                    if (bottom[gx] >= 0) {
                                        walk[bottom[gx]][1] = trilen;
                                    }
                                    walk[trilen][0] = trilen + 3;
                                    walk[trilen][1] = trilen + 4;
                                    tri[++trilen][0] = A2;
                                    tri[trilen][1] = G2;
                                    tri[trilen][2] = C2;
                                    if (gx > 0 && broken[curgrid][gx] < gy) {
                                        walk[trilen][2] = tlr[qmg - 1][2];
                                        walk[tlr[qmg - 1][2]][0] = trilen;
                                    } else {
                                        walk[trilen][2] = -1;
                                    }
                                    walk[trilen][0] = trilen + 3;
                                    walk[trilen][1] = trilen + 1;
                                    tri[++trilen][0] = G2;
                                    tri[trilen][1] = D;
                                    tri[trilen][2] = C2;
                                    walk[trilen][0] = trilen + 3;
                                    walk[trilen][2] = trilen - 1;
                                    tri[++trilen][0] = B;
                                    tri[trilen][1] = D;
                                    tri[trilen][2] = G1;
                                    walk[trilen][1] = trilen + 2;
                                    walk[trilen][2] = trilen - 3;
                                    tri[++trilen][0] = A2;
                                    tri[trilen][1] = G1;
                                    tri[trilen][2] = G2;
                                    walk[trilen][0] = trilen - 4;
                                    walk[trilen][1] = trilen + 1;
                                    walk[trilen][2] = trilen - 3;
                                    tri[++trilen][0] = D;
                                    tri[trilen][1] = G2;
                                    tri[trilen][2] = G1;
                                    walk[trilen][0] = trilen - 3;
                                    walk[trilen][1] = trilen - 1;
                                    walk[trilen][2] = trilen - 2;
                                    bottom[gx] = ++trilen - 4;
                                    tlr[qmg][0] = trilen - 6;
                                    tlr[qmg][1] = trilen - 5;
                                    tlr[qmg][2] = trilen - 3;
                                    istwo[qmg] = true;
                                } else {
                                    tri[trilen][0] = B;
                                    tri[trilen][1] = G2;
                                    tri[trilen][2] = A2;
                                    walk[trilen][2] = bottom[gx];
                                    if (bottom[gx] >= 0) {
                                        walk[bottom[gx]][1] = trilen;
                                    }
                                    walk[trilen][0] = trilen + 3;
                                    walk[trilen][1] = trilen + 4;
                                    tri[++trilen][0] = A2;
                                    tri[trilen][1] = G1;
                                    tri[trilen][2] = C2;
                                    if (gx > 0 && broken[curgrid][gx] < gy) {
                                        walk[trilen][2] = tlr[qmg - 1][2];
                                        walk[tlr[qmg - 1][2]][0] = trilen;
                                    } else {
                                        walk[trilen][2] = -1;
                                    }
                                    walk[trilen][0] = trilen + 3;
                                    walk[trilen][1] = trilen + 1;
                                    tri[++trilen][0] = G1;
                                    tri[trilen][1] = D;
                                    tri[trilen][2] = C2;
                                    walk[trilen][0] = trilen + 3;
                                    walk[trilen][2] = trilen - 1;
                                    tri[++trilen][0] = B;
                                    tri[trilen][1] = D;
                                    tri[trilen][2] = G2;
                                    walk[trilen][1] = trilen + 2;
                                    walk[trilen][2] = trilen - 3;
                                    tri[++trilen][0] = A2;
                                    tri[trilen][1] = G2;
                                    tri[trilen][2] = G1;
                                    walk[trilen][0] = trilen - 4;
                                    walk[trilen][1] = trilen + 1;
                                    walk[trilen][2] = trilen - 3;
                                    tri[++trilen][0] = D;
                                    tri[trilen][1] = G1;
                                    tri[trilen][2] = G2;
                                    walk[trilen][0] = trilen - 3;
                                    walk[trilen][1] = trilen - 1;
                                    walk[trilen][2] = trilen - 2;
                                    bottom[gx] = ++trilen - 4;
                                    tlr[qmg][0] = trilen - 6;
                                    tlr[qmg][1] = trilen - 5;
                                    tlr[qmg][2] = trilen - 3;
                                    istwo[qmg] = true;
                                }
                            }
                            int starttri = trilen - 1;
                            int maxit = 2 * glen[qg] + 2;
                            for (int i5 = 2; i5 < glen[qg]; ++i5) {
                                int w;
                                int we2;
                                int we0;
                                int pt2 = grid[qg][i5];
                                int curtri = starttri;
                                int p0 = -1;
                                int p1 = -1;
                                int p2 = -1;
                                int w0 = -1;
                                int w1 = -1;
                                int w2 = -1;
                                boolean found = false;
                                for (int itnum = 0; itnum < maxit && !found; ++itnum) {
                                    boolean t2;
                                    boolean t1;
                                    boolean t0;
                                    p0 = tri[curtri][0];
                                    p1 = tri[curtri][1];
                                    p2 = tri[curtri][2];
                                    w0 = walk[curtri][0];
                                    w1 = walk[curtri][1];
                                    w2 = walk[curtri][2];
                                    float ptx = samples[0][pt2];
                                    float pty = samples[1][pt2];
                                    float p0x = samples[0][p0];
                                    float p0y = samples[1][p0];
                                    float p1x = samples[0][p1];
                                    float p1y = samples[1][p1];
                                    float p2x = samples[0][p2];
                                    float p2y = samples[1][p2];
                                    float p01x = p0x - p1x;
                                    float p01y = p0y - p1y;
                                    float p02x = p0x - p2x;
                                    float p02y = p0y - p2y;
                                    float p12x = p1x - p2x;
                                    float p12y = p1y - p2y;
                                    float c0 = p01x * (p0y - pty) - p01y * (p0x - ptx);
                                    float c1 = p12x * (p1y - pty) - p12y * (p1x - ptx);
                                    float c2 = p02x * (pty - p2y) - p02y * (ptx - p2x);
                                    boolean bl = c0 == 0.0f || c0 > 0.0f == p01x * p02y - p01y * p02x > 0.0f ? true : (t0 = false);
                                    boolean bl2 = c1 == 0.0f || c1 > 0.0f == p12x * p01y - p12y * p01x > 0.0f ? true : (t1 = false);
                                    boolean bl3 = c2 == 0.0f || c2 > 0.0f == p02x * p12y - p02y * p12x > 0.0f ? true : (t2 = false);
                                    if (!(t0 || t1 || t2)) {
                                        throw new SetException("DelaunayOverlap: subtriangulation error");
                                    }
                                    if (!t0) {
                                        if (curtri != tlr[qmg][2]) {
                                            curtri = w0;
                                            continue;
                                        }
                                        throw new SetException("DelaunayOverlap: subtriangulation error");
                                    }
                                    if (!t1) {
                                        if (curtri != bottom[gx]) {
                                            curtri = w1;
                                            continue;
                                        }
                                        throw new SetException("DelaunayOverlap: subtriangulation error");
                                    }
                                    if (!t2) {
                                        if (curtri != tlr[qmg][0] && curtri != tlr[qmg][1]) {
                                            curtri = w2;
                                            continue;
                                        }
                                        throw new SetException("DelaunayOverlap: subtriangulation error");
                                    }
                                    found = true;
                                }
                                if (!found) {
                                    throw new SetException("DelaunayOverlap: subtriangulation error");
                                }
                                if (curtri == bottom[gx]) {
                                    we0 = -1;
                                    we2 = -1;
                                    for (w = 0; w < 3; ++w) {
                                        if (walk[w0][w] == curtri) {
                                            we0 = w;
                                        }
                                        if (walk[w2][w] != curtri) continue;
                                        we2 = w;
                                    }
                                    if (we0 < 0 || we2 < 0) {
                                        throw new SetException("DelaunayOverlap: subtriangulation error");
                                    }
                                    tri[curtri][0] = pt2;
                                    walk[curtri][0] = trilen;
                                    walk[curtri][2] = trilen + 1;
                                    tri[trilen][0] = p1;
                                    tri[trilen][1] = pt2;
                                    tri[trilen][2] = p0;
                                    walk[trilen][0] = curtri;
                                    walk[trilen][1] = trilen + 1;
                                    walk[trilen][2] = w0;
                                    walk[w0][we0] = trilen++;
                                    tri[trilen][0] = p0;
                                    tri[trilen][1] = pt2;
                                    tri[trilen][2] = p2;
                                    walk[trilen][0] = trilen - 1;
                                    walk[trilen][1] = curtri;
                                    walk[trilen][2] = w2;
                                    walk[w2][we2] = trilen++;
                                    continue;
                                }
                                if (curtri == tlr[qmg][0] || curtri == tlr[qmg][1]) {
                                    we0 = -1;
                                    int we1 = -1;
                                    for (w = 0; w < 3; ++w) {
                                        if (walk[w0][w] == curtri) {
                                            we0 = w;
                                        }
                                        if (walk[w1][w] != curtri) continue;
                                        we1 = w;
                                    }
                                    if (we0 < 0 || we1 < 0) {
                                        throw new SetException("DelaunayOverlap: subtriangulation error");
                                    }
                                    tri[curtri][1] = pt2;
                                    walk[curtri][0] = trilen;
                                    walk[curtri][1] = trilen + 1;
                                    tri[trilen][0] = p0;
                                    tri[trilen][1] = p1;
                                    tri[trilen][2] = pt2;
                                    walk[trilen][0] = w0;
                                    walk[w0][we0] = trilen;
                                    walk[trilen][1] = trilen + 1;
                                    walk[trilen][2] = curtri;
                                    tri[++trilen][0] = pt2;
                                    tri[trilen][1] = p1;
                                    tri[trilen][2] = p2;
                                    walk[trilen][0] = trilen - 1;
                                    walk[trilen][1] = w1;
                                    walk[w1][we1] = trilen;
                                    walk[trilen][2] = curtri;
                                    ++trilen;
                                    continue;
                                }
                                int we1 = -1;
                                we2 = -1;
                                for (w = 0; w < 3; ++w) {
                                    if (walk[w1][w] == curtri) {
                                        we1 = w;
                                    }
                                    if (walk[w2][w] != curtri) continue;
                                    we2 = w;
                                }
                                if (we1 < 0 || we2 < 0) {
                                    throw new SetException("DelaunayOverlap: subtriangulation error");
                                }
                                tri[curtri][2] = pt2;
                                walk[curtri][1] = trilen;
                                walk[curtri][2] = trilen + 1;
                                tri[trilen][0] = pt2;
                                tri[trilen][1] = p1;
                                tri[trilen][2] = p2;
                                walk[trilen][0] = curtri;
                                walk[trilen][1] = w1;
                                walk[w1][we1] = trilen;
                                walk[trilen][2] = trilen + 1;
                                tri[++trilen][0] = p0;
                                tri[trilen][1] = pt2;
                                tri[trilen][2] = p2;
                                walk[trilen][0] = curtri;
                                walk[trilen][1] = trilen - 1;
                                walk[trilen][2] = w2;
                                walk[w2][we2] = trilen++;
                            }
                        }
                    }
                }
            }
            if (curgrid == 0) {
                for (i = 0; i < ledges - 1; ++i) {
                    ltrinum[i] = tlr[i * (lenx - 1)][1];
                    ltriedge[i] = 2;
                }
                for (i = 0; i < redges - 1; ++i) {
                    rtrinum[i] = tlr[(i + 1) * (lenx - 1) - 1][2];
                    rtriedge[i] = 0;
                }
                continue;
            }
            int tmup = curgrid * lenp + lenx * (broken[curgrid][0] + 1);
            float tx = samples[0][tmup];
            float ty = samples[1][tmup];
            if (samples[1][leftedge[ledges - 1]] < ty != (sig = samples[1][leftedge[0]] < samples[1][leftedge[ledges - 1]]) && samples[1][leftedge[ledges - 1]] != ty) {
                float py;
                float px;
                int itnum;
                min2 = 0;
                int max = ledges - 1;
                int sg = (min2 + max) / 2;
                for (itnum = 0; samples[1][leftedge[sg + 1]] < ty == samples[1][leftedge[sg]] < ty && itnum < ledges; ++itnum) {
                    if (samples[1][leftedge[sg]] < ty == sig) {
                        min2 = sg;
                    } else {
                        if (sg == 0) {
                            throw new SetException("DelaunayOverlap: illegal grid overlap");
                        }
                        max = sg;
                    }
                    sg = (min2 + max) / 2;
                    if (sg != ledges - 1) continue;
                    throw new SetException("DelaunayOverlap: pathological grid overlap");
                }
                if (itnum >= ledges) {
                    throw new SetException("DelaunayOverlap: corrupt left edge structure");
                }
                int clep = leftedge[sg];
                float cx = samples[0][clep];
                int clep1 = leftedge[sg + 1];
                float c1y = samples[1][clep1];
                float cy = samples[1][clep];
                float c1x = samples[0][clep1];
                if ((tx - cx) * (ty - c1y) - (ty - cy) * (tx - c1x) > 0.0f == ((px = samples[0][pt = curgrid * lenp - lenx + 1]) - cx) * ((py = samples[1][pt]) - c1y) - (py - cy) * (px - c1x) > 0.0f) {
                    start2 = ledges - 1;
                    min2 = 0;
                    max = leny - 1;
                    sg = (min2 + max) / 2;
                    float ll = samples[1][leftedge[ledges - 1]];
                    int offst = curgrid * lenp;
                    int offst2 = offst + lenx;
                    for (itnum = 0; samples[1][lenx * sg + offst] < ll == samples[1][lenx * sg + offst2] < ll && itnum < leny; ++itnum) {
                        if (ll > samples[1][lenx * sg + offst]) {
                            min2 = sg;
                        } else {
                            if (sg == 0) {
                                throw new SetException("DelaunayOverlap: illegal grid overlap");
                            }
                            max = sg;
                        }
                        sg = (min2 + max) / 2;
                        if (sg != leny - 1) continue;
                        throw new SetException("DelaunayOverlap: pathological grid overlap");
                    }
                    if (itnum >= leny) {
                        throw new SetException("DelaunayOverlap:  corrupt grid structure");
                    }
                    start1 = lenx * sg + offst2;
                } else {
                    start1 = tmup;
                    start2 = sg;
                }
            } else {
                start1 = tmup;
                start2 = ledges - 1;
            }
            tmup = curgrid * lenp + lenx * (broken[curgrid][lenx] + 2) - 1;
            tx = samples[0][tmup];
            ty = samples[1][tmup];
            sig = samples[1][rightedge[0]] < samples[1][rightedge[redges - 1]];
            if (samples[1][rightedge[redges - 1]] < ty != sig && samples[1][rightedge[redges - 1]] != ty) {
                float py;
                float px;
                int itnum;
                min2 = 0;
                int max = redges - 1;
                int sg = (min2 + max) / 2;
                for (itnum = 0; samples[1][rightedge[sg + 1]] < ty == samples[1][rightedge[sg]] < ty && itnum < redges; ++itnum) {
                    if (samples[1][rightedge[sg]] < ty == sig) {
                        min2 = sg;
                    } else {
                        if (sg == 0) {
                            throw new SetException("DelaunayOverlap: illegal grid overlap");
                        }
                        max = sg;
                    }
                    sg = (min2 + max) / 2;
                    if (sg != redges - 1) continue;
                    throw new SetException("DelaunayOverlap: pathological grid overlap");
                }
                if (itnum >= redges) {
                    throw new SetException("DelaunayOverlap: corrupt right edge structure");
                }
                int crep = rightedge[sg];
                float cx = samples[0][crep];
                int crep1 = rightedge[sg + 1];
                float c1y = samples[1][crep1];
                float cy = samples[1][crep];
                float c1x = samples[0][crep1];
                if ((tx - cx) * (ty - c1y) - (ty - cy) * (tx - c1x) > 0.0f == ((px = samples[0][pt = curgrid * lenp - 2]) - cx) * ((py = samples[1][pt]) - c1y) - (py - cy) * (px - c1x) > 0.0f) {
                    end2 = redges - 1;
                    min2 = 0;
                    max = leny - 1;
                    sg = (min2 + max) / 2;
                    float ll = samples[1][rightedge[redges - 1]];
                    int offst = curgrid * lenp + lenx - 1;
                    int offst2 = offst + lenx;
                    for (itnum = 0; samples[1][lenx * sg + offst] < ll == samples[1][lenx * sg + offst2] < ll && itnum < leny; ++itnum) {
                        if (ll > samples[1][lenx * sg + offst]) {
                            min2 = sg;
                        } else {
                            if (sg == 0) {
                                throw new SetException("DelaunayOverlap: illegal grid overlap");
                            }
                            max = sg;
                        }
                        sg = (min2 + max) / 2;
                        if (sg != leny - 1) continue;
                        throw new SetException("DelaunayOverlap: pathological grid overlap");
                    }
                    if (itnum >= leny) {
                        throw new SetException("DelaunayOverlap:  corrupt grid structure");
                    }
                    end1 = lenx * sg + offst2;
                } else {
                    end1 = tmup;
                    end2 = sg;
                }
            } else {
                end1 = tmup;
                end2 = redges - 1;
            }
            int[] old_leftedge = leftedge;
            int[] old_rightedge = rightedge;
            int old_ledges = ledges;
            int old_redges = redges;
            int[] old_ltrinum = ltrinum;
            int[] old_ltriedge = ltriedge;
            int[] old_rtrinum = rtrinum;
            int[] old_rtriedge = rtriedge;
            leftedge = new int[numgrids * leny];
            ltrinum = new int[numgrids * leny];
            ltriedge = new int[numgrids * leny];
            ledges = 0;
            rightedge = new int[numgrids * leny];
            rtrinum = new int[numgrids * leny];
            rtriedge = new int[numgrids * leny];
            redges = 0;
            System.arraycopy(old_leftedge, 0, leftedge, 0, start2 + 1);
            System.arraycopy(old_ltrinum, 0, ltrinum, 0, start2);
            System.arraycopy(old_ltriedge, 0, ltriedge, 0, start2);
            ledges += start2 + 1;
            System.arraycopy(old_rightedge, 0, rightedge, 0, end2 + 1);
            System.arraycopy(old_rtrinum, 0, rtrinum, 0, end2);
            System.arraycopy(old_rtriedge, 0, rtriedge, 0, end2);
            redges += end2 + 1;
            for (i4 = start1; i4 <= (curgrid + 1) * lenp - lenx; i4 += lenx) {
                leftedge[ledges++] = i4;
            }
            for (i4 = end1; i4 < (curgrid + 1) * lenp; i4 += lenx) {
                rightedge[redges++] = i4;
            }
            int curledge = start2;
            int curredge = redges - leny + broken[curgrid][lenx - 1];
            int b2lbr = 0;
            int base1 = start1;
            int base2 = start2;
            if (base2 == old_ledges - 1) {
                base2 = curgrid * lenp - lenx;
                b2lbr = 1;
            }
            int base1x = 0;
            int base1y = base1 % lenp / lenx;
            boolean down = false;
            if (base1y > 0 && broken[curgrid][0] < base1y - 1) {
                oneUp1x = 0;
                oneUp1y = base1y - 1;
            } else if (base1y == leny - 1 || broken[curgrid][1] < base1y) {
                oneUp1x = 1;
                oneUp1y = base1y;
            } else {
                oneUp1x = 0;
                oneUp1y = base1y + 1;
                down = true;
            }
            int oneUp1 = curgrid * lenp + oneUp1y * lenx + oneUp1x;
            int oneUp2 = base2 + 1;
            boolean diag = false;
            boolean firsttri = true;
            while (base1 != end1 || base2 != end2 || b2lbr != 2) {
                int i6;
                if (base1 == end1) {
                    diag = true;
                } else if (base2 == end2 && b2lbr == 2) {
                    diag = false;
                } else {
                    boolean sigD;
                    float dy;
                    float dx;
                    float by;
                    float bx;
                    float ax = samples[0][base1];
                    float ay = samples[1][base1];
                    float cx = samples[0][oneUp1];
                    float cy = samples[1][oneUp1];
                    if (b2lbr == 0) {
                        bx = samples[0][old_leftedge[base2]];
                        by = samples[1][old_leftedge[base2]];
                        dx = samples[0][old_leftedge[oneUp2]];
                        dy = samples[1][old_leftedge[oneUp2]];
                    } else if (b2lbr == 1) {
                        bx = samples[0][base2];
                        by = samples[1][base2];
                        dx = samples[0][oneUp2];
                        dy = samples[1][oneUp2];
                    } else {
                        bx = samples[0][old_rightedge[base2]];
                        by = samples[1][old_rightedge[base2]];
                        dx = samples[0][old_rightedge[oneUp2]];
                        dy = samples[1][old_rightedge[oneUp2]];
                    }
                    float abx = ax - bx;
                    float aby = ay - by;
                    float acx = ax - cx;
                    float acy = ay - cy;
                    float dbx = dx - bx;
                    float dby = dy - by;
                    float dcx = dx - cx;
                    float dcy = dy - cy;
                    float Q = abx * acx + aby * acy;
                    float R = dbx * abx + dby * aby;
                    float S = acx * dcx + acy * dcy;
                    float T = dbx * dcx + dby * dcy;
                    boolean QD = abx * acy - aby * acx > 0.0f;
                    boolean RD = dbx * aby - dby * abx > 0.0f;
                    boolean SD = acx * dcy - acy * dcx > 0.0f;
                    boolean TD = dcx * dby - dcy * dbx > 0.0f;
                    boolean bl = sigD = (QD ? 1 : 0) + (RD ? 1 : 0) + (SD ? 1 : 0) + (TD ? 1 : 0) < 2;
                    diag = QD == sigD ? true : (RD == sigD || SD == sigD ? false : (TD == sigD ? true : (Q < 0.0f && T < 0.0f || R > 0.0f && S > 0.0f ? true : (R < 0.0f && S < 0.0f || Q > 0.0f && T > 0.0f ? false : (Q < 0.0f ? Q : T) < (R < 0.0f ? R : S)))));
                }
                if (diag) {
                    int x2;
                    if (b2lbr == 0) {
                        tri[trilen][0] = old_leftedge[oneUp2];
                        tri[trilen][1] = base1;
                        tri[trilen][2] = old_leftedge[base2];
                    } else if (b2lbr == 1) {
                        tri[trilen][0] = oneUp2;
                        tri[trilen][1] = base1;
                        tri[trilen][2] = base2;
                    } else {
                        tri[trilen][0] = old_rightedge[oneUp2];
                        tri[trilen][1] = base1;
                        tri[trilen][2] = old_rightedge[base2];
                    }
                    walk[trilen][0] = -1;
                    if (firsttri) {
                        ltrinum[curledge] = trilen;
                        ltriedge[curledge] = 2;
                        ++curledge;
                        firsttri = false;
                    } else {
                        walk[trilen][1] = trilen - 1;
                        walk[trilen - 1][0] = trilen;
                    }
                    if (b2lbr == 0) {
                        walk[trilen][2] = x2 = old_ltrinum[base2];
                        walk[x2][old_ltriedge[base2]] = trilen;
                    } else if (b2lbr == 1) {
                        walk[trilen][2] = x2 = old_bottom[base2 % lenx];
                        walk[x2][1] = trilen;
                    } else {
                        walk[trilen][2] = x2 = old_rtrinum[oneUp2];
                        walk[x2][old_rtriedge[oneUp2]] = trilen;
                    }
                    base2 = oneUp2;
                    if (b2lbr == 0 && base2 == old_ledges - 1) {
                        b2lbr = 1;
                        base2 = curgrid * lenp - lenx;
                    }
                    if (b2lbr == 1 && base2 == curgrid * lenp - 1) {
                        b2lbr = 2;
                        base2 = old_redges - 1;
                    }
                    oneUp2 = base2 + (b2lbr == 2 ? -1 : 1);
                } else {
                    if (b2lbr == 0) {
                        tri[trilen][0] = old_leftedge[base2];
                        tri[trilen][1] = oneUp1;
                        tri[trilen][2] = base1;
                    } else if (b2lbr == 1) {
                        tri[trilen][0] = base2;
                        tri[trilen][1] = oneUp1;
                        tri[trilen][2] = base1;
                    } else {
                        tri[trilen][0] = old_rightedge[base2];
                        tri[trilen][1] = oneUp1;
                        tri[trilen][2] = base1;
                    }
                    walk[trilen][0] = -1;
                    if (firsttri) {
                        ltrinum[curledge] = trilen;
                        ltriedge[curledge] = 1;
                        ++curledge;
                        firsttri = false;
                    } else {
                        walk[trilen][2] = trilen - 1;
                        walk[trilen - 1][0] = trilen;
                    }
                    if (oneUp1 - base1 == -lenx) {
                        if (base1x < lenx - 1) {
                            int x3;
                            walk[trilen][1] = x3 = tlr[(lenx - 1) * oneUp1y + oneUp1x][1];
                            walk[x3][2] = trilen;
                        } else {
                            walk[trilen][1] = -1;
                            rtrinum[curredge] = trilen;
                            rtriedge[curredge] = 1;
                            --curredge;
                        }
                    } else if (oneUp1 - base1 == 1) {
                        if (base1y < leny - 1) {
                            int x4;
                            int inx = (lenx - 1) * base1y + base1x;
                            walk[trilen][1] = x4 = tlr[inx][0];
                            walk[x4][istwo[inx] ? 2 : 0] = trilen;
                        } else {
                            walk[trilen][1] = -1;
                            bottom[base1x] = trilen;
                        }
                    } else if (base1x > 0) {
                        int x5;
                        walk[trilen][1] = x5 = tlr[(lenx - 1) * base1y + base1x - 1][2];
                        walk[x5][0] = trilen;
                    } else {
                        walk[trilen][1] = -1;
                        ltrinum[curledge] = trilen;
                        ltriedge[curledge] = 1;
                        ++curledge;
                    }
                    base1 = oneUp1;
                    base1x = oneUp1x;
                    base1y = oneUp1y;
                    if (broken[curgrid][base1x == 0 ? 0 : base1x + 1] < base1y - 1 && base1y > 0 && !down) {
                        oneUp1x = base1x;
                        oneUp1y = base1y - 1;
                    } else if (base1y == leny - 1 || base1x < lenx - 1 && broken[curgrid][base1x + 1] < base1y) {
                        oneUp1x = base1x + 1;
                        oneUp1y = base1y;
                        down = false;
                    } else {
                        oneUp1x = base1x;
                        oneUp1y = base1y + 1;
                        down = true;
                    }
                    oneUp1 = curgrid * lenp + oneUp1y * lenx + oneUp1x;
                }
                if (++trilen <= trisize) continue;
                trisize += trisize;
                int[][] newtri = new int[trisize + 2][3];
                int[][] newwalk = new int[trisize + 2][3];
                for (i6 = 0; i6 < trilen; ++i6) {
                    newtri[i6][0] = tri[i6][0];
                    newtri[i6][1] = tri[i6][1];
                    newtri[i6][2] = tri[i6][2];
                    newwalk[i6][0] = walk[i6][0];
                    newwalk[i6][1] = walk[i6][1];
                    newwalk[i6][2] = walk[i6][2];
                }
                for (i6 = trilen; i6 < trisize + 2; ++i6) {
                    newwalk[i6][0] = -1;
                    newwalk[i6][1] = -1;
                    newwalk[i6][2] = -1;
                }
                tri = newtri;
                walk = newwalk;
            }
            rtrinum[curredge] = trilen - 1;
            rtriedge[curredge] = diag ? 2 : 1;
            curredge = redges - leny + broken[curgrid][lenx - 1] + 1;
            for (i3 = x = broken[curgrid][1] + 1; i3 < leny - 1; ++i3) {
                ltrinum[curledge] = tlr[(lenx - 1) * i3][1];
                ltriedge[curledge] = 2;
                ++curledge;
            }
            for (i3 = x = broken[curgrid][lenx - 1] + 1; i3 < leny - 1; ++i3) {
                rtrinum[curredge] = tlr[(lenx - 1) * (i3 + 1) - 1][2];
                rtriedge[curredge] = 0;
                ++curredge;
            }
        }
        for (curgrid = 0; curgrid < numgrids; ++curgrid) {
            int tri1;
            int curtri;
            if (curgrid < numgrids - 1) {
                curtri = trilen / 2;
                for (int gx = 0; gx < lenx - 1; ++gx) {
                    for (int gy = 0; gy <= broken[curgrid][gx + 1]; ++gy) {
                        int qg = leng * curgrid + (lenx - 1) * gy + gx;
                        if (curtri < 0) {
                            curtri = trilen / 2;
                        }
                        for (int pt = 0; pt < glen[qg]; ++pt) {
                            int i7;
                            int TE2;
                            int TE1;
                            int TE0;
                            int itnum;
                            float Px = samples[0][grid[qg][pt]];
                            float Py = samples[1][grid[qg][pt]];
                            boolean located = false;
                            for (itnum = 0; itnum < trilen && !located; ++itnum) {
                                int tri2;
                                int tri0;
                                boolean test2;
                                boolean test1;
                                boolean test0;
                                int t0 = tri[curtri][0];
                                int t1 = tri[curtri][1];
                                int t2 = tri[curtri][2];
                                float Ax = samples[0][t0];
                                float Ay = samples[1][t0];
                                float Bx = samples[0][t1];
                                float By = samples[1][t1];
                                float Cx = samples[0][t2];
                                float Cy = samples[1][t2];
                                float tval0 = (Bx - Ax) * (Py - Ay) - (By - Ay) * (Px - Ax);
                                float tval1 = (Cx - Bx) * (Py - By) - (Cy - By) * (Px - Bx);
                                float tval2 = (Ax - Cx) * (Py - Cy) - (Ay - Cy) * (Px - Cx);
                                boolean bl = tval0 == 0.0f || tval0 > 0.0f == (Bx - Ax) * (Cy - Ay) - (By - Ay) * (Cx - Ax) > 0.0f ? true : (test0 = false);
                                boolean bl4 = tval1 == 0.0f || tval1 > 0.0f == (Cx - Bx) * (Ay - By) - (Cy - By) * (Ax - Bx) > 0.0f ? true : (test1 = false);
                                boolean bl5 = tval2 == 0.0f || tval2 > 0.0f == (Ax - Cx) * (By - Cy) - (Ay - Cy) * (Bx - Cx) > 0.0f ? true : (test2 = false);
                                if (!(test0 || test1 || test2)) {
                                    throw new SetException("DelaunayOverlap: corrupt triangle structure");
                                }
                                if (!test0 && !test1) {
                                    tri0 = walk[curtri][0];
                                    int tri12 = walk[curtri][1];
                                    curtri = tri0 == -1 ? tri12 : tri0;
                                } else if (!test0 && !test2) {
                                    tri0 = walk[curtri][0];
                                    tri2 = walk[curtri][2];
                                    curtri = tri0 == -1 ? tri2 : tri0;
                                } else if (!test1 && !test2) {
                                    tri1 = walk[curtri][1];
                                    tri2 = walk[curtri][2];
                                    curtri = tri1 == -1 ? tri2 : tri1;
                                } else if (!test0) {
                                    curtri = walk[curtri][0];
                                } else if (!test1) {
                                    curtri = walk[curtri][1];
                                } else if (!test2) {
                                    curtri = walk[curtri][2];
                                } else {
                                    located = true;
                                }
                                if (curtri >= 0) continue;
                                itnum = trilen;
                            }
                            if (itnum >= trilen) continue;
                            int q = grid[qg][pt];
                            int ct0 = tri[curtri][0];
                            int ct1 = tri[curtri][1];
                            int ct2 = tri[curtri][2];
                            int T0 = walk[curtri][0];
                            int T1 = walk[curtri][1];
                            int T2 = walk[curtri][2];
                            if (T0 == -1) {
                                TE0 = -1;
                            } else if (walk[T0][0] == curtri) {
                                TE0 = 0;
                            } else if (walk[T0][1] == curtri) {
                                TE0 = 1;
                            } else if (walk[T0][2] == curtri) {
                                TE0 = 2;
                            } else {
                                throw new SetException("DelaunayOverlap: corrupt walk structure");
                            }
                            if (T1 == -1) {
                                TE1 = -1;
                            } else if (walk[T1][0] == curtri) {
                                TE1 = 0;
                            } else if (walk[T1][1] == curtri) {
                                TE1 = 1;
                            } else if (walk[T1][2] == curtri) {
                                TE1 = 2;
                            } else {
                                throw new SetException("DelaunayOverlap: corrupt walk structure");
                            }
                            if (T2 == -1) {
                                TE2 = -1;
                            } else if (walk[T2][0] == curtri) {
                                TE2 = 0;
                            } else if (walk[T2][1] == curtri) {
                                TE2 = 1;
                            } else if (walk[T2][2] == curtri) {
                                TE2 = 2;
                            } else {
                                throw new SetException("DelaunayOverlap: corrupt walk structure");
                            }
                            tri[curtri][2] = q;
                            walk[curtri][1] = trilen;
                            walk[curtri][2] = trilen + 1;
                            tri[trilen][0] = q;
                            tri[trilen][1] = ct1;
                            tri[trilen][2] = ct2;
                            walk[trilen][0] = curtri;
                            walk[trilen][1] = T1;
                            if (TE1 >= 0) {
                                walk[T1][TE1] = trilen;
                            }
                            walk[trilen][2] = trilen + 1;
                            tri[++trilen][0] = ct0;
                            tri[trilen][1] = q;
                            tri[trilen][2] = ct2;
                            walk[trilen][0] = curtri;
                            walk[trilen][1] = trilen - 1;
                            walk[trilen][2] = T2;
                            if (TE2 >= 0) {
                                walk[T2][TE2] = trilen;
                            }
                            if (++trilen <= trisize) continue;
                            trisize += trisize;
                            int[][] newtri = new int[trisize + 2][3];
                            int[][] newwalk = new int[trisize + 2][3];
                            for (i7 = 0; i7 < trilen; ++i7) {
                                newtri[i7][0] = tri[i7][0];
                                newtri[i7][1] = tri[i7][1];
                                newtri[i7][2] = tri[i7][2];
                                newwalk[i7][0] = walk[i7][0];
                                newwalk[i7][1] = walk[i7][1];
                                newwalk[i7][2] = walk[i7][2];
                            }
                            for (i7 = trilen; i7 < trisize + 2; ++i7) {
                                newwalk[i7][0] = -1;
                                newwalk[i7][1] = -1;
                                newwalk[i7][2] = -1;
                            }
                            tri = newtri;
                            walk = newwalk;
                        }
                    }
                }
            }
            curtri = trilen / 2;
            for (int line = 0; line < leny - 1; ++line) {
                for (int pix = 1; pix < lenx - 1; ++pix) {
                    int i8;
                    int TE2;
                    int TE1;
                    int TE0;
                    int itnum;
                    int q = lenp * curgrid + lenx * line + pix;
                    if (ptfell[q] || broken[curgrid][pix] < line || broken[curgrid][pix + 1] < line) continue;
                    float Px = samples[0][q];
                    float Py = samples[1][q];
                    boolean located = false;
                    for (itnum = 0; itnum < trilen && !located; ++itnum) {
                        int tri2;
                        int tri0;
                        boolean test2;
                        boolean test1;
                        boolean test0;
                        int t0 = tri[curtri][0];
                        int t1 = tri[curtri][1];
                        int t2 = tri[curtri][2];
                        float Ax = samples[0][t0];
                        float Ay = samples[1][t0];
                        float Bx = samples[0][t1];
                        float By = samples[1][t1];
                        float Cx = samples[0][t2];
                        float Cy = samples[1][t2];
                        float tval0 = (Bx - Ax) * (Py - Ay) - (By - Ay) * (Px - Ax);
                        float tval1 = (Cx - Bx) * (Py - By) - (Cy - By) * (Px - Bx);
                        float tval2 = (Ax - Cx) * (Py - Cy) - (Ay - Cy) * (Px - Cx);
                        boolean bl = tval0 == 0.0f || tval0 > 0.0f == (Bx - Ax) * (Cy - Ay) - (By - Ay) * (Cx - Ax) > 0.0f ? true : (test0 = false);
                        boolean bl6 = tval1 == 0.0f || tval1 > 0.0f == (Cx - Bx) * (Ay - By) - (Cy - By) * (Ax - Bx) > 0.0f ? true : (test1 = false);
                        boolean bl7 = tval2 == 0.0f || tval2 > 0.0f == (Ax - Cx) * (By - Cy) - (Ay - Cy) * (Bx - Cx) > 0.0f ? true : (test2 = false);
                        if (!(test0 || test1 || test2)) {
                            throw new SetException("DelaunayOverlap: corrupt triangle structure");
                        }
                        if (!test0 && !test1) {
                            tri0 = walk[curtri][0];
                            tri1 = walk[curtri][1];
                            curtri = tri0 == -1 ? tri1 : tri0;
                        } else if (!test0 && !test2) {
                            tri0 = walk[curtri][0];
                            tri2 = walk[curtri][2];
                            curtri = tri0 == -1 ? tri2 : tri0;
                        } else if (!test1 && !test2) {
                            int tri13 = walk[curtri][1];
                            tri2 = walk[curtri][2];
                            curtri = tri13 == -1 ? tri2 : tri13;
                        } else if (!test0) {
                            curtri = walk[curtri][0];
                        } else if (!test1) {
                            curtri = walk[curtri][1];
                        } else if (!test2) {
                            curtri = walk[curtri][2];
                        } else {
                            located = true;
                        }
                        if (curtri >= 0) continue;
                        itnum = trilen;
                    }
                    if (itnum >= trilen) continue;
                    int ct0 = tri[curtri][0];
                    int ct1 = tri[curtri][1];
                    int ct2 = tri[curtri][2];
                    int T0 = walk[curtri][0];
                    int T1 = walk[curtri][1];
                    int T2 = walk[curtri][2];
                    if (T0 == -1) {
                        TE0 = -1;
                    } else if (walk[T0][0] == curtri) {
                        TE0 = 0;
                    } else if (walk[T0][1] == curtri) {
                        TE0 = 1;
                    } else if (walk[T0][2] == curtri) {
                        TE0 = 2;
                    } else {
                        throw new SetException("DelaunayOverlap: corrupt walk structure");
                    }
                    if (T1 == -1) {
                        TE1 = -1;
                    } else if (walk[T1][0] == curtri) {
                        TE1 = 0;
                    } else if (walk[T1][1] == curtri) {
                        TE1 = 1;
                    } else if (walk[T1][2] == curtri) {
                        TE1 = 2;
                    } else {
                        throw new SetException("DelaunayOverlap: corrupt walk structure");
                    }
                    if (T2 == -1) {
                        TE2 = -1;
                    } else if (walk[T2][0] == curtri) {
                        TE2 = 0;
                    } else if (walk[T2][1] == curtri) {
                        TE2 = 1;
                    } else if (walk[T2][2] == curtri) {
                        TE2 = 2;
                    } else {
                        throw new SetException("DelaunayOverlap: corrupt walk structure");
                    }
                    tri[curtri][2] = q;
                    walk[curtri][1] = trilen;
                    walk[curtri][2] = trilen + 1;
                    tri[trilen][0] = q;
                    tri[trilen][1] = ct1;
                    tri[trilen][2] = ct2;
                    walk[trilen][0] = curtri;
                    walk[trilen][1] = T1;
                    if (TE1 >= 0) {
                        walk[T1][TE1] = trilen;
                    }
                    walk[trilen][2] = trilen + 1;
                    tri[++trilen][0] = ct0;
                    tri[trilen][1] = q;
                    tri[trilen][2] = ct2;
                    walk[trilen][0] = curtri;
                    walk[trilen][1] = trilen - 1;
                    walk[trilen][2] = T2;
                    if (TE2 >= 0) {
                        walk[T2][TE2] = trilen;
                    }
                    if (++trilen <= trisize) continue;
                    trisize += trisize;
                    int[][] newtri = new int[trisize + 2][3];
                    int[][] newwalk = new int[trisize + 2][3];
                    for (i8 = 0; i8 < trilen; ++i8) {
                        newtri[i8][0] = tri[i8][0];
                        newtri[i8][1] = tri[i8][1];
                        newtri[i8][2] = tri[i8][2];
                        newwalk[i8][0] = walk[i8][0];
                        newwalk[i8][1] = walk[i8][1];
                        newwalk[i8][2] = walk[i8][2];
                    }
                    for (i8 = trilen; i8 < trisize + 2; ++i8) {
                        newwalk[i8][0] = -1;
                        newwalk[i8][1] = -1;
                        newwalk[i8][2] = -1;
                    }
                    tri = newtri;
                    walk = newwalk;
                }
            }
        }
        this.Tri = new int[trilen][3];
        this.Walk = new int[trilen][3];
        for (i = 0; i < trilen; ++i) {
            this.Tri[i][0] = tri[i][0];
            this.Tri[i][1] = tri[i][1];
            this.Tri[i][2] = tri[i][2];
            this.Walk[i][0] = walk[i][0];
            this.Walk[i][1] = walk[i][1];
            this.Walk[i][2] = walk[i][2];
        }
        this.finish_triang(samples);
    }

    public static void main(String[] argv) throws VisADException {
        Frame frame = new Frame("DelaunayOverlap");
        WindowAdapter l = new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        };
        frame.addWindowListener(l);
        frame.setSize(500, 600);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation(screenSize.width / 2 - 250, screenSize.height / 2 - 300);
        Panel big_panel = new Panel();
        big_panel.setLayout(new GridLayout(1, 1));
        frame.add(big_panel);
        Canvas gcan = new Canvas(){

            public void paint(Graphics gr) {
                if (delO != null) {
                    gr.setColor(Color.red);
                    for (int t = 0; t < delO.Tri.length; ++t) {
                        for (int e = 0; e < 3; ++e) {
                            int gx1 = (int)m_samples[0][delO.Tri[t][e]];
                            int gy1 = (int)m_samples[1][delO.Tri[t][e]];
                            int gx2 = (int)m_samples[0][delO.Tri[t][(e + 1) % 3]];
                            int gy2 = (int)m_samples[1][delO.Tri[t][(e + 1) % 3]];
                            gr.drawLine(gx1, gy1, gx2, gy2);
                        }
                    }
                }
                int colnum = 0;
                for (int p = 0; p < 72; ++p) {
                    int x = (int)m_samples[0][p];
                    int y = (int)m_samples[1][p];
                    if (p % 24 == 0) {
                        gr.setColor(m_col[colnum++]);
                    }
                    gr.fillRect(x - 2, y - 2, 4, 4);
                }
            }
        };
        big_panel.add(gcan);
        System.out.println("Constructing triangulation...");
        long startTime = System.currentTimeMillis();
        delO = new DelaunayOverlap(m_samples, 6, 4);
        long endTime = System.currentTimeMillis();
        frame.setVisible(true);
        System.out.println("Algorithm completed successfully.");
        float algTime = (float)(endTime - startTime) / 1000.0f;
        System.out.println("Triangulation took " + algTime + " seconds.");
        System.out.println("Testing triangulation...");
        boolean good = delO.test(m_samples);
        if (!good) {
            System.out.println("Errors in triangulation!");
        } else {
            System.out.println("Triangulation was constructed correctly.");
        }
    }
}

