/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.Location;
import loci.formats.LogTools;
import loci.formats.MetadataStore;
import loci.formats.MetadataTools;
import loci.formats.RandomAccessStream;
import loci.formats.TiffTools;
import loci.formats.in.BaseTiffReader;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class OMETiffReader
extends BaseTiffReader {
    public static final SAXParserFactory SAX_FACTORY = SAXParserFactory.newInstance();
    private String[] usedFiles;
    private Vector imageIDs;
    private Vector pixelsIDs;
    private Vector tempIfdMap;
    private Vector tempFileMap;
    private Vector tempIfdCount;
    private int currentFile;
    private int currentSeries;
    private int seriesCount;
    private int[] numIFDs;
    private int[][] ifdMap;
    private int[][] fileMap;
    private boolean lsids;
    private boolean isWiscScan;
    private Hashtable[][] usedIFDs;

    public OMETiffReader() {
        super("OME-TIFF", new String[]{"tif", "tiff"});
    }

    protected void initStandardMetadata() throws FormatException, IOException {
        int i;
        super.initStandardMetadata();
        OMETiffHandler handler = new OMETiffHandler();
        String comment = (String)this.getMeta("Comment");
        this.currentSeries = -1;
        this.seriesCount = 0;
        this.imageIDs = null;
        this.pixelsIDs = null;
        this.lsids = true;
        this.tempIfdMap = new Vector();
        this.tempFileMap = new Vector();
        this.tempIfdCount = new Vector();
        try {
            SAXParser parser = SAX_FACTORY.newSAXParser();
            parser.parse((InputStream)new ByteArrayInputStream(comment.getBytes()), (DefaultHandler)handler);
        }
        catch (ParserConfigurationException exc) {
            throw new FormatException(exc);
        }
        catch (SAXException exc) {
            throw new FormatException(exc);
        }
        String s2 = null;
        if (this.ifds.length > 1) {
            s2 = (String)TiffTools.getIFDValue(this.ifds[1], 270);
        }
        this.isWiscScan = s2 != null && s2.indexOf("ome.xsd") != -1;
        Vector<String> files = new Vector<String>();
        Location l = new Location(this.currentId);
        l = l.getAbsoluteFile().getParentFile();
        String[] fileList = l.list();
        if (!this.lsids) {
            fileList = new String[]{this.currentId};
            LogTools.println("Not searching for other files - Image LSID not present");
        }
        for (i = 0; i < fileList.length; ++i) {
            String check = fileList[i].toLowerCase();
            if (!check.endsWith(".tif") && !check.endsWith(".tiff")) continue;
            this.status("Checking " + fileList[i]);
            String iid = l.getAbsolutePath() + File.separator + fileList[i];
            String icomment = TiffTools.getComment(iid);
            boolean addToList = true;
            if (this.imageIDs != null) {
                int k;
                for (k = 0; k < this.imageIDs.size(); ++k) {
                    if (icomment.indexOf((String)this.imageIDs.get(k)) != -1) continue;
                    addToList = false;
                    break;
                }
                if (addToList) {
                    for (k = 0; k < this.pixelsIDs.size(); ++k) {
                        if (icomment.indexOf((String)this.pixelsIDs.get(k)) != -1) continue;
                        addToList = false;
                        break;
                    }
                }
            }
            if (!addToList) continue;
            files.add(iid);
        }
        this.ifdMap = new int[this.seriesCount][];
        this.fileMap = new int[this.seriesCount][];
        this.numIFDs = new int[this.seriesCount];
        for (i = 0; i < this.seriesCount; ++i) {
            int ii = (Integer)this.tempIfdCount.get(i);
            this.ifdMap[i] = new int[ii];
            this.fileMap[i] = new int[ii];
        }
        for (i = 0; i < this.tempIfdMap.size(); ++i) {
            Vector v = (Vector)this.tempIfdMap.get(i);
            for (int j = 0; j < v.size(); ++j) {
                this.ifdMap[i][j] = (Integer)v.get(j);
            }
            this.numIFDs[i] = v.size();
        }
        for (i = 0; i < this.tempFileMap.size(); ++i) {
            Vector v = (Vector)this.tempFileMap.get(i);
            for (int j = 0; j < v.size(); ++j) {
                this.fileMap[i][j] = (Integer)v.get(j);
            }
        }
        this.usedFiles = files.toArray(new String[0]);
        this.usedIFDs = new Hashtable[this.usedFiles.length][];
        for (i = 0; i < this.usedFiles.length; ++i) {
            if (this.usedFiles[i].endsWith(this.currentId)) {
                this.usedIFDs[i] = this.ifds;
                continue;
            }
            this.status("Parsing " + this.usedFiles[i]);
            this.currentSeries = -1;
            this.tempIfdMap = null;
            this.tempFileMap = null;
            this.tempIfdCount = null;
            this.currentFile = i;
            this.usedIFDs[i] = TiffTools.getIFDs(new RandomAccessStream(this.usedFiles[i]));
            String c = (String)TiffTools.getIFDValue(this.usedIFDs[i][0], 270);
            try {
                SAXParser parser = SAX_FACTORY.newSAXParser();
                parser.parse((InputStream)new ByteArrayInputStream(c.getBytes()), (DefaultHandler)handler);
                continue;
            }
            catch (ParserConfigurationException exc) {
                throw new FormatException(exc);
            }
            catch (SAXException exc) {
                throw new FormatException(exc);
            }
        }
        for (i = 0; i < this.getSeriesCount(); ++i) {
            if (this.numIFDs != null && this.lsids) {
                if (this.numIFDs[i] < this.core.imageCount[i]) {
                    LogTools.println("Too few IFDs; got " + this.numIFDs[i] + ", expected " + this.core.imageCount[i]);
                    continue;
                }
                if (this.numIFDs[i] <= this.core.imageCount[i]) continue;
                LogTools.println("Too many IFDs; got " + this.numIFDs[i] + ", expected " + this.core.imageCount[i]);
                continue;
            }
            if (this.core.imageCount[i] <= this.ifds.length) continue;
            this.core.imageCount[i] = this.ifds.length;
            if (this.core.sizeZ[i] > this.ifds.length) {
                this.core.sizeZ[i] = this.ifds.length / (this.core.rgb[i] ? this.core.sizeC[i] : 1);
                this.core.sizeT[i] = 1;
                if (this.core.rgb[i]) continue;
                this.core.sizeC[i] = 1;
                continue;
            }
            if (this.core.sizeT[i] <= this.ifds.length) continue;
            this.core.sizeT[i] = this.ifds.length / (this.core.rgb[i] ? this.core.sizeC[i] : 1);
            this.core.sizeZ[i] = 1;
            if (this.core.rgb[i]) continue;
            this.core.sizeC[i] = 1;
        }
    }

    protected void initMetadataStore() {
        String comment = (String)this.getMeta("Comment");
        this.metadata.remove("Comment");
        MetadataStore store = this.getMetadataStore();
        MetadataTools.convertMetadata(comment, store);
    }

    public String[] getUsedFiles() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.usedFiles;
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        FormatTools.checkPlaneNumber(this, no);
        FormatTools.checkBufferSize(this, buf.length);
        int ifd = this.ifdMap[this.series][no];
        int fileIndex = this.fileMap[this.series][no];
        this.in = new RandomAccessStream(this.usedFiles[fileIndex]);
        TiffTools.getSamples(this.usedIFDs[fileIndex][ifd], this.in, buf);
        this.in.close();
        return this.swapIfRequired(buf);
    }

    public boolean isThisType(String name, boolean open) {
        if (!super.isThisType(name, open)) {
            return false;
        }
        if (!open) {
            return true;
        }
        try {
            RandomAccessStream ras = new RandomAccessStream(name);
            Hashtable ifd = TiffTools.getFirstIFD(ras);
            ras.close();
            if (ifd == null) {
                return false;
            }
            String comment = (String)ifd.get(new Integer(270));
            if (comment == null) {
                return false;
            }
            return comment.indexOf("ome.xsd") >= 0;
        }
        catch (IOException e) {
            return false;
        }
    }

    private class OMETiffHandler
    extends DefaultHandler {
        private String order;
        private int sizeZ;
        private int sizeC;
        private int sizeT;

        private OMETiffHandler() {
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if (qName.equals("Image")) {
                String id = attributes.getValue("ID");
                if (id.startsWith("urn:lsid:")) {
                    if (OMETiffReader.this.imageIDs == null) {
                        OMETiffReader.this.imageIDs = new Vector();
                    }
                    OMETiffReader.this.imageIDs.add(id);
                } else {
                    OMETiffReader.this.lsids = false;
                }
            } else if (qName.equals("Pixels")) {
                OMETiffReader.this.currentSeries++;
                String id = attributes.getValue("ID");
                if (id.startsWith("urn:lsid:")) {
                    if (OMETiffReader.this.pixelsIDs == null) {
                        OMETiffReader.this.pixelsIDs = new Vector();
                    }
                    OMETiffReader.this.pixelsIDs.add(id);
                } else {
                    OMETiffReader.this.lsids = false;
                }
                this.order = attributes.getValue("DimensionOrder");
                this.sizeZ = Integer.parseInt(attributes.getValue("SizeZ"));
                this.sizeC = Integer.parseInt(attributes.getValue("SizeC"));
                this.sizeT = Integer.parseInt(attributes.getValue("SizeT"));
                if (OMETiffReader.this.tempIfdCount != null) {
                    OMETiffReader.this.tempIfdCount.add(new Integer(this.sizeZ * this.sizeC * this.sizeT));
                }
                if (this.sizeZ < 1) {
                    this.sizeZ = 1;
                }
                if (this.sizeC < 1) {
                    this.sizeC = 1;
                }
                if (this.sizeT < 1) {
                    this.sizeT = 1;
                }
                if (((OMETiffReader)OMETiffReader.this).core.sizeZ.length <= OMETiffReader.this.currentSeries) {
                    CoreMetadata tempCore = new CoreMetadata(OMETiffReader.this.currentSeries + 1);
                    int ss = ((OMETiffReader)OMETiffReader.this).core.sizeX.length;
                    System.arraycopy(((OMETiffReader)OMETiffReader.this).core.sizeX, 0, tempCore.sizeX, 0, ss);
                    System.arraycopy(((OMETiffReader)OMETiffReader.this).core.sizeY, 0, tempCore.sizeY, 0, ss);
                    System.arraycopy(((OMETiffReader)OMETiffReader.this).core.sizeZ, 0, tempCore.sizeZ, 0, ss);
                    System.arraycopy(((OMETiffReader)OMETiffReader.this).core.sizeC, 0, tempCore.sizeC, 0, ss);
                    System.arraycopy(((OMETiffReader)OMETiffReader.this).core.sizeT, 0, tempCore.sizeT, 0, ss);
                    System.arraycopy(((OMETiffReader)OMETiffReader.this).core.thumbSizeX, 0, tempCore.thumbSizeX, 0, ss);
                    System.arraycopy(((OMETiffReader)OMETiffReader.this).core.thumbSizeY, 0, tempCore.thumbSizeY, 0, ss);
                    System.arraycopy(((OMETiffReader)OMETiffReader.this).core.pixelType, 0, tempCore.pixelType, 0, ss);
                    System.arraycopy(((OMETiffReader)OMETiffReader.this).core.imageCount, 0, tempCore.imageCount, 0, ss);
                    System.arraycopy(((OMETiffReader)OMETiffReader.this).core.currentOrder, 0, tempCore.currentOrder, 0, ss);
                    System.arraycopy(((OMETiffReader)OMETiffReader.this).core.orderCertain, 0, tempCore.orderCertain, 0, ss);
                    System.arraycopy(((OMETiffReader)OMETiffReader.this).core.rgb, 0, tempCore.rgb, 0, ss);
                    System.arraycopy(((OMETiffReader)OMETiffReader.this).core.littleEndian, 0, tempCore.littleEndian, 0, ss);
                    System.arraycopy(((OMETiffReader)OMETiffReader.this).core.interleaved, 0, tempCore.interleaved, 0, ss);
                    System.arraycopy(((OMETiffReader)OMETiffReader.this).core.indexed, 0, tempCore.indexed, 0, ss);
                    System.arraycopy(((OMETiffReader)OMETiffReader.this).core.falseColor, 0, tempCore.falseColor, 0, ss);
                    System.arraycopy(((OMETiffReader)OMETiffReader.this).core.metadataComplete, 0, tempCore.metadataComplete, 0, ss);
                    OMETiffReader.this.core = tempCore;
                }
                ((OMETiffReader)OMETiffReader.this).core.sizeX[((OMETiffReader)OMETiffReader.this).currentSeries] = Integer.parseInt(attributes.getValue("SizeX"));
                ((OMETiffReader)OMETiffReader.this).core.sizeY[((OMETiffReader)OMETiffReader.this).currentSeries] = Integer.parseInt(attributes.getValue("SizeY"));
                ((OMETiffReader)OMETiffReader.this).core.sizeZ[((OMETiffReader)OMETiffReader.this).currentSeries] = this.sizeZ;
                ((OMETiffReader)OMETiffReader.this).core.sizeC[((OMETiffReader)OMETiffReader.this).currentSeries] = this.sizeC;
                ((OMETiffReader)OMETiffReader.this).core.sizeT[((OMETiffReader)OMETiffReader.this).currentSeries] = this.sizeT;
                ((OMETiffReader)OMETiffReader.this).core.currentOrder[((OMETiffReader)OMETiffReader.this).currentSeries] = this.order;
                ((OMETiffReader)OMETiffReader.this).core.rgb[((OMETiffReader)OMETiffReader.this).currentSeries] = OMETiffReader.this.isRGB();
                ((OMETiffReader)OMETiffReader.this).core.indexed[((OMETiffReader)OMETiffReader.this).currentSeries] = OMETiffReader.this.isIndexed();
                ((OMETiffReader)OMETiffReader.this).core.falseColor[((OMETiffReader)OMETiffReader.this).currentSeries] = OMETiffReader.this.isFalseColor();
                int sc = ((OMETiffReader)OMETiffReader.this).core.sizeC[OMETiffReader.this.currentSeries];
                if (((OMETiffReader)OMETiffReader.this).core.rgb[OMETiffReader.this.currentSeries] && !((OMETiffReader)OMETiffReader.this).core.indexed[OMETiffReader.this.currentSeries]) {
                    sc /= 3;
                }
                if (((OMETiffReader)OMETiffReader.this).core.indexed[OMETiffReader.this.currentSeries]) {
                    int n = OMETiffReader.this.currentSeries;
                    ((OMETiffReader)OMETiffReader.this).core.sizeC[n] = ((OMETiffReader)OMETiffReader.this).core.sizeC[n] * 3;
                }
                ((OMETiffReader)OMETiffReader.this).core.imageCount[((OMETiffReader)OMETiffReader.this).currentSeries] = ((OMETiffReader)OMETiffReader.this).core.sizeZ[OMETiffReader.this.currentSeries] * sc * ((OMETiffReader)OMETiffReader.this).core.sizeT[OMETiffReader.this.currentSeries];
                ((OMETiffReader)OMETiffReader.this).core.pixelType[((OMETiffReader)OMETiffReader.this).currentSeries] = FormatTools.pixelTypeFromString(attributes.getValue("PixelType"));
                if (((OMETiffReader)OMETiffReader.this).core.pixelType[OMETiffReader.this.currentSeries] == 0 || ((OMETiffReader)OMETiffReader.this).core.pixelType[OMETiffReader.this.currentSeries] == 2 || ((OMETiffReader)OMETiffReader.this).core.pixelType[OMETiffReader.this.currentSeries] == 4) {
                    int n = OMETiffReader.this.currentSeries;
                    ((OMETiffReader)OMETiffReader.this).core.pixelType[n] = ((OMETiffReader)OMETiffReader.this).core.pixelType[n] + 1;
                }
                if (OMETiffReader.this.isWiscScan) {
                    ((OMETiffReader)OMETiffReader.this).core.sizeT[((OMETiffReader)OMETiffReader.this).currentSeries] = ((OMETiffReader)OMETiffReader.this).core.imageCount[0];
                }
                ((OMETiffReader)OMETiffReader.this).core.orderCertain[((OMETiffReader)OMETiffReader.this).currentSeries] = true;
                OMETiffReader.this.seriesCount++;
            } else if (qName.equals("TiffData")) {
                String ifd = attributes.getValue("IFD");
                String numPlanes = attributes.getValue("NumPlanes");
                String z = attributes.getValue("FirstZ");
                String c = attributes.getValue("FirstC");
                String t = attributes.getValue("FirstT");
                if (ifd == null || ifd.equals("")) {
                    ifd = "0";
                }
                if (numPlanes == null || numPlanes.equals("")) {
                    numPlanes = OMETiffReader.this.usedIFDs != null ? "" + OMETiffReader.this.usedIFDs[OMETiffReader.this.currentSeries].length : "" + OMETiffReader.this.ifds.length;
                }
                if (z == null || z.equals("")) {
                    z = "0";
                }
                if (c == null || c.equals("")) {
                    c = "0";
                }
                if (t == null || t.equals("")) {
                    t = "0";
                }
                try {
                    if (OMETiffReader.this.usedIFDs != null && OMETiffReader.this.usedIFDs[OMETiffReader.this.currentFile] != null) {
                        int f = Integer.parseInt(ifd);
                        int x = (int)TiffTools.getImageWidth(OMETiffReader.this.usedIFDs[OMETiffReader.this.currentFile][f]);
                        int y = (int)TiffTools.getImageLength(OMETiffReader.this.usedIFDs[OMETiffReader.this.currentFile][f]);
                        if (x != ((OMETiffReader)OMETiffReader.this).core.sizeX[OMETiffReader.this.currentSeries]) {
                            LogTools.println("Mismatched width: got " + ((OMETiffReader)OMETiffReader.this).core.sizeX[OMETiffReader.this.currentSeries] + ", expected " + x);
                            ((OMETiffReader)OMETiffReader.this).core.sizeX[((OMETiffReader)OMETiffReader.this).currentSeries] = x;
                        }
                        if (y != ((OMETiffReader)OMETiffReader.this).core.sizeY[OMETiffReader.this.currentSeries]) {
                            LogTools.println("Mismatched height: got " + ((OMETiffReader)OMETiffReader.this).core.sizeY[OMETiffReader.this.currentSeries] + ", expected " + y);
                            ((OMETiffReader)OMETiffReader.this).core.sizeY[((OMETiffReader)OMETiffReader.this).currentSeries] = y;
                        }
                    }
                }
                catch (FormatException e) {
                    // empty catch block
                }
                int idx = FormatTools.getIndex(this.order, this.sizeZ, this.sizeC, this.sizeT, this.sizeZ * this.sizeC * this.sizeT, Integer.parseInt(z), Integer.parseInt(c), Integer.parseInt(t));
                if (OMETiffReader.this.tempIfdMap != null) {
                    int i;
                    Vector v = new Vector(this.sizeZ * this.sizeC * this.sizeT);
                    Vector y = new Vector(this.sizeZ * this.sizeC * this.sizeT);
                    if (OMETiffReader.this.tempIfdMap.size() >= OMETiffReader.this.seriesCount && OMETiffReader.this.tempIfdMap.size() > 0) {
                        v = (Vector)OMETiffReader.this.tempIfdMap.get(OMETiffReader.this.seriesCount - 1);
                        y = (Vector)OMETiffReader.this.tempFileMap.get(OMETiffReader.this.seriesCount - 1);
                    } else {
                        for (i = 0; i < this.sizeZ * this.sizeC * this.sizeT; ++i) {
                            v.add(new Integer(-1));
                            y.add(new Integer(-1));
                        }
                    }
                    v.setElementAt(new Integer(ifd), idx);
                    y.setElementAt(new Integer(0), idx);
                    for (i = 1; i < Integer.parseInt(numPlanes); ++i) {
                        v.setElementAt(new Integer(Integer.parseInt(ifd) + i), idx + i);
                        y.setElementAt(new Integer(0), idx + i);
                    }
                    if (OMETiffReader.this.tempIfdMap.size() >= OMETiffReader.this.seriesCount) {
                        OMETiffReader.this.tempIfdMap.setElementAt(v, OMETiffReader.this.seriesCount - 1);
                        OMETiffReader.this.tempFileMap.setElementAt(y, OMETiffReader.this.seriesCount - 1);
                    } else {
                        OMETiffReader.this.tempIfdMap.add(v);
                        OMETiffReader.this.tempFileMap.add(y);
                    }
                } else {
                    ((OMETiffReader)OMETiffReader.this).ifdMap[((OMETiffReader)OMETiffReader.this).currentSeries][idx] = Integer.parseInt(ifd);
                    ((OMETiffReader)OMETiffReader.this).fileMap[((OMETiffReader)OMETiffReader.this).currentSeries][idx] = OMETiffReader.this.currentFile;
                    for (int i = 1; i < Integer.parseInt(numPlanes); ++i) {
                        ((OMETiffReader)OMETiffReader.this).ifdMap[((OMETiffReader)OMETiffReader.this).currentSeries][idx + i] = OMETiffReader.this.ifdMap[OMETiffReader.this.currentSeries][idx] + i;
                        ((OMETiffReader)OMETiffReader.this).fileMap[((OMETiffReader)OMETiffReader.this).currentSeries][idx + i] = OMETiffReader.this.currentFile;
                    }
                }
            }
        }
    }
}

