/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import visad.VisADException;
import visad.util.ThreadPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadManager {
    private String name = "TreadManager";
    private static int maxThreads = 1;
    private List<VisADException> visadExceptions = new ArrayList<VisADException>();
    private List<RemoteException> remoteExceptions = new ArrayList<RemoteException>();
    private List<RuntimeException> runtimeExceptions = new ArrayList<RuntimeException>();
    private int numThreadsRunning = 0;
    private Object MUTEX = new Object();
    private boolean running = false;
    private List<MyRunnable> runnables = new ArrayList<MyRunnable>();
    private int myMaxThreads;
    private static Hashtable<Integer, Integer[]> times = new Hashtable();
    public boolean debug = false;
    public static final int MAX_THREADS = 32;

    public ThreadManager() {
        this("ThreadManager");
    }

    public ThreadManager(String theName) {
        this.name = theName;
        if (maxThreads <= 0) {
            maxThreads = Runtime.getRuntime().availableProcessors();
        }
        this.myMaxThreads = maxThreads;
    }

    public ThreadManager(int maxThreads) {
        this.myMaxThreads = maxThreads;
    }

    public static void setGlobalMaxThreads(int max) {
        maxThreads = max;
    }

    public void debug(String msg) {
    }

    public static void clearTimes() {
        times = new Hashtable();
    }

    public void addRunnable(MyRunnable runnable) {
        this.runnables.add(runnable);
    }

    public void handleException(Exception exc) {
        if (exc instanceof VisADException) {
            this.visadExceptions.add((VisADException)exc);
        } else if (exc instanceof RemoteException) {
            this.remoteExceptions.add((RemoteException)exc);
        } else if (exc instanceof RuntimeException) {
            this.runtimeExceptions.add((RuntimeException)exc);
        } else {
            this.runtimeExceptions.add(new RuntimeException(exc));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runnableStopped() {
        Object object = this.MUTEX;
        synchronized (object) {
            --this.numThreadsRunning;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runnableStarted() {
        Object object = this.MUTEX;
        synchronized (object) {
            ++this.numThreadsRunning;
        }
    }

    public int getNumRunnables() {
        return this.runnables.size();
    }

    public void runInParallel(int maxThreads) throws VisADException, RemoteException {
        this.myMaxThreads = maxThreads;
        this.runInParallel();
    }

    public void runSequentially() throws VisADException, RemoteException {
        this.myMaxThreads = 1;
        this.runInParallel();
    }

    public void runAllParallel() throws VisADException, RemoteException {
        this.runInParallel(this.runnables.size());
    }

    public void runInParallel() throws VisADException, RemoteException {
        this.runInParallel(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runInParallel(boolean doAverage) throws VisADException, RemoteException {
        int max;
        this.myMaxThreads = Math.max(this.myMaxThreads, 1);
        this.myMaxThreads = Math.min(this.myMaxThreads, 32);
        int min2 = max = Math.min(this.myMaxThreads, this.runnables.size());
        this.running = true;
        long t1 = System.currentTimeMillis();
        if (max < 2) {
            for (MyRunnable myRunnable : this.runnables) {
                try {
                    myRunnable.run();
                }
                catch (Exception exc) {
                    this.handleException(exc);
                }
                this.checkErrors();
            }
        } else {
            ThreadPool pool;
            try {
                pool = new ThreadPool("thread util", min2, max);
            }
            catch (Exception exc) {
                throw new RuntimeException(exc);
            }
            for (MyRunnable myRunnable : this.runnables) {
                this.runnableStarted();
                final MyRunnable theRunnable = myRunnable;
                Runnable runnable = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            theRunnable.run();
                        }
                        catch (Exception exc) {
                            ThreadManager.this.handleException(exc);
                        }
                        finally {
                            ThreadManager.this.runnableStopped();
                        }
                    }
                };
                pool.queue(runnable);
            }
            try {
                pool.waitForTasks();
                this.checkErrors();
            }
            finally {
                try {
                    pool.stopThreads();
                }
                catch (Exception ignoreThis) {}
            }
        }
        this.running = false;
        long t2 = System.currentTimeMillis();
        if (this.debug) {
            System.err.println(this.name + " time:" + (t2 - t1) + " max threads:" + this.myMaxThreads);
        }
        if (doAverage) {
            // empty if block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkErrors() throws VisADException, RemoteException {
        try {
            if (this.visadExceptions.size() > 0) {
                throw this.visadExceptions.get(0);
            }
            if (this.remoteExceptions.size() > 0) {
                throw this.remoteExceptions.get(0);
            }
            if (this.runtimeExceptions.size() > 0) {
                throw this.runtimeExceptions.get(0);
            }
        }
        finally {
            this.running = false;
        }
    }

    public List<Exception> getExceptions() {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        exceptions.addAll(this.visadExceptions);
        exceptions.addAll(this.remoteExceptions);
        exceptions.addAll(this.runtimeExceptions);
        return exceptions;
    }

    public static final void doWork(int amt, int[] A2) {
        long x = 0L;
        long y = 0L;
        long work = (long)amt * 2000000L;
        for (long i = 0L; i < work; ++i) {
            ++x;
        }
    }

    public static void main(String[] args) throws Exception {
        int numberOfProcessors = Runtime.getRuntime().availableProcessors();
        int myCnt = args.length > 0 ? new Integer(args[0]) : 2;
        for (myCnt = 1; myCnt < 20; ++myCnt) {
            ThreadManager threadManager = new ThreadManager();
            int amt = 2000;
            final int cnt = myCnt;
            final int[] A2 = new int[10000000];
            for (int i = 0; i < cnt; ++i) {
                threadManager.addRunnable(new MyRunnable(){

                    public void run() throws Exception {
                        ThreadManager.doWork(2000 / cnt, A2);
                    }
                });
            }
            long t1 = System.currentTimeMillis();
            threadManager.runInParallel(cnt);
            long t2 = System.currentTimeMillis();
            long time = t2 - t1;
        }
    }

    public static interface MyRunnable {
        public void run() throws Exception;
    }
}

