/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.dbi;

import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.JEVersion;
import com.sleepycat.je.utilint.TestHook;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public class TTL {
    public static final long MILLIS_PER_HOUR = 3600000L;
    public static final long MILLIS_PER_DAY = 86400000L;
    private static final JEVersion MIN_JE_VERSION = new JEVersion("6.5.0");
    public static JEVersion TEST_MIN_JE_VERSION = null;
    private static TestHook<Long> timeTestHook = null;
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private static final SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd.HH");

    public static JEVersion getMinJEVersion() {
        if (TEST_MIN_JE_VERSION != null) {
            return TEST_MIN_JE_VERSION;
        }
        return MIN_JE_VERSION;
    }

    public static void setTimeTestHook(TestHook<Long> hook) {
        timeTestHook = hook;
    }

    public static long currentSystemTime() {
        if (timeTestHook != null) {
            return timeTestHook.getHookValue();
        }
        return System.currentTimeMillis();
    }

    public static long expirationToSystemTime(int expiration, boolean hours) {
        assert (expiration >= 0);
        if (expiration == 0) {
            return 0L;
        }
        return (long)expiration * (hours ? 3600000L : 86400000L);
    }

    public static int ttlToExpiration(int ttl, TimeUnit ttlUnits) {
        int currentTime;
        if (ttl < 0) {
            throw new IllegalArgumentException("TTL value: " + ttl + " must not be negative.");
        }
        if (ttl == 0) {
            return 0;
        }
        if (ttlUnits == TimeUnit.DAYS) {
            if (ttl > 0x2AAAAAA) {
                throw new IllegalArgumentException("TTL value: " + ttl + " must not exceed WriteOptions.TTL_MAX_DAYS");
            }
            currentTime = (int)((TTL.currentSystemTime() + 86400000L - 1L) / 86400000L);
        } else if (ttlUnits == TimeUnit.HOURS) {
            if (ttl > 0x3FFFFFFF) {
                throw new IllegalArgumentException("TTL value: " + ttl + " must not exceed WriteOptions.TTL_MAX_HOURS");
            }
            currentTime = (int)((TTL.currentSystemTime() + 3600000L - 1L) / 3600000L);
        } else {
            throw new IllegalArgumentException("ttlUnits not allowed: " + (Object)((Object)ttlUnits));
        }
        int result = currentTime + ttl;
        if (result <= 0) {
            throw EnvironmentFailureException.unexpectedState("TTL " + ttl + " " + (Object)((Object)ttlUnits) + " results in int overflow, expiration time: " + result + ". System time may be set incorrectly: " + TTL.currentSystemTime());
        }
        return result;
    }

    public static boolean isSystemTimeInHours(long systemMs) {
        long hours = (systemMs + 3600000L - 1L) / 3600000L;
        return hours % 24L != 0L;
    }

    public static int systemTimeToExpiration(long systemMs, boolean hours) {
        return (int)(hours ? (systemMs + 3600000L - 1L) / 3600000L : (systemMs + 86400000L - 1L) / 86400000L);
    }

    public static String formatExpiration(int expiration, boolean hours) {
        return TTL.formatExpirationTime(TTL.expirationToSystemTime(expiration, hours));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatExpirationTime(long time) {
        Date date = new Date(time);
        SimpleDateFormat simpleDateFormat = TIME_FORMAT;
        synchronized (simpleDateFormat) {
            return TIME_FORMAT.format(date);
        }
    }

    public static boolean isExpired(int expiration, boolean hours) {
        return expiration != 0 && TTL.currentSystemTime() > TTL.expirationToSystemTime(expiration, hours);
    }

    public static boolean isExpired(long expirationTime) {
        return expirationTime != 0L && TTL.currentSystemTime() > expirationTime;
    }

    public static boolean expiresWithin(int expiration, boolean hours, long withinMs) {
        return expiration != 0 && TTL.currentSystemTime() + withinMs > TTL.expirationToSystemTime(expiration, hours);
    }

    public static boolean expiresWithin(long expirationTime, long withinMs) {
        return expirationTime != 0L && TTL.currentSystemTime() + withinMs > expirationTime;
    }

    static {
        TIME_FORMAT.setTimeZone(UTC);
    }
}

