/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import visad.VisADException;
import visad.util.TextEditor;

public abstract class CodeEditor
extends TextEditor {
    protected JTextArea lineNumbers;
    protected int numLines;
    protected int numDigits;

    public CodeEditor() {
        this((String)null);
    }

    public CodeEditor(String filename) {
        super(filename);
        final int fontWidth = this.getFontMetrics(MONO).stringWidth(" ");
        this.lineNumbers = new JTextArea("1"){

            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                d.width = CodeEditor.this.numDigits * fontWidth;
                return d;
            }
        };
        this.lineNumbers.setEditable(false);
        this.lineNumbers.setFont(MONO);
        this.numLines = 1;
        this.numDigits = 1;
        JPanel p = new JPanel(){

            public void paint(Graphics g2) {
                super.paint(g2);
                Dimension d = this.getSize();
                int w = d.width - 5;
                int h2 = d.height - 1;
                g2.setColor(Color.gray);
                g2.drawLine(w, 0, w, h2);
            }

            public Dimension getPreferredSize() {
                Dimension d = CodeEditor.this.lineNumbers.getPreferredSize();
                d.width += 10;
                return d;
            }
        };
        p.setBackground(Color.white);
        p.setLayout(new BoxLayout(p, 0));
        p.add(this.lineNumbers);
        this.setRowHeaderView(p);
    }

    public void highlightLine(int line) {
        int start = 0;
        String s2 = this.text.getText() + "\n";
        for (int i = 0; i < line - 1; ++i) {
            start = s2.indexOf("\n", start) + 1;
        }
        int end = s2.indexOf("\n", start);
        this.text.requestFocus();
        this.text.setCaretPosition(start);
        this.text.moveCaretPosition(end);
    }

    public abstract void run() throws VisADException;

    public abstract void compile() throws VisADException;

    public abstract void exec(String var1) throws VisADException;

    protected void updateLineNumbers() {
        String newL;
        String s2 = this.text.getText();
        int len = s2.length();
        int count = 1;
        int index = s2.indexOf("\n");
        while (index >= 0) {
            ++count;
            index = s2.indexOf("\n", index + 1);
        }
        if (count == this.numLines) {
            return;
        }
        String l = this.lineNumbers.getText() + "\n";
        int digits = ("" + count).length();
        int spot = 0;
        int nine = 9;
        for (int i = 2; i <= digits; ++i) {
            spot += i * nine;
            nine *= 10;
        }
        int ten = nine / 9;
        int maxSpot = l.length();
        if ((spot += (digits + 1) * (count - ten + 1)) < maxSpot) {
            newL = l.substring(0, spot - 1);
        } else {
            StringBuffer sb = new StringBuffer(spot);
            sb.append(l);
            for (int i = this.numLines + 1; i < count; ++i) {
                sb.append(i);
                sb.append("\n");
            }
            sb.append(count);
            newL = sb.toString();
        }
        this.numLines = count;
        this.numDigits = digits;
        this.lineNumbers.setText(newL);
    }

    public void undo() throws CannotUndoException {
        super.undo();
        this.updateLineNumbers();
    }

    public void redo() throws CannotRedoException {
        super.redo();
        this.updateLineNumbers();
    }

    public void undoableEditHappened(UndoableEditEvent e) {
        super.undoableEditHappened(e);
        if (!e.getEdit().isSignificant()) {
            return;
        }
        this.updateLineNumbers();
    }
}

