/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.txn;

import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.utilint.DbLsn;

public class WriteLockInfo {
    private long abortLsn = -1L;
    private boolean abortKnownDeleted = false;
    private byte[] abortKey;
    private byte[] abortData;
    private long abortVLSN = -1L;
    private int abortLogSize;
    private int abortExpiration;
    private DatabaseImpl db;
    private boolean neverLocked = true;
    static final WriteLockInfo basicWriteLockInfo = new WriteLockInfo();

    public boolean getAbortKnownDeleted() {
        return this.abortKnownDeleted;
    }

    public void setAbortKnownDeleted(boolean v) {
        this.abortKnownDeleted = v;
    }

    public long getAbortLsn() {
        return this.abortLsn;
    }

    public void setAbortLsn(long abortLsn) {
        this.abortLsn = abortLsn;
    }

    public byte[] getAbortKey() {
        return this.abortKey;
    }

    public void setAbortKey(byte[] v) {
        this.abortKey = v;
    }

    public byte[] getAbortData() {
        return this.abortData;
    }

    public void setAbortData(byte[] v) {
        this.abortData = v;
    }

    public long getAbortVLSN() {
        return this.abortVLSN;
    }

    public void setAbortVLSN(long v) {
        this.abortVLSN = v;
    }

    public int getAbortLogSize() {
        return this.abortLogSize;
    }

    public void setAbortLogSize(int logSize) {
        this.abortLogSize = logSize;
    }

    public void setAbortExpiration(int expiration, boolean expirationInHours) {
        this.abortExpiration = expirationInHours ? -expiration : expiration;
    }

    public int getAbortExpiration() {
        return Math.abs(this.abortExpiration);
    }

    public boolean isAbortExpirationInHours() {
        return this.abortExpiration < 0;
    }

    public DatabaseImpl getDb() {
        return this.db;
    }

    public void setDb(DatabaseImpl db) {
        this.db = db;
    }

    public boolean getNeverLocked() {
        return this.neverLocked;
    }

    public void setNeverLocked(boolean neverLocked) {
        this.neverLocked = neverLocked;
    }

    public void copyAllInfo(WriteLockInfo source) {
        this.abortLsn = source.abortLsn;
        this.abortKnownDeleted = source.abortKnownDeleted;
        this.abortKey = source.abortKey;
        this.abortData = source.abortData;
        this.abortVLSN = source.abortVLSN;
        this.abortLogSize = source.abortLogSize;
        this.abortExpiration = source.abortExpiration;
        this.db = source.db;
        this.neverLocked = source.neverLocked;
    }

    public String toString() {
        return "abortLsn=" + DbLsn.getNoFormatString(this.abortLsn) + " abortKnownDeleted=" + this.abortKnownDeleted + " abortKey=" + Key.getNoFormatString(this.abortKey) + " abortData=" + Key.getNoFormatString(this.abortData) + " abortLogSize=" + this.abortLogSize + " abortVLSN=" + String.format("%,d", this.abortVLSN) + " abortExpiration=" + this.getAbortExpiration() + " abortExpirationInHours=" + this.isAbortExpirationInHours() + " neverLocked=" + this.neverLocked;
    }
}

