/*
 * Decompiled with CFR 0.152.
 */
package thredds.wcs.v1_1_0;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.wcs.v1_1_0.GetCapabilities;
import thredds.wcs.v1_1_0.WcsException;
import ucar.nc2.dt.GridDataset;

public class Request {
    private static Logger log = LoggerFactory.getLogger(Request.class);
    private static final String expectedVersion = "1.1.0";
    private Operation operation;
    private String negotiatedVersion;
    private List<GetCapabilities.Section> sections;
    private List<String> identifierList;
    private String identifier;
    private String datasetPath;
    private GridDataset dataset;
    private List<String> availableCoverageNames;

    public static Request getGetCapabilitiesRequest(Operation operation, String negotiatedVersion, List<GetCapabilities.Section> sections, String datasetPath, GridDataset dataset) {
        if (!operation.equals((Object)Operation.GetCapabilities)) {
            throw new IllegalArgumentException("The \"" + operation.toString() + "\" operation not supported by this method.");
        }
        Objects.requireNonNull(sections);
        Request req = new Request(operation, negotiatedVersion, datasetPath, dataset);
        req.sections = sections;
        return req;
    }

    public static Request getDescribeCoverageRequest(Operation operation, String negotiatedVersion, List<String> identifiers, String datasetPath, GridDataset dataset) throws WcsException {
        if (!operation.equals((Object)Operation.DescribeCoverage)) {
            throw new IllegalArgumentException("The \"" + operation.toString() + "\" operation not supported by this method.");
        }
        Request req = new Request(operation, negotiatedVersion, datasetPath, dataset);
        if (!req.availableCoverageNames.containsAll(identifiers)) {
            throw new WcsException(WcsException.Code.InvalidParameterValue, "identifiers", "The \"identifiers\" parameter contains unrecognized values: " + identifiers);
        }
        req.identifierList = identifiers;
        return req;
    }

    public static Request getGetCoverageRequest(Operation operation, String negotiatedVersion, String identifier, String datasetPath, GridDataset dataset) throws WcsException {
        if (!operation.equals((Object)Operation.GetCoverage)) {
            throw new IllegalArgumentException("The \"" + operation.toString() + "\" operation not supported by this method.");
        }
        Request req = new Request(operation, negotiatedVersion, datasetPath, dataset);
        if (!req.availableCoverageNames.contains(identifier)) {
            throw new WcsException(WcsException.Code.InvalidParameterValue, "identifier", "Unrecognized value in \"identifier\" parameter: " + identifier);
        }
        req.identifier = identifier;
        return req;
    }

    Request(Operation operation, String negotiatedVersion, String datasetPath, GridDataset dataset) {
        Objects.requireNonNull(operation);
        Objects.requireNonNull(negotiatedVersion);
        Objects.requireNonNull(datasetPath);
        Objects.requireNonNull(dataset);
        if (!this.negotiatedVersion.equals(expectedVersion)) {
            throw new IllegalArgumentException("Version <" + negotiatedVersion + "> not as expected <" + expectedVersion + ">.");
        }
        this.operation = operation;
        this.negotiatedVersion = negotiatedVersion;
        this.datasetPath = datasetPath;
        this.dataset = dataset;
        this.availableCoverageNames = new ArrayList<String>();
        for (GridDataset.Gridset gs : this.dataset.getGridsets()) {
            this.availableCoverageNames.add(gs.getGeoCoordSystem().getName());
        }
    }

    public Operation getOperation() {
        return this.operation;
    }

    public String getDatasetName() {
        int pos = this.datasetPath.lastIndexOf(47);
        return pos == -1 ? this.datasetPath : this.datasetPath.substring(pos + 1);
    }

    public String getDatasetPath() {
        return this.datasetPath;
    }

    public GridDataset getDataset() {
        return this.dataset;
    }

    public List<String> getAvailableCoverageNames() {
        return this.availableCoverageNames;
    }

    public List<GetCapabilities.Section> getSections() {
        return Collections.unmodifiableList(this.sections);
    }

    public List<String> getIdentifierList() {
        return this.identifierList;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public static enum Format {
        NONE(""),
        GeoTIFF("image/tiff"),
        GeoTIFF_Float("image/tiff"),
        NetCDF3("application/x-netcdf");

        private String mimeType;

        private Format(String mimeType) {
            this.mimeType = mimeType;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public static Format getFormat(String mimeType) {
            for (Format curSection : Format.values()) {
                if (!curSection.mimeType.equals(mimeType)) continue;
                return curSection;
            }
            throw new IllegalArgumentException("No such instance <" + mimeType + ">.");
        }
    }

    public static enum RequestEncoding {
        GET_KVP,
        POST_XML,
        POST_SOAP;

    }

    public static enum Operation {
        GetCapabilities,
        DescribeCoverage,
        GetCoverage;

    }
}

