/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib1;

import java.io.IOException;
import java.util.Formatter;
import java.util.zip.CRC32;
import net.jcip.annotations.Immutable;
import ucar.nc2.grib.GribNumbers;
import ucar.nc2.grib.grib1.Grib1Gds;
import ucar.nc2.grib.grib1.Grib1GdsPredefined;
import ucar.nc2.grib.grib1.Grib1SectionProductDefinition;
import ucar.unidata.io.RandomAccessFile;

@Immutable
public class Grib1SectionGridDefinition {
    private final byte[] rawData;
    private final long startingPosition;
    private final int gridTemplate;
    private final int predefinedGridDefinition;
    private final int predefinedGridDefinitionCenter;

    public Grib1SectionGridDefinition(RandomAccessFile raf) throws IOException {
        this.startingPosition = raf.getFilePointer();
        int length = GribNumbers.int3(raf);
        raf.skipBytes(2);
        this.gridTemplate = GribNumbers.uint(raf);
        this.rawData = new byte[length];
        raf.seek(this.startingPosition);
        raf.readFully(this.rawData);
        this.predefinedGridDefinition = -1;
        this.predefinedGridDefinitionCenter = -1;
    }

    public Grib1SectionGridDefinition(byte[] rawData) {
        this.rawData = rawData;
        this.gridTemplate = this.getOctet(6);
        this.startingPosition = -1L;
        this.predefinedGridDefinition = -1;
        this.predefinedGridDefinitionCenter = -1;
    }

    public Grib1SectionGridDefinition(Grib1SectionProductDefinition pds) {
        this.startingPosition = -1L;
        this.gridTemplate = -pds.getGridDefinition();
        this.rawData = null;
        this.predefinedGridDefinitionCenter = pds.getCenter();
        this.predefinedGridDefinition = pds.getGridDefinition();
    }

    public byte[] getRawBytes() {
        return this.rawData;
    }

    public long calcCRC() {
        long crc;
        if (this.rawData == null) {
            crc = this.predefinedGridDefinitionCenter << 16 + this.predefinedGridDefinition;
        } else {
            CRC32 crc32 = new CRC32();
            crc32.update(this.rawData);
            crc = crc32.getValue();
        }
        return crc;
    }

    public int getLength() {
        return this.rawData == null ? 0 : this.rawData.length;
    }

    public long getOffset() {
        return this.startingPosition;
    }

    public int getGridTemplate() {
        return this.gridTemplate;
    }

    public int getPredefinedGridDefinition() {
        return this.predefinedGridDefinition;
    }

    private int getOctet(int index) {
        if (this.rawData == null) {
            return 255;
        }
        if (index > this.rawData.length) {
            return -9999;
        }
        return this.rawData[index - 1] & 0xFF;
    }

    public Grib1Gds getGDS() {
        if (this.predefinedGridDefinition != -1) {
            return Grib1GdsPredefined.factory(this.predefinedGridDefinitionCenter, this.predefinedGridDefinition);
        }
        Grib1Gds gds = Grib1Gds.factory(this.gridTemplate, this.rawData);
        if (this.isThin()) {
            gds.setNptsInLine(this.getNptsInLine(gds));
        }
        return gds;
    }

    public final boolean isThin() {
        if (this.rawData == null) {
            return false;
        }
        int octet5 = this.getOctet(5);
        int nv = this.getOctet(4);
        return octet5 != 255 && (nv == 0 || nv == 255);
    }

    private int[] getNptsInLine(Grib1Gds gds) {
        int numPts = (gds.getScanMode() & 0x20) == 0 ? gds.getNy() : gds.getNx();
        int[] parallels = new int[numPts];
        int offset = this.getOctet(5);
        for (int i = 0; i < numPts; ++i) {
            parallels[i] = GribNumbers.int2(this.getOctet(offset++), this.getOctet(offset++));
        }
        return parallels;
    }

    public boolean hasVerticalCoordinateParameters() {
        if (this.rawData == null) {
            return false;
        }
        int octet5 = this.getOctet(5);
        int nv = this.getOctet(4);
        return octet5 != 255 && nv != 0 && nv != 255;
    }

    public double[] getVerticalCoordinateParameters() {
        if (!this.hasVerticalCoordinateParameters()) {
            return null;
        }
        int offset = this.getOctet(5);
        int n = this.getOctet(4);
        double[] vertCoords = new double[n];
        for (int i = 0; i < n; ++i) {
            vertCoords[i] = GribNumbers.float4(this.getOctet(offset++), this.getOctet(offset++), this.getOctet(offset++), this.getOctet(offset++));
        }
        return vertCoords;
    }

    public String toString() {
        Formatter sb = new Formatter();
        sb.format("Grib1SectionGridDefinition", new Object[0]);
        sb.format("  gridTemplate=%d%n", this.gridTemplate);
        sb.format("  predefinedGridDefinition=%d%n", this.predefinedGridDefinition);
        double[] verts = this.getVerticalCoordinateParameters();
        if (verts != null) {
            sb.format("  verticalPressureLevels (%d)=", verts.length);
            for (double d : verts) {
                sb.format("%10.4f ", d);
            }
            sb.format("%n", new Object[0]);
        }
        sb.format("%n", new Object[0]);
        return sb.toString();
    }
}

