/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.stream;

import com.sleepycat.je.JEVersion;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.rep.NodeType;
import com.sleepycat.je.rep.impl.RepImpl;
import com.sleepycat.je.rep.impl.node.NameIdPair;
import com.sleepycat.je.rep.impl.node.RepNode;
import com.sleepycat.je.rep.stream.BaseProtocol;
import com.sleepycat.je.rep.utilint.BinaryProtocol;
import com.sleepycat.je.rep.utilint.RepUtils;
import java.nio.ByteBuffer;
import java.util.UUID;

public class Protocol
extends BaseProtocol {
    public static final BinaryProtocol.MessageOp REPLICA_PROTOCOL_VERSION = new BinaryProtocol.MessageOp(1, ReplicaProtocolVersion.class);
    public static final BinaryProtocol.MessageOp FEEDER_PROTOCOL_VERSION = new BinaryProtocol.MessageOp(2, FeederProtocolVersion.class);
    public static final BinaryProtocol.MessageOp DUP_NODE_REJECT = new BinaryProtocol.MessageOp(3, DuplicateNodeReject.class);
    public static final BinaryProtocol.MessageOp REPLICA_JE_VERSIONS = new BinaryProtocol.MessageOp(4, ReplicaJEVersions.class);
    public static final BinaryProtocol.MessageOp FEEDER_JE_VERSIONS = new BinaryProtocol.MessageOp(5, FeederJEVersions.class);
    public static final BinaryProtocol.MessageOp JE_VERSIONS_REJECT = new BinaryProtocol.MessageOp(6, JEVersionsReject.class);
    public static final BinaryProtocol.MessageOp MEMBERSHIP_INFO = new BinaryProtocol.MessageOp(7, NodeGroupInfo.class);
    public static final BinaryProtocol.MessageOp MEMBERSHIP_INFO_OK = new BinaryProtocol.MessageOp(8, NodeGroupInfoOK.class);
    public static final BinaryProtocol.MessageOp MEMBERSHIP_INFO_REJECT = new BinaryProtocol.MessageOp(9, NodeGroupInfoReject.class);
    public static final BinaryProtocol.MessageOp SNTP_REQUEST = new BinaryProtocol.MessageOp(10, SNTPRequest.class);
    public static final BinaryProtocol.MessageOp SNTP_RESPONSE = new BinaryProtocol.MessageOp(11, SNTPResponse.class);
    public static final BinaryProtocol.MessageOp REAUTHENTICATE = new BinaryProtocol.MessageOp(12, ReAuthenticate.class);
    public static final BinaryProtocol.MessageOp DBID_REQUEST = new BinaryProtocol.MessageOp(13, DBIdRequest.class);
    public static final BinaryProtocol.MessageOp DBID_RESPONSE = new BinaryProtocol.MessageOp(14, DBIdResponse.class);
    public static final BinaryProtocol.MessageOp SECURITY_FAILURE_RESPONSE = new BinaryProtocol.MessageOp(15, SecurityFailureResponse.class);
    private static final BinaryProtocol.MessageOp[] ALL_MESSAGE_OPS = new BinaryProtocol.MessageOp[]{REPLICA_PROTOCOL_VERSION, FEEDER_PROTOCOL_VERSION, DUP_NODE_REJECT, REPLICA_JE_VERSIONS, FEEDER_JE_VERSIONS, JE_VERSIONS_REJECT, MEMBERSHIP_INFO, MEMBERSHIP_INFO_OK, MEMBERSHIP_INFO_REJECT, SNTP_REQUEST, SNTP_RESPONSE, ENTRY, START_STREAM, HEARTBEAT, HEARTBEAT_RESPONSE, COMMIT, ACK, ENTRY_REQUEST, ENTRY_NOTFOUND, RESTORE_REQUEST, RESTORE_RESPONSE, ALT_MATCHPOINT, SHUTDOWN_REQUEST, SHUTDOWN_RESPONSE, GROUP_ACK, REAUTHENTICATE, DBID_REQUEST, DBID_RESPONSE, SECURITY_FAILURE_RESPONSE};
    private final RepUtils.Clock clock;

    private Protocol(RepImpl repImpl, NameIdPair nameIdPair, RepUtils.Clock clock, int protocolVersion, int maxProtocolVersion, int streamLogVersion, int groupFormatVersion) {
        super(repImpl, nameIdPair, protocolVersion, maxProtocolVersion, streamLogVersion, ALL_MESSAGE_OPS, false);
        this.configuredVersion = protocolVersion;
        this.clock = clock;
    }

    public static Protocol get(RepNode repNode, int protocolVersion, int maxProtocolVersion) {
        return Protocol.get(repNode.getRepImpl(), repNode.getNameIdPair(), repNode.getClock(), protocolVersion, maxProtocolVersion, repNode.getGroup().getFormatVersion());
    }

    public static Protocol get(RepImpl repImpl, NameIdPair nameIdPair, RepUtils.Clock clock, int protocolVersion, int maxProtocolVersion, int groupFormatVersion) {
        return Protocol.get(repImpl, nameIdPair, clock, protocolVersion, maxProtocolVersion, 17, groupFormatVersion);
    }

    public static Protocol get(RepNode repNode, int protocolVersion, int maxProtocolVersion, int streamLogVersion) {
        return Protocol.get(repNode.getRepImpl(), repNode.getNameIdPair(), repNode.getClock(), protocolVersion, maxProtocolVersion, streamLogVersion, repNode.getGroup().getFormatVersion());
    }

    public static Protocol get(RepImpl repImpl, NameIdPair nameIdPair, RepUtils.Clock clock, int protocolVersion, int maxProtocolVersion, int streamLogVersion, int groupFormatVersion) {
        int minProtocolVersion = 3;
        if (groupFormatVersion >= 3) {
            minProtocolVersion = 5;
        }
        return Protocol.get(repImpl, nameIdPair, clock, protocolVersion, minProtocolVersion, maxProtocolVersion, streamLogVersion, groupFormatVersion);
    }

    static Protocol get(RepNode repNode, int protocolVersion, int minProtocolVersion, int maxProtocolVersion, int streamLogVersion) {
        int formatVersion = 3;
        if (repNode.getGroup() != null) {
            formatVersion = repNode.getGroup().getFormatVersion();
        }
        return Protocol.get(repNode.getRepImpl(), repNode.getNameIdPair(), repNode.getClock(), protocolVersion, minProtocolVersion, maxProtocolVersion, streamLogVersion, formatVersion);
    }

    private static Protocol get(RepImpl repImpl, NameIdPair nameIdPair, RepUtils.Clock clock, int protocolVersion, int minProtocolVersion, int maxProtocolVersion, int streamLogVersion, int groupFormatVersion) {
        if (!Protocol.isSupportedVersion(protocolVersion, minProtocolVersion, maxProtocolVersion)) {
            return null;
        }
        return new Protocol(repImpl, nameIdPair, clock, protocolVersion, maxProtocolVersion, streamLogVersion, groupFormatVersion);
    }

    static Protocol getProtocol(RepNode repNode, int protocolVersion) {
        int formatVersion = 3;
        if (repNode.getGroup() != null) {
            formatVersion = repNode.getGroup().getFormatVersion();
        }
        return Protocol.getProtocol(repNode.getRepImpl(), repNode.getNameIdPair(), repNode.getClock(), protocolVersion, formatVersion);
    }

    static Protocol getProtocol(RepImpl repImpl, NameIdPair nameIdPair, RepUtils.Clock clock, int protocolVersion, int groupFormatVersion) {
        return new Protocol(repImpl, nameIdPair, clock, protocolVersion, protocolVersion, 17, groupFormatVersion);
    }

    private static boolean isSupportedVersion(int protocolVersion, int minProtocolVersion, int maxProtocolVersion) {
        if (protocolVersion == Integer.MIN_VALUE) {
            return false;
        }
        return minProtocolVersion <= protocolVersion && protocolVersion <= maxProtocolVersion;
    }

    static JEVersion getProtocolJEVersion(int protocolVersion) {
        switch (protocolVersion) {
            case 9: {
                return VERSION_9_JE_VERSION;
            }
            case 8: {
                return VERSION_8_JE_VERSION;
            }
            case 7: {
                return VERSION_7_JE_VERSION;
            }
            case 6: {
                return VERSION_6_JE_VERSION;
            }
            case 5: {
                return VERSION_5_JE_VERSION;
            }
            case 4: {
                return VERSION_4_JE_VERSION;
            }
            case 3: {
                return VERSION_3_JE_VERSION;
            }
        }
        return null;
    }

    static int getJEVersionProtocolVersion(JEVersion jeVersion) {
        if (jeVersion == null) {
            return 9;
        }
        if (jeVersion.compareTo(VERSION_9_JE_VERSION) >= 0) {
            return 9;
        }
        if (jeVersion.compareTo(VERSION_8_JE_VERSION) >= 0) {
            return 8;
        }
        if (jeVersion.compareTo(VERSION_7_JE_VERSION) >= 0) {
            return 7;
        }
        if (jeVersion.compareTo(VERSION_6_JE_VERSION) >= 0) {
            return 6;
        }
        if (jeVersion.compareTo(VERSION_5_JE_VERSION) >= 0) {
            return 5;
        }
        if (jeVersion.compareTo(VERSION_4_JE_VERSION) >= 0) {
            return 4;
        }
        if (jeVersion.compareTo(VERSION_3_JE_VERSION) >= 0) {
            return 3;
        }
        throw new IllegalArgumentException("JE version not supported: " + jeVersion);
    }

    public class NodeGroupInfoReject
    extends BinaryProtocol.RejectMessage {
        NodeGroupInfoReject(String errorMessage) {
            super((BinaryProtocol)Protocol.this, errorMessage);
        }

        @Override
        public BinaryProtocol.MessageOp getOp() {
            return MEMBERSHIP_INFO_REJECT;
        }

        @Override
        public ByteBuffer wireFormat() {
            return this.wireFormat(this.errorMessage);
        }

        public NodeGroupInfoReject(ByteBuffer buffer) {
            super((BinaryProtocol)Protocol.this, buffer);
        }
    }

    public class NodeGroupInfoOK
    extends BaseProtocol.HandshakeMessage {
        private final UUID uuid;
        private final NameIdPair nameIdPair;

        public NodeGroupInfoOK(UUID uuid, NameIdPair nameIdPair) {
            this.uuid = uuid;
            this.nameIdPair = nameIdPair;
        }

        public NodeGroupInfoOK(ByteBuffer buffer) {
            this.uuid = new UUID(LogUtils.readLong(buffer), LogUtils.readLong(buffer));
            this.nameIdPair = this.getNameIdPair(buffer);
        }

        @Override
        public ByteBuffer wireFormat() {
            return this.wireFormat(this.uuid.getMostSignificantBits(), this.uuid.getLeastSignificantBits(), this.nameIdPair);
        }

        @Override
        public BinaryProtocol.MessageOp getOp() {
            return MEMBERSHIP_INFO_OK;
        }

        public NameIdPair getNameIdPair() {
            return this.nameIdPair;
        }

        public UUID getUUID() {
            return this.uuid;
        }
    }

    public class NodeGroupInfo
    extends BaseProtocol.HandshakeMessage {
        private final String groupName;
        private final UUID uuid;
        private final NameIdPair nameIdPair;
        private final String hostName;
        private final int port;
        private final NodeType nodeType;
        private final boolean designatedPrimary;
        private final String jeVersion;

        NodeGroupInfo(String groupName, UUID uuid, NameIdPair nameIdPair, String hostName, int port, NodeType nodeType, boolean designatedPrimary, JEVersion jeVersion) {
            this.groupName = groupName;
            this.uuid = uuid;
            this.nameIdPair = nameIdPair;
            this.hostName = hostName;
            this.port = port;
            this.nodeType = nodeType;
            this.designatedPrimary = designatedPrimary;
            this.jeVersion = jeVersion != null ? jeVersion.getNumericVersionString() : "";
        }

        @Override
        public BinaryProtocol.MessageOp getOp() {
            return MEMBERSHIP_INFO;
        }

        @Override
        public ByteBuffer wireFormat() {
            boolean repGroupV3;
            boolean bl = repGroupV3 = Protocol.this.getVersion() >= 5;
            if (!repGroupV3 && this.nodeType.compareTo(NodeType.ELECTABLE) > 0) {
                throw new IllegalStateException("Node type not supported before group version 3: " + (Object)((Object)this.nodeType));
            }
            Object[] args = new Object[repGroupV3 ? 9 : 8];
            args[0] = this.groupName;
            args[1] = this.uuid.getMostSignificantBits();
            args[2] = this.uuid.getLeastSignificantBits();
            args[3] = this.nameIdPair;
            args[4] = this.hostName;
            args[5] = this.port;
            args[6] = this.nodeType;
            args[7] = this.designatedPrimary;
            if (repGroupV3) {
                args[8] = this.jeVersion;
            }
            return this.wireFormat(args);
        }

        public NodeGroupInfo(ByteBuffer buffer) {
            this.groupName = Protocol.this.getString(buffer);
            this.uuid = new UUID(LogUtils.readLong(buffer), LogUtils.readLong(buffer));
            this.nameIdPair = this.getNameIdPair(buffer);
            this.hostName = Protocol.this.getString(buffer);
            this.port = LogUtils.readInt(buffer);
            this.nodeType = this.getEnum(NodeType.class, buffer);
            this.designatedPrimary = this.getBoolean(buffer);
            this.jeVersion = Protocol.this.getVersion() >= 5 ? Protocol.this.getString(buffer) : "";
        }

        public String getGroupName() {
            return this.groupName;
        }

        public UUID getUUID() {
            return this.uuid;
        }

        public String getNodeName() {
            return this.nameIdPair.getName();
        }

        public int getNodeId() {
            return this.nameIdPair.getId();
        }

        public String getHostName() {
            return this.hostName;
        }

        public NameIdPair getNameIdPair() {
            return this.nameIdPair;
        }

        public int port() {
            return this.port;
        }

        public NodeType getNodeType() {
            return this.nodeType;
        }

        public boolean isDesignatedPrimary() {
            return this.designatedPrimary;
        }

        public JEVersion getJEVersion() {
            return !this.jeVersion.isEmpty() ? new JEVersion(this.jeVersion) : null;
        }
    }

    public class JEVersionsReject
    extends BinaryProtocol.RejectMessage {
        public JEVersionsReject(String errorMessage) {
            super((BinaryProtocol)Protocol.this, errorMessage);
        }

        public JEVersionsReject(ByteBuffer buffer) {
            super((BinaryProtocol)Protocol.this, buffer);
        }

        @Override
        public BinaryProtocol.MessageOp getOp() {
            return JE_VERSIONS_REJECT;
        }
    }

    public class FeederJEVersions
    extends JEVersions {
        private JEVersion minJEVersion;

        FeederJEVersions(JEVersion version, int logVersion, JEVersion minJEVersion) {
            super(version, logVersion);
            this.minJEVersion = minJEVersion;
        }

        @Override
        public ByteBuffer wireFormat() {
            if (Protocol.this.configuredVersion < 7) {
                return super.wireFormat();
            }
            return this.wireFormat(this.getVersion().getVersionString(), this.getLogVersion(), this.minJEVersion.getVersionString());
        }

        public FeederJEVersions(ByteBuffer buffer) {
            super(buffer);
            if (Protocol.this.configuredVersion < 7) {
                return;
            }
            this.minJEVersion = new JEVersion(Protocol.this.getString(buffer));
        }

        @Override
        public BinaryProtocol.MessageOp getOp() {
            return FEEDER_JE_VERSIONS;
        }

        public JEVersion getMinJEVersion() {
            return this.minJEVersion;
        }
    }

    public class ReplicaJEVersions
    extends JEVersions {
        ReplicaJEVersions(JEVersion version, int logVersion) {
            super(version, logVersion);
        }

        public ReplicaJEVersions(ByteBuffer buffer) {
            super(buffer);
        }

        @Override
        public BinaryProtocol.MessageOp getOp() {
            return REPLICA_JE_VERSIONS;
        }
    }

    abstract class JEVersions
    extends BaseProtocol.HandshakeMessage {
        private final JEVersion version;
        private final int logVersion;

        public JEVersions(JEVersion version, int logVersion) {
            this.version = version;
            this.logVersion = logVersion;
        }

        @Override
        public ByteBuffer wireFormat() {
            return this.wireFormat(this.version.getVersionString(), this.logVersion);
        }

        public JEVersions(ByteBuffer buffer) {
            this.version = new JEVersion(Protocol.this.getString(buffer));
            this.logVersion = LogUtils.readInt(buffer);
        }

        public JEVersion getVersion() {
            return this.version;
        }

        public byte getLogVersion() {
            return (byte)this.logVersion;
        }
    }

    public class DBIdResponse
    extends BinaryProtocol.SimpleMessage {
        private final DatabaseId dbId;

        public DBIdResponse(DatabaseId dbId) {
            super(Protocol.this);
            this.dbId = dbId;
        }

        public DBIdResponse(ByteBuffer buffer) {
            super(Protocol.this);
            this.dbId = new DatabaseId(LogUtils.readLong(buffer));
        }

        public DatabaseId getDbId() {
            return this.dbId;
        }

        @Override
        public ByteBuffer wireFormat() {
            return this.wireFormat(this.dbId.getId());
        }

        @Override
        public BinaryProtocol.MessageOp getOp() {
            return DBID_RESPONSE;
        }
    }

    public class DBIdRequest
    extends BinaryProtocol.SimpleMessage {
        final String dbName;

        public DBIdRequest(String dbName) {
            super(Protocol.this);
            this.dbName = dbName;
        }

        public DBIdRequest(ByteBuffer buffer) {
            super(Protocol.this);
            this.dbName = Protocol.this.getString(buffer);
        }

        public String getDbName() {
            return this.dbName;
        }

        @Override
        public ByteBuffer wireFormat() {
            return this.wireFormat(this.dbName);
        }

        @Override
        public BinaryProtocol.MessageOp getOp() {
            return DBID_REQUEST;
        }
    }

    public class SecurityFailureResponse
    extends BinaryProtocol.SimpleMessage {
        private final String message;

        public SecurityFailureResponse(String message) {
            super(Protocol.this);
            if (message == null || message.isEmpty()) {
                throw new IllegalArgumentException("Message cannot be null or empty");
            }
            this.message = message;
        }

        @Override
        public ByteBuffer wireFormat() {
            return this.wireFormat(this.message);
        }

        public SecurityFailureResponse(ByteBuffer buffer) {
            super(Protocol.this);
            this.message = Protocol.this.getString(buffer);
        }

        public String getMessage() {
            return this.message;
        }

        @Override
        public BinaryProtocol.MessageOp getOp() {
            return SECURITY_FAILURE_RESPONSE;
        }
    }

    public class ReAuthenticate
    extends BinaryProtocol.SimpleMessage {
        private final byte[] tokenBytes;

        public ReAuthenticate(byte[] tokenBytes) {
            super(Protocol.this);
            this.tokenBytes = tokenBytes;
        }

        @Override
        public ByteBuffer wireFormat() {
            return this.wireFormat(new Object[]{this.tokenBytes});
        }

        public ReAuthenticate(ByteBuffer buffer) {
            super(Protocol.this);
            this.tokenBytes = this.getByteArray(buffer);
        }

        public byte[] getTokenBytes() {
            if (this.tokenBytes.length == 0) {
                return null;
            }
            return this.tokenBytes;
        }

        @Override
        public BinaryProtocol.MessageOp getOp() {
            return REAUTHENTICATE;
        }
    }

    public class SNTPResponse
    extends BaseProtocol.HandshakeMessage {
        private final long originateTimestamp;
        private final long receiveTimestamp;
        private long transmitTimestamp = -1L;
        private long destinationTimestamp = -1L;

        public SNTPResponse(SNTPRequest request) {
            this.originateTimestamp = request.originateTimestamp;
            this.receiveTimestamp = request.receiveTimestamp;
        }

        @Override
        public ByteBuffer wireFormat() {
            this.transmitTimestamp = Protocol.this.clock.currentTimeMillis();
            return this.wireFormat(this.originateTimestamp, this.receiveTimestamp, this.transmitTimestamp);
        }

        public SNTPResponse(ByteBuffer buffer) {
            this.originateTimestamp = LogUtils.readLong(buffer);
            this.receiveTimestamp = LogUtils.readLong(buffer);
            this.transmitTimestamp = LogUtils.readLong(buffer);
            this.destinationTimestamp = Protocol.this.clock.currentTimeMillis();
        }

        @Override
        public BinaryProtocol.MessageOp getOp() {
            return SNTP_RESPONSE;
        }

        public long getOriginateTimestamp() {
            return this.originateTimestamp;
        }

        public long getReceiveTimestamp() {
            return this.receiveTimestamp;
        }

        public long getTransmitTimestamp() {
            return this.transmitTimestamp;
        }

        public long getDestinationTimestamp() {
            return this.destinationTimestamp;
        }

        public long getDelay() {
            assert (this.destinationTimestamp != -1L);
            return this.destinationTimestamp - this.originateTimestamp - (this.transmitTimestamp - this.receiveTimestamp);
        }

        public long getDelta() {
            assert (this.destinationTimestamp != -1L);
            return (this.receiveTimestamp - this.originateTimestamp + (this.transmitTimestamp - this.destinationTimestamp)) / 2L;
        }
    }

    public class SNTPRequest
    extends BaseProtocol.HandshakeMessage {
        private final long originateTimestamp;
        private long receiveTimestamp = -1L;
        private boolean isLast = true;

        public SNTPRequest(boolean isLast) {
            this.isLast = isLast;
            this.originateTimestamp = Protocol.this.clock.currentTimeMillis();
        }

        @Override
        public ByteBuffer wireFormat() {
            return this.wireFormat(this.originateTimestamp, this.isLast);
        }

        public SNTPRequest(ByteBuffer buffer) {
            this.originateTimestamp = LogUtils.readLong(buffer);
            this.isLast = this.getBoolean(buffer);
            this.receiveTimestamp = Protocol.this.clock.currentTimeMillis();
        }

        @Override
        public BinaryProtocol.MessageOp getOp() {
            return SNTP_REQUEST;
        }

        public long getOriginateTimestamp() {
            return this.originateTimestamp;
        }

        public long getReceiveTimestamp() {
            return this.receiveTimestamp;
        }

        public boolean isLast() {
            return this.isLast;
        }
    }

    public class DuplicateNodeReject
    extends BinaryProtocol.RejectMessage {
        DuplicateNodeReject(String errorMessage) {
            super((BinaryProtocol)Protocol.this, errorMessage);
        }

        public DuplicateNodeReject(ByteBuffer buffer) {
            super((BinaryProtocol)Protocol.this, buffer);
        }

        @Override
        public BinaryProtocol.MessageOp getOp() {
            return DUP_NODE_REJECT;
        }
    }

    public class FeederProtocolVersion
    extends BaseProtocol.ProtocolVersion {
        public FeederProtocolVersion(int proposedVersion) {
            super(proposedVersion);
        }

        public FeederProtocolVersion(ByteBuffer buffer) {
            super(buffer);
        }

        @Override
        public BinaryProtocol.MessageOp getOp() {
            return FEEDER_PROTOCOL_VERSION;
        }
    }

    public class ReplicaProtocolVersion
    extends BaseProtocol.ProtocolVersion {
        public ReplicaProtocolVersion() {
            super(Protocol.this.configuredVersion);
        }

        public ReplicaProtocolVersion(ByteBuffer buffer) {
            super(buffer);
        }

        @Override
        public BinaryProtocol.MessageOp getOp() {
            return REPLICA_PROTOCOL_VERSION;
        }
    }
}

