/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point;

import java.io.IOException;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataDeep;
import ucar.ma2.StructureMembers;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.point.PointFeatureImpl;
import ucar.nc2.units.DateUnit;

public class PointFeatureCopyFactory {
    private static final int POINTER_SIZE = 8;
    private static final int OBJECT_SIZE = 40;
    private static final int ARRAY_SIZE = 8;
    private final StructureMembers sm;
    private final DateUnit du;
    private final int sizeInBytes;

    public PointFeatureCopyFactory(PointFeature proto, DateUnit du) throws IOException {
        StructureData sdata = proto.getData();
        this.du = du;
        this.sm = new StructureMembers(sdata.getStructureMembers());
        this.sizeInBytes = 364 + this.sm.getStructureSize();
    }

    public int getSizeInBytes() {
        return this.sizeInBytes;
    }

    public PointFeature deepCopy(PointFeature from) throws IOException {
        PointFeatureCopy deep = new PointFeatureCopy(from);
        deep.data = StructureDataDeep.copy(from.getData(), this.sm);
        return deep;
    }

    private class PointFeatureCopy
    extends PointFeatureImpl {
        StructureData data;

        PointFeatureCopy(PointFeature pf) {
            super(pf.getLocation(), pf.getObservationTime(), pf.getNominalTime(), PointFeatureCopyFactory.this.du);
        }

        @Override
        public StructureData getDataAll() throws IOException {
            return this.data;
        }

        @Override
        public StructureData getFeatureData() throws IOException {
            return this.data;
        }
    }
}

