/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.bufr;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import ucar.ma2.DataType;
import ucar.ma2.StructureData;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.ft.point.bufr.BufrCdmIndexProto;
import ucar.nc2.iosp.bufr.DataDescriptor;
import ucar.nc2.iosp.bufr.Message;
import ucar.nc2.time.CalendarDate;

public class StandardFields {
    private static int nflds = 50;
    private static Map<BufrCdmIndexProto.FldType, List<String>> type2Flds = new HashMap<BufrCdmIndexProto.FldType, List<String>>(2 * nflds);
    private static Map<String, TypeAndOrder> fld2type = new HashMap<String, TypeAndOrder>(2 * nflds);
    private static Map<Integer, Map<String, BufrCdmIndexProto.FldType>> locals = new HashMap<Integer, Map<String, BufrCdmIndexProto.FldType>>(10);

    private static void addField(String fld, BufrCdmIndexProto.FldType type) {
        List<String> list = type2Flds.get(type);
        if (list == null) {
            list = new ArrayList<String>();
            type2Flds.put(type, list);
        }
        list.add(fld);
        TypeAndOrder tao = new TypeAndOrder(type, list.size() - 1);
        fld2type.put(fld, tao);
    }

    private static TypeAndOrder findTao(int center, String key) {
        BufrCdmIndexProto.FldType result;
        Map<String, BufrCdmIndexProto.FldType> local = locals.get(center);
        if (local != null && (result = local.get(key)) != null) {
            return new TypeAndOrder(result, -1);
        }
        return fld2type.get(key);
    }

    public static BufrCdmIndexProto.FldType findField(int center, String key) {
        BufrCdmIndexProto.FldType result;
        Map<String, BufrCdmIndexProto.FldType> local = locals.get(center);
        if (local != null && (result = local.get(key)) != null) {
            return result;
        }
        return StandardFields.findStandardField(key);
    }

    public static BufrCdmIndexProto.FldType findStandardField(String key) {
        TypeAndOrder tao = fld2type.get(key);
        return tao == null ? null : tao.type;
    }

    public static StandardFieldsFromMessage extract(Message m3) throws IOException {
        StandardFieldsFromMessage result = new StandardFieldsFromMessage();
        StandardFields.extract(m3.ids.getCenterId(), m3.getRootDataDescriptor(), result);
        return result;
    }

    private static void extract(int center, DataDescriptor dds, StandardFieldsFromMessage extract) {
        for (DataDescriptor subdds : dds.getSubKeys()) {
            extract.match(center, subdds);
            if (subdds.getSubKeys() == null) continue;
            StandardFields.extract(center, subdds, extract);
        }
    }

    static {
        StandardFields.addField("0-1-1", BufrCdmIndexProto.FldType.wmoBlock);
        StandardFields.addField("0-1-2", BufrCdmIndexProto.FldType.wmoId);
        StandardFields.addField("0-1-18", BufrCdmIndexProto.FldType.stationId);
        StandardFields.addField("0-4-1", BufrCdmIndexProto.FldType.year);
        StandardFields.addField("0-4-2", BufrCdmIndexProto.FldType.month);
        StandardFields.addField("0-4-3", BufrCdmIndexProto.FldType.day);
        StandardFields.addField("0-4-4", BufrCdmIndexProto.FldType.hour);
        StandardFields.addField("0-4-5", BufrCdmIndexProto.FldType.minute);
        StandardFields.addField("0-4-6", BufrCdmIndexProto.FldType.sec);
        StandardFields.addField("0-5-1", BufrCdmIndexProto.FldType.lat);
        StandardFields.addField("0-6-1", BufrCdmIndexProto.FldType.lon);
        StandardFields.addField("0-7-30", BufrCdmIndexProto.FldType.heightOfStation);
        StandardFields.addField("0-1-15", BufrCdmIndexProto.FldType.stationId);
        StandardFields.addField("0-1-19", BufrCdmIndexProto.FldType.stationId);
        StandardFields.addField("0-4-7", BufrCdmIndexProto.FldType.sec);
        StandardFields.addField("0-4-43", BufrCdmIndexProto.FldType.doy);
        StandardFields.addField("0-5-2", BufrCdmIndexProto.FldType.lat);
        StandardFields.addField("0-6-2", BufrCdmIndexProto.FldType.lon);
        StandardFields.addField("0-7-1", BufrCdmIndexProto.FldType.heightOfStation);
        StandardFields.addField("0-1-62", BufrCdmIndexProto.FldType.stationId);
        StandardFields.addField("0-1-63", BufrCdmIndexProto.FldType.stationId);
        StandardFields.addField("0-7-2", BufrCdmIndexProto.FldType.height);
        StandardFields.addField("0-7-10", BufrCdmIndexProto.FldType.height);
        StandardFields.addField("0-7-7", BufrCdmIndexProto.FldType.height);
        StandardFields.addField("0-1-5", BufrCdmIndexProto.FldType.stationId);
        StandardFields.addField("0-1-6", BufrCdmIndexProto.FldType.stationId);
        StandardFields.addField("0-1-8", BufrCdmIndexProto.FldType.stationId);
        StandardFields.addField("0-1-10", BufrCdmIndexProto.FldType.stationId);
        StandardFields.addField("0-1-11", BufrCdmIndexProto.FldType.stationId);
        StandardFields.addField("0-7-6", BufrCdmIndexProto.FldType.heightAboveStation);
        StandardFields.addField("0-7-7", BufrCdmIndexProto.FldType.heightAboveStation);
        HashMap<String, BufrCdmIndexProto.FldType> uu = new HashMap<String, BufrCdmIndexProto.FldType>(10);
        uu.put("0-1-194", BufrCdmIndexProto.FldType.stationId);
        locals.put(59, uu);
    }

    public static class StandardFieldsFromStructure {
        private Map<BufrCdmIndexProto.FldType, Field> map = new HashMap<BufrCdmIndexProto.FldType, Field>();

        public StandardFieldsFromStructure(int center, Structure obs) {
            for (Variable v : obs.getVariables()) {
                Field fld;
                String key;
                TypeAndOrder tao;
                Attribute att = v.findAttribute("BUFR:TableB_descriptor");
                if (att == null || (tao = StandardFields.findTao(center, key = att.getStringValue())) == null) continue;
                Field oldFld = this.map.get(tao.type);
                if (oldFld == null) {
                    fld = new Field(tao, v);
                    this.map.put(tao.type, fld);
                    continue;
                }
                if (oldFld.tao.order >= tao.order) continue;
                fld = new Field(tao, v);
                this.map.put(tao.type, fld);
            }
        }

        public void extract(StructureData sdata) {
            StructureMembers sm = sdata.getStructureMembers();
            for (Field fld : this.map.values()) {
                StructureMembers.Member m3 = sm.findMember(fld.memberName);
                DataType dtype = m3.getDataType();
                if (dtype.isString()) {
                    fld.valueS = sdata.getScalarString(m3).trim();
                    continue;
                }
                if (dtype.isIntegral()) {
                    fld.value = sdata.convertScalarInt(m3);
                    fld.valueD = fld.value;
                    continue;
                }
                if (!dtype.isNumeric()) continue;
                fld.valueD = sdata.convertScalarDouble(m3);
            }
        }

        public boolean hasField(BufrCdmIndexProto.FldType type) {
            return null != this.map.get(type);
        }

        public String getFieldName(BufrCdmIndexProto.FldType type) {
            Field fld = this.map.get(type);
            return fld == null ? null : fld.memberName;
        }

        public String getFieldValueS(BufrCdmIndexProto.FldType type) {
            Field fld = this.map.get(type);
            if (fld == null) {
                return null;
            }
            if (fld.valueS != null) {
                return fld.valueS;
            }
            if (fld.value != -1) {
                return Integer.toString(fld.value);
            }
            if (!Double.isNaN(fld.valueD)) {
                return Double.toString(fld.valueD);
            }
            return null;
        }

        public int getFieldValue(BufrCdmIndexProto.FldType type) {
            Field fld = this.map.get(type);
            return fld == null ? -1 : fld.value;
        }

        public double getFieldValueD(BufrCdmIndexProto.FldType type) {
            Field fld = this.map.get(type);
            if (fld == null) {
                return Double.NaN;
            }
            if (fld.hasScale) {
                return fld.valueD * fld.scale + fld.offset;
            }
            return fld.valueD;
        }

        public String getStationId() {
            if (this.hasField(BufrCdmIndexProto.FldType.stationId)) {
                return this.getFieldValueS(BufrCdmIndexProto.FldType.stationId);
            }
            if (this.hasField(BufrCdmIndexProto.FldType.wmoBlock) && this.hasField(BufrCdmIndexProto.FldType.wmoId)) {
                return this.getFieldValue(BufrCdmIndexProto.FldType.wmoBlock) + "/" + this.getFieldValue(BufrCdmIndexProto.FldType.wmoId);
            }
            if (this.hasField(BufrCdmIndexProto.FldType.wmoId)) {
                return Integer.toString(this.getFieldValue(BufrCdmIndexProto.FldType.wmoId));
            }
            return null;
        }

        public CalendarDate makeCalendarDate() {
            int sec;
            if (!this.hasField(BufrCdmIndexProto.FldType.year)) {
                return null;
            }
            int year = this.getFieldValue(BufrCdmIndexProto.FldType.year);
            int hour = !this.hasField(BufrCdmIndexProto.FldType.hour) ? 0 : this.getFieldValue(BufrCdmIndexProto.FldType.hour);
            int minute = !this.hasField(BufrCdmIndexProto.FldType.minute) ? 0 : this.getFieldValue(BufrCdmIndexProto.FldType.minute);
            int n = sec = !this.hasField(BufrCdmIndexProto.FldType.sec) ? 0 : this.getFieldValue(BufrCdmIndexProto.FldType.sec);
            if (sec < 0) {
                sec = 0;
            } else if (sec > 0) {
                Field fld = this.map.get(BufrCdmIndexProto.FldType.sec);
                if (fld.scale != 0.0) {
                    sec = (int)((double)sec * fld.scale);
                }
                if (sec < 0 || sec > 59) {
                    sec = 0;
                }
            }
            if (this.hasField(BufrCdmIndexProto.FldType.month) && this.hasField(BufrCdmIndexProto.FldType.day)) {
                int month = this.getFieldValue(BufrCdmIndexProto.FldType.month);
                int day = this.getFieldValue(BufrCdmIndexProto.FldType.day);
                return CalendarDate.of(null, year, month, day, hour, minute, sec);
            }
            if (this.hasField(BufrCdmIndexProto.FldType.doy)) {
                int doy = this.getFieldValue(BufrCdmIndexProto.FldType.doy);
                return CalendarDate.withDoy(null, year, doy, hour, minute, sec);
            }
            return null;
        }

        private static class Field {
            TypeAndOrder tao;
            String memberName;
            String valueS;
            int value = -1;
            double valueD = Double.NaN;
            double scale = 1.0;
            double offset = 0.0;
            boolean hasScale;

            private Field(TypeAndOrder tao, Variable v) {
                this.tao = tao;
                this.memberName = v.getShortName();
                Attribute att = v.findAttribute("scale_factor");
                if (att != null && !att.isString()) {
                    this.scale = att.getNumericValue().doubleValue();
                    this.hasScale = true;
                }
                if ((att = v.findAttribute("add_offset")) != null && !att.isString()) {
                    this.offset = att.getNumericValue().doubleValue();
                    this.hasScale = true;
                }
            }
        }
    }

    public static class StandardFieldsFromMessage {
        Map<BufrCdmIndexProto.FldType, List<DataDescriptor>> typeMap = new TreeMap<BufrCdmIndexProto.FldType, List<DataDescriptor>>();

        void match(int center, DataDescriptor dds) {
            String name = dds.getFxyName();
            BufrCdmIndexProto.FldType type = StandardFields.findField(center, name);
            if (type == null) {
                return;
            }
            List<DataDescriptor> list = this.typeMap.get(type);
            if (list == null) {
                list = new ArrayList<DataDescriptor>(3);
                this.typeMap.put(type, list);
            }
            list.add(dds);
        }

        public boolean hasStation() {
            if (this.typeMap.get(BufrCdmIndexProto.FldType.lat) == null) {
                return false;
            }
            if (this.typeMap.get(BufrCdmIndexProto.FldType.lon) == null) {
                return false;
            }
            if (this.typeMap.get(BufrCdmIndexProto.FldType.stationId) != null) {
                return true;
            }
            return this.typeMap.get(BufrCdmIndexProto.FldType.wmoId) != null;
        }

        public boolean hasTime() {
            if (this.typeMap.get(BufrCdmIndexProto.FldType.year) == null) {
                return false;
            }
            if (this.typeMap.get(BufrCdmIndexProto.FldType.month) == null) {
                return false;
            }
            return this.typeMap.get(BufrCdmIndexProto.FldType.day) != null || this.typeMap.get(BufrCdmIndexProto.FldType.doy) != null;
        }

        public String toString() {
            Formatter f = new Formatter();
            for (BufrCdmIndexProto.FldType type : this.typeMap.keySet()) {
                f.format(" %20s: ", type);
                List<DataDescriptor> list = this.typeMap.get(type);
                for (DataDescriptor dds : list) {
                    f.format(" %s", dds.getName());
                    if (dds.getDesc() != null) {
                        f.format("=%s", dds.getDesc());
                    }
                    f.format(",", new Object[0]);
                }
                f.format(" %n", new Object[0]);
            }
            return f.toString();
        }
    }

    private static class TypeAndOrder {
        BufrCdmIndexProto.FldType type;
        int order;

        private TypeAndOrder(BufrCdmIndexProto.FldType type, int order) {
            this.type = type;
            this.order = order;
        }
    }
}

