/*
 * Decompiled with CFR 0.152.
 */
package visad.bom;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import visad.DataReferenceImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Linear1DSet;
import visad.MathType;
import visad.RealType;
import visad.VisADException;
import visad.bom.FlexibleTrackManipulation;

class EndManipFTM
implements ActionListener {
    FlexibleTrackManipulation ftm;
    DataReferenceImpl track_ref;

    EndManipFTM(FlexibleTrackManipulation f, DataReferenceImpl tr) {
        this.ftm = f;
        this.track_ref = tr;
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("end")) {
            try {
                this.ftm.endManipulation();
            }
            catch (VisADException ex) {
            }
            catch (RemoteException ex) {}
        } else if (cmd.equals("add")) {
            try {
                FlatField ff = (FlatField)this.track_ref.getData();
                int ntimes = ff.getLength();
                Linear1DSet time_set = (Linear1DSet)ff.getDomainSet();
                Linear1DSet new_time_set = new Linear1DSet((MathType)RealType.Time, time_set.getFirst(), time_set.getLast() + time_set.getStep(), ntimes + 1);
                double[][] values = ff.getValues();
                double[][] new_values = new double[3][ntimes + 1];
                System.arraycopy(values[0], 0, new_values[0], 0, ntimes);
                System.arraycopy(values[1], 0, new_values[1], 0, ntimes);
                System.arraycopy(values[2], 0, new_values[2], 0, ntimes);
                int k = ntimes;
                new_values[0][k] = 2.0 * (double)k - 8.0;
                new_values[1][k] = 2.0 * (double)k - 8.0;
                int s2 = k % 8;
                if (4 <= s2 && s2 < 6) {
                    if (new_values[1][k] >= 0.0) {
                        s2 += 2;
                    }
                } else if (6 <= s2 && s2 < 8 && new_values[1][k] < 0.0) {
                    s2 -= 2;
                }
                new_values[2][k] = s2;
                FlatField new_ff = new FlatField((FunctionType)ff.getType(), new_time_set);
                new_ff.setSamples(new_values);
                this.track_ref.setData(new_ff);
            }
            catch (VisADException ex) {
                ex.printStackTrace();
            }
            catch (RemoteException ex) {
                ex.printStackTrace();
            }
        }
    }
}

