/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import com.sleepycat.je.utilint.LongAvgRate;
import com.sleepycat.je.utilint.Stat;
import com.sleepycat.je.utilint.StatDefinition;
import com.sleepycat.je.utilint.StatGroup;
import com.sleepycat.je.utilint.StatWithValueType;
import java.util.concurrent.TimeUnit;

public class LongAvgRateStat
extends StatWithValueType<Long> {
    private static final long serialVersionUID = 1L;
    private final LongAvgRate avg;

    public LongAvgRateStat(StatGroup group, StatDefinition definition, long periodMillis, TimeUnit reportTimeUnit) {
        super(group, definition);
        assert (definition.getType() == StatDefinition.StatType.INCREMENTAL);
        this.avg = new LongAvgRate(definition.getName(), periodMillis, reportTimeUnit);
    }

    private LongAvgRateStat(StatDefinition definition, LongAvgRate avg) {
        super(definition);
        this.avg = avg;
    }

    public void add(long value, long time) {
        this.avg.add(value, time);
    }

    @Override
    public Class<Long> getValueType() {
        return Long.class;
    }

    @Override
    public Long get() {
        return this.avg.get();
    }

    @Override
    public void clear() {
        this.avg.clear();
    }

    @Override
    public LongAvgRateStat copy() {
        return new LongAvgRateStat(this.definition, this.avg.copy());
    }

    @Override
    protected String getFormattedValue() {
        return this.avg.getFormattedValue();
    }

    @Override
    public boolean isNotSet() {
        return this.avg.isNotSet();
    }

    @Override
    public void set(Long newValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(Stat<Long> other) {
        throw new UnsupportedOperationException();
    }

    public LongAvgRateStat computeInterval(Stat<Long> base) {
        assert (base instanceof LongAvgRateStat);
        LongAvgRate baseAvg = ((LongAvgRateStat)base).avg;
        return new LongAvgRateStat(this.definition, this.avg.copyLatest(baseAvg));
    }

    @Override
    public void negate() {
    }
}

