/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.compat.DbCompat;
import com.sleepycat.persist.impl.AbstractInput;
import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.RefreshException;
import com.sleepycat.persist.impl.SimpleCatalog;
import com.sleepycat.persist.raw.RawObject;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.IdentityHashMap;

abstract class RawAbstractInput
extends AbstractInput {
    private IdentityHashMap converted;

    RawAbstractInput(Catalog catalog, boolean rawAccess, IdentityHashMap converted) {
        super(catalog, rawAccess);
        this.converted = converted;
    }

    @Override
    public Object readObject() throws RefreshException {
        return this.readNext();
    }

    @Override
    public Object readKeyObject(Format format) throws RefreshException {
        return this.readNext();
    }

    @Override
    public Object readStringObject() throws RefreshException {
        return this.readNext();
    }

    @Override
    public void registerPriKeyObject(Object o) {
    }

    @Override
    public void registerPriStringKeyObject(Object o) {
    }

    @Override
    public int readArrayLength() {
        throw DbCompat.unexpectedState();
    }

    @Override
    public int readEnumConstant(String[] names) {
        throw DbCompat.unexpectedState();
    }

    @Override
    public void skipField(Format declaredFormat) {
    }

    abstract Object readNext() throws RefreshException;

    Object checkAndConvert(Object o, Format declaredFormat) throws RefreshException {
        if (o == null) {
            if (declaredFormat.isPrimitive()) {
                throw new IllegalArgumentException("A primitive type may not be null or missing: " + declaredFormat.getClassName());
            }
        } else if (declaredFormat.isSimple()) {
            if (declaredFormat.isPrimitive()) {
                if (o.getClass() != declaredFormat.getWrapperFormat().getType()) {
                    throw new IllegalArgumentException("Raw value class: " + o.getClass().getName() + " must be the wrapper class for a primitive type: " + declaredFormat.getClassName());
                }
            } else if (o.getClass() != declaredFormat.getType()) {
                throw new IllegalArgumentException("Raw value class: " + o.getClass().getName() + " must be the declared class for a simple type: " + declaredFormat.getClassName());
            }
        } else {
            if (o instanceof RawObject) {
                Object o2 = null;
                if (!this.rawAccess) {
                    if (this.converted != null) {
                        o2 = this.converted.get(o);
                    } else {
                        this.converted = new IdentityHashMap();
                    }
                }
                if (o2 != null) {
                    o = o2;
                } else if (!this.rawAccess) {
                    o = this.catalog.convertRawObject((RawObject)o, this.converted);
                }
            } else if (!SimpleCatalog.isSimpleType(o.getClass())) {
                throw new IllegalArgumentException("Raw value class: " + o.getClass().getName() + " must be RawObject a simple type");
            }
            if (this.rawAccess) {
                RawAbstractInput.checkRawType(this.catalog, o, declaredFormat);
            } else if (!declaredFormat.getType().isAssignableFrom(o.getClass())) {
                throw new IllegalArgumentException("Raw value class: " + o.getClass().getName() + " is not assignable to type: " + declaredFormat.getClassName());
            }
        }
        return o;
    }

    static Format checkRawType(Catalog catalog, Object o, Format declaredFormat) throws RefreshException {
        Format format;
        assert (declaredFormat != null);
        if (o instanceof RawObject) {
            format = (Format)((RawObject)o).getType();
            format = catalog.getFormat(format.getId(), false);
        } else {
            format = catalog.getFormat(o.getClass(), false);
            if (!format.isSimple() || format.isEnum()) {
                throw new IllegalArgumentException("Not a RawObject or a non-enum simple type: " + format.getClassName());
            }
        }
        if (!format.isAssignableTo(declaredFormat)) {
            throw new IllegalArgumentException("Not a subtype of the field's declared class " + declaredFormat.getClassName() + ": " + format.getClassName());
        }
        if (!format.isCurrentVersion()) {
            throw new IllegalArgumentException("Raw type version is not current.  Class: " + format.getClassName() + " Version: " + format.getVersion());
        }
        Format proxiedFormat = format.getProxiedFormat();
        if (proxiedFormat != null) {
            format = proxiedFormat;
        }
        return format;
    }

    @Override
    public String readString() throws RefreshException {
        return (String)this.readNext();
    }

    @Override
    public char readChar() throws RefreshException {
        return ((Character)this.readNext()).charValue();
    }

    @Override
    public boolean readBoolean() throws RefreshException {
        return (Boolean)this.readNext();
    }

    @Override
    public byte readByte() throws RefreshException {
        return (Byte)this.readNext();
    }

    @Override
    public short readShort() throws RefreshException {
        return (Short)this.readNext();
    }

    @Override
    public int readInt() throws RefreshException {
        return (Integer)this.readNext();
    }

    @Override
    public long readLong() throws RefreshException {
        return (Long)this.readNext();
    }

    @Override
    public float readSortedFloat() throws RefreshException {
        return ((Float)this.readNext()).floatValue();
    }

    @Override
    public double readSortedDouble() throws RefreshException {
        return (Double)this.readNext();
    }

    @Override
    public BigDecimal readSortedBigDecimal() throws RefreshException {
        return (BigDecimal)this.readNext();
    }

    @Override
    public BigInteger readBigInteger() throws RefreshException {
        return (BigInteger)this.readNext();
    }
}

