/*
 * Decompiled with CFR 0.152.
 */
package ucar.ma2;

import ucar.ma2.Array;
import ucar.ma2.ArrayByte;
import ucar.ma2.ArrayChar;
import ucar.ma2.ArrayDouble;
import ucar.ma2.ArrayFloat;
import ucar.ma2.ArrayInt;
import ucar.ma2.ArrayLong;
import ucar.ma2.ArrayShort;
import ucar.ma2.DataType;
import ucar.ma2.StructureDataW;
import ucar.ma2.StructureMembers;

public class StructureDataScalar
extends StructureDataW {
    public StructureDataScalar(String name) {
        super(new StructureMembers(name));
    }

    public void addMember(String name, String desc, String units, DataType dtype, boolean isUnsigned, Number val) {
        StructureMembers.Member m3 = this.members.addMember(name, desc, units, dtype, new int[0]);
        Array data = null;
        switch (dtype) {
            case BYTE: {
                data = new ArrayByte.D0();
                data.setByte(0, val.byteValue());
                break;
            }
            case SHORT: {
                data = new ArrayShort.D0();
                data.setShort(0, val.shortValue());
                break;
            }
            case INT: {
                data = new ArrayInt.D0();
                data.setInt(0, val.intValue());
                break;
            }
            case LONG: {
                data = new ArrayLong.D0();
                data.setDouble(0, (double)val.longValue());
                break;
            }
            case FLOAT: {
                data = new ArrayFloat.D0();
                data.setFloat(0, val.floatValue());
                break;
            }
            case DOUBLE: {
                data = new ArrayDouble.D0();
                data.setDouble(0, val.doubleValue());
            }
        }
        this.setMemberData(m3, data);
    }

    public void addMemberString(String name, String desc, String units, String val, int max_len) {
        StructureMembers.Member m3 = this.members.addMember(name, desc, units, DataType.CHAR, new int[]{max_len});
        ArrayChar data = ArrayChar.makeFromString(val, max_len);
        this.setMemberData(m3, (Array)data);
    }
}

