/*
 * Decompiled with CFR 0.152.
 */
package ucar.multiarray;

import java.io.IOException;
import java.lang.reflect.Array;
import ucar.multiarray.ConcreteIndexMap;
import ucar.multiarray.MultiArrayImpl;
import ucar.multiarray.MultiArrayProxy;

public class FlipMap
extends ConcreteIndexMap {
    private int position_;

    public FlipMap(int position) {
        this.init(new IMap());
        this.position_ = position;
    }

    public FlipMap(ConcreteIndexMap prev, int position) {
        this.link(prev, new IMap());
        this.position_ = position;
    }

    public static void main(String[] args) {
        int[] shape = new int[]{48, 64};
        MultiArrayImpl delegate = new MultiArrayImpl(Integer.TYPE, shape);
        int size = MultiArrayImpl.numberOfElements(shape);
        for (int ii = 0; ii < size; ++ii) {
            Array.setInt(delegate.storage, ii, ii);
        }
        FlipMap im = new FlipMap(1);
        MultiArrayProxy ma = new MultiArrayProxy(delegate, im);
        try {
            System.out.println("Rank  " + ma.getRank());
            int[] lengths = ma.getLengths();
            System.out.println("Shape { " + lengths[0] + " " + lengths[1] + " }");
            System.out.println(ma.getInt(new int[]{0, 0}));
        }
        catch (IOException ee) {
            // empty catch block
        }
    }

    private class IMap
    extends ConcreteIndexMap.ZZMap {
        private IMap() {
        }

        public synchronized int get(int key) {
            int value = super.get(key);
            if (key == FlipMap.this.position_) {
                return FlipMap.this.lengthsMap_.get(key) - 1 - value;
            }
            return value;
        }
    }
}

