/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2;

import ucar.nc2.grib.grib2.Grib2Gds;
import ucar.nc2.grib.grib2.Grib2Pds;
import ucar.nc2.grib.grib2.Grib2Record;
import ucar.nc2.grib.grib2.Grib2Utils;
import ucar.nc2.grib.grib2.table.Grib2Customizer;

public class Grib2Variable {
    private final Grib2Customizer cust;
    private final int discipline;
    private final int center;
    private final int subcenter;
    private final int gdsHash;
    private final Grib2Gds gds;
    private final Grib2Pds pds;
    private final boolean intvMerge;
    private final boolean useGenType;

    public static int cdmVariableHash(Grib2Customizer cust, Grib2Record gr, int gdsHashOverride, boolean intvMerge, boolean useGenType) {
        Grib2Variable gv = new Grib2Variable(cust, gr, gdsHashOverride, intvMerge, useGenType);
        return gv.hashCode();
    }

    public Grib2Variable(Grib2Customizer cust, Grib2Record gr, int gdsHashOverride, boolean intvMerge, boolean useGenType) {
        this.cust = cust;
        this.discipline = gr.getDiscipline();
        this.center = gr.getId().getCenter_id();
        this.subcenter = gr.getId().getSubcenter_id();
        this.gds = gr.getGDS();
        this.gdsHash = gdsHashOverride != 0 ? gdsHashOverride : gr.getGDS().hashCode();
        this.pds = gr.getPDS();
        this.intvMerge = intvMerge;
        this.useGenType = useGenType;
    }

    public Grib2Variable(Grib2Customizer cust, int discipline, int center, int subcenter, Grib2Gds gds, Grib2Pds pds, boolean intvMerge, boolean useGenType) {
        this.cust = cust;
        this.discipline = discipline;
        this.center = center;
        this.subcenter = subcenter;
        this.gds = gds;
        this.gdsHash = gds.hashCode;
        this.pds = pds;
        this.intvMerge = intvMerge;
        this.useGenType = useGenType;
    }

    public boolean equals(Object o) {
        double size2;
        double size;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Grib2Variable var2 = (Grib2Variable)o;
        if (this.gdsHash != var2.gdsHash) {
            return false;
        }
        if (!this.gds.equals(var2.gds)) {
            return false;
        }
        Grib2Pds pds2 = var2.pds;
        if (this.pds.getParameterNumber() != pds2.getParameterNumber()) {
            return false;
        }
        if (this.pds.getParameterCategory() != pds2.getParameterCategory()) {
            return false;
        }
        if (this.pds.getTemplateNumber() != pds2.getTemplateNumber()) {
            return false;
        }
        if (this.discipline != var2.discipline) {
            return false;
        }
        if (Grib2Utils.isLayer(this.pds) != Grib2Utils.isLayer(pds2)) {
            return false;
        }
        if (this.pds.getLevelType1() != pds2.getLevelType1()) {
            return false;
        }
        if (this.pds.isTimeInterval() != pds2.isTimeInterval()) {
            return false;
        }
        if (this.pds.isTimeInterval() && !this.intvMerge && (size = this.cust.getForecastTimeIntervalSizeInHours(this.pds)) != (size2 = this.cust.getForecastTimeIntervalSizeInHours(pds2))) {
            return false;
        }
        if (this.pds.isSpatialInterval() != pds2.isSpatialInterval()) {
            return false;
        }
        if (this.pds.isSpatialInterval() && this.pds.getStatisticalProcessType() != pds2.getStatisticalProcessType()) {
            return false;
        }
        int ensDerivedType = -1;
        if (this.pds.isEnsembleDerived() != pds2.isEnsembleDerived()) {
            return false;
        }
        if (this.pds.isEnsembleDerived()) {
            Grib2Pds.PdsEnsembleDerived pdsDerived = (Grib2Pds.PdsEnsembleDerived)((Object)this.pds);
            Grib2Pds.PdsEnsembleDerived pdsDerived2 = (Grib2Pds.PdsEnsembleDerived)((Object)pds2);
            if (pdsDerived.getDerivedForecastType() != pdsDerived2.getDerivedForecastType()) {
                return false;
            }
            ensDerivedType = pdsDerived.getDerivedForecastType();
        } else if (this.pds.isEnsemble() != pds2.isEnsemble()) {
            return false;
        }
        int probType = -1;
        if (this.pds.isProbability() != pds2.isProbability()) {
            return false;
        }
        if (this.pds.isProbability()) {
            Grib2Pds.PdsProbability pdsProb = (Grib2Pds.PdsProbability)((Object)this.pds);
            Grib2Pds.PdsProbability pdsProb2 = (Grib2Pds.PdsProbability)((Object)pds2);
            if (pdsProb.getProbabilityHashcode() != pdsProb2.getProbabilityHashcode()) {
                return false;
            }
            probType = pdsProb.getProbabilityType();
        }
        if (pds2.getParameterCategory() > 191 || pds2.getParameterNumber() > 191 || pds2.getLevelType1() > 191 || pds2.isTimeInterval() && pds2.getStatisticalProcessType() > 191 || ensDerivedType > 191 || probType > 191) {
            if (this.center != var2.center) {
                return false;
            }
            if (this.subcenter != var2.subcenter) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int genType;
        int result = 17;
        result += result * 31 + this.discipline;
        result += result * 31 + this.pds.getLevelType1();
        if (Grib2Utils.isLayer(this.pds)) {
            result += result * 31 + 1;
        }
        result += result * 31 + this.gdsHash;
        result += result * 31 + this.pds.getParameterCategory();
        result += result * 31 + this.pds.getTemplateNumber();
        if (this.pds.isTimeInterval() && !this.intvMerge) {
            double size = this.cust.getForecastTimeIntervalSizeInHours(this.pds);
            result += result * (int)(31.0 + 1000.0 * size);
        }
        if (this.pds.isSpatialInterval()) {
            result += result * 31 + this.pds.getStatisticalProcessType();
        }
        result += result * 31 + this.pds.getParameterNumber();
        int ensDerivedType = -1;
        if (this.pds.isEnsembleDerived()) {
            Grib2Pds.PdsEnsembleDerived pdsDerived = (Grib2Pds.PdsEnsembleDerived)((Object)this.pds);
            ensDerivedType = pdsDerived.getDerivedForecastType();
            result += result * 31 + ensDerivedType;
        } else if (this.pds.isEnsemble()) {
            result += result * 31 + 1;
        }
        int probType = -1;
        if (this.pds.isProbability()) {
            Grib2Pds.PdsProbability pdsProb = (Grib2Pds.PdsProbability)((Object)this.pds);
            probType = pdsProb.getProbabilityType();
            result += result * 31 + pdsProb.getProbabilityHashcode();
        }
        if (this.pds.getParameterCategory() > 191 || this.pds.getParameterNumber() > 191 || this.pds.getLevelType1() > 191 || this.pds.isTimeInterval() && this.pds.getStatisticalProcessType() > 191 || ensDerivedType > 191 || probType > 191) {
            result += result * 31 + this.center;
            if (this.subcenter > 0) {
                result += result * 31 + this.subcenter;
            }
        }
        if ((genType = this.pds.getGenProcessType()) == 6 || genType == 7 || this.useGenType && genType > 0) {
            result += result * 31 + genType;
        }
        return result;
    }
}

