/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.units;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.units.TimeUnit;
import ucar.units.ConversionException;

public class TimeDuration {
    private static final Logger log = LoggerFactory.getLogger(TimeDuration.class);
    private String text;
    private TimeUnit timeUnit;
    private boolean isBlank;
    private static boolean debug = false;

    private TimeDuration() {
    }

    public TimeDuration(TimeDuration src) {
        this.text = src.getText();
        this.timeUnit = new TimeUnit(src.getTimeUnit());
        this.isBlank = src.isBlank();
    }

    public TimeDuration(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
        this.text = timeUnit.toString();
    }

    public TimeDuration(String text) throws ParseException {
        this.text = text = text == null ? "" : text.trim();
        if (text.length() == 0) {
            this.isBlank = true;
            try {
                this.timeUnit = new TimeUnit("1 sec");
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        try {
            this.timeUnit = new TimeUnit(text);
            if (debug) {
                System.out.println(" set time unit= " + this.timeUnit);
            }
        }
        catch (Exception e) {
            try {
                DatatypeFactory factory = DatatypeFactory.newInstance();
                Duration d = factory.newDuration(text);
                Calendar c = Calendar.getInstance();
                c.set(1900, 0, 1, 0, 0, 0);
                long secs = d.getTimeInMillis(c.getTime()) / 1000L;
                this.timeUnit = new TimeUnit(secs + " secs");
            }
            catch (Exception e1) {
                throw new ParseException(e.getMessage(), 0);
            }
        }
    }

    public static TimeDuration parseW3CDuration(String text) throws ParseException {
        TimeDuration td = new TimeDuration();
        td.text = text = text == null ? "" : text.trim();
        try {
            DatatypeFactory factory = DatatypeFactory.newInstance();
            Duration d = factory.newDuration(text);
            Calendar c = Calendar.getInstance();
            c.set(1900, 0, 1, 0, 0, 0);
            long secs = d.getTimeInMillis(c.getTime()) / 1000L;
            td.timeUnit = new TimeUnit(secs + " secs");
        }
        catch (Exception e) {
            throw new ParseException(e.getMessage(), 0);
        }
        return td;
    }

    public double getValue() {
        return this.timeUnit.getValue();
    }

    public double getValue(TimeUnit want) throws ConversionException {
        return this.timeUnit.convertTo(this.timeUnit.getValue(), want);
    }

    public double getValue(String unit) {
        try {
            TimeUnit tdayUnit = new TimeUnit(unit);
            return this.getValue(tdayUnit);
        }
        catch (Exception e) {
            log.error("Illegal time unit =", (Object)unit, (Object)e);
            return -1.0;
        }
    }

    public double getValueInSeconds() {
        return this.timeUnit.getValueInSeconds();
    }

    public void setValueInSeconds(double secs) {
        this.timeUnit.setValueInSeconds(secs);
        this.text = null;
    }

    public boolean isBlank() {
        return this.isBlank;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public String getText() {
        return this.text == null ? this.timeUnit.toString() : this.text;
    }

    public String toString() {
        return this.getText();
    }

    public int hashCode() {
        return this.isBlank() ? 0 : (int)this.getValueInSeconds();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TimeDuration)) {
            return false;
        }
        TimeDuration to = (TimeDuration)o;
        return to.getValueInSeconds() == this.getValueInSeconds();
    }

    public Date add(Date d) {
        return this.timeUnit.add(d);
    }

    private static void doDuration(String s2) {
        try {
            System.out.println("start = (" + s2 + ")");
            TimeDuration d = new TimeDuration(s2);
            System.out.println("duration = (" + d.toString() + ")");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public static void main2(String[] args) {
        TimeDuration.doDuration("3 days");
    }

    public static void main(String[] arg) throws Exception {
        DatatypeFactory factory = DatatypeFactory.newInstance();
        Duration d = factory.newDuration("P3D");
        long secs1 = d.getTimeInMillis(new Date()) / 1000L;
        Calendar c = Calendar.getInstance();
        c.set(1970, 0, 1, 0, 0, 0);
        long secs2 = d.getTimeInMillis(c.getTime()) / 1000L;
        System.out.printf("%d %d same = %s%n", secs1, secs2, secs1 == secs2);
    }
}

