/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;
import visad.AnimationControl;
import visad.AxisScale;
import visad.ConstantMap;
import visad.ContourControl;
import visad.Control;
import visad.DataDisplayLink;
import visad.DataRenderer;
import visad.DataShadow;
import visad.Display;
import visad.DisplayException;
import visad.DisplayImpl;
import visad.DisplayRealType;
import visad.DisplayRenderer;
import visad.DisplayTupleType;
import visad.ProjectionControl;
import visad.RealType;
import visad.ScalarMapControlEvent;
import visad.ScalarMapEvent;
import visad.ScalarMapListener;
import visad.ScalarType;
import visad.Set;
import visad.Unit;
import visad.UnitException;
import visad.VisADException;

public class ScalarMap
implements Cloneable,
Serializable,
Comparable {
    private Unit overrideUnit = null;
    private double override_scale;
    private double override_offset;
    private ScalarType Scalar;
    private DisplayRealType DisplayScalar;
    private int ScalarIndex;
    private int DisplayScalarIndex;
    int ValueIndex;
    private transient Control control;
    private transient DisplayImpl display;
    private boolean isManual;
    boolean isScaled;
    double[] displayRange = new double[2];
    private double[] dataRange = new double[2];
    private double[] defaultUnitRange = new double[2];
    private double scale;
    private double offset;
    private long NewTick;
    private long OldTick;
    private boolean tickFlag;
    private String scalarName = null;
    private boolean scale_flag = false;
    private boolean back_scale_flag = false;
    private boolean scale_on = true;
    private boolean underscore_to_blank = false;
    private transient Vector ListenerVector = new Vector();
    private AxisScale axisScale = null;
    private static final double SCALE = 0.06;
    private static final double OFFSET = 1.05;

    public ScalarMap(ScalarType scalar, DisplayRealType display_scalar) throws VisADException {
        this(scalar, display_scalar, true);
    }

    ScalarMap(ScalarType scalar, DisplayRealType display_scalar, boolean needNonNullScalar) throws VisADException {
        if (scalar == null && needNonNullScalar) {
            throw new DisplayException("ScalarMap: scalar is null");
        }
        if (display_scalar == null) {
            throw new DisplayException("ScalarMap: display_scalar is null");
        }
        if (display_scalar.equals(Display.List)) {
            throw new DisplayException("ScalarMap: display_scalar may not be List");
        }
        boolean text = display_scalar.getText();
        if (scalar != null && !text && !(scalar instanceof RealType)) {
            throw new DisplayException("ScalarMap: TextType scalar cannot be used with RealType display_scalar");
        }
        this.control = null;
        this.Scalar = scalar;
        this.DisplayScalar = display_scalar;
        this.display = null;
        this.ScalarIndex = -1;
        this.DisplayScalarIndex = -1;
        this.isScaled = this.DisplayScalar.getRange(this.displayRange);
        this.isManual = false;
        this.dataRange[0] = Double.NaN;
        this.dataRange[1] = Double.NaN;
        this.defaultUnitRange[0] = this.dataRange[0];
        this.defaultUnitRange[1] = this.dataRange[1];
        this.OldTick = Long.MIN_VALUE;
        this.NewTick = -9223372036854775807L;
        this.tickFlag = false;
        if (this.Scalar != null) {
            this.scalarName = this.Scalar.getName();
        }
        if (this.DisplayScalar.equals(Display.XAxis) || this.DisplayScalar.equals(Display.YAxis) || this.DisplayScalar.equals(Display.ZAxis)) {
            this.axisScale = new AxisScale(this);
        }
    }

    public void resetAutoScale() {
        this.isManual = false;
    }

    public void disableAutoScale() {
        this.isManual = true;
    }

    public boolean isAutoScale() {
        return !this.isManual;
    }

    public boolean doInitialize() {
        if (this.DisplayScalar.equals(Display.IsoContour)) {
            if (this.control != null) {
                float[] lowhibase = new float[3];
                boolean[] dashes = new boolean[1];
                float[] levs = ((ContourControl)this.control).getLevels(lowhibase, dashes);
                return levs == null;
            }
            return false;
        }
        return this.isScaled && !this.isManual;
    }

    public void setOverrideUnit(Unit unit) throws VisADException {
        if (!(this.Scalar instanceof RealType)) {
            throw new UnitException("Scalar is not RealType");
        }
        Unit rtunit = ((RealType)this.Scalar).getDefaultUnit();
        if (!Unit.canConvert(unit, rtunit)) {
            throw new UnitException("unit not convertable with RealType default");
        }
        if (unit != null) {
            this.overrideUnit = unit;
            this.override_offset = this.overrideUnit.toThis(0.0, rtunit);
            this.override_scale = this.overrideUnit.toThis(1.0, rtunit) - this.override_offset;
        }
    }

    public Unit getOverrideUnit() {
        return this.overrideUnit;
    }

    public String getScalarName() {
        return this.scalarName;
    }

    public void setScalarName(String name) {
        this.scalarName = name;
        if (this.axisScale != null) {
            this.axisScale.setTitle(this.scalarName);
        }
    }

    public long incTick() {
        ++this.NewTick;
        if (this.NewTick == Long.MAX_VALUE) {
            this.NewTick = -9223372036854775807L;
        }
        if (this.display != null) {
            this.display.controlChanged();
        }
        return this.NewTick;
    }

    public synchronized void setTicks() {
        this.tickFlag = this.OldTick < this.NewTick || this.NewTick < 0L && 0L < this.OldTick;
        this.OldTick = this.NewTick;
        if (this.control != null) {
            this.control.setTicks();
        }
    }

    public synchronized boolean peekTicks(DataRenderer r, DataDisplayLink link) {
        if (this.control == null) {
            return this.OldTick < this.NewTick || this.NewTick < 0L && 0L < this.OldTick;
        }
        return this.OldTick < this.NewTick || this.NewTick < 0L && 0L < this.OldTick || this.control.peekTicks(r, link);
    }

    public synchronized boolean checkTicks(DataRenderer r, DataDisplayLink link) {
        if (this.control == null) {
            return this.tickFlag;
        }
        return this.tickFlag || this.control.checkTicks(r, link);
    }

    synchronized void resetTicks() {
        this.tickFlag = false;
        if (this.control != null) {
            this.control.resetTicks();
        }
    }

    public ScalarType getScalar() {
        return this.Scalar;
    }

    public DisplayRealType getDisplayScalar() {
        return this.DisplayScalar;
    }

    public DisplayImpl getDisplay() {
        return this.display;
    }

    synchronized void nullDisplay() throws RemoteException, VisADException {
        if (this.control != null) {
            this.control.nullControl();
            ScalarMapControlEvent evt = new ScalarMapControlEvent(this, 4, this.control);
            this.notifyCtlListeners(evt);
        }
        this.control = null;
        this.display = null;
        this.ScalarIndex = -1;
        this.DisplayScalarIndex = -1;
        this.scale_flag = this.back_scale_flag;
        if (this.axisScale != null) {
            this.axisScale.setAxisOrdinal(-1);
        }
    }

    synchronized void setDisplay(DisplayImpl d) throws VisADException {
        if (d.equals(this.display)) {
            return;
        }
        if (this.display != null) {
            throw new DisplayException("ScalarMap.setDisplay: ScalarMap cannot belong to two Displays");
        }
        this.display = d;
        if (this.scale_flag) {
            this.makeScale();
        }
        if (!(this instanceof ConstantMap)) {
            ProjectionControl pcontrol = this.display.getProjectionControl();
            try {
                this.setAspectCartesian(pcontrol.getAspectCartesian());
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    public Control getControl() {
        return this.control;
    }

    synchronized void setControl() throws VisADException, RemoteException {
        Control evtCtl;
        int evtID;
        if (this.control != null) {
            evtID = 5;
            evtCtl = this.control;
        } else {
            evtID = 3;
            evtCtl = null;
        }
        if (this.display == null) {
            throw new DisplayException("ScalarMap.setControl: not part of any Display");
        }
        this.control = this.display.getDisplayRenderer().makeControl(this);
        if (this.control != null) {
            this.display.addControl(this.control);
            if (evtCtl == null) {
                evtCtl = this.control;
            }
        }
        if (this.control != null || evtCtl != null) {
            this.notifyCtlListeners(new ScalarMapControlEvent(this, evtID, evtCtl));
        }
    }

    public boolean getScale(double[] so, double[] data, double[] display) {
        if (this.overrideUnit != null) {
            so[0] = this.scale * this.override_scale;
            so[1] = this.scale * this.override_offset + this.offset;
        } else {
            so[0] = this.scale;
            so[1] = this.offset;
        }
        data[0] = this.dataRange[0];
        data[1] = this.dataRange[1];
        display[0] = this.displayRange[0];
        display[1] = this.displayRange[1];
        return this.isScaled;
    }

    public double[] getRange() {
        double[] range = new double[]{this.dataRange[0], this.dataRange[1]};
        return range;
    }

    public void setRangeByUnits() throws VisADException, RemoteException {
        this.isManual = true;
        this.setRange(null, 0.0, 0.0, true);
        if (this.scale == this.scale && this.offset == this.offset) {
            this.incTick();
        } else {
            this.isManual = false;
        }
    }

    public void setRange(double low, double hi) throws VisADException, RemoteException {
        this.setRange(low, hi, 0);
    }

    public void setRange(double low, double hi, int remoteId) throws VisADException, RemoteException {
        if (this.DisplayScalar.equals(Display.Animation)) {
            System.err.println("Warning: setRange on ScalarMap to Display.Animation has no effect.");
            return;
        }
        this.isManual = true;
        this.setRange(null, low, hi, false, remoteId);
        if (this.scale == this.scale && this.offset == this.offset) {
            this.incTick();
        } else {
            this.isManual = false;
        }
    }

    public void setRange(DataShadow shadow) throws VisADException, RemoteException {
        if (!this.isManual) {
            this.setRange(shadow, 0.0, 0.0, false, 0);
        }
    }

    private synchronized void setRange(DataShadow shadow, double low, double hi, boolean unit_flag) throws VisADException, RemoteException {
        this.setRange(shadow, low, hi, unit_flag, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void setRange(DataShadow shadow, double low, double hi, boolean unit_flag, int remoteId) throws VisADException, RemoteException {
        Unit display_unit;
        Unit data_unit;
        int i = this.ScalarIndex;
        if (shadow != null) {
            if (this.DisplayScalar.equals(Display.Latitude) || this.DisplayScalar.equals(Display.Longitude)) {
                data_unit = this.Scalar instanceof RealType ? ((RealType)this.Scalar).getDefaultUnit() : null;
                display_unit = this.DisplayScalar.getDefaultUnit();
                if (data_unit != null && display_unit != null && Unit.canConvert(data_unit, display_unit)) {
                    this.dataRange[0] = data_unit.toThis(this.displayRange[0], display_unit);
                    this.dataRange[1] = data_unit.toThis(this.displayRange[1], display_unit);
                } else {
                    if (i < 0 || i >= shadow.ranges[0].length) {
                        return;
                    }
                    this.dataRange[0] = shadow.ranges[0][i];
                    this.dataRange[1] = shadow.ranges[1][i];
                }
            } else {
                if (i < 0 || i >= shadow.ranges[0].length) {
                    return;
                }
                this.dataRange[0] = shadow.ranges[0][i];
                this.dataRange[1] = shadow.ranges[1][i];
            }
        } else if (unit_flag) {
            data_unit = this.Scalar instanceof RealType ? ((RealType)this.Scalar).getDefaultUnit() : null;
            display_unit = this.DisplayScalar.getDefaultUnit();
            if (data_unit == null || display_unit == null) {
                throw new UnitException("ScalarMap.setRangeByUnits: null Unit");
            }
            this.dataRange[0] = data_unit.toThis(this.displayRange[0], display_unit);
            this.dataRange[1] = data_unit.toThis(this.displayRange[1], display_unit);
        } else {
            this.dataRange[0] = low;
            this.dataRange[1] = hi;
            if (this.overrideUnit != null) {
                this.dataRange[0] = (this.dataRange[0] - this.override_offset) / this.override_scale;
                this.dataRange[1] = (this.dataRange[1] - this.override_offset) / this.override_scale;
            }
        }
        this.defaultUnitRange[0] = this.dataRange[0];
        this.defaultUnitRange[1] = this.dataRange[1];
        if (this.defaultUnitRange[0] == this.defaultUnitRange[1]) {
            double half = this.defaultUnitRange[0] / 2000.0;
            if (half < 0.5) {
                half = 0.5;
            }
            this.defaultUnitRange[0] = this.defaultUnitRange[0] - half;
            this.defaultUnitRange[1] = this.defaultUnitRange[1] + half;
        }
        if (this.isScaled) {
            this.computeScaleAndOffset();
        } else {
            if (this.dataRange[0] == Double.MAX_VALUE || this.dataRange[1] == -1.7976931348623157E308) {
                this.dataRange[0] = Double.NaN;
                this.dataRange[1] = Double.NaN;
            }
            if (this.overrideUnit != null) {
                this.dataRange[0] = this.defaultUnitRange[0] * this.override_scale + this.override_offset;
                this.dataRange[1] = this.defaultUnitRange[1] * this.override_scale + this.override_offset;
            }
        }
        if (this.DisplayScalar.equals(Display.Animation) && shadow != null) {
            if (this.control != null && ((AnimationControl)((Object)this.control)).getComputeSet()) {
                Set set = shadow.animationSampling;
                ((AnimationControl)((Object)this.control)).setSet(set, true);
            }
        } else if (this.DisplayScalar.equals(Display.IsoContour)) {
            if (this.control != null) {
                float[] lowhibase = new float[3];
                boolean[] dashes = new boolean[1];
                boolean public_set = ((ContourControl)this.control).getPublicSet();
                if (!public_set) {
                    float f;
                    boolean[] bvalues = new boolean[2];
                    float[] values = new float[5];
                    ((ContourControl)this.control).getMainContours(bvalues, values);
                    if (shadow == null) {
                        values[0] = (float)this.dataRange[0];
                    }
                    if ((f = (float)(this.dataRange[1] - this.dataRange[0]) / 10.0f) != 0.0f) {
                        values[1] = f;
                    }
                    values[2] = (float)this.dataRange[0];
                    values[3] = (float)this.dataRange[1];
                    values[4] = (float)this.dataRange[0];
                    ((ContourControl)this.control).setMainContours(bvalues, values, true, true);
                }
            }
        } else if ((this.DisplayScalar.equals(Display.XAxis) || this.DisplayScalar.equals(Display.YAxis) || this.DisplayScalar.equals(Display.ZAxis)) && this.dataRange[0] != Double.MAX_VALUE && this.dataRange[1] != -1.7976931348623157E308 && this.dataRange[0] == this.dataRange[0] && this.dataRange[1] == this.dataRange[1] && this.dataRange[0] != this.dataRange[1] && this.scale == this.scale && this.offset == this.offset) {
            if (this.display != null) {
                this.makeScale();
            } else {
                this.scale_flag = true;
            }
            this.back_scale_flag = true;
        }
        if (this.dataRange[0] == this.dataRange[0] && this.dataRange[1] == this.dataRange[1] && this.ListenerVector != null) {
            ScalarMapEvent evt = new ScalarMapEvent(this, shadow == null ? 2 : 1, remoteId);
            Vector listeners_clone = null;
            Vector public_set = this.ListenerVector;
            synchronized (public_set) {
                listeners_clone = (Vector)this.ListenerVector.clone();
            }
            Enumeration listeners = listeners_clone.elements();
            while (listeners.hasMoreElements()) {
                ScalarMapListener listener = (ScalarMapListener)listeners.nextElement();
                listener.mapChanged(evt);
            }
        }
    }

    private void computeScaleAndOffset() {
        if (this.dataRange[0] == Double.MAX_VALUE || this.dataRange[1] == -1.7976931348623157E308) {
            this.dataRange[0] = Double.NaN;
            this.dataRange[1] = Double.NaN;
            this.scale = Double.NaN;
            this.offset = Double.NaN;
        } else {
            if (this.dataRange[0] == this.dataRange[1]) {
                double half = this.dataRange[0] / 2000.0;
                if (half < 0.5) {
                    half = 0.5;
                }
                this.dataRange[0] = this.dataRange[0] - half;
                this.dataRange[1] = this.dataRange[1] + half;
            }
            if (this.overrideUnit != null) {
                this.dataRange[0] = this.defaultUnitRange[0] * this.override_scale + this.override_offset;
                this.dataRange[1] = this.defaultUnitRange[1] * this.override_scale + this.override_offset;
            }
            this.scale = (this.displayRange[1] - this.displayRange[0]) / (this.dataRange[1] - this.dataRange[0]);
            this.offset = this.displayRange[0] - this.scale * this.dataRange[0];
        }
        if (Double.isInfinite(this.scale) || Double.isInfinite(this.offset) || this.scale != this.scale || this.offset != this.offset) {
            this.dataRange[0] = Double.NaN;
            this.dataRange[1] = Double.NaN;
            this.scale = Double.NaN;
            this.offset = Double.NaN;
        }
    }

    public void addScalarMapListener(ScalarMapListener listener) {
        if (this.ListenerVector == null) {
            this.ListenerVector = new Vector();
        }
        this.ListenerVector.addElement(listener);
        if (this.dataRange[0] == this.dataRange[0] && this.dataRange[1] == this.dataRange[1]) {
            try {
                listener.mapChanged(new ScalarMapEvent(this, 2));
            }
            catch (VisADException e) {
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    public void removeScalarMapListener(ScalarMapListener listener) {
        if (listener != null && this.ListenerVector != null) {
            this.ListenerVector.removeElement(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyCtlListeners(ScalarMapControlEvent evt) throws RemoteException, VisADException {
        if (this.ListenerVector != null) {
            Vector listeners_clone = null;
            Vector vector = this.ListenerVector;
            synchronized (vector) {
                listeners_clone = (Vector)this.ListenerVector.clone();
            }
            Enumeration listeners = listeners_clone.elements();
            while (listeners.hasMoreElements()) {
                ScalarMapListener listener = (ScalarMapListener)listeners.nextElement();
                listener.controlChanged(evt);
            }
        }
    }

    public void setUnderscoreToBlank(boolean u2b) {
        this.underscore_to_blank = u2b;
        if (this.Scalar != null) {
            this.scalarName = this.Scalar.getName();
            if (this.underscore_to_blank) {
                this.scalarName = this.scalarName.replace('_', ' ');
            }
            if (this.axisScale != null) {
                this.axisScale.setTitle(this.scalarName);
            }
        }
    }

    public void makeScale() throws VisADException {
        if (this.axisScale != null) {
            DisplayRenderer displayRenderer = null;
            if (this.display == null) {
                return;
            }
            displayRenderer = this.display.getDisplayRenderer();
            if (displayRenderer == null) {
                return;
            }
            boolean scaleMade = this.axisScale.makeScale();
            if (scaleMade) {
                if (this.scale_on) {
                    displayRenderer.setScale(this.axisScale);
                } else {
                    displayRenderer.clearScale(this.axisScale);
                }
                this.scale_flag = false;
            }
        }
    }

    public void setScaleEnable(boolean on) {
        this.scale_on = on;
        if (this.axisScale != null) {
            this.axisScale.setVisible(on);
        }
    }

    public boolean getScaleEnable() {
        return this.scale_on;
    }

    public void setScaleColor(float[] color) throws VisADException {
        if (!(this.DisplayScalar.equals(Display.XAxis) || this.DisplayScalar.equals(Display.YAxis) || this.DisplayScalar.equals(Display.ZAxis))) {
            throw new DisplayException("ScalarMap.setScaleColor: DisplayScalar must be XAxis, YAxis or ZAxis");
        }
        if (color == null || color.length != 3) {
            throw new DisplayException("ScalarMap.setScaleColor: color is null or wrong length");
        }
        this.axisScale.setColor(color);
    }

    public boolean badRange() {
        boolean bad;
        boolean bl = bad = this.isScaled && (this.scale != this.scale || this.offset != this.offset);
        if (this.DisplayScalar.equals(Display.Animation)) {
            Set set;
            bad = this.control != null ? (bad |= (set = ((AnimationControl)((Object)this.control)).getSet()) == null) : true;
        }
        return bad;
    }

    public float[] scaleValues(double[] values) {
        if (values == null) {
            return null;
        }
        float[] new_values = new float[values.length];
        if (this.badRange()) {
            for (int i = 0; i < values.length; ++i) {
                new_values[i] = Float.NaN;
            }
        } else {
            if (this.overrideUnit != null && !this.overrideUnit.equals(((RealType)this.Scalar).getDefaultUnit())) {
                try {
                    values = this.overrideUnit.toThis(values, ((RealType)this.Scalar).getDefaultUnit());
                }
                catch (UnitException e) {
                    // empty catch block
                }
            }
            if (this.isScaled) {
                for (int i = 0; i < values.length; ++i) {
                    new_values[i] = (float)(this.offset + this.scale * values[i]);
                }
            } else {
                for (int i = 0; i < values.length; ++i) {
                    new_values[i] = (float)values[i];
                }
            }
        }
        return new_values;
    }

    public float[] scaleValues(float[] values) {
        return this.scaleValues(values, true);
    }

    public float[] scaleValues(float[] values, boolean newArray) {
        if (values == null) {
            return null;
        }
        float[] new_values = null;
        if (this.badRange()) {
            new_values = newArray ? new float[values.length] : values;
            for (int i = 0; i < values.length; ++i) {
                new_values[i] = Float.NaN;
            }
        } else {
            if (this.overrideUnit != null && !this.overrideUnit.equals(((RealType)this.Scalar).getDefaultUnit())) {
                try {
                    values = this.overrideUnit.toThis(values, ((RealType)this.Scalar).getDefaultUnit(), newArray);
                }
                catch (UnitException e) {
                    // empty catch block
                }
            }
            if (this.isScaled) {
                new_values = newArray ? new float[values.length] : values;
                for (int i = 0; i < values.length; ++i) {
                    new_values[i] = values[i] == values[i] ? (float)(this.offset + this.scale * (double)values[i]) : Float.NaN;
                }
            } else {
                new_values = values;
            }
        }
        return new_values;
    }

    public byte[] scaleValues(byte[] values, int factor) throws VisADException {
        if (values == null) {
            return null;
        }
        byte[] new_values = null;
        if (this.badRange()) {
            new_values = new byte[values.length];
        } else {
            if (this.overrideUnit != null && !this.overrideUnit.equals(((RealType)this.Scalar).getDefaultUnit())) {
                throw new VisADException("scaleValues(byte[]): non-default units not supported");
            }
            if (this.isScaled) {
                new_values = new byte[values.length];
                for (int i = 0; i < values.length; ++i) {
                    float v = values[i];
                    if (v < 0.0f) {
                        v += 256.0f;
                    }
                    if ((v = (float)((double)factor * (this.offset + this.scale * (double)v))) < 0.0f) {
                        v = 0.0f;
                    } else if (v > 255.0f) {
                        v = 255.0f;
                    }
                    new_values[i] = (byte)v;
                }
            } else {
                new_values = values;
            }
        }
        return new_values;
    }

    public float[] inverseScaleValues(float[] values) {
        return this.inverseScaleValues(values, true);
    }

    public float[] inverseScaleValues(float[] values, boolean newArray) {
        float[] new_values;
        if (values == null) {
            return null;
        }
        float[] fArray = new_values = newArray ? new float[values.length] : values;
        if (this.isScaled) {
            for (int i = 0; i < values.length; ++i) {
                new_values[i] = values[i] == values[i] ? (float)(((double)values[i] - this.offset) / this.scale) : Float.NaN;
            }
        } else if (newArray) {
            for (int i = 0; i < values.length; ++i) {
                new_values[i] = values[i];
            }
        }
        if (this.overrideUnit != null) {
            try {
                new_values = this.overrideUnit.toThat(new_values, ((RealType)this.Scalar).getDefaultUnit(), false);
            }
            catch (UnitException e) {
                // empty catch block
            }
        }
        return new_values;
    }

    public static void equalizeFlow(Vector mapVector, DisplayTupleType flow_tuple) throws VisADException, RemoteException {
        DisplayTupleType tuple;
        DisplayRealType dtype;
        ScalarMap map;
        double[] range = new double[2];
        double low = Double.MAX_VALUE;
        double hi = -1.7976931348623157E308;
        boolean anyAuto = false;
        Enumeration maps = mapVector.elements();
        while (maps.hasMoreElements()) {
            map = (ScalarMap)maps.nextElement();
            dtype = map.getDisplayScalar();
            tuple = dtype.getTuple();
            if (!flow_tuple.equals(tuple) || map.isManual || map.badRange()) continue;
            anyAuto = true;
            low = Math.min(low, map.dataRange[0]);
            hi = Math.max(hi, map.dataRange[1]);
        }
        if (!anyAuto) {
            return;
        }
        hi = Math.max(hi, -low);
        low = -hi;
        maps = mapVector.elements();
        while (maps.hasMoreElements()) {
            map = (ScalarMap)maps.nextElement();
            dtype = map.getDisplayScalar();
            tuple = dtype.getTuple();
            if (!flow_tuple.equals(tuple) || map.isManual || map.badRange()) continue;
            map.setRange(null, low, hi, false);
        }
    }

    int getDisplayScalarIndex() {
        return this.DisplayScalarIndex;
    }

    int getScalarIndex() {
        return this.ScalarIndex;
    }

    void setScalarIndex(int index) {
        this.ScalarIndex = index;
    }

    void setDisplayScalarIndex(int index) {
        this.DisplayScalarIndex = index;
    }

    public void setValueIndex(int index) {
        this.ValueIndex = index;
    }

    public int getValueIndex() {
        return this.ValueIndex;
    }

    public int compareTo(Object o) {
        return -((ScalarMap)o).compareTo(this);
    }

    protected int compareTo(ScalarMap that) {
        int comp = this.getScalar().compareTo(that.getScalar());
        if (comp == 0) {
            comp = this.getDisplayScalar().compareTo(that.getDisplayScalar());
        }
        return comp;
    }

    public boolean equals(Object o) {
        return o instanceof ScalarMap && this.compareTo(o) == 0;
    }

    public int hashCode() {
        ScalarType s2 = this.getScalar();
        DisplayRealType ds = this.getDisplayScalar();
        int hash = 0;
        if (s2 != null) {
            hash = ds != null ? s2.hashCode() ^ ds.hashCode() : s2.hashCode();
        } else if (ds != null) {
            hash = ds.hashCode();
        }
        return hash;
    }

    public Object clone() {
        try {
            ScalarMap sm = new ScalarMap(this.Scalar, this.DisplayScalar);
            this.copy(sm);
            return sm;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected void copy(ScalarMap map) throws VisADException, RemoteException {
        map.isScaled = this.isScaled;
        map.isManual = this.isManual;
        map.dataRange[0] = this.dataRange[0];
        map.dataRange[1] = this.dataRange[1];
        map.defaultUnitRange[0] = this.defaultUnitRange[0];
        map.defaultUnitRange[1] = this.defaultUnitRange[1];
        map.displayRange[0] = this.displayRange[0];
        map.displayRange[1] = this.displayRange[1];
        map.scale = this.scale;
        map.offset = this.offset;
        map.axisScale = this.axisScale != null ? this.axisScale.clone(map) : null;
        map.scale_flag = this.scale_flag;
        map.back_scale_flag = this.back_scale_flag;
        if (map.display != null) {
            map.setControl();
        }
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String pre) {
        return pre + "ScalarMap: " + this.Scalar.toString() + " -> " + this.DisplayScalar.toString() + "\n";
    }

    public AxisScale getAxisScale() {
        return this.axisScale;
    }

    void setAspectCartesian(double[] aspect) throws VisADException, RemoteException {
        double asp = Double.NaN;
        if (this.DisplayScalar.equals(Display.XAxis)) {
            asp = aspect[0];
        }
        if (this.DisplayScalar.equals(Display.YAxis)) {
            asp = aspect[1];
        }
        if (this.DisplayScalar.equals(Display.ZAxis)) {
            asp = aspect[2];
        }
        if (asp == asp) {
            this.isScaled = this.DisplayScalar.getRange(this.displayRange);
            this.displayRange[0] = this.displayRange[0] * asp;
            this.displayRange[1] = this.displayRange[1] * asp;
            this.computeScaleAndOffset();
            this.makeScale();
        }
    }
}

