/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CoordinateSystem;
import visad.CylindricalCoordinateSystem;
import visad.DataRenderer;
import visad.Set;
import visad.SphericalCoordinateSystem;
import visad.VisADException;
import visad.VisADGeometryArray;

public class VisADLineArray
extends VisADGeometryArray {
    private static final double LIMIT = 1.0;
    private static final double ALPHA = (double)0.01f;

    public static VisADLineArray merge(VisADLineArray[] arrays) throws VisADException {
        if (arrays == null || arrays.length == 0) {
            return null;
        }
        VisADLineArray array = new VisADLineArray();
        VisADLineArray.merge(arrays, array);
        return array;
    }

    public VisADGeometryArray adjustLongitude(DataRenderer renderer) throws VisADException {
        float[] lons = this.getLongitudes(renderer);
        if (this.any_longitude_rotate) {
            VisADLineArray array = new VisADLineArray();
            array.vertexCount = this.vertexCount;
            array.coordinates = this.coordinates;
            array.colors = this.colors;
            return array;
        }
        return this;
    }

    public VisADGeometryArray adjustSeam(DataRenderer renderer) throws VisADException {
        CoordinateSystem coord_sys = renderer.getDisplayCoordinateSystem();
        if (coord_sys == null || coord_sys instanceof SphericalCoordinateSystem || coord_sys instanceof CylindricalCoordinateSystem || this.coordinates == null) {
            return this;
        }
        int len = this.coordinates.length / 3;
        if (len < 6) {
            return this;
        }
        double[][] cs = new double[3][len];
        int j = 0;
        for (int i = 0; i < len; ++i) {
            cs[0][i] = this.coordinates[j++];
            cs[1][i] = this.coordinates[j++];
            cs[2][i] = this.coordinates[j++];
        }
        double[][] rs = coord_sys.fromReference(Set.copyDoubles(cs));
        boolean[] test = new boolean[len];
        boolean any_split = false;
        if (len < 2) {
            return this;
        }
        double[][] bs = new double[3][len / 2];
        double[][] ss = new double[3][len / 2];
        double ALPHA1 = 1.0099999997764826;
        double ALPHA1m = 0.9900000002235174;
        for (int i = 0; i < len / 2; ++i) {
            bs[0][i] = ALPHA1 * rs[0][2 * i] - (double)0.01f * rs[0][2 * i + 1];
            bs[1][i] = ALPHA1 * rs[1][2 * i] - (double)0.01f * rs[1][2 * i + 1];
            bs[2][i] = ALPHA1 * rs[2][2 * i] - (double)0.01f * rs[2][2 * i + 1];
            ss[0][i] = ALPHA1 * rs[0][2 * i + 1] - (double)0.01f * rs[0][2 * i];
            ss[1][i] = ALPHA1 * rs[1][2 * i + 1] - (double)0.01f * rs[1][2 * i];
            ss[2][i] = ALPHA1 * rs[2][2 * i + 1] - (double)0.01f * rs[2][2 * i];
        }
        double[][] ds = coord_sys.toReference(bs);
        double[][] es = coord_sys.toReference(ss);
        double IALPHA = 100.00000223517424;
        for (int i = 0; i < len; i += 2) {
            double a0 = cs[0][i + 1] - cs[0][i];
            double a1 = cs[1][i + 1] - cs[1][i];
            double a2 = cs[2][i + 1] - cs[2][i];
            double b0 = IALPHA * (cs[0][i] - ds[0][i / 2]);
            double b1 = IALPHA * (cs[1][i] - ds[1][i / 2]);
            double b2 = IALPHA * (cs[2][i] - ds[2][i / 2]);
            double aa = a0 * a0 + a1 * a1 + a2 * a2;
            double aminusb = (b0 - a0) * (b0 - a0) + (b1 - a1) * (b1 - a1) + (b2 - a2) * (b2 - a2);
            double abratio = aminusb / aa;
            double c0 = IALPHA * (cs[0][i + 1] - es[0][i / 2]);
            double c1 = IALPHA * (cs[1][i + 1] - es[1][i / 2]);
            double c2 = IALPHA * (cs[2][i + 1] - es[2][i / 2]);
            double aminusc = (c0 + a0) * (c0 + a0) + (c1 + a1) * (c1 + a1) + (c2 + a2) * (c2 + a2);
            double acratio = aminusc / aa;
            boolean bl = test[i] = (double)0.01f < abratio || (double)0.01f < acratio;
            if (!test[i]) continue;
            any_split = true;
        }
        bs = null;
        ss = null;
        if (!any_split) {
            return this;
        }
        double[] lengths = new double[len];
        for (int i = 0; i < len; ++i) {
            lengths[i] = 0.0;
        }
        double mean_length = 0.0;
        double var_length = 0.0;
        double max_length = 0.0;
        int num_length = 0;
        for (int i = 0; i < len; i += 2) {
            double cd2 = (cs[0][i + 1] - cs[0][i]) * (cs[0][i + 1] - cs[0][i]) + (cs[1][i + 1] - cs[1][i]) * (cs[1][i + 1] - cs[1][i]) + (cs[2][i + 1] - cs[2][i]) * (cs[2][i + 1] - cs[2][i]);
            if (test[i]) continue;
            lengths[i] = cd2;
            ++num_length;
            mean_length += lengths[i];
            var_length += lengths[i] * lengths[i];
            if (!(lengths[i] > max_length)) continue;
            max_length = lengths[i];
        }
        if (num_length < 2) {
            return this;
        }
        var_length = Math.sqrt((var_length - (mean_length /= (double)num_length) * mean_length) / (double)num_length);
        double limit_length = mean_length + 1.0 * var_length;
        cs = null;
        rs = null;
        Object lastcoord = null;
        Object lastcol = null;
        VisADLineArray array = new VisADLineArray();
        float[] coords = new float[3 * this.coordinates.length];
        int color_length = 0;
        byte[] cols = null;
        if (this.colors != null) {
            color_length = 3;
            cols = new byte[3 * this.colors.length];
            if (this.colors.length != this.coordinates.length) {
                color_length = 4;
            }
        }
        int ki = 0;
        int kj = 0;
        j = 0;
        for (int i = 0; i < 3 * len; i += 6) {
            if (!test[i / 3]) {
                coords[ki] = this.coordinates[i];
                coords[ki + 1] = this.coordinates[i + 1];
                coords[ki + 2] = this.coordinates[i + 2];
                coords[ki + 3] = this.coordinates[i + 3];
                coords[ki + 4] = this.coordinates[i + 4];
                coords[ki + 5] = this.coordinates[i + 5];
                ki += 6;
                if (color_length == 3) {
                    cols[kj] = this.colors[j];
                    cols[kj + 1] = this.colors[j + 1];
                    cols[kj + 2] = this.colors[j + 2];
                    cols[kj + 3] = this.colors[j + 3];
                    cols[kj + 4] = this.colors[j + 4];
                    cols[kj + 5] = this.colors[j + 5];
                    kj += 6;
                } else if (color_length == 4) {
                    cols[kj] = this.colors[j];
                    cols[kj + 1] = this.colors[j + 1];
                    cols[kj + 2] = this.colors[j + 2];
                    cols[kj + 3] = this.colors[j + 3];
                    cols[kj + 4] = this.colors[j + 4];
                    cols[kj + 5] = this.colors[j + 5];
                    cols[kj + 6] = this.colors[j + 6];
                    cols[kj + 7] = this.colors[j + 7];
                    kj += 8;
                }
            } else {
                any_split = true;
            }
            j += 2 * color_length;
        }
        if (!any_split) {
            return this;
        }
        array.vertexCount = ki / 3;
        array.coordinates = new float[ki];
        System.arraycopy(coords, 0, array.coordinates, 0, ki);
        if (this.colors != null) {
            array.colors = new byte[kj];
            System.arraycopy(cols, 0, array.colors, 0, kj);
        }
        return array;
    }

    public VisADGeometryArray removeMissing() {
        VisADLineArray array = new VisADLineArray();
        float[] coords = new float[this.coordinates.length];
        int color_length = 3;
        byte[] cols = null;
        if (this.colors != null) {
            cols = new byte[this.colors.length];
            if (this.colors.length != this.coordinates.length) {
                color_length = 4;
            }
        }
        int k = 0;
        int m3 = 0;
        int j = 0;
        boolean any_missing = false;
        for (int i = 0; i < this.coordinates.length; i += 6) {
            if (!(this.coordinates[i] != this.coordinates[i] || this.coordinates[i + 1] != this.coordinates[i + 1] || this.coordinates[i + 2] != this.coordinates[i + 2] || this.coordinates[i + 3] != this.coordinates[i + 3] || this.coordinates[i + 4] != this.coordinates[i + 4] || this.coordinates[i + 5] != this.coordinates[i + 5] || Float.isInfinite(this.coordinates[i]) || Float.isInfinite(this.coordinates[i + 1]) || Float.isInfinite(this.coordinates[i + 2]) || Float.isInfinite(this.coordinates[i + 3]) || Float.isInfinite(this.coordinates[i + 4]) || Float.isInfinite(this.coordinates[i + 5]))) {
                coords[k] = this.coordinates[i];
                coords[k + 1] = this.coordinates[i + 1];
                coords[k + 2] = this.coordinates[i + 2];
                coords[k + 3] = this.coordinates[i + 3];
                coords[k + 4] = this.coordinates[i + 4];
                coords[k + 5] = this.coordinates[i + 5];
                if (this.colors != null) {
                    cols[m3] = this.colors[j];
                    cols[m3 + 1] = this.colors[j + 1];
                    cols[m3 + 2] = this.colors[j + 2];
                    m3 += 3;
                    if (color_length == 4) {
                        cols[m3++] = this.colors[j + 3];
                    }
                    cols[m3] = this.colors[j + color_length];
                    cols[m3 + 1] = this.colors[j + color_length + 1];
                    cols[m3 + 2] = this.colors[j + color_length + 2];
                    m3 += 3;
                    if (color_length == 4) {
                        cols[m3++] = this.colors[j + color_length + 3];
                    }
                }
                k += 6;
            } else {
                any_missing = true;
            }
            j += 2 * color_length;
        }
        if (!any_missing) {
            return this;
        }
        array.coordinates = new float[k];
        System.arraycopy(coords, 0, array.coordinates, 0, k);
        if (this.colors != null) {
            array.colors = new byte[m3];
            System.arraycopy(cols, 0, array.colors, 0, m3);
        }
        return array;
    }

    public Object clone() {
        VisADLineArray array = new VisADLineArray();
        this.copy(array);
        return array;
    }
}

