/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataStore;
import loci.formats.RandomAccessStream;
import loci.formats.codec.BaseCodec;
import loci.formats.codec.JPEGCodec;
import loci.formats.codec.PackbitsCodec;

public class DicomReader
extends FormatReader {
    private static final Hashtable TYPES = DicomReader.buildTypes();
    private static final int PIXEL_REPRESENTATION = 2621699;
    private static final int TRANSFER_SYNTAX_UID = 131088;
    private static final int SLICE_SPACING = 0x180088;
    private static final int SAMPLES_PER_PIXEL = 0x280002;
    private static final int PHOTOMETRIC_INTERPRETATION = 2621444;
    private static final int PLANAR_CONFIGURATION = 2621446;
    private static final int NUMBER_OF_FRAMES = 0x280008;
    private static final int ROWS = 2621456;
    private static final int COLUMNS = 2621457;
    private static final int PIXEL_SPACING = 2621488;
    private static final int BITS_ALLOCATED = 2621696;
    private static final int WINDOW_CENTER = 2625616;
    private static final int WINDOW_WIDTH = 2625617;
    private static final int RESCALE_INTERCEPT = 2625618;
    private static final int RESCALE_SLOPE = 2625619;
    private static final int ICON_IMAGE_SEQUENCE = 0x880200;
    private static final int ITEM = -73728;
    private static final int ITEM_DELIMINATION = -73715;
    private static final int SEQUENCE_DELIMINATION = -73507;
    private static final int PIXEL_DATA = 2145386512;
    private static final int AE = 16709;
    private static final int AS = 16723;
    private static final int AT = 16724;
    private static final int CS = 17235;
    private static final int DA = 17473;
    private static final int DS = 17491;
    private static final int DT = 17492;
    private static final int FD = 17988;
    private static final int FL = 17996;
    private static final int IS = 18771;
    private static final int LO = 19535;
    private static final int LT = 19540;
    private static final int PN = 20558;
    private static final int SH = 21320;
    private static final int SL = 21324;
    private static final int SS = 21331;
    private static final int ST = 21332;
    private static final int TM = 21581;
    private static final int UI = 21833;
    private static final int UL = 21836;
    private static final int US = 21843;
    private static final int UT = 21844;
    private static final int OB = 20290;
    private static final int OW = 20311;
    private static final int SQ = 21329;
    private static final int UN = 21838;
    private static final int QQ = 16191;
    private static final int IMPLICIT_VR = 11565;
    protected int bitsPerPixel;
    protected int offsets;
    private int location;
    private int elementLength;
    private int vr;
    private boolean oddLocations;
    private boolean inSequence;
    private boolean bigEndianTransferSyntax;
    private byte[][] lut;
    private boolean isJPEG = false;
    private boolean isRLE = false;

    public DicomReader() {
        super("Digital Img. & Comm. in Med.", new String[]{"dcm", "dicom"});
    }

    public boolean isThisType(byte[] block) {
        return false;
    }

    public byte[][] get8BitLookupTable() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.lut;
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        BaseCodec codec;
        FormatTools.assertId(this.currentId, true, 1);
        FormatTools.checkPlaneNumber(this, no);
        FormatTools.checkBufferSize(this, buf.length);
        int bytes = this.core.sizeX[0] * this.core.sizeY[0] * FormatTools.getBytesPerPixel(this.core.pixelType[0]) * (this.isIndexed() ? 1 : this.core.sizeC[0]);
        this.in.seek(this.offsets + bytes * no);
        if (this.isRLE) {
            this.in.skipBytes(67);
            while (this.in.read() == 0) {
            }
            this.in.seek(this.in.getFilePointer() - 1L);
        }
        this.in.read(buf);
        if (this.isRLE) {
            Object tmp;
            codec = new PackbitsCodec();
            buf = codec.decompress(buf);
            int b = FormatTools.getBytesPerPixel(this.core.pixelType[0]);
            int plane = bytes / b;
            if (b > 1) {
                int i;
                tmp = new byte[b][plane];
                for (i = 0; i < b; ++i) {
                    System.arraycopy(buf, i * plane, tmp[i], 0, plane);
                }
                for (i = 0; i < plane; ++i) {
                    for (int j = 0; j < b; ++j) {
                        buf[i * b + j] = this.core.littleEndian[0] ? tmp[b - j - 1][i] : tmp[j][i];
                    }
                }
            }
            if (buf.length < plane * b) {
                tmp = buf;
                buf = new byte[plane * b];
                System.arraycopy(tmp, 0, buf, 0, ((byte[][])tmp).length);
            }
        }
        if (this.isJPEG) {
            codec = new JPEGCodec();
            buf = codec.decompress(buf);
        }
        return buf;
    }

    protected void initFile(String id) throws FormatException, IOException {
        if (debug) {
            this.debug("DicomReader.initFile(" + id + ")");
        }
        super.initFile(id);
        this.in = new RandomAccessStream(id);
        this.in.order(true);
        this.core.littleEndian[0] = true;
        this.location = 0;
        this.status("Verifying DICOM format");
        this.in.seek(128L);
        if (this.in.readString(4).equals("DICM")) {
            this.in.seek(0L);
            this.addMeta("Header information", this.in.readString(128));
            this.in.readInt();
            this.location = 128;
        } else {
            this.in.seek(0L);
        }
        this.status("Reading tags");
        boolean decodingTags = true;
        while (decodingTags) {
            int tag = this.getNextTag();
            if ((this.location & 1) != 0) {
                this.oddLocations = true;
            }
            if (this.inSequence) {
                this.addInfo(tag, null);
                if (this.in.getFilePointer() < this.in.length() - 4L) continue;
                decodingTags = false;
                continue;
            }
            switch (tag) {
                case 131088: {
                    String s2 = this.in.readString(this.elementLength);
                    this.addInfo(tag, s2);
                    if (s2.startsWith("1.2.840.10008.1.2.4")) {
                        this.isJPEG = true;
                    } else if (s2.startsWith("1.2.840.10008.1.2.5")) {
                        this.isRLE = true;
                    } else if (s2.indexOf("1.2.4") > -1 || s2.indexOf("1.2.5") > -1) {
                        throw new FormatException("Sorry, compressed DICOM images not supported");
                    }
                    if (s2.indexOf("1.2.840.10008.1.2.2") < 0) break;
                    this.bigEndianTransferSyntax = true;
                    break;
                }
                case 0x280008: {
                    String s2 = this.in.readString(this.elementLength);
                    this.addInfo(tag, s2);
                    double frames = Double.parseDouble(s2);
                    if (!(frames > 1.0)) break;
                    this.core.imageCount[0] = (int)frames;
                    break;
                }
                case 0x280002: {
                    short samplesPerPixel = this.in.readShort();
                    this.addInfo(tag, samplesPerPixel);
                    break;
                }
                case 2621444: {
                    this.addInfo(tag, this.in.readString(this.elementLength));
                    break;
                }
                case 2621446: {
                    this.addInfo(tag, this.in.readShort());
                    break;
                }
                case 2621456: {
                    this.core.sizeY[0] = this.in.readShort();
                    this.addInfo(tag, this.core.sizeY[0]);
                    break;
                }
                case 2621457: {
                    this.core.sizeX[0] = this.in.readShort();
                    this.addInfo(tag, this.core.sizeX[0]);
                    break;
                }
                case 2621488: {
                    this.addInfo(tag, this.in.readString(this.elementLength));
                    break;
                }
                case 0x180088: {
                    this.addInfo(tag, this.in.readString(this.elementLength));
                    break;
                }
                case 2621696: {
                    this.bitsPerPixel = this.in.readShort();
                    this.addInfo(tag, this.bitsPerPixel);
                    break;
                }
                case 2621699: {
                    this.addInfo(tag, this.in.readShort());
                    break;
                }
                case 2625616: 
                case 2625617: 
                case 2625618: 
                case 2625619: {
                    this.addInfo(tag, this.in.readString(this.elementLength));
                    break;
                }
                case 2145386512: {
                    if (this.elementLength != 0) {
                        this.offsets = (int)this.in.getFilePointer();
                        this.addInfo(tag, this.location);
                        decodingTags = false;
                        break;
                    }
                    this.addInfo(tag, null);
                    break;
                }
                case 2139619344: {
                    if (this.elementLength == 0) break;
                    this.offsets = this.location + 4;
                    decodingTags = false;
                    break;
                }
                default: {
                    this.addInfo(tag, null);
                }
            }
            if (this.in.getFilePointer() < this.in.length() - 4L) continue;
            decodingTags = false;
        }
        if (this.core.imageCount[0] == 0) {
            this.core.imageCount[0] = 1;
        }
        this.status("Populating metadata");
        this.core.sizeZ[0] = this.core.imageCount[0];
        if (this.core.sizeC[0] == 0) {
            this.core.sizeC[0] = 1;
        }
        this.core.rgb[0] = this.core.sizeC[0] > 1;
        this.core.sizeT[0] = 1;
        this.core.currentOrder[0] = "XYCZT";
        this.core.interleaved[0] = !this.isJPEG && !this.isRLE;
        this.core.metadataComplete[0] = true;
        this.core.falseColor[0] = false;
        MetadataStore store = this.getMetadataStore();
        while (this.bitsPerPixel % 8 != 0) {
            ++this.bitsPerPixel;
        }
        if (this.bitsPerPixel == 24 || this.bitsPerPixel == 48) {
            this.bitsPerPixel /= 3;
        }
        switch (this.bitsPerPixel) {
            case 8: {
                this.core.pixelType[0] = 1;
                break;
            }
            case 16: {
                this.core.pixelType[0] = 3;
                break;
            }
            case 32: {
                this.core.pixelType[0] = 5;
            }
        }
        FormatTools.populatePixels(store, this);
        String date = (String)this.getMeta("Content Date");
        String time = (String)this.getMeta("Content Time");
        String stamp = null;
        if (date != null && time != null) {
            stamp = date + " " + time;
            SimpleDateFormat parse = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss.SSSSSS");
            Date d = parse.parse(stamp, new ParsePosition(0));
            SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            stamp = d != null ? fmt.format(d) : null;
        }
        if (stamp == null || stamp.trim().equals("")) {
            stamp = null;
        }
        store.setImage(this.currentId, stamp, (String)this.getMeta("Image Type"), null);
        store.setInstrument((String)this.getMeta("Manufacturer"), (String)this.getMeta("Manufacturer's Model Name"), null, null, null);
        for (int i = 0; i < this.core.sizeC[0]; ++i) {
            store.setLogicalChannel(i, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
        }
    }

    private void addInfo(int tag, String value) throws IOException {
        long oldFp = this.in.getFilePointer();
        String info = this.getHeaderInfo(tag, value);
        if (this.inSequence && info != null && this.vr != 21329) {
            info = ">" + info;
        }
        if (info != null && tag != -73728) {
            String key = (String)TYPES.get(new Integer(tag));
            if (key == null) {
                key = "" + tag;
            }
            if (key.equals("Samples per pixel")) {
                this.core.sizeC[0] = Integer.parseInt(info.trim());
                if (this.core.sizeC[0] > 1) {
                    this.core.rgb[0] = true;
                }
            } else if (key.equals("Photometric Interpretation")) {
                if (info.trim().equals("PALETTE COLOR")) {
                    this.core.indexed[0] = true;
                    this.core.sizeC[0] = 3;
                    this.core.rgb[0] = true;
                    this.lut = new byte[3][];
                }
            } else if (key.indexOf("Palette Color LUT Data") != -1) {
                String color = key.substring(0, key.indexOf(" ")).trim();
                int ndx = color.equals("Red") ? 0 : (color.equals("Green") ? 1 : 2);
                long fp = this.in.getFilePointer();
                this.in.seek(oldFp + (long)(ndx * ndx));
                this.lut[ndx] = new byte[this.elementLength / 2];
                for (int i = 0; i < this.lut[ndx].length; ++i) {
                    this.lut[ndx][i] = (byte)(this.in.read() & 0xFF);
                    this.in.skipBytes(1);
                }
                this.in.seek(fp);
            }
            if (tag != 2145386512) {
                this.addMeta(key, info);
            }
        }
    }

    private void addInfo(int tag, int value) throws IOException {
        this.addInfo(tag, Integer.toString(value));
    }

    private String getHeaderInfo(int tag, String value) throws IOException {
        Integer key;
        String id;
        if (tag == -73715 || tag == -73507) {
            this.inSequence = false;
        }
        if ((id = (String)TYPES.get(key = new Integer(tag))) != null) {
            if (this.vr == 11565 && id != null) {
                this.vr = (id.charAt(0) << 8) + id.charAt(1);
            }
            if (id.length() > 2) {
                id = id.substring(2);
            }
        }
        if (tag == -73728) {
            return id != null ? id : null;
        }
        if (value != null) {
            return value;
        }
        boolean skip = false;
        switch (this.vr) {
            case 16709: 
            case 16723: 
            case 16724: 
            case 17235: 
            case 17473: 
            case 17491: 
            case 17492: 
            case 18771: 
            case 19535: 
            case 19540: 
            case 20558: 
            case 21320: 
            case 21332: 
            case 21581: 
            case 21833: {
                value = this.in.readString(this.elementLength);
                break;
            }
            case 21843: {
                if (this.elementLength == 2) {
                    value = Integer.toString(this.in.readShort());
                    break;
                }
                value = "";
                int n = this.elementLength / 2;
                for (int i = 0; i < n; ++i) {
                    value = value + Integer.toString(this.in.readShort()) + " ";
                }
                break;
            }
            case 11565: {
                value = this.in.readString(this.elementLength);
                if (this.elementLength > 4 && this.elementLength <= 44) break;
                value = null;
                break;
            }
            case 21329: {
                boolean privateTag;
                value = "";
                boolean bl = privateTag = (tag >> 16 & 1) != 0;
                if (tag != 0x880200 && !privateTag) break;
                skip = true;
                break;
            }
            default: {
                skip = true;
            }
        }
        if (skip) {
            long skipCount = this.elementLength;
            if (this.in.getFilePointer() + skipCount <= this.in.length()) {
                this.in.skipBytes((int)skipCount);
            }
            this.location += this.elementLength;
            value = "";
        }
        if (value != null && id == null && !value.equals("")) {
            return value;
        }
        if (id == null) {
            return null;
        }
        return value;
    }

    private int getLength() throws IOException {
        byte[] b = new byte[4];
        this.in.read(b);
        this.vr = (b[0] << 8) + b[1];
        switch (this.vr) {
            case 20290: 
            case 20311: 
            case 21329: 
            case 21838: {
                if (b[2] == 0 || b[3] == 0) {
                    return this.in.readInt();
                }
                this.vr = 11565;
                if (this.core.littleEndian[0]) {
                    return (b[3] << 24) + (b[2] << 16) + (b[1] << 8) + b[0];
                }
                return (b[0] << 24) + (b[1] << 16) + (b[2] << 8) + b[3];
            }
            case 16191: 
            case 16709: 
            case 16723: 
            case 16724: 
            case 17235: 
            case 17473: 
            case 17491: 
            case 17492: 
            case 17988: 
            case 17996: 
            case 18771: 
            case 19535: 
            case 19540: 
            case 20558: 
            case 21320: 
            case 21324: 
            case 21331: 
            case 21332: 
            case 21581: 
            case 21833: 
            case 21836: 
            case 21843: 
            case 21844: {
                if (this.core.littleEndian[0]) {
                    return (b[3] << 8) + b[2];
                }
                return (b[2] << 8) + b[3];
            }
        }
        this.vr = 11565;
        if (this.core.littleEndian[0]) {
            return (b[3] << 24) + (b[2] << 16) + (b[1] << 8) + b[0];
        }
        return (b[0] << 24) + (b[1] << 16) + (b[2] << 8) + b[3];
    }

    private int getNextTag() throws IOException {
        short elementWord;
        int tag;
        int groupWord = this.in.readShort();
        if (groupWord == 2048 && this.bigEndianTransferSyntax) {
            this.core.littleEndian[0] = false;
            groupWord = 8;
            this.in.order(false);
        }
        if ((tag = groupWord << 16 & 0xFFFF0000 | (elementWord = this.in.readShort()) & 0xFFFF) == 2145386512 && (this.isRLE || this.isJPEG)) {
            this.in.skipBytes(20);
        }
        this.elementLength = this.getLength();
        if (this.elementLength == 13 && !this.oddLocations) {
            this.elementLength = 10;
        }
        if (this.elementLength == -1) {
            this.elementLength = 0;
            this.inSequence = true;
        }
        return tag;
    }

    private static Hashtable buildTypes() {
        Hashtable<Integer, String> dict = new Hashtable<Integer, String>();
        dict.put(new Integer(131074), "Media Storage SOP Class UID");
        dict.put(new Integer(131075), "Media Storage SOP Instance UID");
        dict.put(new Integer(131088), "Transfer Syntax UID");
        dict.put(new Integer(131090), "Implementation Class UID");
        dict.put(new Integer(131091), "Implementation Version Name");
        dict.put(new Integer(131094), "Source Application Entity Title");
        dict.put(new Integer(524293), "Specific Character Set");
        dict.put(new Integer(524296), "Image Type");
        dict.put(new Integer(524304), "Recognition Code");
        dict.put(new Integer(524306), "Instance Creation Date");
        dict.put(new Integer(524307), "Instance Creation Time");
        dict.put(new Integer(524308), "Instance Creator UID");
        dict.put(new Integer(524310), "SOP Class UID");
        dict.put(new Integer(524312), "SOP Instance UID");
        dict.put(new Integer(524314), "Related General SOP Class UID");
        dict.put(new Integer(524315), "Original Specialized SOP Class UID");
        dict.put(new Integer(524320), "Study Date");
        dict.put(new Integer(524321), "Series Date");
        dict.put(new Integer(524322), "Acquisition Date");
        dict.put(new Integer(524323), "Content Date");
        dict.put(new Integer(524324), "Overlay Date");
        dict.put(new Integer(524325), "Curve Date");
        dict.put(new Integer(524330), "Acquisition Date/Time");
        dict.put(new Integer(524336), "Study Time");
        dict.put(new Integer(524337), "Series Time");
        dict.put(new Integer(524338), "Acquisition Time");
        dict.put(new Integer(524339), "Content Time");
        dict.put(new Integer(524340), "Overlay Time");
        dict.put(new Integer(524341), "Curve Time");
        dict.put(new Integer(524353), "Data Set Subtype");
        dict.put(new Integer(524368), "Accession Number");
        dict.put(new Integer(524370), "Query/Retrieve Level");
        dict.put(new Integer(524372), "Retrieve AE Title");
        dict.put(new Integer(524374), "Instance Availability");
        dict.put(new Integer(524376), "Failed SOP Instance UID List");
        dict.put(new Integer(524384), "Modality");
        dict.put(new Integer(524385), "Modalities in Study");
        dict.put(new Integer(524386), "SOP Classes in Study");
        dict.put(new Integer(524388), "Conversion Type");
        dict.put(new Integer(524392), "Presentation Intent Type");
        dict.put(new Integer(524400), "Manufacturer");
        dict.put(new Integer(524416), "Institution Name");
        dict.put(new Integer(524417), "Institution Address");
        dict.put(new Integer(524418), "Institution Code Sequence");
        dict.put(new Integer(524432), "Referring Physician's Name");
        dict.put(new Integer(524434), "Referring Physician's Address");
        dict.put(new Integer(524436), "Referring Physician's Telephone");
        dict.put(new Integer(524438), "Referring Physician ID");
        dict.put(new Integer(524544), "Code Value");
        dict.put(new Integer(524546), "Coding Scheme Designator");
        dict.put(new Integer(524547), "Coding Scheme Version");
        dict.put(new Integer(524548), "Code Meaning");
        dict.put(new Integer(524549), "Mapping Resource");
        dict.put(new Integer(524550), "Context Group Version");
        dict.put(new Integer(524551), "Context Group Local Version");
        dict.put(new Integer(524555), "Context Group Extension Flag");
        dict.put(new Integer(524556), "Coding Scheme UID");
        dict.put(new Integer(524557), "Context Group Extension Creator UID");
        dict.put(new Integer(524559), "Context ID");
        dict.put(new Integer(524560), "Coding Scheme ID");
        dict.put(new Integer(524562), "Coding Scheme Registry");
        dict.put(new Integer(524564), "Coding Scheme External ID");
        dict.put(new Integer(524565), "Coding Scheme Name");
        dict.put(new Integer(524566), "Responsible Organization");
        dict.put(new Integer(524801), "Timezone Offset from UTC");
        dict.put(new Integer(528400), "Station Name");
        dict.put(new Integer(528432), "Study Description");
        dict.put(new Integer(528434), "Procedure Code Sequence");
        dict.put(new Integer(528446), "Series Description");
        dict.put(new Integer(528448), "Institutional Department Name");
        dict.put(new Integer(528456), "Physician(s) of Record");
        dict.put(new Integer(528457), "Physician(s) of Record ID");
        dict.put(new Integer(528464), "Performing Physician's Name");
        dict.put(new Integer(528466), "Performing Physican ID");
        dict.put(new Integer(528480), "Name of Physician(s) Reading Study");
        dict.put(new Integer(528482), "Physician(s) Reading Study ID");
        dict.put(new Integer(528496), "Operator's Name");
        dict.put(new Integer(528498), "Operator ID");
        dict.put(new Integer(528512), "Admitting Diagnoses Description");
        dict.put(new Integer(528516), "Admitting Diagnoses Code Sequence");
        dict.put(new Integer(528528), "Manufacturer's Model Name");
        dict.put(new Integer(528640), "Referenced Results Sequence");
        dict.put(new Integer(528656), "Referenced Study Sequence");
        dict.put(new Integer(528657), "Referenced Performed Procedure Step");
        dict.put(new Integer(528661), "Referenced Series Sequence");
        dict.put(new Integer(528672), "Referenced Patient Sequence");
        dict.put(new Integer(528677), "Referenced Visit Sequence");
        dict.put(new Integer(528688), "Referenced Overlay Sequence");
        dict.put(new Integer(528698), "Referenced Waveform Sequence");
        dict.put(new Integer(528704), "Referenced Image Sequence");
        dict.put(new Integer(528709), "Referenced Curve Sequence");
        dict.put(new Integer(528714), "Referenced Instance Sequence");
        dict.put(new Integer(528720), "Referenced SOP Class UID");
        dict.put(new Integer(528725), "Referenced SOP Instance UID");
        dict.put(new Integer(528730), "SOP Classes Supported");
        dict.put(new Integer(528736), "Referenced Frame Number");
        dict.put(new Integer(528789), "Transaction UID");
        dict.put(new Integer(528791), "Failure Reason");
        dict.put(new Integer(528792), "Failed SOP Sequence");
        dict.put(new Integer(528793), "Referenced SOP Sequence");
        dict.put(new Integer(528896), "Studies Containing Other Referenced Instances Sequence");
        dict.put(new Integer(528976), "Related Series Sequence");
        dict.put(new Integer(532753), "Derivation Description");
        dict.put(new Integer(532754), "Source Image Sequence");
        dict.put(new Integer(532768), "Stage Name");
        dict.put(new Integer(532770), "Stage Number");
        dict.put(new Integer(532772), "Number of Stages");
        dict.put(new Integer(532775), "View Name");
        dict.put(new Integer(532776), "View Number");
        dict.put(new Integer(532777), "Number of Event Timers");
        dict.put(new Integer(532778), "Number of Views in Stage");
        dict.put(new Integer(532784), "Event Elapsed Time(s)");
        dict.put(new Integer(532786), "Event Timer Name(s)");
        dict.put(new Integer(532802), "Start Trim");
        dict.put(new Integer(532803), "Stop Trim");
        dict.put(new Integer(532804), "Recommended Display Frame Rate");
        dict.put(new Integer(533016), "Anatomic Region Sequence");
        dict.put(new Integer(533024), "Anatomic Region Modifier Sequence");
        dict.put(new Integer(533032), "Primary Anatomic Structure Sequence");
        dict.put(new Integer(533033), "Anatomic Structure Sequence");
        dict.put(new Integer(533040), "Primary Anatomic Structure Modifier");
        dict.put(new Integer(533056), "Transducer Position Sequence");
        dict.put(new Integer(533058), "Transducer Position Modifier Sequence");
        dict.put(new Integer(533060), "Transducer Orientation Sequence");
        dict.put(new Integer(533062), "Transducer Orientation Modifier");
        dict.put(new Integer(536577), "Alternate Representation Sequence");
        dict.put(new Integer(561159), "Frame Type");
        dict.put(new Integer(561298), "Referenced Image Evidence Sequence");
        dict.put(new Integer(561441), "Referenced Raw Data Sequence");
        dict.put(new Integer(561443), "Creator-Version UID");
        dict.put(new Integer(561444), "Derivation Image Sequence");
        dict.put(new Integer(561492), "Source Image Evidence Sequence");
        dict.put(new Integer(561669), "Pixel Representation");
        dict.put(new Integer(561670), "Volumetric Properties");
        dict.put(new Integer(561671), "Volume Based Calculation Technique");
        dict.put(new Integer(561672), "Complex Image Component");
        dict.put(new Integer(561673), "Acquisition Contrast");
        dict.put(new Integer(561685), "Derivation Code Sequence");
        dict.put(new Integer(561719), "Reference Grayscale Presentation State");
        dict.put(new Integer(0x100010), "Patient's Name");
        dict.put(new Integer(0x100020), "Patient ID");
        dict.put(new Integer(0x100021), "Issuer of Patient ID");
        dict.put(new Integer(0x100030), "Patient's Birth Date");
        dict.put(new Integer(1048626), "Patient's Birth Time");
        dict.put(new Integer(0x100040), "Patient's Sex");
        dict.put(new Integer(0x100050), "Patient's Insurance Plane Code");
        dict.put(new Integer(0x100101), "Patient's Primary Language Code");
        dict.put(new Integer(0x100102), "Patient's Primary Language Modifier");
        dict.put(new Integer(0x101000), "Other Patient IDs");
        dict.put(new Integer(0x101001), "Other Patient Names");
        dict.put(new Integer(0x101005), "Patient's Birth Name");
        dict.put(new Integer(0x101010), "Patient's Age");
        dict.put(new Integer(0x101020), "Patient's Size");
        dict.put(new Integer(0x101030), "Patient's Weight");
        dict.put(new Integer(0x101040), "Patient's Address");
        dict.put(new Integer(0x101060), "Patient's Mother's Birth Name");
        dict.put(new Integer(0x101080), "Military Rank");
        dict.put(new Integer(0x101081), "Branch of Service");
        dict.put(new Integer(0x101090), "Medical Record Locator");
        dict.put(new Integer(0x102000), "Medical Alerts");
        dict.put(new Integer(0x102110), "Contrast Allergies");
        dict.put(new Integer(1057104), "Country of Residence");
        dict.put(new Integer(1057106), "Region of Residence");
        dict.put(new Integer(1057108), "Patient's Telephone Numbers");
        dict.put(new Integer(1057120), "Ethnic Group");
        dict.put(new Integer(1057152), "Occupation");
        dict.put(new Integer(1057184), "Smoking Status");
        dict.put(new Integer(1057200), "Additional Patient History");
        dict.put(new Integer(1057216), "Pregnancy Status");
        dict.put(new Integer(1057232), "Last Menstrual Date");
        dict.put(new Integer(1057264), "Patient's Religious Preference");
        dict.put(new Integer(0x104000), "Patient Comments");
        dict.put(new Integer(0x120010), "Clinical Trial Sponsor Name");
        dict.put(new Integer(0x120020), "Clinical Trial Protocol ID");
        dict.put(new Integer(0x120021), "Clinical Trial Protocol Name");
        dict.put(new Integer(1179696), "Clinical Trial Site ID");
        dict.put(new Integer(1179697), "Clinical Trial Site Name");
        dict.put(new Integer(1179712), "Clinical Trial Subject ID");
        dict.put(new Integer(1179714), "Clinical Trial Subject Reading ID");
        dict.put(new Integer(1179728), "Clinical Trial Time Point ID");
        dict.put(new Integer(1179729), "Clinical Trial Time Point Description");
        dict.put(new Integer(1179744), "Clinical Trial Coordinating Center");
        dict.put(new Integer(0x180010), "Contrast/Bolus Agent");
        dict.put(new Integer(1572882), "Contrast/Bolus Agent Sequence");
        dict.put(new Integer(1572884), "Contrast/Bolus Admin. Route Sequence");
        dict.put(new Integer(1572885), "Body Part Examined");
        dict.put(new Integer(1572896), "Scanning Sequence");
        dict.put(new Integer(1572897), "Sequence Variant");
        dict.put(new Integer(1572898), "Scan Options");
        dict.put(new Integer(1572899), "MR Acquisition Type");
        dict.put(new Integer(1572900), "Sequence Name");
        dict.put(new Integer(1572901), "Angio Flag");
        dict.put(new Integer(1572902), "Intervention Drug Information Sequence");
        dict.put(new Integer(1572903), "Intervention Drug Stop Time");
        dict.put(new Integer(1572904), "Intervention Drug Dose");
        dict.put(new Integer(1572905), "Intervention Drug Sequence");
        dict.put(new Integer(1572906), "Additional Drug Sequence");
        dict.put(new Integer(1572913), "Radiopharmaceutical");
        dict.put(new Integer(1572916), "Intervention Drug Name");
        dict.put(new Integer(1572917), "Intervention Drug Start Time");
        dict.put(new Integer(1572918), "Intervention Sequence");
        dict.put(new Integer(1572920), "Intervention Status");
        dict.put(new Integer(1572922), "Intervention Description");
        dict.put(new Integer(1572928), "Cine Rate");
        dict.put(new Integer(1572944), "Slice Thickness");
        dict.put(new Integer(1572960), "KVP");
        dict.put(new Integer(1572976), "Counts Accumulated");
        dict.put(new Integer(1572977), "Acquisition Termination Condition");
        dict.put(new Integer(1572978), "Effective Duration");
        dict.put(new Integer(1572979), "Acquisition Start Condition");
        dict.put(new Integer(1572980), "Acquisition Start Condition Data");
        dict.put(new Integer(1572981), "Acquisition Termination Condition Data");
        dict.put(new Integer(0x180080), "Repetition Time");
        dict.put(new Integer(0x180081), "Echo Time");
        dict.put(new Integer(1572994), "Inversion Time");
        dict.put(new Integer(1572995), "Number of Averages");
        dict.put(new Integer(1572996), "Imaging Frequency");
        dict.put(new Integer(1572997), "Imaged Nucleus");
        dict.put(new Integer(1572998), "Echo Number(s)");
        dict.put(new Integer(1572999), "Magnetic Field Strength");
        dict.put(new Integer(0x180088), "Spacing Between Slices");
        dict.put(new Integer(1573001), "Number of Phase Encoding Steps");
        dict.put(new Integer(1573008), "Data Collection Diameter");
        dict.put(new Integer(1573009), "Echo Train Length");
        dict.put(new Integer(1573011), "Percent Sampling");
        dict.put(new Integer(1573012), "Percent Phase Field of View");
        dict.put(new Integer(1573013), "Pixel Bandwidth");
        dict.put(new Integer(0x181000), "Device Serial Number");
        dict.put(new Integer(1576964), "Plate ID");
        dict.put(new Integer(0x181010), "Secondary Capture Device ID");
        dict.put(new Integer(0x181011), "Hardcopy Creation Device ID");
        dict.put(new Integer(1576978), "Date of Secondary Capture");
        dict.put(new Integer(1576980), "Time of Secondary Capture");
        dict.put(new Integer(1576982), "Secondary Capture Device Manufacturer");
        dict.put(new Integer(1576983), "Hardcopy Device Manufacturer");
        dict.put(new Integer(0x181018), "Secondary Capture Device Model Name");
        dict.put(new Integer(1576985), "Secondary Capture Device Software Version");
        dict.put(new Integer(1576986), "Hardcopy Device Software Version");
        dict.put(new Integer(1576987), "Hardcopy Device Model Name");
        dict.put(new Integer(1576992), "Software Version(s)");
        dict.put(new Integer(1576994), "Video Image Format Acquired");
        dict.put(new Integer(1576995), "Digital Image Format Acquired");
        dict.put(new Integer(1577008), "Protocol Name");
        dict.put(new Integer(1577024), "Contrast/Bolus Route");
        dict.put(new Integer(1577025), "Contrast/Bolus Volume");
        dict.put(new Integer(1577026), "Contrast/Bolus Start Time");
        dict.put(new Integer(1577027), "Contrast/Bolus Stop Time");
        dict.put(new Integer(1577028), "Contrast/Bolus Total Dose");
        dict.put(new Integer(1577029), "Syringe Counts");
        dict.put(new Integer(1577030), "Contrast Flow Rate");
        dict.put(new Integer(1577031), "Contrast Flow Duration");
        dict.put(new Integer(1577032), "Contrast/Bolus Ingredient");
        dict.put(new Integer(1577033), "Contrast Ingredient Concentration");
        dict.put(new Integer(1577040), "Spatial Resolution");
        dict.put(new Integer(1577056), "Trigger Time");
        dict.put(new Integer(1577057), "Trigger Source or Type");
        dict.put(new Integer(1577058), "Nominal Interval");
        dict.put(new Integer(1577059), "Frame Time");
        dict.put(new Integer(1577060), "Framing Type");
        dict.put(new Integer(1577061), "Frame Time Vector");
        dict.put(new Integer(1577062), "Frame Delay");
        dict.put(new Integer(1577063), "Image Trigger Delay");
        dict.put(new Integer(1577064), "Multiplex Group Time Offset");
        dict.put(new Integer(1577065), "Trigger Time Offset");
        dict.put(new Integer(1577066), "Synchronization Trigger");
        dict.put(new Integer(1577068), "Synchronization Channel");
        dict.put(new Integer(1577070), "Trigger Sample Position");
        dict.put(new Integer(1577072), "Radiopharmaceutical Route");
        dict.put(new Integer(1577073), "Radiopharmaceutical Volume");
        dict.put(new Integer(1577074), "Radiopharmaceutical Start Time");
        dict.put(new Integer(1577075), "Radiopharmaceutical Stop Time");
        dict.put(new Integer(1577076), "Radionuclide Total Dose");
        dict.put(new Integer(1577077), "Radionuclide Half Life");
        dict.put(new Integer(1577078), "Radionuclide Positron Fraction");
        dict.put(new Integer(1577079), "Radiopharmaceutical Specific Activity");
        dict.put(new Integer(0x181080), "Beat Rejection Flag");
        dict.put(new Integer(0x181081), "Low R-R Value");
        dict.put(new Integer(1577090), "High R-R Value");
        dict.put(new Integer(1577091), "Intervals Acquired");
        dict.put(new Integer(1577092), "Intervals Rejected");
        dict.put(new Integer(1577093), "PVC Rejection");
        dict.put(new Integer(1577094), "Skip Beats");
        dict.put(new Integer(0x181088), "Heart Rate");
        dict.put(new Integer(1577104), "Cardiac Number of Images");
        dict.put(new Integer(1577108), "Trigger Window");
        dict.put(new Integer(0x181100), "Reconstruction Diameter");
        dict.put(new Integer(0x181110), "Distance Source to Detector");
        dict.put(new Integer(0x181111), "Distance Source to Patient");
        dict.put(new Integer(0x181114), "Estimated Radiographic Mag. Factor");
        dict.put(new Integer(1577248), "Gantry/Detector Tilt");
        dict.put(new Integer(0x181121), "Gantry/Detector Skew");
        dict.put(new Integer(1577264), "Table Height");
        dict.put(new Integer(0x181131), "Table Traverse");
        dict.put(new Integer(1577268), "Table Motion");
        dict.put(new Integer(1577269), "Table Vertical Increment");
        dict.put(new Integer(1577270), "Table Lateral Increment");
        dict.put(new Integer(1577271), "Table Longitudinal Increment");
        dict.put(new Integer(0x181138), "Table Angle");
        dict.put(new Integer(1577274), "Table Type");
        dict.put(new Integer(1577280), "Rotation Direction");
        dict.put(new Integer(0x181141), "Angular Position");
        dict.put(new Integer(1577282), "Radial Position");
        dict.put(new Integer(1577283), "Scan Arc");
        dict.put(new Integer(0x181144), "Angular Step");
        dict.put(new Integer(1577285), "Center of Rotation Offset");
        dict.put(new Integer(1577287), "Field of View Shape");
        dict.put(new Integer(1577289), "Field of View Dimension(s)");
        dict.put(new Integer(1577296), "Exposure Time");
        dict.put(new Integer(0x181151), "X-ray Tube Current");
        dict.put(new Integer(1577298), "Exposure");
        dict.put(new Integer(1577299), "Exposure in uAs");
        dict.put(new Integer(1577300), "Average Pulse Width");
        dict.put(new Integer(0x181155), "Radiation Setting");
        dict.put(new Integer(1577302), "Rectification Type");
        dict.put(new Integer(1577306), "Radiation Mode");
        dict.put(new Integer(1577310), "Image Area Dose Product");
        dict.put(new Integer(1577312), "Filter Type");
        dict.put(new Integer(0x181161), "Type of Filters");
        dict.put(new Integer(1577314), "Intensifier Size");
        dict.put(new Integer(1577316), "Imager Pixel Spacing");
        dict.put(new Integer(0x181166), "Grid");
        dict.put(new Integer(1577328), "Generator Power");
        dict.put(new Integer(0x181180), "Collimator/Grid Name");
        dict.put(new Integer(0x181181), "Collimator Type");
        dict.put(new Integer(0x181182), "Focal Distance");
        dict.put(new Integer(0x181183), "X Focus Center");
        dict.put(new Integer(0x181184), "Y Focus Center");
        dict.put(new Integer(1577360), "Focal Spot(s)");
        dict.put(new Integer(0x181191), "Anode Target Material");
        dict.put(new Integer(1577376), "Body Part Thickness");
        dict.put(new Integer(1577378), "Compression Force");
        dict.put(new Integer(1577472), "Date of Last Calibration");
        dict.put(new Integer(1577473), "Time of Last Calibration");
        dict.put(new Integer(1577488), "Convolution Kernel");
        dict.put(new Integer(1577538), "Actual Frame Duration");
        dict.put(new Integer(1577539), "Count Rate");
        dict.put(new Integer(1577540), "Preferred Playback Sequencing");
        dict.put(new Integer(1577552), "Receive Coil Name");
        dict.put(new Integer(1577553), "Transmit Coil Name");
        dict.put(new Integer(1577568), "Plate Type");
        dict.put(new Integer(1577569), "Phosphor Type");
        dict.put(new Integer(1577728), "Scan Velocity");
        dict.put(new Integer(1577729), "Whole Body Technique");
        dict.put(new Integer(1577730), "Scan Length");
        dict.put(new Integer(1577744), "Acquisition Matrix");
        dict.put(new Integer(1577746), "In-plane Phase Encoding Direction");
        dict.put(new Integer(1577748), "Flip Angle");
        dict.put(new Integer(1577749), "Variable Flip Angle Flag");
        dict.put(new Integer(1577750), "SAR");
        dict.put(new Integer(0x181318), "dB/dt");
        dict.put(new Integer(1577984), "Acquisition Device Processing Descr.");
        dict.put(new Integer(1577985), "Acquisition Device Processing Code");
        dict.put(new Integer(1577986), "Cassette Orientation");
        dict.put(new Integer(1577987), "Cassette Size");
        dict.put(new Integer(1577988), "Exposures on Plate");
        dict.put(new Integer(1577989), "Relative X-ray Exposure");
        dict.put(new Integer(1578064), "Column Angulation");
        dict.put(new Integer(1578080), "Tomo Layer Height");
        dict.put(new Integer(1578096), "Tomo Angle");
        dict.put(new Integer(1578112), "Tomo Time");
        dict.put(new Integer(1578128), "Tomo Type");
        dict.put(new Integer(1578129), "Tomo Class");
        dict.put(new Integer(1578133), "Number of Tomosynthesis Source Images");
        dict.put(new Integer(1578240), "Positioner Motion");
        dict.put(new Integer(1578248), "Positioner Type");
        dict.put(new Integer(1578256), "Positioner Primary Angle");
        dict.put(new Integer(0x181511), "Positioner Secondary Angle");
        dict.put(new Integer(1578272), "Positioner Primary Angle Increment");
        dict.put(new Integer(1578273), "Positioner Secondary Angle Increment");
        dict.put(new Integer(1578288), "Detector Primary Angle");
        dict.put(new Integer(1578289), "Detector Secondary Angle");
        dict.put(new Integer(1578496), "Shutter Shape");
        dict.put(new Integer(1578498), "Shutter Left Vertical Edge");
        dict.put(new Integer(1578500), "Shutter Right Vertical Edge");
        dict.put(new Integer(1578502), "Shutter Upper Horizontal Edge");
        dict.put(new Integer(1578504), "Shutter Lower Horizontal Edge");
        dict.put(new Integer(1578512), "Center of Circular Shutter");
        dict.put(new Integer(1578514), "Radius of Circular Shutter");
        dict.put(new Integer(1578528), "Vertices of the Polygonal Shutter");
        dict.put(new Integer(1578530), "Shutter Presentation Value");
        dict.put(new Integer(1578531), "Shutter Overlay Group");
        dict.put(new Integer(1578752), "Collimator Shape");
        dict.put(new Integer(1578754), "Collimator Left Vertical Edge");
        dict.put(new Integer(1578756), "Collimator Right Vertical Edge");
        dict.put(new Integer(1578758), "Collimator Upper Horizontal Edge");
        dict.put(new Integer(1578760), "Collimator Lower Horizontal Edge");
        dict.put(new Integer(1578768), "Center of Circular Collimator");
        dict.put(new Integer(1578770), "Radius of Circular Collimator");
        dict.put(new Integer(1578784), "Vertices of the polygonal Collimator");
        dict.put(new Integer(0x181800), "Acquisition Time Synchronized");
        dict.put(new Integer(0x181801), "Time Source");
        dict.put(new Integer(1579010), "Time Distribution Protocol");
        dict.put(new Integer(1579011), "NTP Source Address");
        dict.put(new Integer(1581057), "Page Number Vector");
        dict.put(new Integer(1581058), "Frame Label Vector");
        dict.put(new Integer(1581059), "Frame Primary Angle Vector");
        dict.put(new Integer(1581060), "Frame Secondary Angle Vector");
        dict.put(new Integer(1581061), "Slice Location Vector");
        dict.put(new Integer(1581062), "Display Window Label Vector");
        dict.put(new Integer(1581072), "Nominal Scanned Pixel Spacing");
        dict.put(new Integer(1581088), "Digitizing Device Transport Direction");
        dict.put(new Integer(1581104), "Rotation of Scanned Film");
        dict.put(new Integer(1585408), "IVUS Acquisition");
        dict.put(new Integer(1585409), "IVUS Pullback Rate");
        dict.put(new Integer(1585410), "IVUS Gated Rate");
        dict.put(new Integer(1585411), "IVUS Pullback Start Frame Number");
        dict.put(new Integer(1585412), "IVUS Pullback Stop Frame Number");
        dict.put(new Integer(1585413), "Lesion Number");
        dict.put(new Integer(1593344), "Output Power");
        dict.put(new Integer(1593360), "Transducer Data");
        dict.put(new Integer(1593362), "Focus Depth");
        dict.put(new Integer(1593376), "Processing Function");
        dict.put(new Integer(1593377), "Postprocessing Fuction");
        dict.put(new Integer(1593378), "Mechanical Index");
        dict.put(new Integer(1593380), "Bone Thermal Index");
        dict.put(new Integer(1593382), "Cranial Thermal Index");
        dict.put(new Integer(1593383), "Soft Tissue Thermal Index");
        dict.put(new Integer(1593384), "Soft Tissue-focus Thermal Index");
        dict.put(new Integer(1593385), "Soft Tissue-surface Thermal Index");
        dict.put(new Integer(1593424), "Depth of scan field");
        dict.put(new Integer(1593600), "Patient Position");
        dict.put(new Integer(1593601), "View Position");
        dict.put(new Integer(1593604), "Projection Eponymous Name Code");
        dict.put(new Integer(1597440), "Sensitivity");
        dict.put(new Integer(1597457), "Sequence of Ultrasound Regions");
        dict.put(new Integer(1597458), "Region Spatial Format");
        dict.put(new Integer(1597460), "Region Data Type");
        dict.put(new Integer(1597462), "Region Flags");
        dict.put(new Integer(1597464), "Region Location Min X0");
        dict.put(new Integer(1597466), "Region Location Min Y0");
        dict.put(new Integer(1597468), "Region Location Max X1");
        dict.put(new Integer(1597470), "Region Location Max Y1");
        dict.put(new Integer(1597472), "Reference Pixel X0");
        dict.put(new Integer(1597474), "Reference Pixel Y0");
        dict.put(new Integer(1597476), "Physical Units X Direction");
        dict.put(new Integer(1597478), "Physical Units Y Direction");
        dict.put(new Integer(1597480), "Reference Pixel Physical Value X");
        dict.put(new Integer(1597482), "Reference Pixel Physical Value Y");
        dict.put(new Integer(1597484), "Physical Delta X");
        dict.put(new Integer(1597486), "Physical Delta Y");
        dict.put(new Integer(1597488), "Transducer Frequency");
        dict.put(new Integer(1597489), "Transducer Type");
        dict.put(new Integer(1597490), "Pulse Repetition Frequency");
        dict.put(new Integer(1597492), "Doppler Correction Angle");
        dict.put(new Integer(1597494), "Steering Angle");
        dict.put(new Integer(1597497), "Doppler Sample Volume X Position");
        dict.put(new Integer(1597499), "Doppler Sample Volume Y Position");
        dict.put(new Integer(1597501), "TM-Line Position X0");
        dict.put(new Integer(1597503), "TM-Line Position Y0");
        dict.put(new Integer(1597505), "TM-Line Position X1");
        dict.put(new Integer(1597507), "TM-Line Position Y1");
        dict.put(new Integer(1597508), "Pixel Component Organization");
        dict.put(new Integer(1597510), "Pixel Component Mask");
        dict.put(new Integer(1597512), "Pixel Component Range Start");
        dict.put(new Integer(1597514), "Pixel Component Range Stop");
        dict.put(new Integer(1597516), "Pixel Component Physical Units");
        dict.put(new Integer(1597518), "Pixel Component Data Type");
        dict.put(new Integer(1597520), "Number of Table Break Points");
        dict.put(new Integer(1597522), "Table of X Break Points");
        dict.put(new Integer(1597524), "Table of Y Break Points");
        dict.put(new Integer(1597526), "Number of Table Entries");
        dict.put(new Integer(1597528), "Table of Pixel Values");
        dict.put(new Integer(1597530), "Table of Parameter Values");
        dict.put(new Integer(1597536), "R Wave Time Vector");
        dict.put(new Integer(1601536), "Detector Conditions Nominal Flag");
        dict.put(new Integer(1601537), "Detector Temperature");
        dict.put(new Integer(1601540), "Detector Type");
        dict.put(new Integer(1601541), "Detector Configuration");
        dict.put(new Integer(1601542), "Detector Description");
        dict.put(new Integer(1601544), "Detector Mode");
        dict.put(new Integer(1601546), "Detector ID");
        dict.put(new Integer(1601548), "Date of Last Detector Calibration");
        dict.put(new Integer(1601550), "Time of Last Detector Calibration");
        dict.put(new Integer(1601554), "Detector Time Since Last Exposure");
        dict.put(new Integer(1601556), "Detector Active Time");
        dict.put(new Integer(1601558), "Detector Activation Offset");
        dict.put(new Integer(1601562), "Detector Binning");
        dict.put(new Integer(1601568), "Detector Element Physical Size");
        dict.put(new Integer(1601570), "Detector Element Spacing");
        dict.put(new Integer(1601572), "Detector Active Shape");
        dict.put(new Integer(1601574), "Detector Active Dimension(s)");
        dict.put(new Integer(1601576), "Detector Active Origin");
        dict.put(new Integer(1601578), "Detector Manufacturer Name");
        dict.put(new Integer(1601579), "Detector Model Name");
        dict.put(new Integer(1601584), "Field of View Origin");
        dict.put(new Integer(1601586), "Field of View Rotation");
        dict.put(new Integer(1601588), "Field of View Horizontal Flip");
        dict.put(new Integer(1601600), "Grid Absorbing Material");
        dict.put(new Integer(1601601), "Grid Spacing Material");
        dict.put(new Integer(1601602), "Grid Thickness");
        dict.put(new Integer(1601604), "Grid Pitch");
        dict.put(new Integer(1601606), "Grid Aspect Ratio");
        dict.put(new Integer(1601608), "Grid Period");
        dict.put(new Integer(1601612), "Grid Focal Distance");
        dict.put(new Integer(1601616), "Filter Material");
        dict.put(new Integer(1601618), "Filter Thickness Min");
        dict.put(new Integer(1601620), "Filter Thickness Max");
        dict.put(new Integer(1601632), "Exposure Control Mode");
        dict.put(new Integer(0x20000D), "Study Instance UID");
        dict.put(new Integer(0x20000E), "Series Instance UID");
        dict.put(new Integer(0x200011), "Series Number");
        dict.put(new Integer(0x200012), "Acquisition Number");
        dict.put(new Integer(2097171), "Instance Number");
        dict.put(new Integer(0x200020), "Patient Orientation");
        dict.put(new Integer(0x200030), "Image Position");
        dict.put(new Integer(0x200032), "Image Position (Patient)");
        dict.put(new Integer(2097207), "Image Orientation (Patient)");
        dict.put(new Integer(0x200050), "Location");
        dict.put(new Integer(0x200052), "Frame of Reference UID");
        dict.put(new Integer(0x200070), "Image Geometry Type");
        dict.put(new Integer(0x201001), "Acquisitions in Series");
        dict.put(new Integer(0x201020), "Reference");
        dict.put(new Integer(2101313), "Slice Location");
        dict.put(new Integer(0x280002), "Samples per pixel");
        dict.put(new Integer(2621443), "Samples per pixel used");
        dict.put(new Integer(2621444), "Photometric Interpretation");
        dict.put(new Integer(2621446), "Planar Configuration");
        dict.put(new Integer(0x280008), "Number of frames");
        dict.put(new Integer(2621449), "Frame Increment Pointer");
        dict.put(new Integer(2621450), "Frame Dimension Pointer");
        dict.put(new Integer(2621456), "Rows");
        dict.put(new Integer(2621457), "Columns");
        dict.put(new Integer(2621458), "Planes");
        dict.put(new Integer(2621460), "Ultrasound Color Data Present");
        dict.put(new Integer(2621488), "Pixel Spacing");
        dict.put(new Integer(2621489), "Zoom Factor");
        dict.put(new Integer(2621490), "Zoom Center");
        dict.put(new Integer(2621492), "Pixel Aspect Ratio");
        dict.put(new Integer(2621521), "Corrected Image");
        dict.put(new Integer(2621696), "Bits Allocated");
        dict.put(new Integer(2621697), "Bits Stored");
        dict.put(new Integer(2621698), "High Bit");
        dict.put(new Integer(2621699), "Pixel Representation");
        dict.put(new Integer(2621702), "Smallest Image Pixel Value");
        dict.put(new Integer(2621703), "Largest Image Pixel Value");
        dict.put(new Integer(2621704), "Smallest Pixel Value in Series");
        dict.put(new Integer(2621705), "Largest Pixel Value in Series");
        dict.put(new Integer(2621712), "Smallest Image Pixel Value in Plane");
        dict.put(new Integer(2621713), "Largest Image Pixel Value in Plane");
        dict.put(new Integer(2621728), "Pixel Padding Value");
        dict.put(new Integer(2622208), "Quality Control Image");
        dict.put(new Integer(2622209), "Burned in Annotation");
        dict.put(new Integer(2625600), "Pixel Intensity Relationship");
        dict.put(new Integer(2625601), "Pixel Intensity Relationship Sign");
        dict.put(new Integer(2625616), "Window Center");
        dict.put(new Integer(2625617), "Window Width");
        dict.put(new Integer(2625618), "Rescale Intercept");
        dict.put(new Integer(2625619), "Rescale Slope");
        dict.put(new Integer(2625620), "Rescale Type");
        dict.put(new Integer(2625621), "Window Center and Width Explanation");
        dict.put(new Integer(2625680), "Recommended Viewing Mode");
        dict.put(new Integer(2625793), "Red Palette Color LUT Descriptor");
        dict.put(new Integer(2625794), "Green Palette Color LUT Descriptor");
        dict.put(new Integer(2625795), "Blue Palette Color LUT Descriptor");
        dict.put(new Integer(2625945), "Palette Color LUT UID");
        dict.put(new Integer(2626049), "Red Palette Color LUT Data");
        dict.put(new Integer(2626050), "Green Palette Color LUT Data");
        dict.put(new Integer(2626051), "Blue Palette Color LUT Data");
        dict.put(new Integer(0x281221), "Segmented Red Palette Color LUT Data");
        dict.put(new Integer(0x281222), "Segmented Green Palette Color LUT Data");
        dict.put(new Integer(2626083), "Segmented Blue Palette Color LUT Data");
        dict.put(new Integer(2626304), "Implant Present");
        dict.put(new Integer(2626384), "Partial View");
        dict.put(new Integer(2626385), "Partial View Description");
        dict.put(new Integer(2629904), "Lossy Image Compression");
        dict.put(new Integer(0x282112), "Lossy Image Compression Ratio");
        dict.put(new Integer(2629908), "Lossy Image Compression Method");
        dict.put(new Integer(2633728), "Modality LUT Sequence");
        dict.put(new Integer(2633730), "LUT Descriptor");
        dict.put(new Integer(2633731), "LUT Explanation");
        dict.put(new Integer(2633732), "Modality LUT Type");
        dict.put(new Integer(2633734), "LUT Data");
        dict.put(new Integer(2633744), "VOI LUT Sequence");
        dict.put(new Integer(2634000), "Softcopy VOI LUT Sequence");
        dict.put(new Integer(2641920), "Bi-Plane Acquisition Sequence");
        dict.put(new Integer(2646032), "Representative Frame Number");
        dict.put(new Integer(2646048), "Frame Numbers of Interest (FOI)");
        dict.put(new Integer(2646050), "Frame(s) of Interest Description");
        dict.put(new Integer(2646051), "Frame of Interest Type");
        dict.put(new Integer(2646080), "R Wave Pointer");
        dict.put(new Integer(2646272), "Mask Subtraction Sequence");
        dict.put(new Integer(2646273), "Mask Operation");
        dict.put(new Integer(2646274), "Applicable Frame Range");
        dict.put(new Integer(2646288), "Mask Frame Numbers");
        dict.put(new Integer(2646290), "Contrast Frame Averaging");
        dict.put(new Integer(2646292), "Mask Sub-pixel Shift");
        dict.put(new Integer(2646304), "TID Offset");
        dict.put(new Integer(2646416), "Mask Operation Explanation");
        dict.put(new Integer(2658305), "Data Point Rows");
        dict.put(new Integer(2658306), "Data Point Columns");
        dict.put(new Integer(2658307), "Signal Domain Columns");
        dict.put(new Integer(2658568), "Data Representation");
        dict.put(new Integer(2658576), "Pixel Measures Sequence");
        dict.put(new Integer(2658610), "Frame VOI LUT Sequence");
        dict.put(new Integer(2658629), "Pixel Value Transformation Sequence");
        dict.put(new Integer(2658869), "Signal Domain Rows");
        dict.put(new Integer(5505041), "Number of Energy Windows");
        dict.put(new Integer(5505057), "Number of Detectors");
        dict.put(new Integer(5505105), "Number of Rotations");
        dict.put(new Integer(5505152), "Slice Vector");
        dict.put(new Integer(5505153), "Number of Slices");
        dict.put(new Integer(5505538), "Type of Detector Motion");
        dict.put(new Integer(0x540400), "Image ID");
        dict.put(new Integer(0x20100100), "Border Density");
        return dict;
    }
}

