/*
 * Decompiled with CFR 0.152.
 */
package visad.bom;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.rmi.RemoteException;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.CellImpl;
import visad.ConstantMap;
import visad.CoordinateSystem;
import visad.Data;
import visad.DataDisplayLink;
import visad.DataReference;
import visad.DataReferenceImpl;
import visad.DataRenderer;
import visad.Display;
import visad.DisplayImpl;
import visad.DisplayRenderer;
import visad.FlatField;
import visad.FunctionType;
import visad.GraphicsModeControl;
import visad.Integer1DSet;
import visad.Linear1DSet;
import visad.Linear2DSet;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.SetType;
import visad.ShadowType;
import visad.ShapeControl;
import visad.Text;
import visad.TextControl;
import visad.TextType;
import visad.Tuple;
import visad.VisADException;
import visad.VisADGeometryArray;
import visad.VisADLineArray;
import visad.VisADRay;
import visad.java2d.DirectManipulationRendererJ2D;
import visad.java2d.DisplayImplJ2D;

public class PickManipulationRendererJ2D
extends DirectManipulationRendererJ2D {
    private int mouseModifiersMask = 0;
    private int mouseModifiersValue = 0;
    private transient DataDisplayLink link = null;
    private transient DataReference ref = null;
    private float[][] spatialValues = null;
    private int closeIndex = -1;
    private int directManifoldDimension = -1;
    private String whyNotDirect = null;
    private static final String notSimpleField = "not simple field";
    private static final String notSimpleTuple = "not simple tuple";
    private boolean stop = false;

    public PickManipulationRendererJ2D() {
        this(0, 0);
    }

    public PickManipulationRendererJ2D(int mmm, int mmv) {
        this.mouseModifiersMask = mmm;
        this.mouseModifiersValue = mmv;
    }

    public void checkDirect() throws VisADException, RemoteException {
        this.setIsDirectManipulation(false);
        DisplayImpl display = this.getDisplay();
        DataDisplayLink[] Links = this.getLinks();
        if (Links == null || Links.length == 0) {
            this.link = null;
            return;
        }
        this.link = Links[0];
        this.ref = this.link.getDataReference();
        ShadowType shadow = this.link.getShadow().getAdaptedShadowType();
        MathType type = this.link.getType();
        if (type instanceof FunctionType) {
            if (shadow.getLevelOfDifficulty() != 3) {
                this.whyNotDirect = notSimpleField;
                return;
            }
        } else if (type instanceof SetType) {
            if (shadow.getLevelOfDifficulty() != 3) {
                this.whyNotDirect = notSimpleField;
                return;
            }
        } else if (shadow.getLevelOfDifficulty() != 5) {
            this.whyNotDirect = notSimpleTuple;
            return;
        }
        this.setIsDirectManipulation(true);
    }

    private int getDirectManifoldDimension() {
        return this.directManifoldDimension;
    }

    public String getWhyNotDirect() {
        return this.whyNotDirect;
    }

    public void addPoint(float[] x) throws VisADException {
    }

    public CoordinateSystem getDisplayCoordinateSystem() {
        return null;
    }

    public synchronized void setSpatialValues(float[][] spatial_values) {
        this.spatialValues = spatial_values;
    }

    public synchronized float checkClose(double[] origin, double[] direction) {
        int mouseModifiers = this.getLastMouseModifiers();
        if ((mouseModifiers & this.mouseModifiersMask) != this.mouseModifiersValue) {
            return Float.MAX_VALUE;
        }
        float distance = Float.MAX_VALUE;
        if (this.spatialValues == null) {
            return distance;
        }
        float o_x = (float)origin[0];
        float o_y = (float)origin[1];
        float o_z = (float)origin[2];
        float d_x = (float)direction[0];
        float d_y = (float)direction[1];
        float d_z = (float)direction[2];
        for (int i = 0; i < this.spatialValues[0].length; ++i) {
            float dot;
            float d;
            float x = this.spatialValues[0][i] - o_x;
            float y = this.spatialValues[1][i] - o_y;
            float z = this.spatialValues[2][i] - o_z;
            if (!((d = (float)Math.sqrt((x -= (dot = x * d_x + y * d_y + z * d_z) * d_x) * x + (y -= dot * d_y) * y + (z -= dot * d_z) * z)) < distance)) continue;
            distance = d;
            this.closeIndex = i;
        }
        return distance;
    }

    public int getCloseIndex() {
        return this.closeIndex;
    }

    public synchronized void drag_direct(VisADRay ray, boolean first, int mouseModifiers) {
        if (this.ref == null) {
            return;
        }
        if (first) {
            try {
                this.ref.setData(this.ref.getData());
            }
            catch (VisADException e) {
            }
            catch (RemoteException e) {
                // empty catch block
            }
        }
    }

    public static void main(String[] args) throws VisADException, RemoteException {
        RealType x = RealType.getRealType("x");
        RealType y = RealType.getRealType("y");
        FunctionType f1d = new FunctionType(x, y);
        RealTupleType xy = new RealTupleType(x, y);
        TextType t = new TextType("text");
        RealType s2 = RealType.getRealType("shape");
        Data[] td = new Data[]{new Real(x, 0.5), new Real(y, 0.5), new Text(t, "text")};
        Tuple text = new Tuple(td);
        Real[] sd = new Real[]{new Real(x, -0.5), new Real(y, -0.5), new Real(s2, 0.0)};
        RealTuple shape = new RealTuple(sd);
        Real real = new Real(x, -0.5);
        Real[] rtd = new Real[]{new Real(x, 0.5), new Real(y, -0.5)};
        RealTuple real_tuple = new RealTuple(rtd);
        FlatField field1d = new FlatField(f1d, new Linear1DSet((MathType)x, -1.0, -0.5, 64));
        double[][] values = new double[1][64];
        for (int i = 0; i < 64; ++i) {
            values[0][i] = 0.5 + Math.abs((double)i - 31.5) / 63.0;
        }
        field1d.setSamples(values);
        Linear2DSet set2d = new Linear2DSet((MathType)xy, 0.5, 1.0, 32, -0.25, 0.25, 32);
        DisplayImplJ2D display = new DisplayImplJ2D("display");
        DisplayRenderer dr = display.getDisplayRenderer();
        dr.setPickThreshhold(0.2f);
        ScalarMap xmap = new ScalarMap(x, Display.XAxis);
        display.addMap(xmap);
        xmap.setRange(-1.0, 1.0);
        ScalarMap ymap = new ScalarMap(y, Display.YAxis);
        display.addMap(ymap);
        ymap.setRange(-1.0, 1.0);
        ScalarMap tmap = new ScalarMap(t, Display.Text);
        display.addMap(tmap);
        TextControl tcontrol = (TextControl)tmap.getControl();
        tcontrol.setCenter(true);
        ScalarMap smap = new ScalarMap(s2, Display.Shape);
        display.addMap(smap);
        ShapeControl scontrol = (ShapeControl)smap.getControl();
        scontrol.setShapeSet(new Integer1DSet((MathType)s2, 1));
        VisADLineArray cross = new VisADLineArray();
        cross.coordinates = new float[]{0.1f, 0.1f, 0.0f, -0.1f, -0.1f, 0.0f, 0.1f, -0.1f, 0.0f, -0.1f, 0.1f, 0.0f};
        cross.vertexCount = cross.coordinates.length / 3;
        scontrol.setShapes(new VisADGeometryArray[]{cross});
        GraphicsModeControl mode = ((DisplayImpl)display).getGraphicsModeControl();
        mode.setScaleEnable(true);
        DataReferenceImpl tref = new DataReferenceImpl("text");
        tref.setData(text);
        display.addReferences((DataRenderer)new PickManipulationRendererJ2D(), tref);
        CellImpl cellt = new CellImpl(){
            private boolean first = true;

            public void doAction() throws VisADException, RemoteException {
                if (this.first) {
                    this.first = false;
                } else {
                    System.out.println("text picked");
                }
            }
        };
        cellt.addReference(tref);
        DataReferenceImpl sref = new DataReferenceImpl("shape");
        sref.setData(shape);
        display.addReferences((DataRenderer)new PickManipulationRendererJ2D(), sref);
        CellImpl cells = new CellImpl(){
            private boolean first = true;

            public void doAction() throws VisADException, RemoteException {
                if (this.first) {
                    this.first = false;
                } else {
                    System.out.println("shape picked");
                }
            }
        };
        cells.addReference(sref);
        DataReferenceImpl rref = new DataReferenceImpl("Real");
        rref.setData(real);
        ConstantMap[] rmaps = new ConstantMap[]{new ConstantMap(5.0, Display.PointSize)};
        display.addReferences((DataRenderer)new PickManipulationRendererJ2D(), rref, rmaps);
        CellImpl cellr = new CellImpl(){
            private boolean first = true;

            public void doAction() throws VisADException, RemoteException {
                if (this.first) {
                    this.first = false;
                } else {
                    System.out.println("Real picked");
                }
            }
        };
        cellr.addReference(rref);
        DataReferenceImpl rtref = new DataReferenceImpl("RealTuple");
        rtref.setData(real_tuple);
        ConstantMap[] rtmaps = new ConstantMap[]{new ConstantMap(5.0, Display.PointSize)};
        display.addReferences((DataRenderer)new PickManipulationRendererJ2D(), rtref, rtmaps);
        CellImpl cellrt = new CellImpl(){
            private boolean first = true;

            public void doAction() throws VisADException, RemoteException {
                if (this.first) {
                    this.first = false;
                } else {
                    System.out.println("RealTuple picked");
                }
            }
        };
        cellrt.addReference(rtref);
        DataReferenceImpl field1dref = new DataReferenceImpl("field1d");
        field1dref.setData(field1d);
        final PickManipulationRendererJ2D pmr1d = new PickManipulationRendererJ2D();
        display.addReferences((DataRenderer)pmr1d, field1dref);
        CellImpl cellfield1d = new CellImpl(){
            private boolean first = true;

            public void doAction() throws VisADException, RemoteException {
                if (this.first) {
                    this.first = false;
                } else {
                    int i = pmr1d.getCloseIndex();
                    System.out.println("1-D Field picked, index = " + i);
                }
            }
        };
        cellfield1d.addReference(field1dref);
        DataReferenceImpl setref = new DataReferenceImpl("set");
        setref.setData(set2d);
        final PickManipulationRendererJ2D pmrset = new PickManipulationRendererJ2D();
        display.addReferences((DataRenderer)pmrset, setref);
        CellImpl cellset = new CellImpl(){
            private boolean first = true;

            public void doAction() throws VisADException, RemoteException {
                if (this.first) {
                    this.first = false;
                } else {
                    int i = pmrset.getCloseIndex();
                    System.out.println("set picked, index = " + i);
                }
            }
        };
        cellset.addReference(setref);
        JFrame frame = new JFrame("test PickManipulationRendererJ2D");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setAlignmentY(0.0f);
        panel.setAlignmentX(0.0f);
        frame.getContentPane().add(panel);
        panel.add(display.getComponent());
        frame.setSize(500, 500);
        frame.setVisible(true);
    }
}

