/*
 * Decompiled with CFR 0.152.
 */
package visad.python;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.TreeSet;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import ucar.netcdf.NetcdfFile;
import visad.AxisScale;
import visad.ConstantMap;
import visad.CoordinateSystem;
import visad.Data;
import visad.DataImpl;
import visad.Display;
import visad.DisplayImpl;
import visad.Field;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded2DSet;
import visad.Gridded3DSet;
import visad.GriddedSet;
import visad.Integer1DSet;
import visad.Integer2DSet;
import visad.Linear1DSet;
import visad.Linear2DSet;
import visad.Linear3DSet;
import visad.LinearNDSet;
import visad.MathType;
import visad.Real;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.ScalarMap;
import visad.Set;
import visad.SetType;
import visad.TupleType;
import visad.UnionSet;
import visad.Unit;
import visad.VisADException;
import visad.data.DefaultFamily;
import visad.data.mcidas.PointDataAdapter;
import visad.data.netcdf.Plain;
import visad.data.netcdf.QuantityDBManager;
import visad.data.netcdf.in.DefaultView;
import visad.data.netcdf.in.NetcdfAdapter;
import visad.data.units.NoSuchUnitException;
import visad.data.units.ParseException;
import visad.data.units.Parser;
import visad.jmet.DumpType;
import visad.math.FFT;
import visad.math.Histogram;
import visad.matrix.JamaCholeskyDecomposition;
import visad.matrix.JamaEigenvalueDecomposition;
import visad.matrix.JamaLUDecomposition;
import visad.matrix.JamaMatrix;
import visad.matrix.JamaQRDecomposition;
import visad.matrix.JamaSingularValueDecomposition;
import visad.ss.BasicSSCell;
import visad.ss.FancySSCell;
import visad.util.Util;

public abstract class JPythonMethods {
    private static final String DEFAULT_NAME = "Jython";
    private static final String ID = JPythonMethods.class.getName();
    private static DefaultFamily form = new DefaultFamily(ID);
    private static final String[] ops = new String[]{"gt", "ge", "lt", "le", "eq", "ne", "ne", "ge", "le"};
    private static final String[] ops_sym = new String[]{">", ">=", "<", "<=", "==", "!=", "<>", "=>", "=<"};
    public static Hashtable JyVars = new Hashtable();
    private static Hashtable<String, JFrame> frames = new Hashtable();

    public static DataImpl load(String location) throws VisADException {
        return form.open(location);
    }

    public static void plot(float[] data) throws VisADException, RemoteException {
        JPythonMethods.plot(null, JPythonMethods.field(data), false, 1.0, 1.0, 1.0);
    }

    public static void plot(float[][] data) throws VisADException, RemoteException {
        JPythonMethods.plot(null, JPythonMethods.field(data), false, 1.0, 1.0, 1.0);
    }

    public static void plot(DataImpl data) throws VisADException, RemoteException {
        JPythonMethods.plot(null, data, false, 1.0, 1.0, 1.0);
    }

    public static void plot(float[] data, ScalarMap[] maps) throws VisADException, RemoteException {
        JPythonMethods.plot(null, JPythonMethods.field(data), false, 1.0, 1.0, 1.0, maps);
    }

    public static void plot(float[][] data, ScalarMap[] maps) throws VisADException, RemoteException {
        JPythonMethods.plot(null, JPythonMethods.field(data), false, 1.0, 1.0, 1.0, maps);
    }

    public static void plot(DataImpl data, ScalarMap[] maps) throws VisADException, RemoteException {
        JPythonMethods.plot(null, data, false, 1.0, 1.0, 1.0, maps);
    }

    public static void plot(float[] data, boolean editMaps) throws VisADException, RemoteException {
        JPythonMethods.plot(null, JPythonMethods.field(data), editMaps, 1.0, 1.0, 1.0);
    }

    public static void plot(float[][] data, boolean editMaps) throws VisADException, RemoteException {
        JPythonMethods.plot(null, JPythonMethods.field(data), editMaps, 1.0, 1.0, 1.0);
    }

    public static void plot(DataImpl data, boolean editMaps) throws VisADException, RemoteException {
        JPythonMethods.plot(null, data, editMaps, 1.0, 1.0, 1.0);
    }

    public static void plot(String name, float[] data) throws VisADException, RemoteException {
        JPythonMethods.plot(name, JPythonMethods.field(data), false, 1.0, 1.0, 1.0);
    }

    public static void plot(String name, float[][] data) throws VisADException, RemoteException {
        JPythonMethods.plot(name, JPythonMethods.field(data), false, 1.0, 1.0, 1.0);
    }

    public static void plot(String name, DataImpl data) throws VisADException, RemoteException {
        JPythonMethods.plot(name, data, false, 1.0, 1.0, 1.0);
    }

    public static void plot(String name, float[] data, ScalarMap[] maps) throws VisADException, RemoteException {
        JPythonMethods.plot(name, JPythonMethods.field(data), false, 1.0, 1.0, 1.0, maps);
    }

    public static void plot(String name, float[][] data, ScalarMap[] maps) throws VisADException, RemoteException {
        JPythonMethods.plot(name, JPythonMethods.field(data), false, 1.0, 1.0, 1.0, maps);
    }

    public static void plot(String name, DataImpl data, ScalarMap[] maps) throws VisADException, RemoteException {
        JPythonMethods.plot(name, data, false, 1.0, 1.0, 1.0, maps);
    }

    public static void plot(String name, float[] data, boolean editMaps) throws VisADException, RemoteException {
        JPythonMethods.plot(name, JPythonMethods.field(data), editMaps, 1.0, 1.0, 1.0);
    }

    public static void plot(String name, float[][] data, boolean editMaps) throws VisADException, RemoteException {
        JPythonMethods.plot(name, JPythonMethods.field(data), editMaps, 1.0, 1.0, 1.0);
    }

    public static void plot(String name, DataImpl data, boolean editMaps) throws VisADException, RemoteException {
        JPythonMethods.plot(name, data, editMaps, 1.0, 1.0, 1.0);
    }

    public static void plot(float[] data, double red, double green, double blue) throws VisADException, RemoteException {
        JPythonMethods.plot(null, JPythonMethods.field(data), false, red, green, blue);
    }

    public static void plot(float[][] data, double red, double green, double blue) throws VisADException, RemoteException {
        JPythonMethods.plot(null, JPythonMethods.field(data), false, red, green, blue);
    }

    public static void plot(DataImpl data, double red, double green, double blue) throws VisADException, RemoteException {
        JPythonMethods.plot(null, data, false, red, green, blue);
    }

    public static void plot(String name, float[] data, boolean editMaps, double red, double green, double blue) throws VisADException, RemoteException {
        JPythonMethods.plot(name, JPythonMethods.field(data), editMaps, red, green, blue, null);
    }

    public static void plot(String name, float[][] data, boolean editMaps, double red, double green, double blue) throws VisADException, RemoteException {
        JPythonMethods.plot(name, JPythonMethods.field(data), editMaps, red, green, blue, null);
    }

    public static void plot(String name, DataImpl data, boolean editMaps, double red, double green, double blue) throws VisADException, RemoteException {
        JPythonMethods.plot(name, data, editMaps, red, green, blue, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void plot(String name, DataImpl data, boolean editMaps, double red, double green, double blue, ScalarMap[] maps) throws VisADException, RemoteException {
        BasicSSCell display;
        if (data == null) {
            throw new VisADException("Data cannot be null");
        }
        final String title = name == null ? DEFAULT_NAME : name;
        Hashtable<String, JFrame> hashtable = frames;
        synchronized (hashtable) {
            JFrame frame;
            display = BasicSSCell.getSSCellByName(title);
            if (display == null) {
                display = new FancySSCell(title);
                display.setDimension(1);
                display.setPreferredSize(new Dimension(256, 256));
                frame = new JFrame("VisAD Display Plot (" + title + ")");
                frames.put(title, frame);
                JPanel pane = new JPanel();
                pane.setLayout(new BoxLayout(pane, 1));
                frame.setContentPane(pane);
                pane.add(display);
                JButton mapping = new JButton("Mappings");
                JButton controls = new JButton("Controls");
                JButton clear = new JButton("Clear");
                JButton close = new JButton("Close");
                JPanel buttons = new JPanel();
                buttons.setLayout(new BoxLayout(buttons, 0));
                buttons.add(mapping);
                buttons.add(controls);
                buttons.add(clear);
                buttons.add(close);
                pane.add(buttons);
                final FancySSCell fdisp = (FancySSCell)display;
                fdisp.setAutoShowControls(false);
                if (maps != null) {
                    display.setMaps(maps);
                    fdisp.setAutoDetect(false);
                } else {
                    fdisp.setAutoDetect(!editMaps);
                }
                mapping.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        fdisp.addMapDialog();
                    }
                });
                controls.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        fdisp.showWidgetFrame();
                    }
                });
                close.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        try {
                            fdisp.smartClear();
                            JPythonMethods.clearplot(title);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
                clear.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        try {
                            fdisp.smartClear();
                        }
                        catch (VisADException exc) {
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                    }
                });
                frame.pack();
            } else {
                frame = frames.get(title);
            }
            frame.setVisible(true);
            frame.toFront();
        }
        ConstantMap[] cmaps = new ConstantMap[]{new ConstantMap(red, Display.Red), new ConstantMap(green, Display.Green), new ConstantMap(blue, Display.Blue)};
        display.addData(data, cmaps);
        if (editMaps) {
            ((FancySSCell)display).addMapDialog();
        }
    }

    public static void clearplot() throws VisADException, RemoteException {
        JPythonMethods.clearplot(null);
    }

    public static void clearplot(String name) throws VisADException, RemoteException {
        String title = name == null ? DEFAULT_NAME : name;
        BasicSSCell display = BasicSSCell.getSSCellByName(title);
        if (display != null) {
            JFrame frame = frames.get(title);
            display.clearCell();
            display.clearMaps();
            frame.setVisible(false);
            frame.dispose();
            frame = null;
            display.destroyCell();
            display = null;
        }
    }

    public static void saveNetcdf(String fn, Data d) throws VisADException, RemoteException, IOException {
        new Plain().save(fn, d, false);
    }

    public static void saveplot(DisplayImpl disp, String filename) throws VisADException, RemoteException, IOException {
        Util.captureDisplay(disp, filename);
    }

    public static void saveplot(String filename) throws VisADException, RemoteException, IOException {
        JPythonMethods.saveplot((String)null, filename);
    }

    public static void saveplot(String name, String filename) throws VisADException, RemoteException, IOException {
        if (name == null) {
            name = DEFAULT_NAME;
        }
        final BasicSSCell sscell = BasicSSCell.getSSCellByName(name);
        final String fn = filename;
        if (sscell != null) {
            Runnable captureDisp = new Runnable(){

                public void run() {
                    try {
                        sscell.captureImage(new File(fn));
                    }
                    catch (Exception se) {
                        System.out.println("Error saving plot = " + se);
                    }
                }
            };
            Thread ts = new Thread(captureDisp);
            ts.start();
        }
    }

    public static Data abs_data(Data data) throws VisADException, RemoteException {
        return data.abs();
    }

    @Deprecated
    public static Data abs(Data data) throws VisADException, RemoteException {
        return data.abs();
    }

    @Deprecated
    public static double abs(double value) {
        return Math.abs(value);
    }

    @Deprecated
    public static int abs(int value) {
        return Math.abs(value);
    }

    @Deprecated
    public static long abs(long value) {
        return Math.abs(value);
    }

    public static Data acos(Data data) throws VisADException, RemoteException {
        return data.acos();
    }

    public static Data acosDegrees(Data data) throws VisADException, RemoteException {
        return data.acosDegrees();
    }

    public static Data asin(Data data) throws VisADException, RemoteException {
        return data.asin();
    }

    public static Data asinDegrees(Data data) throws VisADException, RemoteException {
        return data.asinDegrees();
    }

    public static Data atan(Data data) throws VisADException, RemoteException {
        return data.atan();
    }

    public static Data atanDegrees(Data data) throws VisADException, RemoteException {
        return data.atanDegrees();
    }

    public static Data ceil(Data data) throws VisADException, RemoteException {
        return data.ceil();
    }

    public static Data cos(Data data) throws VisADException, RemoteException {
        return data.cos();
    }

    public static Data cosDegrees(Data data) throws VisADException, RemoteException {
        return data.cosDegrees();
    }

    public static Data exp(Data data) throws VisADException, RemoteException {
        return data.exp();
    }

    public static Data floor(Data data) throws VisADException, RemoteException {
        return data.floor();
    }

    public static Data log(Data data) throws VisADException, RemoteException {
        return data.log();
    }

    public static Data rint(Data data) throws VisADException, RemoteException {
        return data.rint();
    }

    public static Data round(Data data) throws VisADException, RemoteException {
        return data.round();
    }

    public static double round(double value, int digits) {
        boolean neg = value < 0.0;
        double multiple = Math.pow(10.0, digits);
        if (neg) {
            value = -value;
        }
        double tmp = Math.floor(value * multiple + 0.5);
        if (neg) {
            tmp = -tmp;
        }
        return tmp / multiple;
    }

    public static double round(double value) {
        return JPythonMethods.round(value, 0);
    }

    public static Data sin(Data data) throws VisADException, RemoteException {
        return data.sin();
    }

    public static Data sinDegrees(Data data) throws VisADException, RemoteException {
        return data.sinDegrees();
    }

    public static Data sqrt(Data data) throws VisADException, RemoteException {
        return data.sqrt();
    }

    public static Data tan(Data data) throws VisADException, RemoteException {
        return data.tan();
    }

    public static Data tanDegrees(Data data) throws VisADException, RemoteException {
        return data.tanDegrees();
    }

    public static Data atan2(Data data1, Data data2) throws VisADException, RemoteException {
        return data1.atan2(data2);
    }

    public static Data atan2Degrees(Data data1, Data data2) throws VisADException, RemoteException {
        return data1.atan2Degrees(data2);
    }

    public static Data atan2(Data data1, double data2) throws VisADException, RemoteException {
        return data1.atan2(new Real(data2));
    }

    public static Data atan2Degrees(Data data1, double data2) throws VisADException, RemoteException {
        return data1.atan2Degrees(new Real(data2));
    }

    public static Data max_data(Data data1, Data data2) throws VisADException, RemoteException {
        return data1.max(data2);
    }

    public static Data max_data(Data data1, double data2) throws VisADException, RemoteException {
        return data1.max(new Real(data2));
    }

    public static Data max_data(double data1, Data data2) throws VisADException, RemoteException {
        return new Real(data1).max(data2);
    }

    public static Data min_data(Data data1, Data data2) throws VisADException, RemoteException {
        return data1.min(data2);
    }

    public static Data min_data(Data data1, double data2) throws VisADException, RemoteException {
        return data1.min(new Real(data2));
    }

    public static Data min_data(double data1, Data data2) throws VisADException, RemoteException {
        return new Real(data1).min(data2);
    }

    public static Data atan2(double data1, Data data2) throws VisADException, RemoteException {
        return new Real(data1).atan2(data2);
    }

    public static Data atan2Degrees(double data1, Data data2) throws VisADException, RemoteException {
        return new Real(data1).atan2Degrees(data2);
    }

    public static FlatField fft(Field field) throws VisADException, RemoteException {
        return FFT.fourierTransform(field, true);
    }

    public static FlatField ifft(Field field) throws VisADException, RemoteException {
        return FFT.fourierTransform(field, false);
    }

    public static JamaMatrix matrixMultiply(FlatField data1, FlatField data2) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        JamaMatrix matrix1 = JamaMatrix.convertToMatrix(data1);
        JamaMatrix matrix2 = JamaMatrix.convertToMatrix(data2);
        return matrix1.times(matrix2);
    }

    public static JamaMatrix solve(FlatField data1, FlatField data2) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        JamaMatrix matrix1 = JamaMatrix.convertToMatrix(data1);
        JamaMatrix matrix2 = JamaMatrix.convertToMatrix(data2);
        return matrix1.solve(matrix2);
    }

    public static JamaMatrix inverse(FlatField data) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        JamaMatrix matrix = JamaMatrix.convertToMatrix(data);
        return matrix.inverse();
    }

    public static JamaMatrix transpose(FlatField data) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        JamaMatrix matrix = JamaMatrix.convertToMatrix(data);
        return matrix.transpose();
    }

    public static double det(FlatField data) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        JamaMatrix matrix = JamaMatrix.convertToMatrix(data);
        return matrix.det();
    }

    public static double norm1(FlatField data) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        JamaMatrix matrix = JamaMatrix.convertToMatrix(data);
        return matrix.norm1();
    }

    public static double norm2(FlatField data) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        JamaMatrix matrix = JamaMatrix.convertToMatrix(data);
        return matrix.norm2();
    }

    public static double normInf(FlatField data) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        JamaMatrix matrix = JamaMatrix.convertToMatrix(data);
        return matrix.normInf();
    }

    public static double normF(FlatField data) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        JamaMatrix matrix = JamaMatrix.convertToMatrix(data);
        return matrix.normF();
    }

    public static double rank(FlatField data) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        JamaMatrix matrix = JamaMatrix.convertToMatrix(data);
        return matrix.rank();
    }

    public static double cond(FlatField data) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        JamaMatrix matrix = JamaMatrix.convertToMatrix(data);
        return matrix.cond();
    }

    public static double trace(FlatField data) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        JamaMatrix matrix = JamaMatrix.convertToMatrix(data);
        return matrix.trace();
    }

    public static JamaCholeskyDecomposition chol(FlatField data) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        JamaMatrix matrix = JamaMatrix.convertToMatrix(data);
        return matrix.chol();
    }

    public static JamaEigenvalueDecomposition eig(FlatField data) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        JamaMatrix matrix = JamaMatrix.convertToMatrix(data);
        return matrix.eig();
    }

    public static JamaLUDecomposition lu(FlatField data) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        JamaMatrix matrix = JamaMatrix.convertToMatrix(data);
        return matrix.lu();
    }

    public static JamaQRDecomposition qr(FlatField data) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        JamaMatrix matrix = JamaMatrix.convertToMatrix(data);
        return matrix.qr();
    }

    public static JamaSingularValueDecomposition svd(FlatField data) throws VisADException, RemoteException, IllegalAccessException, InstantiationException, InvocationTargetException {
        JamaMatrix matrix = JamaMatrix.convertToMatrix(data);
        return matrix.svd();
    }

    public static FlatField hist(Field field, Set set) throws VisADException, RemoteException {
        return Histogram.makeHistogram(field, set);
    }

    public static FlatField hist(Field field, int[] ranges) throws VisADException, RemoteException {
        if (ranges == null || ranges.length == 0) {
            throw new VisADException("bad ranges");
        }
        int dim = ranges.length;
        int[] sizes = new int[dim];
        for (int i = 0; i < dim; ++i) {
            sizes[i] = 64;
        }
        return JPythonMethods.hist(field, ranges, sizes);
    }

    public static FlatField hist(Field field, int[] ranges, int[] sizes) throws VisADException, RemoteException {
        if (ranges == null || ranges.length == 0) {
            throw new VisADException("bad ranges");
        }
        if (sizes == null || sizes.length != ranges.length) {
            throw new VisADException("bad sizes");
        }
        if (field == null) {
            throw new VisADException("bad field");
        }
        FunctionType ftype = (FunctionType)field.getType();
        RealType[] frealComponents = ftype.getRealComponents();
        int n = frealComponents.length;
        int dim = ranges.length;
        RealType[] srealComponents = new RealType[dim];
        for (int i = 0; i < dim; ++i) {
            if (0 > ranges[i] || ranges[i] >= n) {
                throw new VisADException("range index out of range " + ranges[i]);
            }
            srealComponents[i] = frealComponents[ranges[i]];
        }
        RealTupleType rtt = new RealTupleType(srealComponents);
        float[][] values = field.getFloats(false);
        int nn = values.length;
        double[][] data_ranges = new double[dim][2];
        for (int i = 0; i < dim; ++i) {
            if (0 <= ranges[i] && ranges[i] < nn) {
                data_ranges[i][0] = Double.MAX_VALUE;
                data_ranges[i][1] = -1.7976931348623157E308;
                float[] v = values[ranges[i]];
                for (int j = 0; j < v.length; ++j) {
                    if ((double)v[j] < data_ranges[i][0]) {
                        data_ranges[i][0] = v[j];
                    }
                    if (!((double)v[j] > data_ranges[i][1])) continue;
                    data_ranges[i][1] = v[j];
                }
                continue;
            }
            throw new VisADException("range index out of range " + ranges[i]);
        }
        GriddedSet set = null;
        if (dim == 1) {
            set = new Linear1DSet((MathType)rtt, data_ranges[0][0], data_ranges[0][1], sizes[0]);
        } else if (dim == 2) {
            set = new Linear2DSet((MathType)rtt, data_ranges[0][0], data_ranges[0][1], sizes[0], data_ranges[1][0], data_ranges[1][1], sizes[1]);
        } else if (dim == 3) {
            set = new Linear3DSet((MathType)rtt, data_ranges[0][0], data_ranges[0][1], sizes[0], data_ranges[1][0], data_ranges[1][1], sizes[1], data_ranges[2][0], data_ranges[2][1], sizes[2]);
        } else {
            double[] firsts = new double[dim];
            double[] lasts = new double[dim];
            for (int i = 0; i < dim; ++i) {
                firsts[i] = data_ranges[i][0];
                lasts[i] = data_ranges[i][1];
            }
            set = new LinearNDSet((MathType)rtt, firsts, lasts, sizes);
        }
        FlatField result = Histogram.makeHistogram(field, set);
        return result;
    }

    public static FlatField field(float[] values) throws VisADException, RemoteException {
        return JPythonMethods.field("value", values);
    }

    public static FlatField field(String name, float[] values) throws VisADException, RemoteException {
        return JPythonMethods.field("domain", name, values);
    }

    public static FlatField field(String dom0, String name, float[] values) throws VisADException, RemoteException {
        if (values == null || values.length == 0) {
            throw new VisADException("bad values");
        }
        RealType domain = RealType.getRealType(dom0);
        return JPythonMethods.field((Set)new Integer1DSet((MathType)domain, values.length), name, values);
    }

    public static FlatField field(Set set, String name, float[] values) throws VisADException, RemoteException {
        if (values == null) {
            throw new VisADException("bad values");
        }
        if (set == null || set.getLength() < values.length) {
            throw new VisADException("bad set " + set);
        }
        if (name == null) {
            throw new VisADException("bad name");
        }
        MathType domain = ((SetType)set.getType()).getDomain();
        if (domain.getDimension() == 1) {
            domain = domain.getComponent(0);
        }
        RealType range = RealType.getRealType(name);
        FunctionType ftype = new FunctionType(domain, range);
        FlatField field = new FlatField(ftype, set);
        int len = set.getLength();
        boolean copy = true;
        if (values.length < len) {
            float[] new_values = new float[len];
            System.arraycopy(values, 0, new_values, 0, len);
            for (int i = values.length; i < len; ++i) {
                new_values[i] = Float.NaN;
            }
            values = new_values;
            copy = false;
        }
        float[][] field_values = new float[][]{values};
        field.setSamples(field_values, copy);
        return field;
    }

    public static FlatField field(float[][] values) throws VisADException, RemoteException {
        return JPythonMethods.field("value", values);
    }

    public static FlatField field(String name, float[][] values) throws VisADException, RemoteException {
        return JPythonMethods.field("ImageLine", "ImageElement", name, values);
    }

    public static FlatField field(String dom0, String dom1, String rng, float[][] values) throws VisADException, RemoteException {
        int[] temps = JPythonMethods.getValuesLengths(values);
        int values_len = temps[0];
        int min2 = temps[1];
        int max = temps[2];
        RealType first = RealType.getRealType(dom0);
        RealType second = RealType.getRealType(dom1);
        RealTupleType domain = new RealTupleType(first, second);
        return JPythonMethods.field((Set)new Integer2DSet((MathType)domain, max, values_len), rng, values);
    }

    public static FlatField field(Set set, String name, float[][] values) throws VisADException, RemoteException {
        int m3;
        int j;
        int[] temps = JPythonMethods.getValuesLengths(values);
        int values_len = temps[0];
        int min2 = temps[1];
        int max = temps[2];
        if (set == null || !(set instanceof GriddedSet) || set.getManifoldDimension() != 2) {
            throw new VisADException("bad set " + set);
        }
        int len0 = ((GriddedSet)set).getLength(0);
        int len1 = ((GriddedSet)set).getLength(1);
        if (len0 < max || len1 < values_len) {
            throw new VisADException("bad set length " + len0 + " " + len1);
        }
        if (name == null) {
            throw new VisADException("bad name");
        }
        MathType domain = ((SetType)set.getType()).getDomain();
        if (domain.getDimension() == 1) {
            domain = domain.getComponent(0);
        }
        RealType range = RealType.getRealType(name);
        FunctionType ftype = new FunctionType(domain, range);
        FlatField field = new FlatField(ftype, set);
        int len = len0 * len1;
        float[] new_values = new float[len];
        for (j = 0; j < values_len; ++j) {
            m3 = j * len0;
            int n = values[j].length;
            if (n > 0) {
                System.arraycopy(values[j], 0, new_values, m3, n);
            }
            for (int i = m3 + n; i < m3 + len0; ++i) {
                new_values[i] = Float.NaN;
            }
        }
        for (j = values_len; j < len1; ++j) {
            for (int i = m3 = j * len0; i < m3 + len0; ++i) {
                new_values[i] = Float.NaN;
            }
        }
        float[][] field_values = new float[][]{new_values};
        field.setSamples(field_values, false);
        return field;
    }

    public static int[] getValuesLengths(float[][] values) throws VisADException {
        if (values == null) {
            throw new VisADException("bad values");
        }
        int values_len = values.length;
        int min2 = Integer.MAX_VALUE;
        int max = 0;
        for (int j = 0; j < values_len; ++j) {
            if (values[j] == null) {
                throw new VisADException("bad values");
            }
            int n = values[j].length;
            if (n > max) {
                max = n;
            }
            if (n >= min2) continue;
            min2 = n;
        }
        if (max < min2) {
            min2 = 0;
        }
        return new int[]{values_len, min2, max};
    }

    public static int getDomainDimension(Data data) throws VisADException, RemoteException {
        return JPythonMethods.domainDimension(data);
    }

    public static int domainDimension(Data data) throws VisADException, RemoteException {
        return ((FunctionType)data.getType()).getDomain().getDimension();
    }

    public static int getRangeDimension(Data data) throws VisADException, RemoteException {
        return JPythonMethods.rangeDimension(data);
    }

    public static int rangeDimension(Data data) throws VisADException, RemoteException {
        int nr = 1;
        if (data instanceof FlatField) {
            nr = ((FlatField)data).getRangeDimension();
        }
        return nr;
    }

    public static RealTupleType getDomainType(Data data) throws VisADException, RemoteException {
        return JPythonMethods.domainType(data);
    }

    public static RealTupleType domainType(Data data) throws VisADException, RemoteException {
        return ((FunctionType)data.getType()).getDomain();
    }

    public static RealTupleType getDomainType(FunctionType type) throws VisADException, RemoteException {
        return type.getDomain();
    }

    public static MathType getRangeType(Data data) throws VisADException, RemoteException {
        return JPythonMethods.rangeType(data);
    }

    public static MathType rangeType(Data data) throws VisADException, RemoteException {
        return ((FunctionType)data.getType()).getRange();
    }

    public static MathType getRangeType(FunctionType type) throws VisADException, RemoteException {
        return type.getRange();
    }

    public static String domainType(Data data, int comp) throws VisADException, RemoteException {
        return ((FunctionType)data.getType()).getDomain().getComponent(comp).toString();
    }

    public static String rangeType(Data data, int comp) throws VisADException, RemoteException {
        MathType rt = JPythonMethods.rangeType(data);
        int rd = JPythonMethods.rangeDimension(data);
        String dt = rt.toString();
        if (rd > 1) {
            dt = ((TupleType)rt).getComponent(comp).toString();
        }
        return dt;
    }

    public static Unit makeUnit(String name) throws NoSuchUnitException, ParseException {
        return Parser.parse(name);
    }

    public static Integer1DSet makeDomain(int length) throws VisADException {
        return new Integer1DSet(length);
    }

    public static Integer1DSet makeDomain(MathType type, int length) throws VisADException {
        return new Integer1DSet(type, length);
    }

    public static Integer1DSet makeDomain(String name, int length) throws VisADException {
        return new Integer1DSet((MathType)RealType.getRealType(name), length);
    }

    public static Integer2DSet makeDomain(int lengthX, int lengthY) throws VisADException {
        return new Integer2DSet(lengthX, lengthY);
    }

    public static Integer2DSet makeDomain(MathType type, int lengthX, int lengthY) throws VisADException {
        return new Integer2DSet(type, lengthX, lengthY);
    }

    public static Integer2DSet makeDomain(String name, int lengthX, int lengthY) throws VisADException, RemoteException {
        return new Integer2DSet((MathType)((RealTupleType)JPythonMethods.makeType(name)), lengthX, lengthY);
    }

    public static Linear1DSet makeDomain(double first, double last, int length) throws VisADException {
        return new Linear1DSet(first, last, length);
    }

    public static Linear1DSet makeDomain(MathType type, double first, double last, int length) throws VisADException {
        return new Linear1DSet(type, first, last, length);
    }

    public static Linear1DSet makeDomain(String name, double first, double last, int length) throws VisADException {
        return new Linear1DSet((MathType)RealType.getRealType(name), first, last, length);
    }

    public static Linear2DSet makeDomain(double first1, double last1, int length1, double first2, double last2, int length2) throws VisADException {
        return new Linear2DSet(first1, last1, length1, first2, last2, length2);
    }

    public static Linear2DSet makeDomain(MathType type, double first1, double last1, int length1, double first2, double last2, int length2) throws VisADException {
        return new Linear2DSet(type, first1, last1, length1, first2, last2, length2);
    }

    public static Linear2DSet makeDomain(String name, double first1, double last1, int length1, double first2, double last2, int length2) throws VisADException, RemoteException {
        return new Linear2DSet((MathType)((RealTupleType)JPythonMethods.makeType(name)), first1, last1, length1, first2, last2, length2);
    }

    public static Linear3DSet makeDomain(double first1, double last1, int length1, double first2, double last2, int length2, double first3, double last3, int length3) throws VisADException {
        return new Linear3DSet(first1, last1, length1, first2, last2, length2, first3, last3, length3);
    }

    public static Linear3DSet makeDomain(MathType type, double first1, double last1, int length1, double first2, double last2, int length2, double first3, double last3, int length3) throws VisADException {
        return new Linear3DSet(type, first1, last1, length1, first2, last2, length2, first3, last3, length3);
    }

    public static Linear3DSet makeDomain(String name, double first1, double last1, int length1, double first2, double last2, int length2, double first3, double last3, int length3) throws VisADException, RemoteException {
        return new Linear3DSet((MathType)((RealTupleType)JPythonMethods.makeType(name)), first1, last1, length1, first2, last2, length2, first3, last3, length3);
    }

    public static Set getDomainSet(Data data) throws VisADException, RemoteException {
        return ((Field)data).getDomainSet();
    }

    public static Set getDomain(Data data) throws VisADException, RemoteException {
        return ((Field)data).getDomainSet();
    }

    public static int[] getDomainSizes(Data data) throws VisADException, RemoteException {
        return ((GriddedSet)((Field)data).getDomainSet()).getLengths();
    }

    public static FlatField replace(FieldImpl f, int[] list, Real v) throws VisADException, RemoteException {
        return JPythonMethods.replace(f, list, v.getValue());
    }

    public static FlatField replace(FieldImpl f, int[] list, double v) throws VisADException, RemoteException {
        FlatField ff;
        if (f instanceof FlatField) {
            try {
                ff = (FlatField)f.clone();
            }
            catch (CloneNotSupportedException cns) {
                throw new VisADException("Cannot clone field object");
            }
        } else {
            ff = (FlatField)((FlatField)f.getSample(0)).clone();
        }
        float[][] dv = ff.getFloats(false);
        for (int i = 0; i < list.length; ++i) {
            dv[0][list[i]] = (float)v;
        }
        ff.setSamples(dv, false);
        return ff;
    }

    public static FlatField setToMissing(FieldImpl f, double v) throws VisADException, RemoteException {
        FlatField ff;
        if (f instanceof FlatField) {
            try {
                ff = (FlatField)f.clone();
            }
            catch (CloneNotSupportedException cns) {
                throw new VisADException("Cannot clone field object");
            }
        } else {
            ff = (FlatField)((FlatField)f.getSample(0)).clone();
        }
        float[][] dv = ff.getFloats(false);
        for (int i = 0; i < dv[0].length; ++i) {
            if ((double)dv[0][i] != v) continue;
            dv[0][i] = Float.NaN;
        }
        ff.setSamples(dv, false);
        return ff;
    }

    public static FlatField replaceMissing(FieldImpl f, double v) throws VisADException, RemoteException {
        FlatField ff;
        if (f instanceof FlatField) {
            try {
                ff = (FlatField)f.clone();
            }
            catch (CloneNotSupportedException cns) {
                throw new VisADException("Cannot clone field object");
            }
        } else {
            ff = (FlatField)((FlatField)f.getSample(0)).clone();
        }
        float[][] dv = ff.getFloats(false);
        for (int i = 0; i < dv[0].length; ++i) {
            if (dv[0][i] == dv[0][i]) continue;
            dv[0][i] = (float)v;
        }
        ff.setSamples(dv, false);
        return ff;
    }

    public static FlatField replace(FieldImpl f, double v) throws VisADException, RemoteException {
        FlatField ff;
        if (f instanceof FlatField) {
            try {
                ff = (FlatField)f.clone();
            }
            catch (CloneNotSupportedException cns) {
                throw new VisADException("Cannot clone field object");
            }
        } else {
            ff = (FlatField)((FlatField)f.getSample(0)).clone();
        }
        float[][] dv = ff.getFloats(false);
        for (int i = 0; i < dv[0].length; ++i) {
            dv[0][i] = (float)v;
        }
        ff.setSamples(dv, false);
        return ff;
    }

    public static FlatField replace(FieldImpl f, Real v) throws VisADException, RemoteException {
        FlatField ff;
        if (f instanceof FlatField) {
            try {
                ff = (FlatField)f.clone();
            }
            catch (CloneNotSupportedException cns) {
                throw new VisADException("Cannot clone field object");
            }
        } else {
            ff = (FlatField)((FlatField)f.getSample(0)).clone();
        }
        float[][] dv = ff.getFloats(false);
        float vv = (float)v.getValue();
        for (int i = 0; i < dv[0].length; ++i) {
            dv[0][i] = vv;
        }
        ff.setSamples(dv, false);
        return ff;
    }

    public static double[] getMinMax(FieldImpl f) throws VisADException, RemoteException {
        int numItems;
        boolean isFI = false;
        if (f instanceof FlatField) {
            numItems = 1;
        } else if (JPythonMethods.domainDimension(f) == 1) {
            isFI = true;
            numItems = JPythonMethods.getDomainSet(f).getLength();
        } else {
            throw new VisADException("Cannot rescale the data - unknown structure");
        }
        double[] minmax = new double[]{Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY};
        for (int m3 = 0; m3 < numItems; ++m3) {
            float[][] dv = isFI ? ((FlatField)f.getSample(m3)).getFloats(false) : f.getFloats(false);
            for (int i = 0; i < dv.length; ++i) {
                for (int k = 0; k < dv[i].length; ++k) {
                    if ((double)dv[i][k] < minmax[0]) {
                        minmax[0] = dv[i][k];
                    }
                    if (!((double)dv[i][k] > minmax[1])) continue;
                    minmax[1] = dv[i][k];
                }
            }
        }
        if (minmax[0] > minmax[1]) {
            minmax[0] = Double.NaN;
            minmax[1] = Double.NaN;
        }
        return minmax;
    }

    public static FieldImpl rescale(FieldImpl f, double outlo, double outhi) throws VisADException, RemoteException {
        double[] minmax = JPythonMethods.getMinMax(f);
        return JPythonMethods.rescale(f, minmax[0], minmax[1], outlo, outhi);
    }

    public static FieldImpl rescale(FieldImpl f, double inlo, double inhi, double outlo, double outhi) throws VisADException, RemoteException {
        FlatField ff = null;
        FieldImpl fi = null;
        boolean isFI = false;
        int numItems = 1;
        if (f instanceof FlatField) {
            try {
                ff = (FlatField)f.clone();
            }
            catch (CloneNotSupportedException cns) {
                throw new VisADException("Cannot clone field object");
            }
        } else if (JPythonMethods.domainDimension(f) == 1) {
            isFI = true;
            try {
                fi = (FieldImpl)f.clone();
                numItems = JPythonMethods.getDomainSet(f).getLength();
            }
            catch (CloneNotSupportedException cnsfi) {
                throw new VisADException("Cannot clone FieldImpl object");
            }
        } else {
            throw new VisADException("Cannot rescale the data - unknown structure");
        }
        for (int m3 = 0; m3 < numItems; ++m3) {
            float[][] dv = isFI ? ((FlatField)fi.getSample(m3)).getFloats(false) : ff.getFloats(false);
            double outrange = outhi - outlo;
            double inrange = inhi - inlo;
            for (int i = 0; i < dv.length; ++i) {
                for (int k = 0; k < dv[i].length; ++k) {
                    dv[i][k] = (float)(outlo + outrange * ((double)dv[i][k] - inlo) / inrange);
                    if ((double)dv[i][k] < outlo) {
                        dv[i][k] = (float)outlo;
                    }
                    if (!((double)dv[i][k] > outhi)) continue;
                    dv[i][k] = (float)outhi;
                }
            }
            if (isFI) {
                ((FlatField)fi.getSample(m3)).setSamples(dv, false);
                continue;
            }
            ff.setSamples(dv, false);
        }
        if (isFI) {
            return fi;
        }
        return ff;
    }

    public static float[][] getLatLons(GriddedSet domain, int[] index) throws VisADException {
        boolean isLatLon = JPythonMethods.isLatLonOrder(domain);
        float[][] values = JPythonMethods.getEarthLocationPoints(domain);
        if (!isLatLon) {
            float[] tmp = values[0];
            values[0] = values[1];
            values[1] = tmp;
        }
        if (index == null) {
            return values;
        }
        float[][] vals = new float[2][index.length];
        for (int i = 0; i < index.length; ++i) {
            vals[0][i] = values[0][index[i]];
            vals[1][i] = values[1][index[i]];
        }
        return vals;
    }

    public static float[][] getLatLons(GriddedSet domain) throws VisADException {
        return JPythonMethods.getLatLons(domain, null);
    }

    public static float[][][] getLatLons2D(GriddedSet domain) throws VisADException {
        float[][] latlon;
        int[] nxy = domain.getLengths();
        int nx = nxy[0];
        int ny = nxy[1];
        try {
            latlon = JPythonMethods.getLatLons(domain);
        }
        catch (VisADException noll) {
            return null;
        }
        float[][][] vals = new float[2][nx][ny];
        int k = 0;
        for (int x = 1; x < nx - 1; ++x) {
            for (int y = 1; y < ny - 1; ++y) {
                k = x + nx * y;
                vals[0][x][y] = latlon[0][k];
                vals[1][x][y] = latlon[1][k];
            }
        }
        return vals;
    }

    public static float[][] getEarthLocationPoints(GriddedSet domain) throws VisADException {
        CoordinateSystem cs = domain.getCoordinateSystem();
        if (cs == null) {
            return domain.getSamples();
        }
        RealTupleType refType = cs.getReference();
        Unit[] refUnits = cs.getReferenceUnits();
        float[][] points = CoordinateSystem.transformCoordinates(refType, null, refUnits, null, ((SetType)domain.getType()).getDomain(), cs, domain.getSetUnits(), domain.getSetErrors(), domain.getSamples(), false);
        return points;
    }

    public static boolean isLatLonOrder(SampledSet spatialSet) throws VisADException {
        RealTupleType spatialType = ((SetType)spatialSet.getType()).getDomain();
        RealTupleType spatialReferenceType = spatialSet.getCoordinateSystem() != null ? spatialSet.getCoordinateSystem().getReference() : null;
        return spatialType.equals(RealTupleType.LatitudeLongitudeTuple) || spatialType.equals(RealTupleType.LatitudeLongitudeAltitude) || spatialReferenceType != null && (spatialReferenceType.equals(RealTupleType.LatitudeLongitudeTuple) || spatialReferenceType.equals(RealTupleType.LatitudeLongitudeAltitude));
    }

    public static FlatField createAreaField(FieldImpl f) throws VisADException, RemoteException {
        int x;
        float[][] latlon;
        GriddedSet ds = null;
        ds = f instanceof FlatField ? (GriddedSet)((FlatField)f).getDomainSet() : (GriddedSet)((FlatField)f.getSample(0)).getDomainSet();
        int[] nxy = ds.getLengths();
        int nx = nxy[0];
        int ny = nxy[1];
        try {
            latlon = JPythonMethods.getLatLons(ds);
        }
        catch (VisADException noll) {
            return null;
        }
        float[][] area = new float[1][nx * ny];
        int k = 0;
        for (x = 1; x < nx - 1; ++x) {
            for (int y = 1; y < ny - 1; ++y) {
                k = x + nx * y;
                area[0][k] = (float)Math.abs(3085.8025 * (double)(latlon[0][k - nx] - latlon[0][k + nx]) * Math.cos((double)latlon[0][k] * 0.01745329252) * (double)(latlon[1][k + 1] - latlon[1][k - 1]));
            }
        }
        k = nx * (ny - 1);
        for (x = 0; x < nx; ++x) {
            area[0][x] = area[0][x + nx];
            area[0][x + k] = area[0][x + k - nx];
        }
        for (int y = 0; y < ny; ++y) {
            k = nx * y;
            area[0][k] = area[0][k + 1];
            area[0][k + nx - 1] = area[0][k + nx - 2];
        }
        RealTupleType domain = ((SetType)ds.getType()).getDomain();
        Unit u = null;
        try {
            u = JPythonMethods.makeUnit("km2");
        }
        catch (Exception e) {
            // empty catch block
        }
        RealType range = JPythonMethods.makeRealType("area", u);
        FunctionType ftype = new FunctionType(domain, range);
        FlatField field = new FlatField(ftype, ds);
        field.setSamples(area, false);
        latlon = null;
        return field;
    }

    public static double computeSum(FlatField f, int[] list) throws VisADException, RemoteException {
        if (f == null) {
            return Double.NaN;
        }
        float[][] dv = f.getFloats(false);
        double sum = 0.0;
        for (int i = 0; i < list.length; ++i) {
            if (Float.isNaN(dv[0][list[i]])) continue;
            sum += (double)dv[0][list[i]];
        }
        return sum;
    }

    public static double computeAverage(FlatField f, int[] list) throws VisADException, RemoteException {
        if (f == null) {
            return Double.NaN;
        }
        float[][] dv = f.getFloats(false);
        double sum = 0.0;
        double count = 0.0;
        for (int i = 0; i < list.length; ++i) {
            if (Float.isNaN(dv[0][list[i]])) continue;
            sum += (double)dv[0][list[i]];
            count += 1.0;
        }
        if (count > 0.0) {
            return sum / count;
        }
        return Double.NaN;
    }

    public static FieldImpl mask(FieldImpl f, String op, double v) throws VisADException, RemoteException {
        return JPythonMethods.mask(f, op, new Real(v), false);
    }

    public static FieldImpl mask(FieldImpl f, String op, double v, boolean useNaN) throws VisADException, RemoteException {
        return JPythonMethods.mask(f, op, new Real(v), useNaN);
    }

    public static FieldImpl mask(Data f, String op, Data v) throws VisADException, RemoteException {
        if (!(f instanceof FieldImpl)) {
            throw new VisADException("Data must be a FieldImpl or FlatField");
        }
        return JPythonMethods.mask((FieldImpl)f, op, v, false);
    }

    public static FieldImpl mask(FieldImpl f, String op, Data v) throws VisADException, RemoteException {
        return JPythonMethods.mask(f, op, v, false);
    }

    public static FieldImpl mask(FieldImpl f, String op, Data v, boolean useNaN) throws VisADException, RemoteException {
        int numItems;
        FlatField ff = null;
        FieldImpl fi = null;
        boolean isFI = false;
        Set ds = null;
        float fail = 0.0f;
        if (useNaN) {
            fail = Float.NaN;
        }
        if (f instanceof FlatField) {
            numItems = 1;
            ds = ((FlatField)f).getDomainSet();
        } else if (JPythonMethods.domainDimension(f) == 1) {
            isFI = true;
            numItems = JPythonMethods.getDomain(f).getLength();
            ds = ((FlatField)f.getSample(0)).getDomainSet();
        } else {
            throw new VisADException("Cannot rescale the data - unknown structure");
        }
        int oper = -1;
        for (int i = 0; i < ops.length; ++i) {
            if (ops[i].equalsIgnoreCase(op)) {
                oper = i;
            }
            if (!ops_sym[i].equalsIgnoreCase(op)) continue;
            oper = i;
        }
        if (oper < 0) {
            throw new VisADException("Invalid operator: " + op);
        }
        RealTupleType domain = ((SetType)ds.getType()).getDomain();
        Unit u = null;
        try {
            u = JPythonMethods.makeUnit("");
        }
        catch (Exception e) {
            // empty catch block
        }
        RealType range = JPythonMethods.makeRealType("mask", u);
        FunctionType ftype = new FunctionType(domain, range);
        FlatField field = new FlatField(ftype, ds);
        if (isFI) {
            Set dsfi = f.getDomainSet();
            RealTupleType dsdom = ((SetType)f.getDomainSet().getType()).getDomain();
            FunctionType dsft = new FunctionType(dsdom, ftype);
            fi = new FieldImpl(dsft, dsfi);
        }
        boolean isReal = false;
        float vv = 0.0f;
        if (v.getType() == RealType.Generic) {
            isReal = true;
            vv = (float)((Real)v).getValue();
        }
        for (int m3 = 0; m3 < numItems; ++m3) {
            ff = isReal ? (isFI ? (FlatField)f.getSample(m3) : (FlatField)f) : (isFI ? (FlatField)f.getSample(m3).subtract(v) : (FlatField)f.subtract(v));
            float[][] dv = ff.getFloats(true);
            for (int i = 0; i < dv.length; ++i) {
                for (int k = 0; k < dv[i].length; ++k) {
                    if (oper == 0) {
                        if (dv[i][k] > vv) {
                            dv[i][k] = 1.0f;
                            continue;
                        }
                        dv[i][k] = fail;
                        continue;
                    }
                    if (oper == 1 || oper == 7) {
                        if (dv[i][k] >= vv) {
                            dv[i][k] = 1.0f;
                            continue;
                        }
                        dv[i][k] = fail;
                        continue;
                    }
                    if (oper == 2) {
                        if (dv[i][k] < vv) {
                            dv[i][k] = 1.0f;
                            continue;
                        }
                        dv[i][k] = fail;
                        continue;
                    }
                    if (oper == 3 || oper == 8) {
                        if (dv[i][k] <= vv) {
                            dv[i][k] = 1.0f;
                            continue;
                        }
                        dv[i][k] = fail;
                        continue;
                    }
                    if (oper == 4) {
                        if (dv[i][k] == vv) {
                            dv[i][k] = 1.0f;
                            continue;
                        }
                        dv[i][k] = fail;
                        continue;
                    }
                    dv[i][k] = dv[i][k] != vv ? 1.0f : fail;
                }
            }
            field.setSamples(dv, false);
            if (!isFI) continue;
            fi.setSample(m3, (Data)field);
        }
        if (isFI) {
            return fi;
        }
        return field;
    }

    public static FieldImpl maskWithinRange(FieldImpl f, double vmin, double vmax, boolean useNaN) throws VisADException, RemoteException {
        return JPythonMethods.maskRange(f, vmin, vmax, useNaN, true);
    }

    public static FieldImpl maskOutsideRange(FieldImpl f, double vmin, double vmax, boolean useNaN) throws VisADException, RemoteException {
        return JPythonMethods.maskRange(f, vmin, vmax, useNaN, false);
    }

    private static FieldImpl maskRange(FieldImpl f, double vmin, double vmax, boolean useNaN, boolean doWithin) throws VisADException, RemoteException {
        int numItems;
        FieldImpl fi = null;
        boolean isFI = false;
        Set ds = null;
        float fail = 0.0f;
        if (useNaN) {
            fail = Float.NaN;
        }
        if (f instanceof FlatField) {
            numItems = 1;
            ds = ((FlatField)f).getDomainSet();
        } else if (JPythonMethods.domainDimension(f) == 1) {
            isFI = true;
            numItems = JPythonMethods.getDomain(f).getLength();
            ds = ((FlatField)f.getSample(0)).getDomainSet();
        } else {
            throw new VisADException("Cannot rescale the data - unknown structure");
        }
        RealTupleType domain = ((SetType)ds.getType()).getDomain();
        Unit u = null;
        try {
            u = JPythonMethods.makeUnit("");
        }
        catch (Exception e) {
            // empty catch block
        }
        RealType range = JPythonMethods.makeRealType("mask", u);
        FunctionType ftype = new FunctionType(domain, range);
        FlatField field = new FlatField(ftype, ds);
        if (isFI) {
            Set dsfi = f.getDomainSet();
            RealTupleType dsdom = ((SetType)f.getDomainSet().getType()).getDomain();
            FunctionType dsft = new FunctionType(dsdom, ftype);
            fi = new FieldImpl(dsft, dsfi);
        }
        for (int m3 = 0; m3 < numItems; ++m3) {
            float[][] dv = isFI ? ((FlatField)f.getSample(m3)).getFloats(true) : ((FlatField)f).getFloats(true);
            for (int i = 0; i < dv.length; ++i) {
                for (int k = 0; k < dv[i].length; ++k) {
                    if (doWithin) {
                        if ((double)dv[i][k] > vmin && (double)dv[i][k] < vmax) {
                            dv[i][k] = 1.0f;
                            continue;
                        }
                        dv[i][k] = fail;
                        continue;
                    }
                    dv[i][k] = (double)dv[i][k] < vmin || (double)dv[i][k] > vmax ? 1.0f : fail;
                }
            }
            field.setSamples(dv, false);
            if (!isFI) continue;
            fi.setSample(m3, (Data)field);
        }
        if (isFI) {
            return fi;
        }
        return field;
    }

    public static int[] find(FieldImpl f, String op, double v) throws VisADException, RemoteException {
        return JPythonMethods.find((Data)f, op, new Real(v));
    }

    public static int[] find(Data f, String op, Data v) throws VisADException, RemoteException {
        int i;
        FlatField fv = f instanceof FlatField ? (FlatField)f.subtract(v) : (FlatField)((FieldImpl)f).getSample(0).subtract(v);
        float[][] dv = fv.getFloats(false);
        ArrayList<Integer> zz = new ArrayList<Integer>(fv.getLength());
        int oper = -1;
        for (i = 0; i < ops.length; ++i) {
            if (ops[i].equalsIgnoreCase(op)) {
                oper = i;
            }
            if (!ops_sym[i].equalsIgnoreCase(op)) continue;
            oper = i;
        }
        if (oper < 0) {
            throw new VisADException("Invalid operator: " + op);
        }
        for (i = 0; i < 1; ++i) {
            for (int k = 0; k < dv[i].length; ++k) {
                if (oper == 0) {
                    if (!(dv[i][k] > 0.0f)) continue;
                    zz.add(k);
                    continue;
                }
                if (oper == 1 || oper == 7) {
                    if (!(dv[i][k] >= 0.0f)) continue;
                    zz.add(k);
                    continue;
                }
                if (oper == 2) {
                    if (!(dv[i][k] < 0.0f)) continue;
                    zz.add(k);
                    continue;
                }
                if (oper == 3 || oper == 8) {
                    if (!(dv[i][k] <= 0.0f)) continue;
                    zz.add(k);
                    continue;
                }
                if (oper == 4) {
                    if (dv[i][k] != 0.0f) continue;
                    zz.add(k);
                    continue;
                }
                if (dv[i][k] == 0.0f) continue;
                zz.add(k);
            }
        }
        int m3 = zz.size();
        int[] rv = new int[m3];
        for (int i2 = 0; i2 < m3; ++i2) {
            rv[i2] = (Integer)zz.get(i2);
        }
        return rv;
    }

    public static int[] findWithinRange(FieldImpl f, double vmin, double vmax) throws VisADException, RemoteException {
        return JPythonMethods.findByRange(f, vmin, vmax, true);
    }

    public static int[] findOutsideRange(FieldImpl f, double vmin, double vmax) throws VisADException, RemoteException {
        return JPythonMethods.findByRange(f, vmin, vmax, false);
    }

    private static int[] findByRange(FieldImpl f, double vmin, double vmax, boolean doWithin) throws VisADException, RemoteException {
        float[][] dv = f instanceof FlatField ? ((FlatField)f).getFloats(false) : ((FlatField)f.getSample(0)).getFloats(false);
        ArrayList<Integer> zz = new ArrayList<Integer>(dv[0].length);
        for (int i = 0; i < 1; ++i) {
            for (int k = 0; k < dv[i].length; ++k) {
                if (doWithin) {
                    if (!((double)dv[i][k] > vmin) || !((double)dv[i][k] < vmax)) continue;
                    zz.add(k);
                    continue;
                }
                if (!((double)dv[i][k] < vmin) && !((double)dv[i][k] > vmax)) continue;
                zz.add(k);
            }
        }
        int m3 = zz.size();
        int[] rv = new int[m3];
        for (int i = 0; i < m3; ++i) {
            rv[i] = (Integer)zz.get(i);
        }
        return rv;
    }

    public static Field resample(Field data, Set s2) throws VisADException, RemoteException {
        return data.resample(s2, 0, 0);
    }

    public static double getValue(Real r) {
        return r.getValue();
    }

    public static double[][] getValues(Field data) throws VisADException, RemoteException {
        return data.getValues();
    }

    public static void setValues(Field f, double[][] vals) throws VisADException, RemoteException {
        f.setSamples(vals);
    }

    public static Field combine(Field[] fields) throws VisADException, RemoteException {
        return FieldImpl.combine(fields);
    }

    public static Field extract(Field data, MathType t) throws VisADException, RemoteException {
        return ((FieldImpl)data).extract(t);
    }

    public static Field extract(Field data, String s2) throws VisADException, RemoteException {
        return ((FieldImpl)data).extract(s2);
    }

    public static Field extract(Field data, int comp) throws VisADException, RemoteException {
        return ((FieldImpl)data).extract(comp);
    }

    public static Field domainFactor(Field data, RealType factor) throws VisADException, RemoteException {
        return ((FieldImpl)data).domainFactor(factor);
    }

    public static Field domainFactor(Field data, int comp) throws VisADException, RemoteException {
        RealType mt = (RealType)((FunctionType)data.getType()).getDomain().getComponent(comp);
        return ((FieldImpl)data).domainFactor(mt);
    }

    public static Data evaluate(Field data, Real domain) throws VisADException, RemoteException {
        return data.evaluate(domain);
    }

    public static Data evaluate(Field data, double domain) throws VisADException, RemoteException {
        return data.evaluate(new Real(domain));
    }

    public static MathType makeType(String s2) throws VisADException, RemoteException {
        String ss = s2.trim();
        if (!(ss.indexOf(44) == -1 && ss.indexOf(62) == -1 || ss.startsWith("(") && ss.endsWith(")"))) {
            ss = "(" + s2.trim() + ")";
        }
        return MathType.stringToType(ss);
    }

    public static RealTupleType makeType(String[] s2, CoordinateSystem c) throws VisADException, RemoteException {
        RealType[] rt = new RealType[s2.length];
        for (int i = 0; i < s2.length; ++i) {
            rt[i] = RealType.getRealType(s2[i]);
        }
        return new RealTupleType(rt, c, null);
    }

    public static RealType makeRealType(String name) {
        return RealType.getRealType(name);
    }

    public static RealType getRealType(String name) {
        return RealType.getRealType(name);
    }

    public static RealType makeRealType(String name, Unit unit) {
        return RealType.getRealType(name, unit);
    }

    public static RealType getRealType(String name, Unit unit) {
        return RealType.getRealType(name, unit);
    }

    public static MathType getType(Data data) throws VisADException, RemoteException {
        return data.getType();
    }

    public static void showAxesScales(DisplayImpl d, boolean on) throws VisADException, RemoteException {
        d.getGraphicsModeControl().setScaleEnable(on);
    }

    public static void setAxesScalesLabel(ScalarMap[] sm, String[] labels) throws VisADException, RemoteException {
        if (sm.length != labels.length) {
            throw new VisADException("number of ScalarMaps must match number of labels");
        }
        for (int i = 0; i < sm.length; ++i) {
            AxisScale scale = sm[i].getAxisScale();
            if (scale == null) continue;
            scale.setTitle(labels[i]);
        }
    }

    public static void setAxesScalesFont(ScalarMap[] sm, Font f) throws VisADException, RemoteException {
        for (int i = 0; i < sm.length; ++i) {
            AxisScale scale = sm[i].getAxisScale();
            if (scale == null) continue;
            scale.setFont(f);
        }
    }

    public static UnionSet makePairedLines(MathType mt, double[][] points) throws VisADException, RemoteException {
        int dim = points.length;
        int len = points[0].length;
        UnionSet us = null;
        if (dim == 2) {
            float[][] samples = new float[2][2];
            SampledSet[] gs2 = new Gridded2DSet[len / 2];
            for (int k = 0; k < len; k += 2) {
                samples[0][0] = (float)points[0][k];
                samples[0][1] = (float)points[0][k + 1];
                samples[1][0] = (float)points[1][k];
                samples[1][1] = (float)points[1][k + 1];
                gs2[k / 2] = new Gridded2DSet(mt, samples, 2);
            }
            us = new UnionSet(gs2);
        } else if (dim == 3) {
            float[][] samples = new float[3][2];
            SampledSet[] gs3 = new Gridded3DSet[len / 2];
            for (int k = 0; k < len; k += 2) {
                samples[0][0] = (float)points[0][k];
                samples[0][1] = (float)points[0][k + 1];
                samples[1][0] = (float)points[1][k];
                samples[1][1] = (float)points[1][k + 1];
                samples[2][0] = (float)points[2][k];
                samples[2][1] = (float)points[2][k + 1];
                gs3[k / 2] = new Gridded3DSet(mt, samples, 3);
            }
            us = new UnionSet(gs3);
        }
        return us;
    }

    public static void dumpTypes(Data d) throws VisADException, RemoteException {
        MathType t = d.getType();
        DumpType.dumpMathType(t);
        System.out.println("- - - - - - - - - - - - - - - - - - - - - - - ");
        System.out.println("DataType analysis...");
        DumpType.dumpDataType(d);
    }

    public static ByteArrayOutputStream whatTypes(Data d) throws VisADException, RemoteException {
        MathType t = d.getType();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DumpType.dumpMathType(t, bos);
        DumpType.dumpDataType(d, bos);
        return bos;
    }

    public static void dumpType(Data d) throws VisADException, RemoteException {
        MathType t = d.getType();
        DumpType.dumpMathType(t);
    }

    public static ByteArrayOutputStream whatType(Data d) throws VisADException, RemoteException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        MathType t = d.getType();
        DumpType.dumpMathType(t, bos);
        return bos;
    }

    public static PointDataAdapter getPointDataAdapter(String request) throws VisADException, RemoteException {
        return new PointDataAdapter(request);
    }

    public static Data getNetcdfData(String filename) throws VisADException, RemoteException, IOException {
        return JPythonMethods.getNetcdfData(filename, null);
    }

    public static Data getNetcdfData(String filename, String factor) throws VisADException, RemoteException, IOException {
        NetcdfFile nf = new NetcdfFile(filename, true);
        DefaultView dv = new DefaultView(nf, QuantityDBManager.instance(), true);
        if (factor != null) {
            TreeSet<String> ts = new TreeSet<String>();
            ts.add(factor);
            dv.setOuterDimensionNameSet(ts);
        }
        NetcdfAdapter na = new NetcdfAdapter(dv);
        return na.getData();
    }

    public static double[][] getScale(ScalarMap smap) {
        double[] so = new double[2];
        double[] data = new double[2];
        double[] display = new double[2];
        smap.getScale(so, data, display);
        return new double[][]{so, data, display};
    }
}

