/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import visad.util.GUIFrame;
import visad.util.TextEditor;

public class TextFrame
extends GUIFrame
implements UndoableEditListener {
    protected TextEditor textPane;
    private String title = "VisAD Text Editor";

    public TextFrame() {
        this((String)null);
    }

    public TextFrame(String filename) {
        this(new TextEditor(filename));
    }

    public TextFrame(TextEditor textEdit) {
        this.textPane = textEdit;
        this.textPane.addUndoableEditListener(this);
        this.addMenuItem("File", "New", "fileNew", 'n');
        this.addMenuItem("File", "Open...", "fileOpen", 'o');
        this.addMenuItem("File", "Save", "fileSave", 's', false);
        this.addMenuItem("File", "Save as...", "fileSaveAs", 'a');
        this.addMenuItem("File", "Exit", "fileExit", 'x');
        this.addMenuItem("Edit", "Undo", "editUndo", 'u', false);
        this.addMenuItem("Edit", "Redo", "editRedo", 'r', false);
        this.addMenuItem("Edit", "Cut", "editCut", 't');
        this.addMenuItem("Edit", "Copy", "editCopy", 'c');
        this.addMenuItem("Edit", "Paste", "editPaste", 'p');
        this.layoutGUI();
    }

    protected void layoutGUI() {
        this.setContentPane(this.textPane);
        this.setTitle(this.title);
    }

    public void setTitle(String title) {
        this.title = title;
        this.refreshTitleBar();
    }

    public String getTitle() {
        return this.title;
    }

    private void refreshUndoMenuItems() {
        JMenuItem editUndo = this.getMenuItem("Edit", "Undo");
        JMenuItem editRedo = this.getMenuItem("Edit", "Redo");
        editUndo.setEnabled(this.textPane.canUndo());
        editUndo.setText(this.textPane.getUndoName());
        editRedo.setEnabled(this.textPane.canRedo());
        editRedo.setText(this.textPane.getRedoName());
    }

    private void refreshSaveMenuItem(boolean dirty) {
        JMenuItem fileSave = this.getMenuItem("File", "Save");
        fileSave.setEnabled(dirty);
    }

    private void refreshTitleBar() {
        String filename = this.textPane.getFilename();
        super.setTitle(this.title + (filename == null ? "" : " - " + filename));
    }

    private void refreshMenuItems(boolean dirty) {
        this.refreshUndoMenuItems();
        this.refreshSaveMenuItem(dirty);
    }

    protected boolean askSaveChanges(boolean allowCancel) {
        int ans = JOptionPane.showConfirmDialog(this, "Save changes to the file?", this.getTitle(), allowCancel ? 1 : 0);
        if (ans == 0) {
            this.fileSave();
        }
        return ans != 2;
    }

    public void showError(String msg) {
        int index;
        int i = 0;
        int len = msg.length();
        StringBuffer sb = new StringBuffer(len);
        while ((index = msg.indexOf(13, i)) >= 0) {
            sb.append(msg.substring(i, index));
            i = index + 1;
        }
        sb.append(msg.substring(i));
        msg = sb.toString();
        JOptionPane.showMessageDialog(this, msg, this.getTitle(), 0);
    }

    public void fileNew() {
        if (this.textPane.hasChanged() && !this.askSaveChanges(true)) {
            return;
        }
        this.textPane.newFile();
        this.refreshMenuItems(false);
        this.refreshTitleBar();
    }

    public void fileOpen() {
        if (this.textPane.hasChanged() && !this.askSaveChanges(true)) {
            return;
        }
        this.textPane.openDialog();
        this.refreshMenuItems(false);
        this.refreshTitleBar();
    }

    public boolean fileSave() {
        boolean success = this.textPane.saveFile();
        if (success) {
            this.refreshSaveMenuItem(false);
        }
        return success;
    }

    public boolean fileSaveAs() {
        boolean success = this.textPane.saveDialog();
        if (success) {
            this.refreshSaveMenuItem(false);
            this.refreshTitleBar();
        }
        return success;
    }

    public void fileExit() {
        if (this.textPane.hasChanged()) {
            this.askSaveChanges(false);
        }
        System.exit(0);
    }

    public void editUndo() {
        this.textPane.undo();
        this.refreshMenuItems(true);
    }

    public void editRedo() {
        this.textPane.redo();
        this.refreshMenuItems(true);
    }

    public void editCut() {
        this.textPane.cut();
        this.refreshMenuItems(true);
    }

    public void editCopy() {
        this.textPane.copy();
        this.refreshUndoMenuItems();
    }

    public void editPaste() {
        this.textPane.paste();
        this.refreshMenuItems(true);
    }

    public void undoableEditHappened(UndoableEditEvent e) {
        if (!e.getEdit().isSignificant()) {
            return;
        }
        this.refreshMenuItems(true);
    }

    public TextEditor getTextPane() {
        return this.textPane;
    }

    public static void main(String[] args) {
        final TextFrame frame = new TextFrame();
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                frame.fileExit();
            }
        });
        frame.setBounds(100, 100, 500, 800);
        frame.setVisible(true);
    }
}

