/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import com.sun.j3d.utils.universe.SimpleUniverse;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Group;
import javax.media.j3d.Node;
import javax.media.j3d.SceneGraphObject;
import javax.media.j3d.VirtualUniverse;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import ncsa.hdf.hdf5lib.H5;
import visad.ConstantMap;
import visad.Display;
import visad.DisplayImpl;
import visad.VisADException;
import visad.data.bio.LociForm;
import visad.data.mcidas.AreaForm;
import visad.data.mcidas.MapForm;
import visad.util.ComboFileFilter;
import visad.util.ExtensionFileFilter;
import visad.util.FormFileFilter;

public class Util {
    private static final Method SGO_GET_NAME;
    private static final Method SGO_SET_NAME;

    public static boolean isApproximatelyEqual(float a, float b, float epsilon) {
        if (Float.isNaN(a)) {
            return Float.isNaN(b);
        }
        if (Float.isNaN(b)) {
            return false;
        }
        if (Float.isInfinite(a)) {
            if (Float.isInfinite(b)) {
                return (double)a < 0.0 && (double)b < 0.0 || (double)a > 0.0 && (double)b > 0.0;
            }
            return false;
        }
        if (Float.isInfinite(b)) {
            return false;
        }
        if (Math.abs(a - b) < epsilon) {
            return true;
        }
        if ((double)a == 0.0 || (double)b == 0.0) {
            return false;
        }
        float FLT_EPSILON = 1.1920929E-7f;
        return Math.abs(1.0f - a / b) < 1.1920929E-7f;
    }

    public static boolean isApproximatelyEqual(float a, float b) {
        return Util.isApproximatelyEqual((double)a, (double)b, 1.0E-5);
    }

    public static boolean isApproximatelyEqual(double a, double b, double epsilon) {
        if (Double.isNaN(a)) {
            return Double.isNaN(b);
        }
        if (Double.isNaN(b)) {
            return false;
        }
        if (Double.isInfinite(a)) {
            if (Double.isInfinite(b)) {
                return a < 0.0 && b < 0.0 || a > 0.0 && b > 0.0;
            }
            return false;
        }
        if (Double.isInfinite(b)) {
            return false;
        }
        if (Math.abs(a - b) < epsilon) {
            return true;
        }
        if (a == 0.0 || b == 0.0) {
            return false;
        }
        double DBL_EPSILON = 2.220446049250313E-16;
        return Math.abs(1.0 - a / b) < 2.220446049250313E-16;
    }

    public static boolean isApproximatelyEqual(double a, double b) {
        return Util.isApproximatelyEqual(a, b, 1.0E-9);
    }

    public static String getVersionDate() {
        try {
            InputStream is = Util.class.getResourceAsStream("/DATE");
            BufferedReader in = new BufferedReader(new InputStreamReader(is));
            String date = in.readLine();
            in.close();
            return date;
        }
        catch (IOException exc) {
            return null;
        }
    }

    public static void printJ3DProperties(PrintStream str, Canvas3D canvas) {
        Map map = VirtualUniverse.getProperties();
        for (Object key : map.keySet()) {
            str.println(String.format("%s=%s", key, map.get(key)));
        }
        if (canvas == null) {
            canvas = new Canvas3D(SimpleUniverse.getPreferredConfiguration());
        }
        str.println("== Canvas3D properties ==");
        map = canvas.queryProperties();
        for (Object key : map.keySet()) {
            str.println(String.format("%s=%s", key, map.get(key).toString()));
        }
    }

    public static void printJ3DProperties(Canvas3D canvas) {
        Util.printJ3DProperties(System.err, canvas);
    }

    public static void printSceneGraph(Node node) {
        if (node == null) {
            return;
        }
        Util.printSceneGraph(node, 0);
    }

    private static void printSceneGraph(Node node, int lvl) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < lvl; ++i) {
            buf.append("    ");
        }
        ++lvl;
        System.err.println(buf.toString() + node.toString());
        if (node instanceof Group) {
            Group group = (Group)node;
            Enumeration children = group.getAllChildren();
            while (children.hasMoreElements()) {
                Util.printSceneGraph((Node)children.nextElement(), lvl);
            }
        }
    }

    public static String getName(SceneGraphObject obj) {
        if (SGO_GET_NAME != null) {
            try {
                return (String)SGO_GET_NAME.invoke((Object)obj, new Object[0]);
            }
            catch (IllegalAccessException exc) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return null;
    }

    public static void setName(SceneGraphObject obj, String name) {
        if (SGO_SET_NAME != null) {
            try {
                SGO_SET_NAME.invoke((Object)obj, name);
            }
            catch (IllegalAccessException exc) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }

    public static String getTimestamp() {
        StringBuffer sb = new StringBuffer();
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        int month = cal.get(2);
        int day = cal.get(5);
        int hour = cal.get(11);
        int min2 = cal.get(12);
        int sec = cal.get(13);
        int milli = cal.get(14);
        sb.append(year);
        sb.append("/");
        if (month < 9) {
            sb.append("0");
        }
        sb.append(month + 1);
        sb.append("/");
        if (day < 10) {
            sb.append("0");
        }
        sb.append(day);
        sb.append(", ");
        if (hour < 10) {
            sb.append("0");
        }
        sb.append(hour);
        sb.append(":");
        if (min2 < 10) {
            sb.append("0");
        }
        sb.append(min2);
        sb.append(":");
        if (sec < 10) {
            sb.append("0");
        }
        sb.append(sec);
        sb.append(".");
        if (milli < 100) {
            sb.append("0");
        }
        if (milli < 10) {
            sb.append("0");
        }
        sb.append(milli);
        return sb.toString();
    }

    public static JFileChooser getVisADFileChooser() {
        JFileChooser dialog = new JFileChooser(System.getProperty("user.dir"));
        Vector<FileFilter> filters = new Vector<FileFilter>();
        boolean jai = Util.canDoJAI();
        ExtensionFileFilter f2000 = new ExtensionFileFilter("r", "Amanda F2000");
        filters.add(f2000);
        ExtensionFileFilter text = new ExtensionFileFilter(new String[]{"csv", "tsv", "bsv", "txt"}, "ASCII text");
        filters.add(text);
        ExtensionFileFilter dem = new ExtensionFileFilter("dem", "Digital Elevation Model");
        filters.add(dem);
        ExtensionFileFilter fits = new ExtensionFileFilter("fits", "Flexible Image Transport System");
        filters.add(fits);
        if (jai) {
            ExtensionFileFilter flashpix = new ExtensionFileFilter("flashpix", "FlashPix");
            filters.add(flashpix);
        }
        if (Util.canDoHDF5()) {
            ExtensionFileFilter hdf5 = new ExtensionFileFilter(new String[]{"hdf", "hdf5"}, "HDF-5");
            filters.add(hdf5);
        }
        ExtensionFileFilter hdfeos = new ExtensionFileFilter(new String[]{"hdf", "hdfeos"}, "HDF-EOS");
        filters.add(hdfeos);
        FormFileFilter mcidasArea = new FormFileFilter(new AreaForm(), "McIDAS area (AREA*, *area)");
        filters.add(mcidasArea);
        FormFileFilter mcidasMap = new FormFileFilter(new MapForm(), "McIDAS map (OUTL*)");
        filters.add(mcidasMap);
        ExtensionFileFilter netcdf = new ExtensionFileFilter("nc", "NetCDF");
        filters.add(netcdf);
        if (jai) {
            ExtensionFileFilter pnm = new ExtensionFileFilter("pnm", "PNM");
            filters.add(pnm);
        }
        ExtensionFileFilter visad = new ExtensionFileFilter("vad", "Binary or serialized VisAD");
        filters.add(visad);
        ExtensionFileFilter vis5d = new ExtensionFileFilter("v5d", "Vis5D");
        filters.add(vis5d);
        FileFilter[] lociFilters = new LociForm().getReaderFilters();
        for (int i = 0; i < lociFilters.length; ++i) {
            filters.add(lociFilters[i]);
        }
        FileFilter[] ff = ComboFileFilter.sortFilters(filters);
        ComboFileFilter combo = new ComboFileFilter(ff, "All VisAD file types");
        dialog.addChoosableFileFilter(combo);
        for (int i = 0; i < ff.length; ++i) {
            dialog.addChoosableFileFilter(ff[i]);
        }
        dialog.setFileFilter(combo);
        return dialog;
    }

    public static void adjustTextField(JTextField field) {
        Dimension msize = field.getMaximumSize();
        Dimension psize = field.getPreferredSize();
        msize.height = psize.height;
        field.setMaximumSize(msize);
    }

    public static void adjustComboBox(JComboBox combo) {
        Dimension msize = combo.getMaximumSize();
        Dimension psize = combo.getPreferredSize();
        msize.height = psize.height;
        combo.setMaximumSize(msize);
    }

    public static void centerWindow(Window window) {
        Dimension s2 = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension w = window.getSize();
        window.setLocation((s2.width - w.width) / 2, (s2.height - w.height) / 2);
        int x = (s2.width - w.width) / 2;
        int y = (s2.height - w.height) / 2;
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        window.setLocation(x, y);
    }

    public static void centerWindow(Window parent, Window window) {
        Point loc = parent.getLocation();
        Dimension p = parent.getSize();
        Dimension w = window.getSize();
        int x = loc.x + (p.width - w.width) / 2;
        int y = loc.y + (p.height - w.height) / 2;
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        window.setLocation(x, y);
    }

    public static boolean canDoHDF5() {
        boolean success = false;
        try {
            H5.J2C(0);
            success = true;
        }
        catch (NoClassDefFoundError err) {
        }
        catch (UnsatisfiedLinkError err) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return success;
    }

    public static boolean canDoImageJ() {
        return Util.canDoClass("ij.IJ") != null;
    }

    public static boolean canDoJPEG() {
        Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName("jpeg");
        return iter.hasNext();
    }

    public static boolean canDoJAI() {
        return Util.canDoClass("javax.media.jai.JAI") != null;
    }

    public static boolean canDoPython() {
        return Util.canDoClass("org.python.util.PythonInterpreter") != null;
    }

    public static boolean canDoQuickTime() {
        return Util.canDoClass("quicktime.QTSession") != null;
    }

    public static boolean canDoJava3D() {
        return Util.canDoJava3D("1.0");
    }

    public static boolean canDoJava3D(String version) {
        Package p;
        boolean b;
        Class testClass = Util.canDoClass("javax.vecmath.Point3d");
        boolean bl = testClass != null ? Util.canDoClass("javax.media.j3d.SceneGraphObject") != null : (b = false);
        if (b && (p = testClass.getPackage()) != null) {
            try {
                b = p.isCompatibleWith(version);
            }
            catch (NumberFormatException nfe) {
                b = false;
            }
        }
        return b;
    }

    private static Class canDoClass(String classname) {
        Class<?> c = null;
        try {
            c = Class.forName(classname);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return c;
    }

    public static void captureDisplay(DisplayImpl display, String filename) {
        Util.captureDisplay(display, filename, false);
    }

    public static void captureDisplay(DisplayImpl display, String filename, boolean sync) {
        final DisplayImpl disp = display;
        final File fn = new File(filename);
        final boolean wait = sync;
        Runnable savedisp = new Runnable(){

            public void run() {
                BufferedImage image = disp.getImage(wait);
                try {
                    Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName("jpeg");
                    ImageWriter writer = iter.next();
                    ImageWriteParam param = writer.getDefaultWriteParam();
                    param.setCompressionMode(2);
                    param.setCompressionQuality(1.0f);
                    FileOutputStream fout = new FileOutputStream(fn);
                    writer.setOutput(fout);
                    IIOImage iio = new IIOImage(image, null, null);
                    writer.write(null, iio, param);
                    fout.close();
                }
                catch (Exception err) {
                    System.err.println("Error whilst saving JPEG: " + err);
                }
            }
        };
        Thread t = new Thread(savedisp);
        t.start();
    }

    public static boolean arraysEqual(Object[] o1, Object[] o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        if (o1.length != o2.length) {
            return false;
        }
        for (int i = 0; i < o1.length; ++i) {
            Object a1 = o1[i];
            Object a2 = o2[i];
            if (a1 != null ? a1.equals(a2) : a2 == null) continue;
            return false;
        }
        return true;
    }

    public static void printArray(String prefix, Object[] array) {
        StringBuffer buf = new StringBuffer();
        buf.append(prefix);
        buf.append(": ");
        if (array == null) {
            buf.append(" null ");
        } else {
            for (int i = 0; i < array.length; ++i) {
                buf.append("[");
                buf.append(i);
                buf.append("]: ");
                buf.append(array[i] == null ? "null" : array[i]);
                buf.append(" ");
            }
        }
        System.out.println(buf.toString());
    }

    public static void printArray(String prefix, double[] array) {
        StringBuffer buf = new StringBuffer();
        buf.append(prefix);
        buf.append(": ");
        if (array == null) {
            buf.append(" null ");
        } else {
            for (int i = 0; i < array.length; ++i) {
                buf.append("[");
                buf.append(i);
                buf.append("]: ");
                buf.append(array[i]);
                buf.append(" ");
            }
        }
        System.out.println(buf.toString());
    }

    public static void invoke(boolean wait, Runnable r) {
        Util.invoke(wait, false, r);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void invoke(boolean wait, boolean printStackTraces, Runnable r) {
        if (wait) {
            if (Thread.currentThread().getName().startsWith("AWT-EventQueue")) {
                r.run();
                return;
            } else {
                try {
                    SwingUtilities.invokeAndWait(r);
                    return;
                }
                catch (InterruptedException exc) {
                    if (!printStackTraces) return;
                    exc.printStackTrace();
                    return;
                }
                catch (InvocationTargetException exc) {
                    if (!printStackTraces) return;
                    exc.getTargetException().printStackTrace();
                }
            }
            return;
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    public static ConstantMap[] getColorMaps(Color color) throws VisADException {
        int alpha = color.getAlpha();
        ConstantMap[] maps = new ConstantMap[alpha == 255 ? 3 : 4];
        maps[0] = new ConstantMap((float)color.getRed() / 255.0f, Display.Red);
        maps[1] = new ConstantMap((float)color.getGreen() / 255.0f, Display.Green);
        maps[2] = new ConstantMap((float)color.getBlue() / 255.0f, Display.Blue);
        if (alpha != 255) {
            maps[3] = new ConstantMap((float)color.getAlpha() / 255.0f, Display.Alpha);
        }
        return maps;
    }

    public static Level configureLogging(int verbosity, String pkg) {
        Level lvl = Level.WARNING;
        switch (verbosity) {
            case 1: {
                lvl = Level.INFO;
                break;
            }
            case 2: {
                lvl = Level.FINE;
                break;
            }
            case 3: {
                lvl = Level.FINER;
                break;
            }
            case 4: {
                lvl = Level.FINEST;
                break;
            }
            case 5: {
                lvl = Level.ALL;
                break;
            }
            default: {
                lvl = Level.WARNING;
            }
        }
        Logger logger = Logger.getLogger(pkg);
        logger.setLevel(lvl);
        logger.setUseParentHandlers(false);
        ConsoleHandler console = new ConsoleHandler();
        console.setLevel(lvl);
        console.setFormatter(new Formatter(){

            public String format(LogRecord r) {
                return String.format("[%s] %s\n", r.getLevel().getName(), r.getMessage());
            }
        });
        logger.addHandler(console);
        return lvl;
    }

    public static Level configureLogging(int verbosity) {
        return Util.configureLogging(verbosity, "visad");
    }

    public static String getStackTrace() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        new IllegalArgumentException("stack trace").printStackTrace(new PrintStream(baos));
        return baos.toString();
    }

    public static float[][] clone(float[][] input) {
        float[][] output = (float[][])input.clone();
        for (int i = 0; i < input.length; ++i) {
            output[i] = (float[])input[i].clone();
        }
        return output;
    }

    public static double[][] clone(double[][] input) {
        double[][] output = (double[][])input.clone();
        for (int i = 0; i < input.length; ++i) {
            output[i] = (double[])input[i].clone();
        }
        return output;
    }

    public static int unsignedShortToInt(short s2) {
        return s2 & 0xFFFF;
    }

    public static int unsignedByteToInt(byte b) {
        return b & 0xFF;
    }

    public static long unsignedByteToLong(byte b) {
        return (long)b & 0xFFL;
    }

    static {
        Method sgoGetName = null;
        Method sgoSetName = null;
        try {
            sgoGetName = SceneGraphObject.class.getDeclaredMethod("getName", new Class[0]);
            sgoSetName = SceneGraphObject.class.getDeclaredMethod("setName", String.class);
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        SGO_GET_NAME = sgoGetName;
        SGO_SET_NAME = sgoSetName;
    }
}

