/*
 * Decompiled with CFR 0.152.
 */
package visad.data.vis5d;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.rmi.RemoteException;
import visad.Data;
import visad.DataImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.LinearLatLonSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.SetType;
import visad.UnimplementedException;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.Form;
import visad.data.FormFileInformer;
import visad.data.FormNode;

public class Vis5DTopoForm
extends Form
implements FormFileInformer {
    private static int num = 0;

    public Vis5DTopoForm() {
        super("Vis5DTopoForm" + num++);
    }

    public boolean isThisType(String name) {
        return name.endsWith(".v5d") || name.endsWith("TOPO");
    }

    public boolean isThisType(byte[] block) {
        String topo = new String(block, 0, 4);
        return topo.equals("TOPO");
    }

    public String[] getDefaultSuffixes() {
        String[] suff = new String[]{"v5d", "TOPO"};
        return suff;
    }

    public synchronized void save(String id, Data data, boolean replace) throws BadFormException, IOException, RemoteException, VisADException {
        throw new UnimplementedException("Vis5DTopoForm.save");
    }

    public synchronized void add(String id, Data data, boolean replace) throws BadFormException {
        throw new BadFormException("Vis5DTopoForm.add");
    }

    public synchronized FormNode getForms(Data data) {
        return null;
    }

    public synchronized DataImpl open(URL url) throws BadFormException, VisADException, IOException {
        return this.open(url.openStream());
    }

    public synchronized DataImpl open(String id) throws BadFormException, IOException, VisADException {
        return this.open(new FileInputStream(id));
    }

    public synchronized DataImpl open(InputStream in) throws BadFormException, IOException, VisADException {
        float southLat;
        float northLat;
        float eastLon;
        float westLon;
        boolean oldStyle;
        DataInputStream din = new DataInputStream(new BufferedInputStream(in));
        byte[] type = new byte[40];
        int ok = din.read(type, 0, 40);
        String header = new String(type);
        if (header.startsWith("TOPO2")) {
            oldStyle = false;
        } else if (header.startsWith("TOPO")) {
            oldStyle = true;
        } else {
            throw new BadFormException("Vis5DTopoForm.open: not a Vis5D TOPO file");
        }
        if (oldStyle) {
            westLon = (float)din.readInt() / 100.0f;
            eastLon = (float)din.readInt() / 100.0f;
            northLat = (float)din.readInt() / 100.0f;
            southLat = (float)din.readInt() / 100.0f;
        } else {
            westLon = din.readFloat();
            eastLon = din.readFloat();
            northLat = din.readFloat();
            southLat = din.readFloat();
        }
        int rows = din.readInt();
        int cols = din.readInt();
        LinearLatLonSet domain = new LinearLatLonSet((MathType)RealTupleType.SpatialEarth2DTuple, -westLon, -eastLon, cols, northLat, southLat, rows);
        FunctionType ftype = new FunctionType(((SetType)domain.getType()).getDomain(), RealType.Altitude);
        FlatField data = new FlatField(ftype, domain);
        float[][] samples = new float[1][rows * cols];
        for (int i = 0; i < rows * cols; ++i) {
            short s2 = (short)(din.readShort() / 2);
            samples[0][i] = new Short(s2).floatValue();
        }
        data.setSamples(samples, false);
        return data;
    }
}

