/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import com.sleepycat.je.utilint.MapStatComponent;
import com.sleepycat.utilint.FormatUtil;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class DoubleExpMovingAvg
extends MapStatComponent<Double, DoubleExpMovingAvg> {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final long periodMillis;
    private long prevTime;
    private double avg;

    public DoubleExpMovingAvg(String name, long periodMillis) {
        assert (name != null);
        assert (periodMillis > 0L);
        this.name = name;
        this.periodMillis = periodMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DoubleExpMovingAvg(DoubleExpMovingAvg other) {
        this.name = other.name;
        this.periodMillis = other.periodMillis;
        DoubleExpMovingAvg doubleExpMovingAvg = this;
        synchronized (doubleExpMovingAvg) {
            DoubleExpMovingAvg doubleExpMovingAvg2 = other;
            synchronized (doubleExpMovingAvg2) {
                this.prevTime = other.prevTime;
                this.avg = other.avg;
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public synchronized void add(double value, long time) {
        assert (time > 0L);
        if (time <= this.prevTime) {
            return;
        }
        if (this.prevTime == 0L) {
            this.avg = value;
        } else {
            double m3 = Math.exp(-((double)(time - this.prevTime) / (double)this.periodMillis));
            this.avg = (1.0 - m3) * value + m3 * this.avg;
        }
        this.prevTime = time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(DoubleExpMovingAvg other) {
        long otherTime;
        double otherValue;
        DoubleExpMovingAvg doubleExpMovingAvg = other;
        synchronized (doubleExpMovingAvg) {
            if (other.isNotSet()) {
                return;
            }
            otherValue = other.avg;
            otherTime = other.prevTime;
        }
        this.add(otherValue, otherTime);
    }

    synchronized double getPrimitive() {
        return this.avg;
    }

    @Override
    public Double get() {
        return this.getPrimitive();
    }

    @Override
    public synchronized void clear() {
        this.prevTime = 0L;
        this.avg = 0.0;
    }

    @Override
    public DoubleExpMovingAvg copy() {
        return new DoubleExpMovingAvg(this);
    }

    @Override
    protected synchronized String getFormattedValue(boolean useCommas) {
        if (this.isNotSet()) {
            return "unknown";
        }
        if (Double.isNaN(this.avg)) {
            return "NaN";
        }
        if (useCommas) {
            return FormatUtil.decimalScale2().format(this.avg);
        }
        return String.format("%.2f", this.avg);
    }

    @Override
    public synchronized boolean isNotSet() {
        return this.prevTime == 0L;
    }

    public synchronized String toString() {
        return "DoubleExpMovingAvg[name=" + this.name + ", avg=" + this.avg + ", prevTime=" + this.prevTime + ", periodMillis=" + this.periodMillis + "]";
    }

    private synchronized void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    private synchronized void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }
}

