/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2.table;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Formatter;
import ucar.nc2.constants.CDM;
import ucar.nc2.grib.grib2.Grib2Parameter;
import ucar.nc2.grib.grib2.table.Grib2Customizer;
import ucar.nc2.grib.grib2.table.Grib2Table;
import ucar.nc2.grib.grib2.table.LocalTables;
import ucar.unidata.util.StringUtil2;

public class DssLocalTables
extends LocalTables {
    private static final String tableName = "resources/grib2/local/cfsr.txt";
    private static boolean debug = false;
    private static DssLocalTables single;

    public static DssLocalTables getCust(Grib2Table table) {
        if (single == null) {
            single = new DssLocalTables(table);
        }
        return single;
    }

    private DssLocalTables(Grib2Table grib2Table) {
        super(grib2Table);
        if (grib2Table.getPath() == null) {
            grib2Table.setPath(tableName);
        }
        this.initLocalTable();
    }

    @Override
    public String getTablePath(int discipline, int category, int number) {
        if (category <= 191 && number <= 191) {
            return super.getTablePath(discipline, category, number);
        }
        return tableName;
    }

    protected void initLocalTable() {
        ClassLoader cl = this.getClass().getClassLoader();
        try (InputStream is = cl.getResourceAsStream(tableName);){
            String line;
            if (is == null) {
                throw new IllegalStateException("Cant find resources/grib2/local/cfsr.txt");
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(is, CDM.utf8Charset));
            while ((line = br.readLine()) != null) {
                if (line.length() == 0 || line.startsWith("#")) continue;
                String[] flds = StringUtil2.splitString(line);
                int p1 = Integer.parseInt(flds[0].trim());
                int p2 = Integer.parseInt(flds[1].trim());
                int p3 = Integer.parseInt(flds[2].trim());
                StringBuilder b = new StringBuilder();
                int count = 3;
                while (count < flds.length && !flds[count].equals(".")) {
                    b.append(flds[count++]).append(' ');
                }
                String abbrev = b.toString().trim();
                b.setLength(0);
                ++count;
                while (count < flds.length && !flds[count].equals(".")) {
                    b.append(flds[count++]).append(' ');
                }
                String name = b.toString().trim();
                b.setLength(0);
                ++count;
                while (count < flds.length && !flds[count].equals(".")) {
                    b.append(flds[count++]).append(' ');
                }
                String unit = b.toString().trim();
                Grib2Parameter s2 = new Grib2Parameter(p1, p2, p3, name, unit, abbrev, null);
                this.local.put(DssLocalTables.makeParamId(p1, p2, p3), s2);
                if (!debug) continue;
                System.out.printf(" %s%n", s2);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static void main(String[] args) {
        DssLocalTables t = new DssLocalTables(new Grib2Table("DSS", 7, 0, 0, 0, -1, null, Grib2Table.Type.dss));
        Formatter f = new Formatter();
        Grib2Parameter.compareTables("DSS-093", "Standard WMO version 8", t.getParameters(), Grib2Customizer.factory(0, 0, 0, 0, 0), f);
        System.out.printf("%s%n", f);
        Formatter f2 = new Formatter();
        Grib2Parameter.compareTables("DSS-093", "NCEP Table", t.getParameters(), Grib2Customizer.factory(7, 0, 0, 0, 0), f2);
        System.out.printf("%s%n", f2);
    }
}

