/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util.xml;

import java.io.IOException;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Verifier;
import org.jdom2.input.SAXBuilder;
import ucar.unidata.util.StringUtil2;

public class Parse {
    private static char[] xmlInC = new char[]{'&', '<', '>'};
    private static String[] xmlOutC = new String[]{"&amp;", "&lt;", "&gt;"};

    public static Element readRootElement(String location) throws IOException {
        Document doc;
        try {
            SAXBuilder builder = new SAXBuilder();
            builder.setExpandEntities(false);
            doc = builder.build(location);
        }
        catch (JDOMException e) {
            throw new IOException(e.getMessage());
        }
        return doc.getRootElement();
    }

    public static String cleanCharacterData(String text) {
        if (text == null) {
            return text;
        }
        boolean bad = false;
        int len = text.length();
        for (int i = 0; i < len; ++i) {
            char ch = text.charAt(i);
            if (Verifier.isXMLCharacter(ch)) continue;
            bad = true;
            break;
        }
        if (!bad) {
            return text;
        }
        StringBuilder sbuff = new StringBuilder(text.length());
        int len2 = text.length();
        for (int i = 0; i < len2; ++i) {
            char ch = text.charAt(i);
            if (!Verifier.isXMLCharacter(ch)) continue;
            sbuff.append(ch);
        }
        return sbuff.toString();
    }

    public static String quoteXmlContent(String x) {
        return StringUtil2.replace(x, xmlInC, xmlOutC);
    }

    public static String unquoteXmlContent(String x) {
        return StringUtil2.unreplace(x, xmlOutC, xmlInC);
    }
}

