/*
 * Decompiled with CFR 0.152.
 */
package thredds.client.catalog;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import net.jcip.annotations.Immutable;
import ucar.nc2.constants.CDM;

@Immutable
public class Documentation {
    private final String href;
    private final String title;
    private final String type;
    private final String inlineContent;
    private final URI uri;

    public Documentation(String href, URI uri, String title, String type, String inlineContent) {
        this.href = href;
        this.uri = uri;
        this.type = type;
        this.inlineContent = inlineContent;
        this.title = title != null ? title : (uri != null ? uri.toString() : null);
    }

    public String getType() {
        return this.type;
    }

    public boolean hasXlink() {
        return this.uri != null;
    }

    public URI getURI() {
        return this.uri;
    }

    public String getXlinkTitle() {
        return this.title;
    }

    public String getXlinkHref() {
        return this.href;
    }

    public String getInlineContent() {
        return this.inlineContent;
    }

    public String readXlinkContent() throws IOException {
        int bytesRead;
        if (this.uri == null) {
            return "";
        }
        URL url = this.uri.toURL();
        InputStream is = url.openStream();
        ByteArrayOutputStream os = new ByteArrayOutputStream(is.available());
        byte[] buffer = new byte[1024];
        while ((bytesRead = is.read(buffer)) != -1) {
            os.write(buffer, 0, bytesRead);
        }
        is.close();
        return new String(os.toByteArray(), CDM.utf8Charset);
    }

    public String toString() {
        return "Documentation{href='" + this.href + '\'' + ", title='" + this.title + '\'' + ", type='" + this.type + '\'' + ", inlineContent='" + this.inlineContent + '\'' + ", uri=" + this.uri + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Documentation that = (Documentation)o;
        if (this.href != null ? !this.href.equals(that.href) : that.href != null) {
            return false;
        }
        if (this.inlineContent != null ? !this.inlineContent.equals(that.inlineContent) : that.inlineContent != null) {
            return false;
        }
        if (this.title != null ? !this.title.equals(that.title) : that.title != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        return !(this.uri != null ? !this.uri.equals(that.uri) : that.uri != null);
    }

    public int hashCode() {
        int result = this.href != null ? this.href.hashCode() : 0;
        result = 31 * result + (this.title != null ? this.title.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.inlineContent != null ? this.inlineContent.hashCode() : 0);
        result = 31 * result + (this.uri != null ? this.uri.hashCode() : 0);
        return result;
    }
}

