/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ncml;

import java.io.IOException;
import java.util.Formatter;
import java.util.Set;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.inventory.DateExtractorFromName;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ft.fmrc.Fmrc;
import ucar.nc2.ncml.Aggregation;
import ucar.nc2.ncml.AggregationOuterDimension;
import ucar.nc2.util.CancelTask;

public class AggregationFmrc
extends AggregationOuterDimension {
    protected static Set<NetcdfDataset.Enhance> fmrcEnhanceMode = NetcdfDataset.getDefaultEnhanceMode();
    private Fmrc fmrc;
    private String runMatcher;

    public AggregationFmrc(NetcdfDataset ncd, String dimName, String recheckS) {
        super(ncd, dimName, Aggregation.Type.forecastModelRunCollection, recheckS);
    }

    public void addDirectoryScanFmrc(String dirName, String suffix, String regexpPatternString, String subdirs, String olderThan, String runMatcher, String forecastMatcher, String offsetMatcher) throws IOException {
        this.runMatcher = runMatcher;
        this.isDate = true;
        this.datasetManager.addDirectoryScan(dirName, suffix, regexpPatternString, subdirs, olderThan, null);
        if (runMatcher != null) {
            DateExtractorFromName dateExtractor = new DateExtractorFromName(runMatcher, false);
            this.datasetManager.setDateExtractor(dateExtractor);
        }
    }

    @Override
    protected void makeDatasets(CancelTask cancelTask) throws IOException {
        super.makeDatasets(cancelTask);
        for (Aggregation.Dataset ds : this.datasets) {
            ds.enhance = fmrcEnhanceMode;
        }
    }

    @Override
    public void getDetailInfo(Formatter f) {
        super.getDetailInfo(f);
        if (this.runMatcher != null) {
            f.format("  runMatcher=%s%n", this.runMatcher);
        }
    }

    @Override
    protected void buildNetcdfDataset(CancelTask cancelTask) throws IOException {
        DateExtractorFromName dateExtractor = null;
        if (this.runMatcher != null) {
            dateExtractor = new DateExtractorFromName(this.runMatcher, false);
        }
        if (dateExtractor == null && this.dateFormatMark != null) {
            dateExtractor = new DateExtractorFromName(this.dateFormatMark, true);
        }
        this.fmrc = new Fmrc(this.datasetManager, new FeatureCollectionConfig());
        this.fmrc.getDataset2D(this.ncDataset);
        this.ncDataset.finish();
    }

    @Override
    protected void rebuildDataset() throws IOException {
        throw new UnsupportedOperationException();
    }
}

