/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.vlsn;

import com.sleepycat.bind.tuple.LongBinding;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Durability;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogItem;
import com.sleepycat.je.recovery.RecoveryInfo;
import com.sleepycat.je.rep.impl.RepParams;
import com.sleepycat.je.rep.impl.node.NameIdPair;
import com.sleepycat.je.rep.vlsn.GhostBucket;
import com.sleepycat.je.rep.vlsn.LogItemCache;
import com.sleepycat.je.rep.vlsn.VLSNBucket;
import com.sleepycat.je.rep.vlsn.VLSNRange;
import com.sleepycat.je.rep.vlsn.VLSNRecoveryTracker;
import com.sleepycat.je.rep.vlsn.VLSNTracker;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.Txn;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.VLSN;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VLSNIndex {
    private final EnvironmentImpl envImpl;
    private VLSNAwaitLatch vlsnPutLatch = null;
    private VLSN putWaitVLSN = null;
    private final Object mappingSynchronizer = new Object();
    private final Object flushSynchronizer = new Object();
    private final Logger logger;
    private AtomicLong nextVLSNCounter;
    private DatabaseImpl mappingDbImpl;
    private VLSNTracker tracker;
    private final LogItemCache logItemCache;

    public VLSNIndex(EnvironmentImpl envImpl, String mappingDbName, NameIdPair nameIdPair, int vlsnStride, int vlsnMaxMappings, int vlsnMaxDistance, RecoveryInfo recoveryInfo) throws DatabaseException {
        this.envImpl = envImpl;
        this.logger = LoggerUtils.getLogger(this.getClass());
        this.init(mappingDbName, vlsnStride, vlsnMaxMappings, vlsnMaxDistance, recoveryInfo);
        this.logItemCache = new LogItemCache(envImpl.getConfigManager().getInt(RepParams.VLSN_LOG_CACHE_SIZE));
    }

    public void initAsMaster() {
        VLSN last = this.tracker.getRange().getLast();
        this.nextVLSNCounter = last.equals(VLSN.NULL_VLSN) ? (this.envImpl.needConvert() ? new AtomicLong(1L) : new AtomicLong(0L)) : new AtomicLong(last.getSequence());
    }

    public VLSN bump() {
        return new VLSN(this.nextVLSNCounter.incrementAndGet());
    }

    public void decrement() {
        this.nextVLSNCounter.decrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(LogItem logItem) {
        VLSN vlsn = logItem.getHeader().getVLSN();
        long lsn = logItem.getNewLsn();
        byte entryType = logItem.getHeader().getType();
        this.logItemCache.put(vlsn, logItem);
        VLSNIndex vLSNIndex = this;
        synchronized (vLSNIndex) {
            this.tracker.track(vlsn, lsn, entryType);
            Object object = this.mappingSynchronizer;
            synchronized (object) {
                if (this.vlsnPutLatch != null && vlsn.compareTo(this.putWaitVLSN) >= 0) {
                    this.vlsnPutLatch.setLogItem(logItem);
                    this.vlsnPutLatch.countDown();
                    this.vlsnPutLatch = null;
                    this.putWaitVLSN = null;
                }
            }
        }
        if (this.logger.isLoggable(Level.FINEST)) {
            LoggerUtils.finest(this.logger, this.envImpl, "vlsnIndex put " + vlsn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogItem waitForVLSN(VLSN vlsn, int waitTime) throws InterruptedException, WaitTimeOutException {
        VLSNRange useRange = this.tracker.getRange();
        if (useRange.getLast().compareTo(vlsn) >= 0) {
            return this.logItemCache.get(vlsn);
        }
        VLSNAwaitLatch waitLatch = null;
        VLSNIndex vLSNIndex = this;
        synchronized (vLSNIndex) {
            useRange = this.tracker.getRange();
            if (useRange.getLast().compareTo(vlsn) >= 0) {
                return this.logItemCache.get(vlsn);
            }
            Object object = this.mappingSynchronizer;
            synchronized (object) {
                this.setupWait(vlsn);
                waitLatch = this.vlsnPutLatch;
            }
        }
        if (!waitLatch.await(waitTime, TimeUnit.MILLISECONDS) || waitLatch.isTerminated()) {
            throw new WaitTimeOutException();
        }
        assert (this.tracker.getRange().getLast().compareTo(vlsn) >= 0);
        LogItem logItem = waitLatch.getLogItem();
        return logItem.getHeader().getVLSN().equals(vlsn) ? logItem : null;
    }

    private void setupWait(VLSN vlsn) {
        if (this.vlsnPutLatch == null) {
            this.putWaitVLSN = vlsn;
            this.vlsnPutLatch = new VLSNAwaitLatch();
        } else if (!vlsn.equals(this.putWaitVLSN)) {
            throw EnvironmentFailureException.unexpectedState(this.envImpl, "unexpected get for VLSN: " + vlsn + "already waiting for VLSN: " + this.putWaitVLSN);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void truncateFromHead(VLSN deleteEnd, long deleteFileNum) throws DatabaseException {
        LoggerUtils.fine(this.logger, this.envImpl, "head truncate called with " + deleteEnd + " delete file#:" + deleteFileNum);
        this.logItemCache.clear();
        if (deleteEnd.equals(VLSN.NULL_VLSN)) {
            return;
        }
        VLSNRange currentRange = this.tracker.getRange();
        if (currentRange.getFirst().compareTo(deleteEnd) > 0) {
            return;
        }
        if (currentRange.isEmpty()) {
            throw EnvironmentFailureException.unexpectedState(this.envImpl, "Didn't expect current range to be empty.  End of delete range = " + deleteEnd);
        }
        if (!currentRange.getLastSync().equals(VLSN.NULL_VLSN) && deleteEnd.compareTo(currentRange.getLastSync()) > 0) {
            throw EnvironmentFailureException.unexpectedState(this.envImpl, "Can't log clean away last matchpoint. DeleteEnd= " + deleteEnd + " lastSync=" + currentRange.getLastSync());
        }
        this.tracker.truncateFromHead(deleteEnd, deleteFileNum);
        TransactionConfig config = new TransactionConfig();
        config.setDurability(Durability.COMMIT_NO_SYNC);
        Txn txn = Txn.createLocalTxn(this.envImpl, config);
        boolean success = false;
        try {
            Object object = this.flushSynchronizer;
            synchronized (object) {
                this.pruneDatabaseHead(deleteEnd, deleteFileNum, txn);
                this.flushToDatabase(txn);
            }
            txn.commit();
            return;
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            if (success) throw throwable;
            txn.abort();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void truncateFromTail(VLSN deleteStart, long lastLsn) throws DatabaseException {
        this.logItemCache.clear();
        VLSNRange currentRange = this.tracker.getRange();
        if (currentRange.getLast().getNext().equals(deleteStart)) {
            return;
        }
        this.tracker.truncateFromTail(deleteStart, lastLsn);
        TransactionConfig config = new TransactionConfig();
        config.setDurability(Durability.COMMIT_NO_SYNC);
        Txn txn = Txn.createLocalTxn(this.envImpl, config);
        boolean success = false;
        try {
            this.pruneDatabaseTail(deleteStart, lastLsn, txn);
            this.flushToDatabase(txn);
            txn.commit();
            return;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            if (success) throw throwable;
            txn.abort();
            throw throwable;
        }
    }

    public VLSNRange getRange() {
        return this.tracker.getRange();
    }

    public long getLTEFileNumber(VLSN vlsn) throws DatabaseException {
        VLSNBucket bucket = this.getLTEBucket(vlsn);
        return bucket.getLTEFileNumber();
    }

    private VLSNBucket getGTEBucket(VLSN vlsn) throws DatabaseException {
        VLSNBucket bucket = this.tracker.getGTEBucket(vlsn);
        if (bucket == null) {
            return this.getGTEBucketFromDatabase(vlsn);
        }
        return bucket;
    }

    private VLSNBucket getLTEBucket(VLSN vlsn) throws DatabaseException {
        VLSNBucket bucket = this.tracker.getLTEBucket(vlsn);
        if (bucket == null) {
            return this.getLTEBucketFromDatabase(vlsn);
        }
        return bucket;
    }

    private boolean isValidBucket(OperationStatus status, DatabaseEntry key) {
        return status == OperationStatus.SUCCESS && LongBinding.entryToLong(key) != -1L;
    }

    public VLSNBucket getLTEBucketFromDatabase(VLSN vlsn) throws DatabaseException {
        block5: {
            VLSNBucket vLSNBucket;
            BasicLocker locker;
            block6: {
                Cursor cursor = null;
                locker = null;
                DatabaseEntry key = new DatabaseEntry();
                DatabaseEntry data = new DatabaseEntry();
                try {
                    locker = BasicLocker.createBasicLocker(this.envImpl);
                    cursor = DbInternal.makeCursor(this.mappingDbImpl, locker, CursorConfig.DEFAULT);
                    if (!this.positionBeforeOrEqual(cursor, vlsn, key, data)) break block5;
                    vLSNBucket = VLSNBucket.readFromDatabase(data);
                    Object var8_7 = null;
                    if (cursor == null) break block6;
                }
                catch (Throwable throwable) {
                    block7: {
                        Object var8_8 = null;
                        if (cursor != null) {
                            cursor.close();
                        }
                        if (locker == null) break block7;
                        ((Locker)locker).operationEnd(true);
                    }
                    throw throwable;
                }
                cursor.close();
            }
            if (locker != null) {
                ((Locker)locker).operationEnd(true);
            }
            return vLSNBucket;
        }
        throw EnvironmentFailureException.unexpectedState(this.envImpl, "Couldn't find bucket for LTE VLSN " + vlsn + "in database. tracker=" + this.tracker);
    }

    private VLSNBucket getGTEBucketFromDatabase(VLSN vlsn) throws DatabaseException {
        VLSNBucket endBucket;
        block17: {
            VLSNBucket vLSNBucket;
            BasicLocker locker;
            block18: {
                OperationStatus status;
                DatabaseEntry data;
                DatabaseEntry key;
                Cursor cursor;
                block11: {
                    VLSNBucket vLSNBucket2;
                    block16: {
                        VLSNBucket bucket;
                        block14: {
                            VLSNBucket vLSNBucket3;
                            block15: {
                                VLSNBucket prevBucket;
                                block12: {
                                    VLSNBucket vLSNBucket4;
                                    block13: {
                                        cursor = null;
                                        locker = null;
                                        key = new DatabaseEntry();
                                        data = new DatabaseEntry();
                                        LongBinding.longToEntry(vlsn.getSequence(), key);
                                        try {
                                            locker = BasicLocker.createBasicLocker(this.envImpl);
                                            cursor = DbInternal.makeCursor(this.mappingDbImpl, locker, CursorConfig.DEFAULT);
                                            status = cursor.getSearchKeyRange(key, data, LockMode.DEFAULT);
                                            if (status != OperationStatus.SUCCESS) break block11;
                                            bucket = VLSNBucket.readFromDatabase(data);
                                            if (!bucket.owns(vlsn)) break block12;
                                            vLSNBucket4 = bucket;
                                            Object var11_12 = null;
                                            if (cursor == null) break block13;
                                        }
                                        catch (Throwable throwable) {
                                            block19: {
                                                Object var11_16 = null;
                                                if (cursor != null) {
                                                    cursor.close();
                                                }
                                                if (locker == null) break block19;
                                                ((Locker)locker).operationEnd(true);
                                            }
                                            throw throwable;
                                        }
                                        cursor.close();
                                    }
                                    if (locker != null) {
                                        ((Locker)locker).operationEnd(true);
                                    }
                                    return vLSNBucket4;
                                }
                                status = cursor.getPrev(key, data, LockMode.DEFAULT);
                                if (!this.isValidBucket(status, key) || !(prevBucket = VLSNBucket.readFromDatabase(data)).owns(vlsn)) break block14;
                                vLSNBucket3 = prevBucket;
                                Object var11_13 = null;
                                if (cursor == null) break block15;
                                cursor.close();
                            }
                            if (locker != null) {
                                ((Locker)locker).operationEnd(true);
                            }
                            return vLSNBucket3;
                        }
                        vLSNBucket2 = bucket;
                        Object var11_14 = null;
                        if (cursor == null) break block16;
                        cursor.close();
                    }
                    if (locker != null) {
                        ((Locker)locker).operationEnd(true);
                    }
                    return vLSNBucket2;
                }
                endBucket = null;
                status = cursor.getLast(key, data, LockMode.DEFAULT);
                if (!this.isValidBucket(status, key) || !(endBucket = VLSNBucket.readFromDatabase(data)).owns(vlsn)) break block17;
                vLSNBucket = endBucket;
                Object var11_15 = null;
                if (cursor == null) break block18;
                cursor.close();
            }
            if (locker != null) {
                ((Locker)locker).operationEnd(true);
            }
            return vLSNBucket;
        }
        throw EnvironmentFailureException.unexpectedState(this.envImpl, "Couldn't find bucket for GTE VLSN " + vlsn + " in database. EndBucket = " + endBucket + " tracker = " + this.tracker);
    }

    private boolean positionBeforeOrEqual(Cursor cursor, VLSN vlsn, DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
        LongBinding.longToEntry(vlsn.getSequence(), key);
        VLSNBucket bucket = null;
        OperationStatus status = cursor.getSearchKeyRange(key, data, LockMode.DEFAULT);
        if (status == OperationStatus.SUCCESS) {
            bucket = VLSNBucket.readFromDatabase(data);
            if (bucket.owns(vlsn)) {
                return true;
            }
            status = cursor.getPrev(key, data, LockMode.DEFAULT);
            return this.isValidBucket(status, key);
        }
        status = cursor.getLast(key, data, LockMode.DEFAULT);
        return this.isValidBucket(status, key);
    }

    private boolean positionAfterOrEqual(Cursor cursor, VLSN vlsn, DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
        LongBinding.longToEntry(vlsn.getSequence(), key);
        VLSNBucket bucket = null;
        OperationStatus status = cursor.getSearchKeyRange(key, data, LockMode.DEFAULT);
        if (status == OperationStatus.SUCCESS) {
            bucket = VLSNBucket.readFromDatabase(data);
            if (bucket.owns(vlsn)) {
                return true;
            }
            status = cursor.getPrev(key, data, LockMode.DEFAULT);
            assert (status == OperationStatus.SUCCESS);
            if (this.isValidBucket(status, key) && (bucket = VLSNBucket.readFromDatabase(data)).owns(vlsn)) {
                return true;
            }
            status = cursor.getNext(key, data, LockMode.DEFAULT);
            return true;
        }
        status = cursor.getLast(key, data, LockMode.DEFAULT);
        return this.isValidBucket(status, key) && (bucket = VLSNBucket.readFromDatabase(data)).owns(vlsn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void pruneDatabaseHead(VLSN deleteEnd, long deleteFileNum, Txn txn) throws DatabaseException {
        Cursor cursor;
        block11: {
            block10: {
                block9: {
                    block8: {
                        cursor = null;
                        try {
                            long keyValue;
                            cursor = DbInternal.makeCursor(this.mappingDbImpl, txn, CursorConfig.DEFAULT);
                            DatabaseEntry key = new DatabaseEntry();
                            DatabaseEntry data = new DatabaseEntry();
                            if (!this.positionBeforeOrEqual(cursor, deleteEnd, key, data)) {
                                Object var17_7 = null;
                                if (cursor == null) return;
                                break block8;
                            }
                            while ((keyValue = LongBinding.entryToLong(key)) != -1L) {
                                OperationStatus status = cursor.delete();
                                if (status != OperationStatus.SUCCESS) {
                                    throw EnvironmentFailureException.unexpectedState(this.envImpl, "Couldn't delete, got status of " + (Object)((Object)status) + "for delete of bucket " + keyValue + " deleteEnd=" + deleteEnd);
                                }
                                if (cursor.getPrev(key, data, LockMode.DEFAULT) == OperationStatus.SUCCESS) continue;
                            }
                            VLSN newStart = deleteEnd.getNext();
                            LongBinding.longToEntry(1L, key);
                            OperationStatus status = cursor.getSearchKeyRange(key, data, LockMode.DEFAULT);
                            if (status != OperationStatus.SUCCESS) {
                                break block9;
                            }
                            VLSNBucket firstBucket = VLSNBucket.readFromDatabase(data);
                            if (firstBucket.getFirst().equals(newStart)) {
                                break block10;
                            }
                            if (firstBucket.getFirst().compareTo(newStart) < 0) {
                                throw EnvironmentFailureException.unexpectedState(this.envImpl, "newStart " + newStart + " should be < first bucket:" + firstBucket);
                            }
                            long nextFile = this.envImpl.getFileManager().getFollowingFileNum(deleteFileNum, true);
                            long lastPossibleLsn = firstBucket.getLsn(firstBucket.getFirst());
                            GhostBucket placeholder = new GhostBucket(newStart, DbLsn.makeLsn(nextFile, 0), lastPossibleLsn);
                            placeholder.writeToDatabase(this.envImpl, cursor);
                            break block11;
                        }
                        catch (Throwable throwable) {
                            Object var17_11 = null;
                            if (cursor == null) throw throwable;
                            cursor.close();
                            throw throwable;
                        }
                    }
                    cursor.close();
                    return;
                }
                Object var17_8 = null;
                if (cursor == null) return;
                cursor.close();
                return;
            }
            Object var17_9 = null;
            if (cursor == null) return;
            cursor.close();
            return;
        }
        Object var17_10 = null;
        if (cursor == null) return;
        cursor.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private VLSN pruneDatabaseTail(VLSN deleteStart, long lastLsn, Txn txn) throws DatabaseException {
        OperationStatus status;
        DatabaseEntry data;
        DatabaseEntry key;
        Cursor cursor;
        VLSN lastOnDiskVLSN;
        block7: {
            block6: {
                lastOnDiskVLSN = deleteStart.getPrev();
                cursor = null;
                cursor = DbInternal.makeCursor(this.mappingDbImpl, txn, CursorConfig.DEFAULT);
                key = new DatabaseEntry();
                data = new DatabaseEntry();
                if (this.positionAfterOrEqual(cursor, deleteStart, key, data)) break block6;
                VLSN vLSN = this.tracker.getLastOnDisk();
                Object var13_10 = null;
                if (cursor == null) return vLSN;
                cursor.close();
                return vLSN;
            }
            VLSNBucket bucket = VLSNBucket.readFromDatabase(data);
            if (bucket.getFirst().compareTo(deleteStart) >= 0) break block7;
            bucket.removeFromTail(deleteStart, lastLsn);
            lastOnDiskVLSN = bucket.getLast();
            bucket.fillDataEntry(data);
            status = cursor.putCurrent(data);
            if (status != OperationStatus.SUCCESS) {
                throw EnvironmentFailureException.unexpectedState(this.envImpl, "Couldn't update " + bucket);
            }
            status = cursor.getNext(key, data, LockMode.DEFAULT);
            if (status == OperationStatus.SUCCESS) break block7;
            VLSN vLSN = lastOnDiskVLSN;
            Object var13_11 = null;
            if (cursor == null) return vLSN;
            cursor.close();
            return vLSN;
        }
        try {
            do {
                if ((status = cursor.delete()) == OperationStatus.SUCCESS) continue;
                throw EnvironmentFailureException.unexpectedState(this.envImpl, "Couldn't delete after vlsn " + deleteStart + " status=" + (Object)((Object)status));
            } while (cursor.getNext(key, data, LockMode.DEFAULT) == OperationStatus.SUCCESS);
            Object var13_12 = null;
            if (cursor == null) return lastOnDiskVLSN;
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            if (cursor == null) throw throwable;
            cursor.close();
            throw throwable;
        }
        cursor.close();
        return lastOnDiskVLSN;
    }

    private void init(String mappingDbName, int vlsnStride, int vlsnMaxMappings, int vlsnMaxDistance, RecoveryInfo recoveryInfo) throws DatabaseException {
        this.openMappingDatabase(mappingDbName);
        this.tracker = new VLSNTracker(this.envImpl, this.mappingDbImpl, vlsnStride, vlsnMaxMappings, vlsnMaxDistance);
        this.merge((VLSNRecoveryTracker)recoveryInfo.vlsnProxy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void merge(VLSNRecoveryTracker recoveryTracker) {
        if (recoveryTracker == null) {
            this.flushToDatabase();
            return;
        }
        if (recoveryTracker.isEmpty()) {
            VLSN lastMatchpointVLSN = recoveryTracker.getLastMatchpointVLSN();
            if (lastMatchpointVLSN.isNull()) {
                return;
            }
            recoveryTracker.track(lastMatchpointVLSN, recoveryTracker.getLastMatchpointLsn(), LogEntryType.LOG_MATCHPOINT.getTypeNum());
        }
        VLSN persistentLast = this.tracker.getRange().getLast();
        VLSN recoveryFirst = recoveryTracker.getRange().getFirst();
        if (!(this.envImpl.isConverted() && persistentLast.isNull() && this.envImpl.isConverted() || recoveryFirst.compareTo(persistentLast.getNext()) <= 0)) {
            throw EnvironmentFailureException.unexpectedState(this.envImpl, "recoveryTracker should overlap or follow on disk last VLSN of " + persistentLast + " recoveryFirst= " + recoveryFirst);
        }
        VLSNRange currentRange = this.tracker.getRange();
        if (currentRange.getLast().getNext().equals(recoveryFirst)) {
            this.tracker.append(recoveryTracker);
            this.flushToDatabase();
            return;
        }
        TransactionConfig config = new TransactionConfig();
        config.setDurability(Durability.COMMIT_NO_SYNC);
        Txn txn = Txn.createLocalTxn(this.envImpl, config);
        boolean success = false;
        try {
            VLSN lastOnDiskVLSN = this.pruneDatabaseTail(recoveryFirst, -1L, txn);
            this.tracker.merge(lastOnDiskVLSN, recoveryTracker);
            this.flushToDatabase(txn);
            txn.commit();
            return;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (success) throw throwable;
            txn.abort();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openMappingDatabase(String mappingDbName) throws DatabaseException {
        Txn locker = Txn.createLocalAutoTxn(this.envImpl, new TransactionConfig());
        try {
            DbTree dbTree = this.envImpl.getDbTree();
            DatabaseImpl db = dbTree.getDb(locker, mappingDbName, null);
            if (db == null) {
                if (this.envImpl.isReadOnly()) {
                    throw EnvironmentFailureException.unexpectedState("A replicated environment can't be opened read only.");
                }
                DatabaseConfig dbConfig = new DatabaseConfig();
                DbInternal.setReplicated(dbConfig, false);
                db = dbTree.createInternalDb(locker, mappingDbName, dbConfig);
            }
            this.mappingDbImpl = db;
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            ((Locker)locker).operationEnd(true);
            throw throwable;
        }
        ((Locker)locker).operationEnd(true);
    }

    public synchronized void close() {
        this.close(true);
    }

    public synchronized void abnormalClose() {
        this.close(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean doFlush) throws DatabaseException {
        try {
            if (doFlush) {
                this.flushToDatabase();
            }
            if (this.vlsnPutLatch != null) {
                this.vlsnPutLatch.terminate();
                LoggerUtils.fine(this.logger, this.envImpl, "Outstanding VLSN put latch cleared at close");
            }
            Object var3_2 = null;
            if (this.mappingDbImpl != null) {
                this.envImpl.getDbTree().releaseDb(this.mappingDbImpl);
                this.mappingDbImpl = null;
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (this.mappingDbImpl != null) {
                this.envImpl.getDbTree().releaseDb(this.mappingDbImpl);
                this.mappingDbImpl = null;
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void flushToDatabase() {
        TransactionConfig config = new TransactionConfig();
        config.setDurability(Durability.COMMIT_NO_SYNC);
        Txn txn = Txn.createLocalTxn(this.envImpl, config);
        boolean success = false;
        try {
            this.flushToDatabase(txn);
            txn.commit();
            return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (success) throw throwable;
            txn.abort();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushToDatabase(Txn txn) throws DatabaseException {
        Object object = this.flushSynchronizer;
        synchronized (object) {
            this.tracker.flushToDatabase(this.mappingDbImpl, txn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<VLSN, Long> dumpDb(boolean display) {
        HashMap<VLSN, Long> mappings;
        BasicLocker locker;
        block13: {
            Cursor cursor = null;
            locker = null;
            if (display) {
                System.out.println(this.tracker);
            }
            mappings = new HashMap<VLSN, Long>();
            try {
                locker = BasicLocker.createBasicLocker(this.envImpl);
                cursor = DbInternal.makeCursor(this.mappingDbImpl, locker, CursorConfig.DEFAULT);
                DatabaseEntry key = new DatabaseEntry();
                DatabaseEntry data = new DatabaseEntry();
                int count = 0;
                while (cursor.getNext(key, data, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                    Long keyValue = LongBinding.entryToLong(key);
                    if (display) {
                        System.out.println("key => " + keyValue);
                    }
                    if (count == 0) {
                        VLSNRange range = VLSNRange.readFromDatabase(data);
                        if (display) {
                            System.out.println("range =>");
                            System.out.println(range);
                        }
                    } else {
                        VLSNBucket bucket = VLSNBucket.readFromDatabase(data);
                        for (long i = bucket.getFirst().getSequence(); i <= bucket.getLast().getSequence(); ++i) {
                            VLSN v = new VLSN(i);
                            long lsn = bucket.getLsn(v);
                            if (lsn == -1L) continue;
                            mappings.put(v, lsn);
                        }
                        if (display) {
                            System.out.println("bucket =>");
                            System.out.println(bucket);
                        }
                    }
                    ++count;
                }
                Object var16_13 = null;
                if (cursor == null) break block13;
            }
            catch (Throwable throwable) {
                Object var16_14 = null;
                if (cursor != null) {
                    cursor.close();
                }
                if (locker != null) {
                    ((Locker)locker).operationEnd(true);
                }
                throw throwable;
            }
            cursor.close();
        }
        if (locker != null) {
            ((Locker)locker).operationEnd(true);
        }
        return mappings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void verifyDb(Environment env, PrintStream out, boolean verbose) throws DatabaseException {
        Cursor cursor;
        Database db;
        block18: {
            block16: {
                block17: {
                    DatabaseConfig dbConfig = new DatabaseConfig();
                    dbConfig.setReadOnly(true);
                    db = env.openDatabase(null, "_jeVlsnMapDb", dbConfig);
                    cursor = null;
                    try {
                        if (verbose) {
                            System.out.println("Verifying VLSN index");
                        }
                        cursor = db.openCursor(null, CursorConfig.READ_COMMITTED);
                        DatabaseEntry key = new DatabaseEntry();
                        DatabaseEntry data = new DatabaseEntry();
                        int count = 0;
                        VLSNRange range = null;
                        VLSNBucket lastBucket = null;
                        Long lastKey = null;
                        VLSN firstVLSNSeen = VLSN.NULL_VLSN;
                        VLSN lastVLSNSeen = VLSN.NULL_VLSN;
                        while (cursor.getNext(key, data, null) == OperationStatus.SUCCESS) {
                            Long keyValue = LongBinding.entryToLong(key);
                            if (count == 0) {
                                if (keyValue != -1L) {
                                    out.println("Wrong key value for range! " + range);
                                }
                                range = VLSNRange.readFromDatabase(data);
                                if (verbose) {
                                    out.println("range=>" + range);
                                }
                            } else {
                                VLSNBucket bucket = VLSNBucket.readFromDatabase(data);
                                if (verbose) {
                                    out.print("key=> " + keyValue);
                                    out.println(" bucket=>" + bucket);
                                }
                                if (lastBucket != null && lastBucket.getLast().compareTo(bucket.getFirst()) >= 0) {
                                    out.println("Buckets out of order.");
                                    out.println("Last = " + lastKey + "/" + lastBucket);
                                    out.println("Current = " + keyValue + "/" + bucket);
                                }
                                lastBucket = bucket;
                                lastKey = keyValue;
                                if (firstVLSNSeen != null && firstVLSNSeen.isNull()) {
                                    firstVLSNSeen = bucket.getFirst();
                                }
                                lastVLSNSeen = bucket.getLast();
                            }
                            ++count;
                        }
                        if (count == 0) {
                            out.println("VLSNIndex not on disk");
                            Object var17_16 = null;
                            if (cursor == null) break block16;
                            break block17;
                        }
                        if (firstVLSNSeen.compareTo(range.getFirst()) != 0) {
                            out.println("First VLSN in bucket = " + firstVLSNSeen + " and doesn't match range " + range.getFirst());
                        }
                        if (lastVLSNSeen.compareTo(range.getLast()) != 0) {
                            out.println("Last VLSN in bucket = " + lastVLSNSeen + " and doesn't match range " + range.getLast());
                        }
                        break block18;
                    }
                    catch (Throwable throwable) {
                        Object var17_18 = null;
                        if (cursor != null) {
                            cursor.close();
                        }
                        db.close();
                        throw throwable;
                    }
                }
                cursor.close();
            }
            db.close();
            return;
        }
        Object var17_17 = null;
        if (cursor != null) {
            cursor.close();
        }
        db.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean verify(boolean verbose) throws DatabaseException {
        if (!this.tracker.verify(verbose)) {
            return false;
        }
        VLSNRange dbRange = null;
        ArrayList<VLSN> firstVLSN = new ArrayList<VLSN>();
        ArrayList<VLSN> lastVLSN = new ArrayList<VLSN>();
        BasicLocker locker = BasicLocker.createBasicLocker(this.envImpl);
        Cursor cursor = null;
        Object object = this.flushSynchronizer;
        synchronized (object) {
            try {
                cursor = DbInternal.makeCursor(this.mappingDbImpl, locker, CursorConfig.DEFAULT);
                DatabaseEntry key = new DatabaseEntry();
                DatabaseEntry data = new DatabaseEntry();
                OperationStatus status = cursor.getFirst(key, data, LockMode.DEFAULT);
                if (status == OperationStatus.SUCCESS) {
                    VLSNRange.VLSNRangeBinding rangeBinding = new VLSNRange.VLSNRangeBinding();
                    dbRange = (VLSNRange)rangeBinding.entryToObject(data);
                    while (cursor.getNext(key, data, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                        VLSNBucket bucket = VLSNBucket.readFromDatabase(data);
                        Long keyValue = LongBinding.entryToLong(key);
                        if (bucket.getFirst().getSequence() != keyValue.longValue()) {
                            boolean bl = false;
                            Object var16_15 = null;
                            if (cursor != null) {
                                cursor.close();
                            }
                            ((Locker)locker).operationEnd(true);
                            return bl;
                        }
                        firstVLSN.add(bucket.getFirst());
                        lastVLSN.add(bucket.getLast());
                    }
                }
                Object var16_16 = null;
                if (cursor != null) {
                    cursor.close();
                }
                ((Locker)locker).operationEnd(true);
            }
            catch (Throwable throwable) {
                Object var16_17 = null;
                if (cursor != null) {
                    cursor.close();
                }
                ((Locker)locker).operationEnd(true);
                throw throwable;
            }
            VLSNRange trackerRange = this.tracker.getRange();
            if (!trackerRange.verifySubset(verbose, dbRange)) {
                return false;
            }
        }
        VLSN firstTracked = this.tracker.getFirstTracked();
        VLSN firstOnDisk = null;
        VLSN lastOnDisk = null;
        if (firstVLSN.size() <= 0) return true;
        lastOnDisk = (VLSN)lastVLSN.get(lastVLSN.size() - 1);
        firstOnDisk = (VLSN)firstVLSN.get(0);
        if (!VLSNTracker.verifyBucketBoundaries(firstVLSN, lastVLSN)) {
            return false;
        }
        if (dbRange.getFirst().compareTo(firstOnDisk) != 0) {
            this.dump(verbose, "Range doesn't match buckets " + dbRange + " firstOnDisk = " + firstOnDisk);
            return false;
        }
        if (!lastOnDisk.equals(this.tracker.getLastOnDisk())) {
            this.dump(verbose, "lastOnDisk=" + lastOnDisk + " tracker=" + this.tracker.getLastOnDisk());
            return false;
        }
        if (!firstTracked.equals(VLSN.NULL_VLSN) && firstTracked.compareTo(lastOnDisk.getNext()) < 0) {
            this.dump(verbose, "lastOnDisk=" + lastOnDisk + " firstTracked=" + firstTracked);
            return false;
        }
        return true;
    }

    private void dump(boolean verbose, String msg) {
        if (verbose) {
            System.out.println(msg);
        }
    }

    public boolean isFlushedToDisk() {
        return this.tracker.isFlushedToDisk();
    }

    public static class WaitTimeOutException
    extends Exception {
        public Throwable fillInStackTrace() {
            return null;
        }
    }

    public static class VLSNAwaitLatch
    extends CountDownLatch {
        private LogItem logItem = null;
        private boolean terminated = false;

        public VLSNAwaitLatch() {
            super(1);
        }

        public long getTriggerLSN() {
            return this.logItem.getNewLsn();
        }

        public VLSN getTriggerVLSN() {
            return this.logItem.getHeader().getVLSN();
        }

        public void setLogItem(LogItem logItem) {
            this.logItem = logItem;
        }

        public LogItem getLogItem() {
            return this.logItem;
        }

        public void terminate() {
            this.terminated = true;
            this.countDown();
        }

        public boolean isTerminated() {
            return this.terminated;
        }
    }

    public static class ForwardVLSNScanner
    extends VLSNScanner {
        public ForwardVLSNScanner(VLSNIndex vlsnIndex) {
            super(vlsnIndex);
        }

        public long getStartingLsn(VLSN vlsn) {
            ++this.startingLsnInvocations;
            this.currentBucket = this.vlsnIndex.getLTEBucket(vlsn);
            return this.currentBucket.getLTELsn(vlsn);
        }

        public long getPreciseLsn(VLSN vlsn) {
            return this.getLsn(vlsn, false);
        }

        public long getApproximateLsn(VLSN vlsn) {
            return this.getLsn(vlsn, true);
        }

        private long getLsn(VLSN vlsn, boolean approximate) {
            assert (this.startingLsnInvocations == 1) : "startingLsns() called " + this.startingLsnInvocations + " times";
            if (this.currentBucket != null && !this.currentBucket.owns(vlsn)) {
                if (this.currentBucket.follows(vlsn)) {
                    return approximate ? this.findPrevLsn(vlsn) : -1L;
                }
                this.currentBucket = null;
            }
            if (this.currentBucket == null) {
                this.currentBucket = this.vlsnIndex.getGTEBucket(vlsn);
                if (!this.currentBucket.owns(vlsn)) {
                    return approximate ? this.findPrevLsn(vlsn) : -1L;
                }
            }
            assert (this.currentBucket.owns(vlsn)) : "vlsn = " + vlsn + " currentBucket=" + this.currentBucket;
            if (approximate) {
                return this.currentBucket.getLTELsn(vlsn);
            }
            return this.currentBucket.getLsn(vlsn);
        }

        private long findPrevLsn(VLSN target) {
            VLSNBucket prevBucket = this.vlsnIndex.getLTEBucket(target);
            assert (!prevBucket.owns(target)) : "target=" + target + "prevBucket=" + prevBucket + " currentBucket=" + this.currentBucket;
            return prevBucket.getLastLsn();
        }
    }

    public static class BackwardVLSNScanner
    extends VLSNScanner {
        public BackwardVLSNScanner(VLSNIndex vlsnIndex) {
            super(vlsnIndex);
        }

        public long getStartingLsn(VLSN vlsn) {
            ++this.startingLsnInvocations;
            this.currentBucket = this.vlsnIndex.getGTEBucket(vlsn);
            return this.currentBucket.getGTELsn(vlsn);
        }

        public long getPreciseLsn(VLSN vlsn) {
            assert (this.startingLsnInvocations == 1) : "startingLsns() called " + this.startingLsnInvocations + " times";
            if (this.currentBucket != null && !this.currentBucket.owns(vlsn)) {
                if (this.currentBucket.precedes(vlsn)) {
                    return -1L;
                }
                this.currentBucket = null;
            }
            if (this.currentBucket == null) {
                this.currentBucket = this.vlsnIndex.getLTEBucket(vlsn);
                if (!this.currentBucket.owns(vlsn)) {
                    return -1L;
                }
            }
            assert (this.currentBucket.owns(vlsn)) : "vlsn = " + vlsn + " currentBucket=" + this.currentBucket;
            return this.currentBucket.getLsn(vlsn);
        }
    }

    private static abstract class VLSNScanner {
        VLSNBucket currentBucket;
        final VLSNIndex vlsnIndex;
        int startingLsnInvocations;

        VLSNScanner(VLSNIndex vlsnIndex) {
            this.vlsnIndex = vlsnIndex;
            this.startingLsnInvocations = 0;
        }

        public abstract long getStartingLsn(VLSN var1);

        public abstract long getPreciseLsn(VLSN var1);
    }
}

