/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.compat.DbCompat;
import com.sleepycat.je.utilint.IdentityHashMap;
import com.sleepycat.persist.evolve.Converter;
import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.ComplexFormat;
import com.sleepycat.persist.impl.Enhanced;
import com.sleepycat.persist.impl.EntityInput;
import com.sleepycat.persist.impl.EntityOutput;
import com.sleepycat.persist.impl.Evolver;
import com.sleepycat.persist.impl.PersistCatalog;
import com.sleepycat.persist.impl.Reader;
import com.sleepycat.persist.impl.RecordInput;
import com.sleepycat.persist.impl.RecordOutput;
import com.sleepycat.persist.impl.SimpleCatalog;
import com.sleepycat.persist.model.ClassMetadata;
import com.sleepycat.persist.model.EntityMetadata;
import com.sleepycat.persist.model.EntityModel;
import com.sleepycat.persist.model.FieldMetadata;
import com.sleepycat.persist.model.PrimaryKeyMetadata;
import com.sleepycat.persist.model.SecondaryKeyMetadata;
import com.sleepycat.persist.raw.RawField;
import com.sleepycat.persist.raw.RawObject;
import com.sleepycat.persist.raw.RawType;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Format
implements Reader,
RawType,
Serializable {
    private static final long serialVersionUID = 545633644568489850L;
    static final int ID_NULL = 0;
    static final int ID_OBJECT = 1;
    static final int ID_BOOL = 2;
    static final int ID_BOOL_W = 3;
    static final int ID_BYTE = 4;
    static final int ID_BYTE_W = 5;
    static final int ID_SHORT = 6;
    static final int ID_SHORT_W = 7;
    static final int ID_INT = 8;
    static final int ID_INT_W = 9;
    static final int ID_LONG = 10;
    static final int ID_LONG_W = 11;
    static final int ID_FLOAT = 12;
    static final int ID_FLOAT_W = 13;
    static final int ID_DOUBLE = 14;
    static final int ID_DOUBLE_W = 15;
    static final int ID_CHAR = 16;
    static final int ID_CHAR_W = 17;
    static final int ID_STRING = 18;
    static final int ID_BIGINT = 19;
    static final int ID_BIGDEC = 20;
    static final int ID_DATE = 21;
    static final int ID_NUMBER = 22;
    static final int ID_SIMPLE_MIN = 2;
    static final int ID_SIMPLE_MAX = 21;
    static final int ID_PREDEFINED = 30;
    private int id;
    private String className;
    private Reader reader;
    private Format superFormat;
    private Format latestFormat;
    private Format previousFormat;
    private Set<String> supertypes;
    private boolean deleted;
    private boolean unused;
    private transient Catalog catalog;
    private transient Class type;
    private transient Format proxiedFormat;
    private transient boolean initialized;

    static boolean isPredefined(Format format) {
        return format.getId() <= 30;
    }

    Format(Class type) {
        this(type.getName());
        this.type = type;
        this.addSupertypes();
    }

    Format(String className) {
        this.className = className;
        this.latestFormat = this;
        this.supertypes = new HashSet<String>();
    }

    void migrateFromBeta(Map<String, Format> formatMap) {
        if (this.latestFormat == null) {
            this.latestFormat = this;
        }
    }

    final boolean isNew() {
        return this.id == 0;
    }

    final Catalog getCatalog() {
        return this.catalog;
    }

    @Override
    public final int getId() {
        return this.id;
    }

    final void setId(int id) {
        this.id = id;
    }

    final Class getType() {
        return this.type;
    }

    final Class getExistingType() {
        if (this.type == null) {
            try {
                this.type = SimpleCatalog.classForName(this.className);
            }
            catch (ClassNotFoundException e) {
                throw DbCompat.unexpectedException(e);
            }
        }
        return this.type;
    }

    final Reader getReader() {
        if (this != this.reader) {
            PersistCatalog.unevolvedFormatsEncountered = true;
        }
        return this.reader;
    }

    final void setReader(Reader reader) {
        this.reader = reader;
    }

    final Format getSuperFormat() {
        return this.superFormat;
    }

    final void setSuperFormat(Format superFormat) {
        this.superFormat = superFormat;
    }

    final Format getProxiedFormat() {
        return this.proxiedFormat;
    }

    final void setProxiedFormat(Format proxiedFormat) {
        this.proxiedFormat = proxiedFormat;
    }

    final Format getLatestVersion() {
        return this.latestFormat;
    }

    public final Format getPreviousVersion() {
        return this.previousFormat;
    }

    final void setLatestVersion(Format newFormat) {
        if (this.latestFormat == this) {
            newFormat.previousFormat = this;
        }
        this.latestFormat = newFormat;
    }

    @Override
    public final boolean isDeleted() {
        return this.deleted;
    }

    final void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    final void setUnused(boolean unused) {
        this.unused = unused;
    }

    void setEvolveNeeded(boolean needed) {
        throw DbCompat.unexpectedState();
    }

    boolean getEvolveNeeded() {
        throw DbCompat.unexpectedState();
    }

    final boolean isInitialized() {
        return this.initialized;
    }

    final void initializeIfNeeded(Catalog catalog, EntityModel model) {
        if (!this.initialized) {
            this.initialized = true;
            this.catalog = catalog;
            if (this.latestFormat == null) {
                this.latestFormat = this;
            }
            if (this.reader == null) {
                this.reader = this;
            }
            if (this.type == null && this.isCurrentVersion() && (this.isSimple() || !catalog.isRawAccess())) {
                this.getExistingType();
            }
            this.initialize(catalog, model, catalog.getInitVersion(this, false));
            this.reader.initializeReader(catalog, model, catalog.getInitVersion(this, true), this);
        }
    }

    @Override
    public void initializeReader(Catalog catalog, EntityModel model, int initVersion, Format oldFormat) {
    }

    private void addSupertypes() {
        this.addInterfaces(this.type);
        for (Class stype = this.type.getSuperclass(); stype != null && stype != Object.class; stype = stype.getSuperclass()) {
            this.supertypes.add(stype.getName());
            this.addInterfaces(stype);
        }
    }

    private void addInterfaces(Class cls) {
        Class<?>[] interfaces;
        for (Class<?> iface : interfaces = cls.getInterfaces()) {
            if (iface == Enhanced.class) continue;
            this.supertypes.add(iface.getName());
            this.addInterfaces(iface);
        }
    }

    boolean areNestedRefsProhibited() {
        return false;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public int getVersion() {
        ClassMetadata meta = this.getClassMetadata();
        if (meta != null) {
            return meta.getVersion();
        }
        return 0;
    }

    @Override
    public Format getSuperType() {
        return this.superFormat;
    }

    @Override
    public boolean isSimple() {
        return false;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public boolean isEnum() {
        return false;
    }

    @Override
    public List<String> getEnumConstants() {
        return null;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public int getDimensions() {
        return 0;
    }

    @Override
    public Format getComponentType() {
        return null;
    }

    @Override
    public Map<String, RawField> getFields() {
        return null;
    }

    @Override
    public ClassMetadata getClassMetadata() {
        return null;
    }

    @Override
    public EntityMetadata getEntityMetadata() {
        return null;
    }

    boolean isAssignableTo(Format format) {
        if (this.proxiedFormat != null) {
            return this.proxiedFormat.isAssignableTo(format);
        }
        return format == this || format.id == 1 || this.supertypes.contains(format.className);
    }

    Format getWrapperFormat() {
        return null;
    }

    boolean isEntity() {
        return false;
    }

    boolean isModelClass() {
        return false;
    }

    ComplexFormat getEntityFormat() {
        return null;
    }

    abstract boolean evolve(Format var1, Evolver var2);

    boolean evolveMetadata(Format newFormat, Converter converter, Evolver evolver) {
        return true;
    }

    final boolean isCurrentVersion() {
        return this.latestFormat == this && !this.deleted;
    }

    final boolean isSameClass(Format other) {
        return this.latestFormat == other.latestFormat;
    }

    abstract void initialize(Catalog var1, EntityModel var2, int var3);

    abstract void collectRelatedFormats(Catalog var1, Map<String, Format> var2);

    abstract Object newArray(int var1);

    @Override
    public abstract Object newInstance(EntityInput var1, boolean var2);

    @Override
    public abstract Object readObject(Object var1, EntityInput var2, boolean var3);

    abstract void writeObject(Object var1, EntityOutput var2, boolean var3);

    abstract void skipContents(RecordInput var1);

    Format skipToSecKey(RecordInput input, String keyName) {
        throw DbCompat.unexpectedState(this.toString());
    }

    void copySecKey(RecordInput input, RecordOutput output) {
        throw DbCompat.unexpectedState(this.toString());
    }

    void copySecMultiKey(RecordInput input, Format keyFormat, Set results) {
        throw DbCompat.unexpectedState(this.toString());
    }

    boolean nullifySecKey(Catalog catalog, Object entity, String keyName, Object keyElement) {
        throw DbCompat.unexpectedState(this.toString());
    }

    boolean isPriKeyNullOrZero(Object o, boolean rawAccess) {
        throw DbCompat.unexpectedState(this.toString());
    }

    void writePriKey(Object o, EntityOutput output, boolean rawAccess) {
        throw DbCompat.unexpectedState(this.toString());
    }

    @Override
    public void readPriKey(Object o, EntityInput input, boolean rawAccess) {
        throw DbCompat.unexpectedState(this.toString());
    }

    public String getOldKeyName(String keyName) {
        throw DbCompat.unexpectedState(this.toString());
    }

    Format getSequenceKeyFormat() {
        throw new IllegalArgumentException("Type not allowed for sequence: " + this.getClassName());
    }

    Object convertRawObject(Catalog catalog, boolean rawAccess, RawObject rawObject, IdentityHashMap converted) {
        throw DbCompat.unexpectedState(this.toString());
    }

    @Override
    public String toString() {
        String INDENT = "  ";
        String INDENT2 = "    ";
        StringBuffer buf = new StringBuffer(500);
        if (this.isSimple()) {
            this.addTypeHeader(buf, "SimpleType");
            buf.append(" primitive=\"");
            buf.append(this.isPrimitive());
            buf.append("\"/>\n");
        } else if (this.isEnum()) {
            this.addTypeHeader(buf, "EnumType");
            buf.append(">\n");
            for (String constant : this.getEnumConstants()) {
                buf.append("  ");
                buf.append("<Constant>");
                buf.append(constant);
                buf.append("</Constant>\n");
            }
            buf.append("</EnumType>\n");
        } else if (this.isArray()) {
            this.addTypeHeader(buf, "ArrayType");
            buf.append(" componentId=\"");
            buf.append(this.getComponentType().getVersion());
            buf.append("\" componentClass=\"");
            buf.append(this.getComponentType().getClassName());
            buf.append("\" dimensions=\"");
            buf.append(this.getDimensions());
            buf.append("\"/>\n");
        } else {
            Format proxiedFormat;
            this.addTypeHeader(buf, "ComplexType");
            Format superType = this.getSuperType();
            if (superType != null) {
                buf.append(" superTypeId=\"");
                buf.append(superType.getId());
                buf.append("\" superTypeClass=\"");
                buf.append(superType.getClassName());
                buf.append('\"');
            }
            if ((proxiedFormat = this.getProxiedFormat()) != null) {
                buf.append(" proxiedTypeId=\"");
                buf.append(proxiedFormat.getId());
                buf.append("\" proxiedTypeClass=\"");
                buf.append(proxiedFormat.getClassName());
                buf.append('\"');
            }
            PrimaryKeyMetadata priMeta = null;
            Map<String, SecondaryKeyMetadata> secondaryKeys = null;
            List<FieldMetadata> compositeKeyFields = null;
            ClassMetadata clsMeta = this.getClassMetadata();
            if (clsMeta != null) {
                compositeKeyFields = clsMeta.getCompositeKeyFields();
                priMeta = clsMeta.getPrimaryKey();
                secondaryKeys = clsMeta.getSecondaryKeys();
            }
            buf.append(" kind=\"");
            buf.append(this.isEntity() ? "entity" : (compositeKeyFields != null ? "compositeKey" : "persistent"));
            buf.append("\">\n");
            Map<String, RawField> fields = this.getFields();
            if (fields != null) {
                for (RawField field : fields.values()) {
                    SecondaryKeyMetadata secMeta;
                    String name = field.getName();
                    RawType type = field.getType();
                    buf.append("  ");
                    buf.append("<Field");
                    buf.append(" name=\"");
                    buf.append(name);
                    buf.append("\" typeId=\"");
                    buf.append(type.getId());
                    buf.append("\" typeClass=\"");
                    buf.append(type.getClassName());
                    buf.append('\"');
                    if (priMeta != null && priMeta.getName().equals(name)) {
                        buf.append(" primaryKey=\"true\"");
                        if (priMeta.getSequenceName() != null) {
                            buf.append(" sequence=\"");
                            buf.append(priMeta.getSequenceName());
                            buf.append('\"');
                        }
                    }
                    if (secondaryKeys != null && (secMeta = ComplexFormat.getSecondaryKeyMetadataByFieldName(secondaryKeys, name)) != null) {
                        buf.append(" secondaryKey=\"true\" keyName=\"");
                        buf.append(secMeta.getKeyName());
                        buf.append("\" relate=\"");
                        buf.append((Object)secMeta.getRelationship());
                        buf.append('\"');
                        String related = secMeta.getRelatedEntity();
                        if (related != null) {
                            buf.append("\" relatedEntity=\"");
                            buf.append(related);
                            buf.append("\" onRelatedEntityDelete=\"");
                            buf.append((Object)secMeta.getDeleteAction());
                            buf.append('\"');
                        }
                    }
                    if (compositeKeyFields != null) {
                        int nFields = compositeKeyFields.size();
                        for (int i = 0; i < nFields; ++i) {
                            FieldMetadata fldMeta = compositeKeyFields.get(i);
                            if (!fldMeta.getName().equals(name)) continue;
                            buf.append(" compositeKeyField=\"");
                            buf.append(i + 1);
                            buf.append('\"');
                        }
                    }
                    buf.append("/>\n");
                }
                EntityMetadata entMeta = this.getEntityMetadata();
                if (entMeta != null) {
                    buf.append("  ");
                    buf.append("<EntityKeys>\n");
                    priMeta = entMeta.getPrimaryKey();
                    if (priMeta != null) {
                        buf.append("    ");
                        buf.append("<Primary class=\"");
                        buf.append(priMeta.getDeclaringClassName());
                        buf.append("\" field=\"");
                        buf.append(priMeta.getName());
                        buf.append("\"/>\n");
                    }
                    if ((secondaryKeys = entMeta.getSecondaryKeys()) != null) {
                        for (SecondaryKeyMetadata secMeta : secondaryKeys.values()) {
                            buf.append("    ");
                            buf.append("<Secondary class=\"");
                            buf.append(secMeta.getDeclaringClassName());
                            buf.append("\" field=\"");
                            buf.append(secMeta.getName());
                            buf.append("\"/>\n");
                        }
                    }
                    buf.append("</EntityKeys>\n");
                }
            }
            buf.append("</ComplexType>\n");
        }
        return buf.toString();
    }

    private void addTypeHeader(StringBuffer buf, String elemName) {
        Format prevVersion;
        buf.append('<');
        buf.append(elemName);
        buf.append(" id=\"");
        buf.append(this.getId());
        buf.append("\" class=\"");
        buf.append(this.getClassName());
        buf.append("\" version=\"");
        buf.append(this.getVersion());
        buf.append('\"');
        Format currVersion = this.getLatestVersion();
        if (currVersion != null) {
            buf.append(" currentVersionId=\"");
            buf.append(currVersion.getId());
            buf.append('\"');
        }
        if ((prevVersion = this.getPreviousVersion()) != null) {
            buf.append(" previousVersionId=\"");
            buf.append(prevVersion.getId());
            buf.append('\"');
        }
    }
}

