/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.ServiceLoader;
import thredds.client.catalog.tools.DataFactory;
import thredds.inventory.MFileCollectionManager;
import ucar.nc2.NetcdfFile;
import ucar.nc2.constants.CF;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.DatasetUrl;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.ft.FeatureDatasetFactory;
import ucar.nc2.ft.GridDatasetStandardFactory;
import ucar.nc2.ft.NoFactoryFoundException;
import ucar.nc2.ft.SimpleGeometryStandardFactory;
import ucar.nc2.ft.point.collection.CompositeDatasetFactory;
import ucar.nc2.ft.point.standard.PointDatasetStandardFactory;
import ucar.nc2.ft.radial.RadialDatasetStandardFactory;
import ucar.nc2.ft.remote.CdmrFeatureDataset;
import ucar.nc2.ft2.coverage.CoverageDatasetFactory;
import ucar.nc2.ft2.coverage.FeatureDatasetCoverage;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.Optional;

public class FeatureDatasetFactoryManager {
    private static List<Factory> factoryList = new ArrayList<Factory>();
    private static boolean userMode = false;
    private static boolean debug = false;

    public static boolean registerFactory(FeatureType datatype, String className) {
        try {
            Class<?> c = Class.forName(className);
            FeatureDatasetFactoryManager.registerFactory(datatype, c);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static void registerFactory(FeatureType datatype, Class c) {
        Object instance;
        if (!FeatureDatasetFactory.class.isAssignableFrom(c)) {
            throw new IllegalArgumentException("Class " + c.getName() + " must implement FeatureDatasetFactory");
        }
        try {
            instance = c.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("FeatureDatasetFactoryManager Class " + c.getName() + " cannot instantiate, probably need default Constructor");
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("FeatureDatasetFactoryManager Class " + c.getName() + " is not accessible");
        }
        if (userMode) {
            factoryList.add(0, new Factory(datatype, c, (FeatureDatasetFactory)instance));
        } else {
            factoryList.add(new Factory(datatype, c, (FeatureDatasetFactory)instance));
        }
    }

    public static void registerFactory(String className) throws ClassNotFoundException {
        Class<?> c = Class.forName(className);
        FeatureDatasetFactoryManager.registerFactory(c);
    }

    public static void registerFactory(Class c) {
        Object instance;
        if (!FeatureDatasetFactory.class.isAssignableFrom(c)) {
            throw new IllegalArgumentException("Class " + c.getName() + " must implement FeatureDatasetFactory");
        }
        try {
            instance = c.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("FeatureDatasetFactoryManager Class " + c.getName() + " cannot instantiate, probably need default Constructor");
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("FeatureDatasetFactoryManager Class " + c.getName() + " is not accessible");
        }
        try {
            FeatureType[] result;
            Method m3 = c.getMethod("getFeatureTypes", new Class[0]);
            for (FeatureType ft : result = (FeatureType[])m3.invoke(instance, new Object[0])) {
                if (userMode) {
                    factoryList.add(0, new Factory(ft, c, (FeatureDatasetFactory)instance));
                    continue;
                }
                factoryList.add(new Factory(ft, c, (FeatureDatasetFactory)instance));
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("FeatureDatasetFactoryManager Class " + c.getName() + " failed invoking getFeatureType()", ex);
        }
    }

    public static FeatureDataset open(String location) throws IOException {
        return FeatureDatasetFactoryManager.open(null, location, null, new Formatter());
    }

    public static FeatureDataset open(FeatureType wantFeatureType, String location, CancelTask task) throws IOException, NoFactoryFoundException {
        Formatter errlog = new Formatter();
        FeatureDataset fd = FeatureDatasetFactoryManager.open(wantFeatureType, location, task, errlog);
        if (fd == null) {
            throw new NoFactoryFoundException(errlog.toString());
        }
        return fd;
    }

    public static FeatureDataset open(FeatureType wantFeatureType, String location, CancelTask task, Formatter errlog) throws IOException {
        NetcdfDataset ncd;
        FeatureDataset fd;
        if (location.startsWith("thredds:")) {
            DataFactory.Result result = new DataFactory().openFeatureDataset(wantFeatureType, location, task);
            errlog.format("%s", result.errLog);
            if (!FeatureDatasetFactoryManager.featureTypeOk(wantFeatureType, result.featureType)) {
                errlog.format("wanted %s but dataset is of type %s%n", new Object[]{wantFeatureType, result.featureType});
                result.close();
                return null;
            }
            return result.featureDataset;
        }
        if (location.startsWith("cdmrFeature:")) {
            Optional<FeatureDataset> opt = CdmrFeatureDataset.factory(wantFeatureType, location);
            if (opt.isPresent()) {
                return opt.get();
            }
            errlog.format("%s", opt.getErrorMessage());
            return null;
        }
        if (location.startsWith("collection:")) {
            String spec = location.substring("collection:".length());
            MFileCollectionManager dcm = MFileCollectionManager.open(spec, spec, null, errlog);
            return CompositeDatasetFactory.factory(location, wantFeatureType, dcm, errlog);
        }
        DatasetUrl durl = DatasetUrl.findDatasetUrl(location);
        if (durl.serviceType == null) {
            Optional<FeatureDatasetCoverage> opt = CoverageDatasetFactory.openGrib(location);
            if (opt.isPresent()) {
                return opt.get();
            }
            if (!opt.getErrorMessage().startsWith("Not a GRIB file") && !opt.getErrorMessage().startsWith("GRIB module not loaded")) {
                errlog.format("%s%n", opt.getErrorMessage());
                return null;
            }
        }
        if ((fd = FeatureDatasetFactoryManager.wrap(wantFeatureType, ncd = NetcdfDataset.acquireDataset(durl, true, task), task, errlog)) == null) {
            ncd.close();
        }
        return fd;
    }

    public static FeatureDataset wrap(FeatureType wantFeatureType, NetcdfDataset ncd, CancelTask task, Formatter errlog) throws IOException {
        if (debug) {
            System.out.println("wrap " + ncd.getLocation() + " want = " + (Object)((Object)wantFeatureType));
        }
        if (wantFeatureType == null || wantFeatureType == FeatureType.ANY) {
            return FeatureDatasetFactoryManager.wrapUnknown(ncd, task, errlog);
        }
        Object analysis = null;
        FeatureDatasetFactory useFactory = null;
        for (Factory fac : factoryList) {
            if (!FeatureDatasetFactoryManager.featureTypeOk(wantFeatureType, fac.featureType)) continue;
            if (debug) {
                System.out.println(" wrap try factory " + fac.factory.getClass().getName());
            }
            if ((analysis = fac.factory.isMine(wantFeatureType, ncd, errlog)) == null) continue;
            useFactory = fac.factory;
            break;
        }
        if (null == useFactory) {
            errlog.format("**Failed to find FeatureDatasetFactory for= %s datatype=%s%n", new Object[]{ncd.getLocation(), wantFeatureType});
            return null;
        }
        return useFactory.open(wantFeatureType, ncd, analysis, task, errlog);
    }

    private static FeatureDataset wrapUnknown(NetcdfDataset ncd, CancelTask task, Formatter errlog) throws IOException {
        FeatureType ft = FeatureDatasetFactoryManager.findFeatureType(ncd);
        if (ft != null) {
            return FeatureDatasetFactoryManager.wrap(ft, ncd, task, errlog);
        }
        Object analysis = null;
        FeatureDatasetFactory useFactory = null;
        for (Factory fac : factoryList) {
            if (debug) {
                System.out.println(" wrapUnknown try factory " + fac.factory.getClass().getName());
            }
            if (null == (analysis = fac.factory.isMine(null, ncd, errlog))) continue;
            useFactory = fac.factory;
            break;
        }
        if (null == useFactory) {
            errlog.format("Failed (wrapUnknown) to find Datatype Factory for= %s%n", ncd.getLocation());
            return null;
        }
        return useFactory.open(null, ncd, analysis, task, errlog);
    }

    public static boolean featureTypeOk(FeatureType want, FeatureType facType) {
        if (want == null) {
            return true;
        }
        if (want == facType) {
            return true;
        }
        if (want == FeatureType.ANY_POINT) {
            return facType.isPointFeatureType();
        }
        if (facType == FeatureType.ANY_POINT) {
            return want.isPointFeatureType();
        }
        if (want == FeatureType.COVERAGE) {
            return facType.isCoverageFeatureType();
        }
        if (want == FeatureType.GRID) {
            return facType.isCoverageFeatureType();
        }
        if (want == FeatureType.SIMPLE_GEOMETRY) {
            return facType.isCoverageFeatureType();
        }
        if (want == FeatureType.UGRID) {
            return facType.isUnstructuredGridFeatureType();
        }
        return false;
    }

    public static FeatureType findFeatureType(NetcdfFile ncd) {
        CF.FeatureType cff;
        String cdm_datatype = ncd.findAttValueIgnoreCase(null, "featureType", null);
        if (cdm_datatype == null) {
            cdm_datatype = ncd.findAttValueIgnoreCase(null, "cdm_data_type", null);
        }
        if (cdm_datatype == null) {
            cdm_datatype = ncd.findAttValueIgnoreCase(null, "cdm_datatype", null);
        }
        if (cdm_datatype == null) {
            cdm_datatype = ncd.findAttValueIgnoreCase(null, "thredds_data_type", null);
        }
        if (cdm_datatype != null) {
            for (FeatureType ft : FeatureType.values()) {
                if (!cdm_datatype.equalsIgnoreCase(ft.name())) continue;
                if (debug) {
                    System.out.println(" wrapUnknown found cdm_datatype " + cdm_datatype);
                }
                return ft;
            }
        }
        if ((cff = CF.FeatureType.getFeatureTypeFromGlobalAttribute(ncd)) != null) {
            return CF.FeatureType.convert(cff);
        }
        return null;
    }

    static {
        for (FeatureDatasetFactory csb : ServiceLoader.load(FeatureDatasetFactory.class)) {
            FeatureDatasetFactoryManager.registerFactory(csb.getClass());
        }
        FeatureDatasetFactoryManager.registerFactory(FeatureType.ANY_POINT, PointDatasetStandardFactory.class);
        FeatureDatasetFactoryManager.registerFactory(FeatureType.COVERAGE, GridDatasetStandardFactory.class);
        FeatureDatasetFactoryManager.registerFactory(FeatureType.SWATH, GridDatasetStandardFactory.class);
        FeatureDatasetFactoryManager.registerFactory(FeatureType.GRID, GridDatasetStandardFactory.class);
        FeatureDatasetFactoryManager.registerFactory(FeatureType.FMRC, GridDatasetStandardFactory.class);
        FeatureDatasetFactoryManager.registerFactory(FeatureType.CURVILINEAR, GridDatasetStandardFactory.class);
        FeatureDatasetFactoryManager.registerFactory(FeatureType.RADIAL, RadialDatasetStandardFactory.class);
        FeatureDatasetFactoryManager.registerFactory(FeatureType.STATION_RADIAL, RadialDatasetStandardFactory.class);
        FeatureDatasetFactoryManager.registerFactory(FeatureType.UGRID, "ucar.nc2.ft.ugrid.UGridDatasetStandardFactory");
        FeatureDatasetFactoryManager.registerFactory(FeatureType.SIMPLE_GEOMETRY, SimpleGeometryStandardFactory.class);
        userMode = true;
    }

    private static class Factory {
        FeatureType featureType;
        Class c;
        FeatureDatasetFactory factory;

        Factory(FeatureType featureType, Class c, FeatureDatasetFactory factory) {
            this.featureType = featureType;
            this.c = c;
            this.factory = factory;
        }

        public String toString() {
            return "featureType=" + (Object)((Object)this.featureType) + ", factory=" + this.factory.getClass();
        }
    }
}

