/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft2.coverage.adapter;

import com.beust.jcommander.internal.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import java.util.Set;
import ucar.nc2.Dimension;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateAxis1DTime;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ft2.coverage.adapter.CurvilinearCS;
import ucar.nc2.ft2.coverage.adapter.DtCoverageCS;
import ucar.nc2.ft2.coverage.adapter.FmrcCS;
import ucar.nc2.ft2.coverage.adapter.GridCS;
import ucar.nc2.ft2.coverage.adapter.SwathCS;
import ucar.nc2.units.SimpleUnit;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.projection.RotatedPole;

public class DtCoverageCSBuilder {
    FeatureType type;
    boolean isLatLon;
    CoordinateAxis xaxis;
    CoordinateAxis yaxis;
    CoordinateAxis timeAxis;
    CoordinateAxis1D vertAxis;
    CoordinateAxis1D ensAxis;
    CoordinateAxis1D timeOffsetAxis;
    CoordinateAxis1DTime rtAxis;
    List<CoordinateAxis> independentAxes;
    List<CoordinateAxis> otherAxes;
    List<CoordinateAxis> allAxes;
    List<CoordinateTransform> coordTransforms;
    ProjectionImpl orgProj;

    public static DtCoverageCSBuilder classify(NetcdfDataset ds, Formatter errlog) {
        if (errlog != null) {
            errlog.format("CoverageFactory for '%s'%n", ds.getLocation());
        }
        ArrayList<CoordinateSystem> css = new ArrayList<CoordinateSystem>(ds.getCoordinateSystems());
        Collections.sort(css, (o1, o2) -> o2.getCoordinateAxes().size() - o1.getCoordinateAxes().size());
        DtCoverageCSBuilder builder = null;
        for (CoordinateSystem cs : css) {
            builder = new DtCoverageCSBuilder(ds, cs, errlog);
            if (builder.type == null) continue;
            break;
        }
        if (builder == null) {
            return null;
        }
        if (errlog != null) {
            errlog.format("coverage = %s%n", new Object[]{builder.type});
        }
        return builder;
    }

    public static String describe(NetcdfDataset ds, Formatter errlog) {
        DtCoverageCSBuilder fac = DtCoverageCSBuilder.classify(ds, errlog);
        return fac == null || fac.type == null ? "" : fac.showSummary();
    }

    public static String describe(NetcdfDataset ds, CoordinateSystem cs, Formatter errlog) {
        DtCoverageCSBuilder fac = new DtCoverageCSBuilder(ds, cs, errlog);
        return fac.type == null ? "" : fac.showSummary();
    }

    DtCoverageCSBuilder(NetcdfDataset ds, CoordinateSystem cs, Formatter errlog) {
        CoordinateAxis eAxis;
        CoordinateAxis toAxis;
        CoordinateAxis t;
        CoordinateAxis rt;
        if (cs.getRankDomain() < 2) {
            if (errlog != null) {
                errlog.format("CoordinateSystem '%s': domain rank < 2%n", cs.getName());
            }
            return;
        }
        if (!cs.isLatLon()) {
            if (cs.getXaxis() == null || cs.getYaxis() == null) {
                if (errlog != null) {
                    errlog.format("%s: NO Lat,Lon or X,Y axis%n", cs.getName());
                }
                return;
            }
            if (null == cs.getProjection()) {
                if (errlog != null) {
                    errlog.format("%s: NO projection found%n", cs.getName());
                }
                return;
            }
        }
        if (cs.isGeoXY()) {
            this.xaxis = cs.getXaxis();
            this.yaxis = cs.getYaxis();
            ProjectionImpl p = cs.getProjection();
            if (!(p instanceof RotatedPole)) {
                if (!SimpleUnit.kmUnit.isCompatible(this.xaxis.getUnitsString()) && errlog != null) {
                    errlog.format("%s: X axis units are not convertible to km%n", cs.getName());
                }
                if (!SimpleUnit.kmUnit.isCompatible(this.yaxis.getUnitsString()) && errlog != null) {
                    errlog.format("%s: Y axis units are not convertible to km%n", cs.getName());
                }
            }
        } else {
            this.xaxis = cs.getLonAxis();
            this.yaxis = cs.getLatAxis();
            this.isLatLon = true;
        }
        if (this.xaxis.getRank() > 2 || this.yaxis.getRank() > 2) {
            if (errlog != null) {
                errlog.format("%s: X and Y axis rank must be <= 2%n", cs.getName());
            }
            return;
        }
        if (this.xaxis.getSize() < 2L || this.yaxis.getSize() < 2L) {
            if (errlog != null) {
                errlog.format("%s: X and Y axis size must be >= 2%n", cs.getName());
            }
            return;
        }
        int xyDomainSize = CoordinateSystem.countDomain(new CoordinateAxis[]{this.xaxis, this.yaxis});
        if (xyDomainSize < 2) {
            if (errlog != null) {
                errlog.format("%s: X and Y axis must have 2 or more dimensions%n", cs.getName());
            }
            return;
        }
        this.allAxes = new ArrayList<CoordinateAxis>(cs.getCoordinateAxes());
        Collections.sort(this.allAxes, new CoordinateAxis.AxisComparator());
        this.independentAxes = new ArrayList<CoordinateAxis>();
        this.otherAxes = new ArrayList<CoordinateAxis>();
        for (CoordinateAxis axis : cs.getCoordinateAxes()) {
            if ((axis.getAxisType() == AxisType.GeoX || axis.getAxisType() == AxisType.GeoY) && this.isLatLon) continue;
            if (axis.isIndependentCoordinate()) {
                this.independentAxes.add(axis);
                continue;
            }
            this.otherAxes.add(axis);
        }
        Collections.sort(this.independentAxes, (o1, o2) -> {
            AxisType t1 = o1.getAxisType();
            AxisType t2 = o2.getAxisType();
            if (t1 != null && t2 != null) {
                return t1.axisOrder() - t2.axisOrder();
            }
            return t1 == null ? (t2 == null ? 0 : -1) : 1;
        });
        CoordinateAxis zAxis = cs.getHeightAxis();
        if ((zAxis == null || zAxis.getRank() > 1) && cs.getPressureAxis() != null) {
            zAxis = cs.getPressureAxis();
        }
        if ((zAxis == null || zAxis.getRank() > 1) && cs.getZaxis() != null) {
            zAxis = cs.getZaxis();
        }
        if (zAxis != null && zAxis instanceof CoordinateAxis1D) {
            this.vertAxis = (CoordinateAxis1D)zAxis;
        }
        if ((rt = cs.findAxis(AxisType.RunTime)) != null) {
            if (!rt.isScalar() && !(rt instanceof CoordinateAxis1D)) {
                if (errlog != null) {
                    errlog.format("%s: RunTime axis must be 1D or scalar%n", cs.getName());
                }
                return;
            }
            if (!(rt instanceof CoordinateAxis1DTime)) {
                try {
                    this.rtAxis = CoordinateAxis1DTime.factory(ds, rt, errlog);
                    int index = this.allAxes.indexOf(rt);
                    this.allAxes.set(index, this.rtAxis);
                }
                catch (Exception e) {
                    if (errlog != null) {
                        errlog.format("%s: Error reading runtime coord= %s err= %s%n", rt.getDatasetLocation(), rt.getFullName(), e.getMessage());
                    }
                    return;
                }
            } else {
                this.rtAxis = (CoordinateAxis1DTime)rt;
            }
        }
        if ((t = cs.getTaxis()) != null && t.getRank() > 1 && this.rtAxis != null && this.rtAxis.getRank() == 1 && !this.rtAxis.getDimension(0).equals(t.getDimension(0))) {
            if (errlog != null) {
                errlog.format("%s: 2D Time axis first dimension must be runtime%n", cs.getName());
            }
            return;
        }
        if (t != null) {
            if (t instanceof CoordinateAxis1D && !(t instanceof CoordinateAxis1DTime)) {
                try {
                    this.timeAxis = CoordinateAxis1DTime.factory(ds, t, errlog);
                    int index = this.allAxes.indexOf(t);
                    this.allAxes.set(index, this.timeAxis);
                }
                catch (Exception e) {
                    if (errlog != null) {
                        errlog.format("%s: Error reading time coord= %s err= %s%n", t.getDatasetLocation(), t.getFullName(), e.getMessage());
                    }
                    return;
                }
            } else {
                this.timeAxis = t;
            }
        }
        if ((toAxis = cs.findAxis(AxisType.TimeOffset)) != null && toAxis.getRank() == 1) {
            this.timeOffsetAxis = (CoordinateAxis1D)toAxis;
        }
        if (t != null || this.rtAxis == null || this.timeOffsetAxis != null) {
            // empty if block
        }
        if ((eAxis = cs.findAxis(AxisType.Ensemble)) != null && eAxis instanceof CoordinateAxis1D) {
            this.ensAxis = (CoordinateAxis1D)eAxis;
        }
        this.type = this.classify();
        this.coordTransforms = new ArrayList<CoordinateTransform>(cs.getCoordinateTransforms());
        this.orgProj = cs.getProjection();
    }

    private FeatureType classify() {
        boolean is2Dhoriz;
        boolean is2Dtime;
        boolean bl = is2Dtime = this.rtAxis != null && (this.timeOffsetAxis != null || this.timeAxis != null && this.timeAxis.getRank() == 2);
        if (is2Dtime) {
            return FeatureType.FMRC;
        }
        boolean bl2 = is2Dhoriz = this.isLatLon && this.xaxis.getRank() == 2 && this.yaxis.getRank() == 2;
        if (is2Dhoriz) {
            Set<Dimension> xyDomain = CoordinateSystem.makeDomain(Lists.newArrayList(this.xaxis, this.yaxis));
            if (this.timeAxis != null && CoordinateSystem.isSubset(this.timeAxis.getDimensionsAll(), xyDomain)) {
                return FeatureType.SWATH;
            }
            return FeatureType.CURVILINEAR;
        }
        Set<Dimension> indDimensions = CoordinateSystem.makeDomain(this.independentAxes);
        Set<Dimension> allDimensions = CoordinateSystem.makeDomain(this.allAxes);
        if (indDimensions.size() == allDimensions.size()) {
            return FeatureType.GRID;
        }
        return FeatureType.COVERAGE;
    }

    public FeatureType getCoverageType() {
        return this.type;
    }

    public DtCoverageCS makeCoordSys() {
        if (this.type == null) {
            return null;
        }
        switch (this.type) {
            case GRID: {
                return new GridCS(this);
            }
            case FMRC: {
                return new FmrcCS(this);
            }
            case CURVILINEAR: {
                return new CurvilinearCS(this);
            }
            case SWATH: {
                return new SwathCS(this);
            }
        }
        return new DtCoverageCS(this);
    }

    public String toString() {
        Formatter f2 = new Formatter();
        f2.format("%s", this.type == null ? "" : this.type.toString());
        f2.format("%n xAxis=  %s", this.xaxis == null ? "" : this.xaxis.getNameAndDimensions());
        f2.format("%n yAxis=  %s", this.yaxis == null ? "" : this.yaxis.getNameAndDimensions());
        f2.format("%n zAxis=  %s", this.vertAxis == null ? "" : this.vertAxis.getNameAndDimensions());
        f2.format("%n tAxis=  %s", this.timeAxis == null ? "" : this.timeAxis.getNameAndDimensions());
        f2.format("%n rtAxis= %s", this.rtAxis == null ? "" : this.rtAxis.getNameAndDimensions());
        f2.format("%n toAxis= %s", this.timeOffsetAxis == null ? "" : this.timeOffsetAxis.getNameAndDimensions());
        f2.format("%n ensAxis=%s", this.ensAxis == null ? "" : this.ensAxis.getNameAndDimensions());
        if (this.type == null) {
            return f2.toString();
        }
        f2.format("%n%n independentAxes=(", new Object[0]);
        for (CoordinateAxis axis : this.independentAxes) {
            f2.format("%s, ", axis.getShortName());
        }
        f2.format(") {", new Object[0]);
        for (Dimension dim : CoordinateSystem.makeDomain(this.independentAxes)) {
            f2.format("%s, ", dim.getShortName());
        }
        f2.format("}", new Object[0]);
        f2.format("%n otherAxes=(", new Object[0]);
        for (CoordinateAxis axis : this.otherAxes) {
            f2.format("%s, ", axis.getShortName());
        }
        f2.format(") {", new Object[0]);
        for (Dimension dim : CoordinateSystem.makeDomain(this.otherAxes)) {
            f2.format("%s, ", dim.getShortName());
        }
        f2.format("}", new Object[0]);
        f2.format("%n allAxes=(", new Object[0]);
        for (CoordinateAxis axis : this.allAxes) {
            f2.format("%s, ", axis.getShortName());
        }
        f2.format(") {", new Object[0]);
        for (Dimension dim : CoordinateSystem.makeDomain(this.allAxes)) {
            f2.format("%s, ", dim.getShortName());
        }
        f2.format("}%n", new Object[0]);
        return f2.toString();
    }

    public String showSummary() {
        if (this.type == null) {
            return "";
        }
        Formatter f2 = new Formatter();
        f2.format("%s", this.type.toString());
        f2.format("(", new Object[0]);
        int count = 0;
        for (CoordinateAxis axis : this.independentAxes) {
            if (count++ > 0) {
                f2.format(",", new Object[0]);
            }
            f2.format("%s", axis.getAxisType() == null ? axis.getShortName() : axis.getAxisType().getCFAxisName());
        }
        f2.format(")", new Object[0]);
        if (this.otherAxes.size() > 0) {
            f2.format(": ", new Object[0]);
            count = 0;
            for (CoordinateAxis axis : this.otherAxes) {
                if (count++ > 0) {
                    f2.format(",", new Object[0]);
                }
                f2.format("%s", axis.getShortName());
            }
        }
        return f2.toString();
    }
}

