/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc.vertical;

import java.io.IOException;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.ma2.Index;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.unidata.geoloc.vertical.VerticalTransformImpl;
import ucar.unidata.util.Parameter;

public class WRFEta
extends VerticalTransformImpl {
    public static final String BasePressureVariable = "base_presure";
    public static final String PerturbationPressureVariable = "perturbation_presure";
    public static final String BaseGeopotentialVariable = "base_geopotential";
    public static final String PerturbationGeopotentialVariable = "perturbation_geopotential";
    public static final String IsStaggeredX = "staggered_x";
    public static final String IsStaggeredY = "staggered_y";
    public static final String IsStaggeredZ = "staggered_z";
    private Variable pertVar;
    private Variable baseVar;
    private boolean isXStag;
    private boolean isYStag;
    private boolean isZStag;

    public WRFEta(NetcdfFile ds, Dimension timeDim, List<Parameter> params) {
        super(timeDim);
        String baseVarName;
        String pertVarName;
        this.isXStag = this.getParameterBooleanValue(params, IsStaggeredX);
        this.isYStag = this.getParameterBooleanValue(params, IsStaggeredY);
        this.isZStag = this.getParameterBooleanValue(params, IsStaggeredZ);
        if (this.isZStag) {
            pertVarName = this.getParameterStringValue(params, PerturbationGeopotentialVariable);
            baseVarName = this.getParameterStringValue(params, BaseGeopotentialVariable);
            this.units = "m";
        } else {
            pertVarName = this.getParameterStringValue(params, PerturbationPressureVariable);
            baseVarName = this.getParameterStringValue(params, BasePressureVariable);
            this.units = "Pa";
        }
        this.pertVar = ds.findVariable(pertVarName);
        this.baseVar = ds.findVariable(baseVarName);
        if (this.pertVar == null) {
            throw new RuntimeException("Cant find perturbation pressure variable= " + pertVarName + " in WRF file");
        }
        if (this.baseVar == null) {
            throw new RuntimeException("Cant find base state pressure variable=  " + baseVarName + " in WRF file");
        }
    }

    @Override
    public ArrayDouble.D3 getCoordinateArray(int timeIndex) throws IOException {
        Array pertArray = this.getTimeSlice(this.pertVar, timeIndex);
        Array baseArray = this.getTimeSlice(this.baseVar, timeIndex);
        int[] shape = pertArray.getShape();
        int ni = shape[0];
        int nj = shape[1];
        int nk = shape[2];
        ArrayDouble.D3 array = new ArrayDouble.D3(ni, nj, nk);
        Index index = array.getIndex();
        for (int i = 0; i < ni; ++i) {
            for (int j = 0; j < nj; ++j) {
                for (int k = 0; k < nk; ++k) {
                    index.set(i, j, k);
                    double d = pertArray.getDouble(index) + baseArray.getDouble(index);
                    if (this.isZStag) {
                        d /= 9.81;
                    }
                    array.setDouble(index, d);
                }
            }
        }
        if (this.isXStag) {
            array = this.addStagger(array, 2);
        }
        if (this.isYStag) {
            array = this.addStagger(array, 1);
        }
        return array;
    }

    @Override
    public ArrayDouble.D1 getCoordinateArray1D(int timeIndex, int xIndex, int yIndex) throws IOException, InvalidRangeException {
        ArrayDouble.D3 data = this.getCoordinateArray(timeIndex);
        int[] origin = new int[3];
        int[] shape = new int[3];
        origin[0] = 0;
        origin[1] = yIndex;
        origin[2] = xIndex;
        shape[0] = data.getShape()[0];
        shape[1] = 1;
        shape[2] = 1;
        Array tmp = data.section(origin, shape);
        return (ArrayDouble.D1)tmp.reduce();
    }

    private ArrayDouble.D3 addStagger(ArrayDouble.D3 array, int dimIndex) {
        int[] shape = array.getShape();
        int[] newShape = new int[3];
        System.arraycopy(shape, 0, newShape, 0, 3);
        int n = dimIndex;
        newShape[n] = newShape[n] + 1;
        int ni = newShape[0];
        int nj = newShape[1];
        int nk = newShape[2];
        ArrayDouble.D3 newArray = new ArrayDouble.D3(ni, nj, nk);
        int n2 = shape[dimIndex];
        double[] d = new double[n2];
        int[] eshape = new int[3];
        int[] neweshape = new int[3];
        for (int i = 0; i < 3; ++i) {
            eshape[i] = i == dimIndex ? n2 : 1;
            neweshape[i] = i == dimIndex ? n2 + 1 : 1;
        }
        int[] origin = new int[3];
        try {
            for (int i = 0; i < (dimIndex == 0 ? 1 : ni); ++i) {
                for (int j = 0; j < (dimIndex == 1 ? 1 : nj); ++j) {
                    for (int k = 0; k < (dimIndex == 2 ? 1 : nk); ++k) {
                        origin[0] = i;
                        origin[1] = j;
                        origin[2] = k;
                        IndexIterator it = array.section(origin, eshape).getIndexIterator();
                        for (int l = 0; l < n2; ++l) {
                            d[l] = it.getDoubleNext();
                        }
                        double[] d2 = this.extrapinterpolate(d);
                        IndexIterator newit = newArray.section(origin, neweshape).getIndexIterator();
                        for (int l = 0; l < n2 + 1; ++l) {
                            newit.setDoubleNext(d2[l]);
                        }
                    }
                }
            }
        }
        catch (InvalidRangeException e) {
            return null;
        }
        return newArray;
    }

    private double[] extrapinterpolate(double[] array) {
        int n = array.length;
        double[] d = new double[n + 1];
        d[0] = 1.5 * array[0] - 0.5 * array[1];
        d[n] = 1.5 * array[n - 1] - 0.5 * array[n - 2];
        for (int i = 1; i < n; ++i) {
            d[i] = 0.5 * (array[i - 1] + array[i]);
        }
        return d;
    }

    private Array getTimeSlice(Variable v, int timeIndex) throws IOException {
        int dimIndex;
        int[] shape = v.getShape();
        int[] origin = new int[v.getRank()];
        if (this.getTimeDimension() != null && (dimIndex = v.findDimensionIndex(this.getTimeDimension().getShortName())) >= 0) {
            shape[dimIndex] = 1;
            origin[dimIndex] = timeIndex;
        }
        try {
            return v.read(origin, shape).reduce();
        }
        catch (InvalidRangeException e) {
            throw new IOException(e);
        }
    }
}

