/*
 * Decompiled with CFR 0.152.
 */
package opendap.servlet;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import opendap.dap.DAP2Exception;
import opendap.dap.DAS;
import opendap.dap.DDS;
import opendap.dap.parsers.ParseException;
import opendap.servers.ServerDDS;
import opendap.servlet.ReqState;
import opendap.servlet.www.jscriptCore;
import opendap.servlet.www.wwwFactory;
import opendap.servlet.www.wwwOutPut;

public class GetHTMLInterfaceHandler {
    private static final boolean _Debug = false;
    private String helpLocation = "http://www.opendap.org/online_help_files/";

    public void sendDataRequestForm(ReqState rs, String dataSet, ServerDDS sdds, DAS myDAS) throws DAP2Exception, ParseException {
        int suffixIndex = rs.getRequest().getRequestURL().toString().lastIndexOf(".");
        String requestURL = rs.getRequest().getRequestURL().substring(0, suffixIndex);
        String dapCssUrl = "/" + requestURL.split("/", 5)[3] + "/tdsDap.css";
        try {
            PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)rs.getResponse().getOutputStream(), StandardCharsets.UTF_8));
            wwwOutPut wOut = new wwwOutPut(pw);
            DDS myDDS = this.getWebFormDDS(dataSet, sdds);
            jscriptCore jsc = new jscriptCore();
            pw.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\"\n\"http://www.w3.org/TR/REC-html40/loose.dtd\">\n<html><head><title>OPeNDAP Dataset Query Form</title>\n<link type=\"text/css\" rel=\"stylesheet\" media=\"screen\" href=\"" + dapCssUrl + "\"/>\n<base href=\"" + this.helpLocation + "\">\n<script type=\"text/javascript\">\n<!--\n");
            pw.flush();
            pw.println(jscriptCore.jScriptCode);
            pw.flush();
            pw.println("DODS_URL = new dods_url(\"" + requestURL + "\");\n// -->\n</script>\n</head>\n<body>\n<p><h2 align='center'>OPeNDAP Dataset Access Form</h2>\n<hr>\n<form action=\"\">\n<table>\n");
            pw.flush();
            wOut.writeDisposition(requestURL);
            pw.println("<tr><td><td><hr>\n");
            wOut.writeGlobalAttributes(myDAS, myDDS);
            pw.println("<tr><td><td><hr>\n");
            wOut.writeVariableEntries(myDAS, myDDS);
            pw.println("</table></form>\n");
            pw.println("<hr>\n");
            pw.println("<address>Send questions or comments to: <a href=\"mailto:support@unidata.ucar.edu\">support@unidata.ucar.edu</a></address></body></html>\n");
            pw.println("<hr>");
            pw.println("<h2>DDS:</h2>");
            pw.println("<pre>");
            myDDS.print(pw);
            pw.println("</pre>");
            pw.println("<hr>");
            pw.flush();
        }
        catch (IOException ioe) {
            System.out.println("OUCH! IOException: " + ioe.getMessage());
            ioe.printStackTrace(System.out);
        }
    }

    public DDS getWebFormDDS(String dataSet, ServerDDS sDDS) throws DAP2Exception, ParseException {
        StringWriter ddsSW = new StringWriter();
        sDDS.print(new PrintWriter(ddsSW));
        ByteArrayInputStream bai = null;
        try {
            bai = new ByteArrayInputStream(ddsSW.toString().getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException uee) {
            throw new DAP2Exception("UTF-8 encoding not supported");
        }
        wwwFactory wfactory = new wwwFactory();
        DDS wwwDDS = new DDS(dataSet, wfactory);
        wwwDDS.setURL(dataSet);
        wwwDDS.parse(bai);
        return wwwDDS;
    }
}

