/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.util.HashMap;
import java.util.Map;
import ucar.nc2.Attribute;
import ucar.nc2.CDMSort;
import ucar.nc2.Dimension;
import ucar.nc2.EnumTypedef;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Sequence;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.dataset.StructureDS;
import ucar.nc2.dataset.VariableDS;

public abstract class CDMNode {
    protected CDMSort sort;
    protected Group group;
    protected Structure parentstruct;
    protected boolean immutable;
    protected String shortName;
    protected Map<Object, Object> annotations;
    protected String dodsname;

    protected CDMNode() {
        if (this instanceof Attribute) {
            this.setSort(CDMSort.ATTRIBUTE);
        } else if (this instanceof Dimension) {
            this.setSort(CDMSort.DIMENSION);
        } else if (this instanceof EnumTypedef) {
            this.setSort(CDMSort.ENUMERATION);
        } else if (this instanceof Sequence) {
            this.setSort(CDMSort.SEQUENCE);
        } else if (this instanceof Structure) {
            this.setSort(CDMSort.STRUCTURE);
        } else if (this instanceof Group) {
            this.setSort(CDMSort.GROUP);
        } else if (this instanceof Variable) {
            this.setSort(CDMSort.VARIABLE);
        }
    }

    public CDMNode(String name) {
        this();
        this.setShortName(name);
    }

    public CDMSort getSort() {
        return this.sort;
    }

    public void setSort(CDMSort sort) {
        if (!this.immutable) {
            this.sort = sort;
        }
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String name) {
        if (!this.immutable) {
            this.shortName = NetcdfFile.makeValidCdmObjectName(name);
        }
    }

    public Group getParentGroup() {
        return this.group;
    }

    public Group getGroup() {
        return this.getParentGroup();
    }

    public void setParentGroup(Group parent) {
        if (!this.immutable) {
            this.group = parent;
        }
    }

    public Structure getParentStructure() {
        return this.parentstruct;
    }

    public void setParentStructure(Structure parent) {
        if (!this.immutable) {
            this.parentstruct = parent;
        }
    }

    public boolean isMemberOfStructure() {
        return this.parentstruct != null;
    }

    public boolean getImmutable() {
        return this.immutable;
    }

    public CDMNode setImmutable() {
        this.immutable = true;
        return this;
    }

    public String getDODSName() {
        if (this.dodsname == null) {
            return this.shortName;
        }
        return this.dodsname;
    }

    public void setDODSName(String name) {
        this.dodsname = name;
    }

    public String getFullName() {
        return NetcdfFile.makeFullName(this);
    }

    public String getFullNameEscaped() {
        return this.getFullName();
    }

    @Deprecated
    public String getName() {
        switch (this.sort) {
            case ATTRIBUTE: 
            case DIMENSION: 
            case ENUMERATION: {
                return this.getShortName();
            }
            case VARIABLE: 
            case SEQUENCE: 
            case STRUCTURE: 
            case GROUP: {
                return this.getFullName();
            }
        }
        return this.getShortName();
    }

    public int localhash() {
        return super.hashCode();
    }

    public static CDMNode unwrap(CDMNode node) {
        Variable inner;
        block3: {
            StructureDS sds;
            if (!(node instanceof Variable)) {
                return node;
            }
            inner = (Variable)node;
            while (true) {
                if (inner instanceof VariableDS) {
                    VariableDS vds = (VariableDS)inner;
                    if ((inner = vds.getOriginalVariable()) != null) continue;
                    inner = vds;
                    break block3;
                }
                if (!(inner instanceof StructureDS)) break block3;
                sds = (StructureDS)inner;
                if ((inner = sds.getOriginalVariable()) == null) break;
            }
            inner = sds;
        }
        return inner;
    }

    public Object annotation(Object id) {
        return this.annotations == null ? null : this.annotations.get(id);
    }

    public Object annotate(Object id, Object value) {
        if (this.annotations == null) {
            this.annotations = new HashMap<Object, Object>();
        }
        Object old = this.annotations.get(id);
        this.annotations.put(id, value);
        return old;
    }
}

