/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2.table;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;
import ucar.nc2.grib.GribTables;
import ucar.nc2.grib.grib2.Grib2Parameter;
import ucar.nc2.grib.grib2.table.Grib2ParamTableInterface;
import ucar.nc2.grib.grib2.table.Grib2TableConfig;

public class EccodesParamTable
implements Grib2ParamTableInterface {
    private static final boolean debugOpen = false;
    private static final boolean debug = false;
    private static final String PATH = "resources/grib2/ecmwf/tables";
    private String title;
    private String source;
    private String tableName;
    private final int version;
    private final int discipline;
    private final int category;
    private final ImmutableMap<Integer, Grib2Parameter> paramMap;

    public static EccodesParamTable factory(int version, int discipline, int category) {
        try {
            return new EccodesParamTable(version, discipline, category);
        }
        catch (Exception e) {
            return null;
        }
    }

    private EccodesParamTable(int version, int discipline, int category) throws IOException {
        this.version = version;
        this.discipline = discipline;
        this.category = category;
        this.paramMap = this.readTable(this.getTablePath());
    }

    @Override
    public String getName() {
        return String.format("Ecmwf version %d discipline %d category %d (%s)", this.version, this.discipline, this.category, this.getTablePath());
    }

    @Override
    public String getShortName() {
        return String.format("Ecmwf version %d (%d-%d)", this.version, this.discipline, this.category);
    }

    @Override
    public ImmutableList<GribTables.Parameter> getParameters() {
        return this.paramMap.values().stream().sorted().map(p -> p).collect(ImmutableList.toImmutableList());
    }

    @Override
    @Nullable
    public Grib2Parameter getParameter(int code) {
        return this.paramMap.get(code);
    }

    @Nullable
    public Grib2Parameter getParameter(int discipline, int category, int number) {
        return this.paramMap.get(number);
    }

    private String getTablePath() {
        return String.format("%s/%d/4.2.%d.%d.table", PATH, this.version, this.discipline, this.category);
    }

    private ImmutableMap<Integer, Grib2Parameter> readTable(String path) throws IOException {
        ImmutableMap.Builder<Integer, Grib2Parameter> builder = ImmutableMap.builder();
        ClassLoader cl = Grib2TableConfig.class.getClassLoader();
        try (InputStream is = cl.getResourceAsStream(path);){
            if (is == null) {
                throw new IllegalStateException("Cant find " + path);
            }
            try (BufferedReader dataIS = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
                String line;
                int count = 0;
                while ((line = dataIS.readLine()) != null) {
                    String units;
                    if (line.startsWith("#") || line.trim().isEmpty()) continue;
                    ++count;
                    int posBlank1 = line.indexOf(32);
                    int posBlank2 = line.indexOf(32, posBlank1 + 1);
                    int lastParen = line.lastIndexOf(40);
                    String num1 = line.substring(0, posBlank1).trim();
                    String num2 = line.substring(posBlank1 + 1, posBlank2);
                    String desc = lastParen > 0 ? line.substring(posBlank2 + 1, lastParen).trim() : line.substring(posBlank2 + 1).trim();
                    String string = units = lastParen > 0 ? line.substring(lastParen).trim() : "";
                    if (units.startsWith("(") & units.endsWith(")")) {
                        units = units.substring(1, units.length() - 1);
                    }
                    if (!num1.equals(num2)) continue;
                    int number = Integer.parseInt(num1);
                    Grib2Parameter parameter = new Grib2Parameter(this.discipline, this.category, number, desc, units, null, desc);
                    builder.put(parameter.getNumber(), parameter);
                }
            }
        }
        return builder.build();
    }
}

