/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.io;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.annotation.concurrent.NotThreadSafe;
import ucar.nc2.dataset.DatasetUrl;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.cache.FileCache;
import ucar.nc2.util.cache.FileCacheIF;
import ucar.nc2.util.cache.FileCacheable;
import ucar.nc2.util.cache.FileFactory;
import ucar.unidata.io.KMPMatch;
import ucar.unidata.util.StringUtil2;

@NotThreadSafe
public class RandomAccessFile
implements DataInput,
DataOutput,
FileCacheable,
Closeable {
    public static final int BIG_ENDIAN = 0;
    public static final int LITTLE_ENDIAN = 1;
    protected static final int defaultBufferSize = 8092;
    protected static boolean debugLeaks;
    protected static boolean debugAccess;
    protected static Set<String> allFiles;
    protected static List<String> openFiles;
    private static AtomicLong count_openFiles;
    private static AtomicInteger maxOpenFiles;
    private static AtomicInteger debug_nseeks;
    private static AtomicLong debug_nbytes;
    protected static boolean showOpen;
    protected static boolean showRead;
    private static final FileFactory factory;
    private static FileCacheIF cache;
    protected String location;
    private int cacheState;
    protected java.io.RandomAccessFile file;
    protected FileChannel fileChannel;
    protected long filePosition;
    protected byte[] buffer;
    protected long bufferStart;
    protected long dataEnd;
    protected int dataSize;
    protected boolean endOfFile;
    protected boolean readonly;
    protected boolean bigEndian;
    boolean bufferModified;
    private long minLength;
    private boolean extendMode;

    public static boolean getDebugLeaks() {
        return debugLeaks;
    }

    public static void setDebugLeaks(boolean b) {
        if (b) {
            count_openFiles.set(0L);
            maxOpenFiles.set(0);
            allFiles = new HashSet<String>(1000);
        }
        debugLeaks = b;
    }

    public static List<String> getOpenFiles() {
        return Collections.unmodifiableList(openFiles);
    }

    public static long getOpenFileCount() {
        return count_openFiles.get();
    }

    public static int getMaxOpenFileCount() {
        return maxOpenFiles.get();
    }

    public static List<String> getAllFiles() {
        if (null == allFiles) {
            return null;
        }
        return allFiles.stream().sorted().collect(Collectors.toList());
    }

    public static void setDebugAccess(boolean b) {
        debugAccess = b;
        if (b) {
            debug_nseeks = new AtomicInteger();
            debug_nbytes = new AtomicLong();
        }
    }

    public static int getDebugNseeks() {
        return debug_nseeks == null ? 0 : debug_nseeks.intValue();
    }

    public static long getDebugNbytes() {
        return debug_nbytes == null ? 0L : debug_nbytes.longValue();
    }

    public static synchronized void enableDefaultGlobalFileCache() {
        if (cache != null) {
            cache.disable();
        }
        cache = new FileCache("RandomAccessFile", 200, 300, 400, 3600);
    }

    public static synchronized void setGlobalFileCache(FileCacheIF _cache) {
        if (cache != null) {
            cache.disable();
        }
        cache = _cache;
    }

    public static synchronized FileCacheIF getGlobalFileCache() {
        return cache;
    }

    public static RandomAccessFile acquire(String location) throws IOException {
        if (cache == null) {
            return new RandomAccessFile(location, "r");
        }
        return (RandomAccessFile)cache.acquire(factory, new DatasetUrl(null, location));
    }

    public static RandomAccessFile acquire(String location, int buffer_size) throws IOException {
        if (cache == null) {
            return new RandomAccessFile(location, "r", buffer_size);
        }
        return (RandomAccessFile)cache.acquire(factory, location, new DatasetUrl(null, location), buffer_size, null, null);
    }

    public static void eject(String location) {
        if (cache != null) {
            cache.eject(location);
        }
    }

    public static void shutdown() {
        if (cache != null) {
            cache.clearCache(true);
        }
    }

    protected RandomAccessFile(int bufferSize) {
        this.file = null;
        this.readonly = true;
        this.init(bufferSize);
    }

    public RandomAccessFile(String location, String mode) throws IOException {
        this(location, mode, 8092);
        this.location = location;
    }

    public RandomAccessFile(String location, String mode, int bufferSize) throws IOException {
        if (bufferSize < 0) {
            bufferSize = 8092;
        }
        this.location = location;
        if (debugLeaks) {
            allFiles.add(location);
        }
        try {
            this.file = new java.io.RandomAccessFile(location, mode);
        }
        catch (IOException ioe) {
            if (ioe.getMessage().equals("Too many open files")) {
                System.out.printf("RandomAccessFile %s%n", ioe);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                this.file = new java.io.RandomAccessFile(location, mode);
            }
            throw ioe;
        }
        this.readonly = mode.equals("r");
        this.init(bufferSize);
        if (debugLeaks) {
            openFiles.add(location);
            int max = Math.max(openFiles.size(), maxOpenFiles.get());
            maxOpenFiles.set(max);
            count_openFiles.getAndIncrement();
            if (showOpen) {
                System.out.println(" DebugRAF open " + location);
            }
        }
    }

    public java.io.RandomAccessFile getRandomAccessFile() {
        return this.file;
    }

    private void init(int bufferSize) {
        this.bufferStart = 0L;
        this.dataEnd = 0L;
        this.dataSize = 0;
        this.filePosition = 0L;
        this.buffer = new byte[bufferSize];
        this.endOfFile = false;
    }

    public void setBufferSize(int bufferSize) {
        this.init(bufferSize);
    }

    public int getBufferSize() {
        return this.buffer.length;
    }

    @Override
    public synchronized void close() throws IOException {
        if (cache != null && this.cacheState > 0) {
            if (this.cacheState == 1) {
                this.cacheState = 2;
                if (cache.release(this)) {
                    return;
                }
                this.cacheState = 0;
            } else {
                return;
            }
        }
        if (debugLeaks) {
            openFiles.remove(this.location);
            if (showOpen) {
                System.out.println("  close " + this.location);
            }
        }
        if (this.file == null) {
            return;
        }
        this.flush();
        long fileSize = this.file.length();
        if (!this.readonly && this.minLength != 0L && this.minLength != fileSize) {
            this.file.setLength(this.minLength);
        }
        this.file.close();
        this.file = null;
    }

    @Override
    public void release() {
        this.cacheState = 2;
    }

    @Override
    public void reacquire() {
        this.cacheState = 1;
    }

    @Override
    public synchronized void setFileCache(FileCacheIF fileCache) {
        if (fileCache == null) {
            this.cacheState = 0;
        }
    }

    @Override
    public long getLastModified() {
        File file = new File(this.getLocation());
        return file.lastModified();
    }

    public boolean isAtEndOfFile() {
        return this.endOfFile;
    }

    public void seek(long pos) throws IOException {
        if (pos < 0L) {
            throw new IOException("Negative seek offset");
        }
        if (pos >= this.bufferStart && pos < this.dataEnd) {
            this.filePosition = pos;
            return;
        }
        this.readBuffer(pos);
    }

    protected void readBuffer(long pos) throws IOException {
        if (this.bufferModified) {
            this.flush();
        }
        this.bufferStart = pos;
        this.filePosition = pos;
        this.dataSize = this.read_(pos, this.buffer, 0, this.buffer.length);
        if (this.dataSize <= 0) {
            this.dataSize = 0;
            this.endOfFile = true;
        } else {
            this.endOfFile = false;
        }
        this.dataEnd = this.bufferStart + (long)this.dataSize;
    }

    public long getFilePointer() {
        return this.filePosition;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    public long length() throws IOException {
        long fileLength;
        long l = fileLength = this.file == null ? -1L : this.file.length();
        if (fileLength < this.dataEnd) {
            return this.dataEnd;
        }
        return fileLength;
    }

    public void order(int endian) {
        if (endian < 0) {
            return;
        }
        this.bigEndian = endian == 0;
    }

    public void order(ByteOrder bo) {
        if (bo == null) {
            return;
        }
        this.bigEndian = bo.equals(ByteOrder.BIG_ENDIAN);
    }

    public void flush() throws IOException {
        if (this.bufferModified) {
            this.file.seek(this.bufferStart);
            this.file.write(this.buffer, 0, this.dataSize);
            this.bufferModified = false;
        }
    }

    public synchronized void setMinLength(long minLength) {
        this.minLength = minLength;
    }

    public void setExtendMode() {
        this.extendMode = true;
    }

    public int read() throws IOException {
        if (this.filePosition < this.dataEnd) {
            int pos = (int)(this.filePosition - this.bufferStart);
            ++this.filePosition;
            return this.buffer[pos] & 0xFF;
        }
        if (this.endOfFile) {
            return -1;
        }
        this.seek(this.filePosition);
        return this.read();
    }

    public int readBytes(byte[] b, int off, int len) throws IOException {
        if (this.endOfFile) {
            return -1;
        }
        int bytesAvailable = (int)(this.dataEnd - this.filePosition);
        if (bytesAvailable < 1) {
            this.seek(this.filePosition);
            return this.readBytes(b, off, len);
        }
        int copyLength = bytesAvailable >= len ? len : bytesAvailable;
        System.arraycopy(this.buffer, (int)(this.filePosition - this.bufferStart), b, off, copyLength);
        this.filePosition += (long)copyLength;
        if (copyLength < len) {
            int extraCopy = len - copyLength;
            if (extraCopy > this.buffer.length) {
                extraCopy = this.read_(this.filePosition, b, off + copyLength, len - copyLength);
            } else {
                this.seek(this.filePosition);
                if (!this.endOfFile) {
                    extraCopy = extraCopy > this.dataSize ? this.dataSize : extraCopy;
                    System.arraycopy(this.buffer, 0, b, off + copyLength, extraCopy);
                } else {
                    extraCopy = -1;
                }
            }
            if (extraCopy > 0) {
                this.filePosition += (long)extraCopy;
                return copyLength + extraCopy;
            }
        }
        return copyLength;
    }

    public long readToByteChannel(WritableByteChannel dest, long offset, long nbytes) throws IOException {
        if (this.fileChannel == null) {
            this.fileChannel = this.file.getChannel();
        }
        long need = nbytes;
        while (need > 0L) {
            long count = this.fileChannel.transferTo(offset, need, dest);
            need -= count;
            offset += count;
        }
        return nbytes - need;
    }

    protected int read_(long pos, byte[] b, int offset, int len) throws IOException {
        this.file.seek(pos);
        int n = this.file.read(b, offset, len);
        if (debugAccess) {
            if (showRead) {
                System.out.printf(" **read_ %s = %d bytes at %d; block = %d%n", this.location, len, pos, pos / (long)this.buffer.length);
            }
            debug_nseeks.incrementAndGet();
            debug_nbytes.addAndGet(len);
        }
        if (this.extendMode && n < len) {
            n = len;
        }
        return n;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.readBytes(b, off, len);
    }

    public int read(byte[] b) throws IOException {
        return this.readBytes(b, 0, b.length);
    }

    public byte[] readBytes(int count) throws IOException {
        byte[] b = new byte[count];
        this.readFully(b);
        return b;
    }

    @Override
    public final void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public final void readFully(byte[] b, int off, int len) throws IOException {
        int count;
        for (int n = 0; n < len; n += count) {
            count = this.read(b, off + n, len - n);
            if (count >= 0) continue;
            throw new EOFException("Reading " + this.location + " at " + this.filePosition + " file length = " + this.length());
        }
    }

    @Override
    public int skipBytes(int n) throws IOException {
        this.seek(this.getFilePointer() + (long)n);
        return n;
    }

    public long skipBytes(long n) throws IOException {
        this.seek(this.getFilePointer() + n);
        return n;
    }

    public void unread() {
        --this.filePosition;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.filePosition < this.dataEnd) {
            int pos = (int)(this.filePosition - this.bufferStart);
            this.buffer[pos] = (byte)b;
            this.bufferModified = true;
            ++this.filePosition;
        } else if (this.dataSize != this.buffer.length) {
            int pos = (int)(this.filePosition - this.bufferStart);
            this.buffer[pos] = (byte)b;
            this.bufferModified = true;
            ++this.filePosition;
            ++this.dataSize;
            ++this.dataEnd;
        } else {
            this.seek(this.filePosition);
            this.write(b);
        }
    }

    public void writeBytes(byte[] b, int off, int len) throws IOException {
        if (len < this.buffer.length) {
            long myDataEnd;
            int spaceInBuffer = 0;
            int copyLength = 0;
            if (this.filePosition >= this.bufferStart) {
                spaceInBuffer = (int)(this.bufferStart + (long)this.buffer.length - this.filePosition);
            }
            if (spaceInBuffer > 0) {
                copyLength = spaceInBuffer > len ? len : spaceInBuffer;
                System.arraycopy(b, off, this.buffer, (int)(this.filePosition - this.bufferStart), copyLength);
                this.bufferModified = true;
                myDataEnd = this.filePosition + (long)copyLength;
                this.dataEnd = myDataEnd > this.dataEnd ? myDataEnd : this.dataEnd;
                this.dataSize = (int)(this.dataEnd - this.bufferStart);
                this.filePosition += (long)copyLength;
            }
            if (copyLength < len) {
                this.seek(this.filePosition);
                System.arraycopy(b, off + copyLength, this.buffer, (int)(this.filePosition - this.bufferStart), len - copyLength);
                this.bufferModified = true;
                myDataEnd = this.filePosition + (long)(len - copyLength);
                this.dataEnd = myDataEnd > this.dataEnd ? myDataEnd : this.dataEnd;
                this.dataSize = (int)(this.dataEnd - this.bufferStart);
                this.filePosition += (long)(len - copyLength);
            }
        } else {
            if (this.bufferModified) {
                this.flush();
            }
            this.file.seek(this.filePosition);
            this.file.write(b, off, len);
            this.filePosition += (long)len;
            this.bufferStart = this.filePosition;
            this.dataSize = 0;
            this.dataEnd = this.bufferStart + (long)this.dataSize;
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.writeBytes(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.writeBytes(b, off, len);
    }

    @Override
    public final boolean readBoolean() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch != 0;
    }

    @Override
    public final byte readByte() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return (byte)ch;
    }

    @Override
    public final int readUnsignedByte() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch;
    }

    @Override
    public final short readShort() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        if (this.bigEndian) {
            return (short)((ch1 << 8) + ch2);
        }
        return (short)((ch2 << 8) + ch1);
    }

    public final void readShort(short[] pa, int start, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            pa[start + i] = this.readShort();
        }
    }

    @Override
    public final int readUnsignedShort() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        if (this.bigEndian) {
            return (ch1 << 8) + ch2;
        }
        return (ch2 << 8) + ch1;
    }

    @Override
    public final char readChar() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        if (this.bigEndian) {
            return (char)((ch1 << 8) + ch2);
        }
        return (char)((ch2 << 8) + ch1);
    }

    @Override
    public final int readInt() throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read()) | (ch3 = this.read()) | (ch4 = this.read())) < 0) {
            throw new EOFException();
        }
        if (this.bigEndian) {
            return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + ch4;
        }
        return (ch4 << 24) + (ch3 << 16) + (ch2 << 8) + ch1;
    }

    public final int readIntUnbuffered(long pos) throws IOException {
        byte[] bb = new byte[4];
        this.read_(pos, bb, 0, 4);
        int ch1 = bb[0] & 0xFF;
        int ch2 = bb[1] & 0xFF;
        int ch3 = bb[2] & 0xFF;
        int ch4 = bb[3] & 0xFF;
        if ((ch1 | ch2 | ch3 | ch4) < 0) {
            throw new EOFException();
        }
        if (this.bigEndian) {
            return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + ch4;
        }
        return (ch4 << 24) + (ch3 << 16) + (ch2 << 8) + ch1;
    }

    public final void readInt(int[] pa, int start, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            pa[start + i] = this.readInt();
        }
    }

    @Override
    public final long readLong() throws IOException {
        if (this.bigEndian) {
            return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
        }
        return ((long)this.readInt() & 0xFFFFFFFFL) + ((long)this.readInt() << 32);
    }

    public final void readLong(long[] pa, int start, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            pa[start + i] = this.readLong();
        }
    }

    @Override
    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public final void readFloat(float[] pa, int start, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            pa[start + i] = Float.intBitsToFloat(this.readInt());
        }
    }

    @Override
    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public final void readDouble(double[] pa, int start, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            pa[start + i] = Double.longBitsToDouble(this.readLong());
        }
    }

    @Override
    public final String readLine() throws IOException {
        StringBuilder input = new StringBuilder();
        int c = -1;
        boolean eol = false;
        block4: while (!eol) {
            c = this.read();
            switch (c) {
                case -1: 
                case 10: {
                    eol = true;
                    continue block4;
                }
                case 13: {
                    eol = true;
                    long cur = this.getFilePointer();
                    if (this.read() == 10) continue block4;
                    this.seek(cur);
                    continue block4;
                }
            }
            input.append((char)c);
        }
        if (c == -1 && input.length() == 0) {
            return null;
        }
        return input.toString();
    }

    @Override
    public final String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    public String readString(int nbytes) throws IOException {
        byte[] data = new byte[nbytes];
        this.readFully(data);
        return new String(data, StandardCharsets.UTF_8);
    }

    public String readStringMax(int nbytes) throws IOException {
        int count;
        byte[] b = new byte[nbytes];
        this.readFully(b);
        for (count = 0; count < nbytes && b[count] != 0; ++count) {
        }
        return new String(b, 0, count, StandardCharsets.UTF_8);
    }

    @Override
    public final void writeBoolean(boolean v) throws IOException {
        this.write(v ? 1 : 0);
    }

    public final void writeBoolean(boolean[] pa, int start, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            this.writeBoolean(pa[start + i]);
        }
    }

    @Override
    public final void writeByte(int v) throws IOException {
        this.write(v);
    }

    @Override
    public final void writeShort(int v) throws IOException {
        this.write(v >>> 8 & 0xFF);
        this.write(v & 0xFF);
    }

    public final void writeShort(short[] pa, int start, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            this.writeShort(pa[start + i]);
        }
    }

    @Override
    public final void writeChar(int v) throws IOException {
        this.write(v >>> 8 & 0xFF);
        this.write(v & 0xFF);
    }

    public final void writeChar(char[] pa, int start, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            this.writeChar(pa[start + i]);
        }
    }

    @Override
    public final void writeInt(int v) throws IOException {
        this.write(v >>> 24 & 0xFF);
        this.write(v >>> 16 & 0xFF);
        this.write(v >>> 8 & 0xFF);
        this.write(v & 0xFF);
    }

    public final void writeInt(int[] pa, int start, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            this.writeInt(pa[start + i]);
        }
    }

    @Override
    public final void writeLong(long v) throws IOException {
        this.write((int)(v >>> 56) & 0xFF);
        this.write((int)(v >>> 48) & 0xFF);
        this.write((int)(v >>> 40) & 0xFF);
        this.write((int)(v >>> 32) & 0xFF);
        this.write((int)(v >>> 24) & 0xFF);
        this.write((int)(v >>> 16) & 0xFF);
        this.write((int)(v >>> 8) & 0xFF);
        this.write((int)v & 0xFF);
    }

    public final void writeLong(long[] pa, int start, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            this.writeLong(pa[start + i]);
        }
    }

    @Override
    public final void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    public final void writeFloat(float[] pa, int start, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            this.writeFloat(pa[start + i]);
        }
    }

    @Override
    public final void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    public final void writeDouble(double[] pa, int start, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            this.writeDouble(pa[start + i]);
        }
    }

    @Override
    public final void writeBytes(String s2) throws IOException {
        int len = s2.length();
        for (int i = 0; i < len; ++i) {
            this.write((byte)s2.charAt(i));
        }
    }

    public final void writeBytes(char[] b, int off, int len) throws IOException {
        for (int i = off; i < len; ++i) {
            this.write((byte)b[i]);
        }
    }

    @Override
    public final void writeChars(String s2) throws IOException {
        int len = s2.length();
        for (int i = 0; i < len; ++i) {
            char v = s2.charAt(i);
            this.write(v >>> 8 & 0xFF);
            this.write(v & 0xFF);
        }
    }

    @Override
    public final void writeUTF(String str) throws IOException {
        char c;
        int i;
        int strlen = str.length();
        int utflen = 0;
        for (i = 0; i < strlen; ++i) {
            c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        if (utflen > 65535) {
            throw new UTFDataFormatException();
        }
        this.write(utflen >>> 8 & 0xFF);
        this.write(utflen & 0xFF);
        for (i = 0; i < strlen; ++i) {
            c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                this.write(c);
                continue;
            }
            if (c > '\u07ff') {
                this.write(0xE0 | c >> 12 & 0xF);
                this.write(0x80 | c >> 6 & 0x3F);
                this.write(0x80 | c & 0x3F);
                continue;
            }
            this.write(0xC0 | c >> 6 & 0x1F);
            this.write(0x80 | c & 0x3F);
        }
    }

    public String toString() {
        return this.location;
    }

    public boolean searchForward(KMPMatch match, int maxBytes) throws IOException {
        int scanBytes;
        int bufStart;
        int pos;
        long start = this.getFilePointer();
        long last = maxBytes < 0 ? this.length() : Math.min(this.length(), start + (long)maxBytes);
        long needToScan = last - start;
        int bytesAvailable = (int)(this.dataEnd - this.filePosition);
        if (bytesAvailable < 1) {
            this.seek(this.filePosition);
            bytesAvailable = (int)(this.dataEnd - this.filePosition);
        }
        if ((pos = match.indexOf(this.buffer, bufStart = (int)(this.filePosition - this.bufferStart), scanBytes = (int)Math.min((long)bytesAvailable, needToScan))) >= 0) {
            this.seek(this.bufferStart + (long)pos);
            return true;
        }
        int matchLen = match.getMatchLength();
        needToScan -= (long)(scanBytes - matchLen);
        while (needToScan > (long)matchLen) {
            this.readBuffer(this.dataEnd - (long)matchLen);
            scanBytes = (int)Math.min((long)this.buffer.length, needToScan);
            pos = match.indexOf(this.buffer, 0, scanBytes);
            if (pos > 0) {
                this.seek(this.bufferStart + (long)pos);
                return true;
            }
            needToScan -= (long)(scanBytes - matchLen);
        }
        this.seek(last);
        return false;
    }

    static {
        openFiles = Collections.synchronizedList(new ArrayList());
        count_openFiles = new AtomicLong();
        maxOpenFiles = new AtomicInteger();
        debug_nseeks = new AtomicInteger();
        debug_nbytes = new AtomicLong();
        factory = new FileFactory(){

            @Override
            public FileCacheable open(DatasetUrl durl, int buffer_size, CancelTask cancelTask, Object iospMessage) throws IOException {
                String location = StringUtil2.replace(durl.trueurl, "\\", "/");
                RandomAccessFile result = new RandomAccessFile(location, "r", buffer_size);
                result.cacheState = 1;
                return result;
            }
        };
    }
}

