/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.misc;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.ArraySequence;
import ucar.ma2.ArrayStructureBB;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Sequence;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.CF;
import ucar.nc2.iosp.AbstractIOServiceProvider;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.util.CancelTask;
import ucar.unidata.io.RandomAccessFile;

public class NmcObsLegacy
extends AbstractIOServiceProvider {
    private static Logger logger = LoggerFactory.getLogger(NmcObsLegacy.class);
    private List<Station> stations = new ArrayList<Station>();
    private List<Report> reports = new ArrayList<Report>();
    private Calendar cal;
    private DateFormatter dateFormatter = new DateFormatter();
    private Date refDate;
    private List<StructureCode> catStructures = new ArrayList<StructureCode>(10);
    private boolean showObs;
    private boolean showSkip;
    private boolean showOverflow;
    private boolean showData;
    private boolean showHeader;
    private boolean showTime;
    private boolean checkType;
    private boolean checkPositions;
    private Report firstReport;
    private String[] catNames = new String[]{"", "Category 01: mandatory constant-pressure data", "Category 02: temperature/dewpoint at variable pressure-levels ", "Category 03: wind at variable pressure-levels ", "Category 04: wind at variable height-levels ", "Category 05: tropopause data", "", "Category 07: cloud cover", "Category 08: additional data", "", "", "Category 51: surface Data", "Category 52: ship surface Data"};
    private static float[] mandPressureLevel = new float[]{1000.0f, 850.0f, 700.0f, 500.0f, 400.0f, 300.0f, 250.0f, 200.0f, 150.0f, 100.0f, 70.0f, 50.0f, 30.0f, 20.0f, 10.0f, 7.0f, 5.0f, 3.0f, 2.0f, 1.0f};

    @Override
    public boolean isValidFile(RandomAccessFile raf) throws IOException {
        raf.seek(0L);
        if (raf.length() < 60L) {
            return false;
        }
        byte[] h2 = raf.readBytes(60);
        for (int i = 32; i < 56; ++i) {
            if (h2[i] == 88) continue;
            return false;
        }
        try {
            short hour = Short.parseShort(new String(h2, 0, 2, StandardCharsets.UTF_8));
            short minute = Short.parseShort(new String(h2, 2, 2, StandardCharsets.UTF_8));
            short year = Short.parseShort(new String(h2, 4, 2, StandardCharsets.UTF_8));
            short month = Short.parseShort(new String(h2, 6, 2, StandardCharsets.UTF_8));
            short day = Short.parseShort(new String(h2, 8, 2, StandardCharsets.UTF_8));
            if (hour < 0 || hour > 24) {
                return false;
            }
            if (minute < 0 || minute > 60) {
                return false;
            }
            if (year < 0 || year > 100) {
                return false;
            }
            if (month < 0 || month > 12) {
                return false;
            }
            if (day < 0 || day > 31) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public String getFileTypeId() {
        return "NMCon29";
    }

    @Override
    public String getFileTypeDescription() {
        return "NMC Office Note 29";
    }

    @Override
    public void open(RandomAccessFile raf, NetcdfFile ncfile, CancelTask cancelTask) throws IOException {
        super.open(raf, ncfile, cancelTask);
        this.init();
        ncfile.addAttribute(null, new Attribute("history", "Direct read of NMC ON29 by CDM"));
        ncfile.addAttribute(null, new Attribute("Conventions", "Unidata"));
        ncfile.addAttribute(null, new Attribute("featureType", CF.FeatureType.timeSeriesProfile.toString()));
        try {
            ncfile.addDimension(null, new Dimension("station", this.stations.size()));
            Structure station = this.makeStationStructure();
            ncfile.addVariable(null, station);
            ncfile.addDimension(null, new Dimension("report", this.reports.size()));
            Structure reportIndexVar = this.makeReportIndexStructure();
            ncfile.addVariable(null, reportIndexVar);
            Structure reportVar = this.makeReportStructure();
            ncfile.addVariable(null, reportVar);
        }
        catch (InvalidRangeException e) {
            logger.error("open ON29 File", e);
            throw new IllegalStateException(e.getMessage());
        }
    }

    @Override
    public Array readData(Variable v, Section section) throws IOException {
        switch (v.getShortName()) {
            case "station": {
                return this.readStation(v, section);
            }
            case "report": {
                return this.readReport(v, section);
            }
            case "reportIndex": {
                return this.readReportIndex(v, section);
            }
        }
        throw new IllegalArgumentException("Unknown variable name= " + v.getShortName());
    }

    private Structure makeStationStructure() throws InvalidRangeException {
        Structure station = new Structure(this.ncfile, null, null, "station");
        station.setDimensions("station");
        station.addAttribute(new Attribute("long_name", "unique stations within this file"));
        int pos = 0;
        Variable v = station.addMemberVariable(new Variable(this.ncfile, null, station, "stationName", DataType.CHAR, ""));
        v.setDimensionsAnonymous(new int[]{6});
        v.addAttribute(new Attribute("long_name", "name of station"));
        v.addAttribute(new Attribute("standard_name", "station_name"));
        v.setSPobject(new Vinfo(pos));
        pos += 6;
        v = station.addMemberVariable(new Variable(this.ncfile, null, station, "lat", DataType.FLOAT, ""));
        v.addAttribute(new Attribute("units", "degrees_north"));
        v.addAttribute(new Attribute("long_name", "geographic latitude"));
        v.addAttribute(new Attribute("accuracy", "degree/100"));
        v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lat.toString()));
        v.setSPobject(new Vinfo(pos));
        pos += 4;
        v = station.addMemberVariable(new Variable(this.ncfile, null, station, "lon", DataType.FLOAT, ""));
        v.addAttribute(new Attribute("units", "degrees_east"));
        v.addAttribute(new Attribute("long_name", "geographic longitude"));
        v.addAttribute(new Attribute("accuracy", "degree/100"));
        v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lon.toString()));
        v.setSPobject(new Vinfo(pos));
        pos += 4;
        v = station.addMemberVariable(new Variable(this.ncfile, null, station, "elev", DataType.FLOAT, ""));
        v.addAttribute(new Attribute("units", "meters"));
        v.addAttribute(new Attribute("long_name", "station elevation above MSL"));
        v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Height.toString()));
        v.setSPobject(new Vinfo(pos));
        pos += 4;
        v = station.addMemberVariable(new Variable(this.ncfile, null, station, "nrecords", DataType.INT, ""));
        v.addAttribute(new Attribute("long_name", "number of records"));
        v.addAttribute(new Attribute("standard_name", "npts"));
        v.setSPobject(new Vinfo(pos));
        return station;
    }

    private Structure makeReportIndexStructure() throws InvalidRangeException {
        Structure reportIndex = new Structure(this.ncfile, null, null, "reportIndex");
        reportIndex.setDimensions("report");
        reportIndex.addAttribute(new Attribute("long_name", "index on report - in memory"));
        int pos = 0;
        Variable v = reportIndex.addMemberVariable(new Variable(this.ncfile, null, reportIndex, "stationName", DataType.CHAR, ""));
        v.setDimensionsAnonymous(new int[]{6});
        v.addAttribute(new Attribute("long_name", "name of station"));
        v.addAttribute(new Attribute("standard_name", "station_name"));
        v.setSPobject(new Vinfo(pos));
        pos += 6;
        v = reportIndex.addMemberVariable(new Variable(this.ncfile, null, reportIndex, "time", DataType.INT, ""));
        v.addAttribute(new Attribute("units", "secs since 1970-01-01 00:00"));
        v.addAttribute(new Attribute("long_name", "observation time"));
        v.setSPobject(new Vinfo(pos));
        return reportIndex;
    }

    private Structure makeReportStructure() throws InvalidRangeException, IOException {
        Structure report = new Structure(this.ncfile, null, null, "report");
        report.setDimensions("report");
        report.addAttribute(new Attribute("long_name", "ON29 observation report"));
        int pos = 0;
        Variable v = report.addMemberVariable(new Variable(this.ncfile, null, report, "time", DataType.INT, ""));
        v.addAttribute(new Attribute("units", "secs since 1970-01-01 00:00"));
        v.addAttribute(new Attribute("long_name", "observation time"));
        v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Time.toString()));
        v.setSPobject(new Vinfo(pos));
        v = report.addMemberVariable(new Variable(this.ncfile, null, report, "timeISO", DataType.CHAR, ""));
        v.setDimensionsAnonymous(new int[]{20});
        v.addAttribute(new Attribute("long_name", "ISO formatted date/time"));
        v.setSPobject(new Vinfo(pos += 4));
        v = report.addMemberVariable(new Variable(this.ncfile, null, report, "reportType", DataType.SHORT, ""));
        v.addAttribute(new Attribute("long_name", "report type from Table R.1"));
        v.setSPobject(new Vinfo(pos += 20));
        v = report.addMemberVariable(new Variable(this.ncfile, null, report, "instType", DataType.SHORT, ""));
        v.addAttribute(new Attribute("long_name", "instrument type from Table R.2"));
        v.setSPobject(new Vinfo(pos += 2));
        v = report.addMemberVariable(new Variable(this.ncfile, null, report, "reserved", DataType.CHAR, ""));
        v.setDimensionsAnonymous(new int[]{7});
        v.addAttribute(new Attribute("long_name", "reserved characters"));
        v.setSPobject(new Vinfo(pos += 2));
        pos += 7;
        List<Record> records = this.firstReport.readData();
        pos = this.makeInnerSequence(report, records, 1, pos);
        pos = this.makeInnerSequence(report, records, 2, pos);
        pos = this.makeInnerSequence(report, records, 3, pos);
        pos = this.makeInnerSequence(report, records, 4, pos);
        pos = this.makeInnerSequence(report, records, 5, pos);
        pos = this.makeInnerSequence(report, records, 7, pos);
        pos = this.makeInnerSequence(report, records, 8, pos);
        pos = this.makeInnerSequence(report, records, 51, pos);
        this.makeInnerSequence(report, records, 52, pos);
        report.calcElementSize();
        return report;
    }

    private int makeInnerSequence(Structure reportVar, List<Record> records, int code, int obs_pos) throws InvalidRangeException {
        for (Record record : records) {
            if (record.code != code) continue;
            Entry first = record.entries[0];
            Structure s2 = first.makeStructure(reportVar);
            s2.setSPobject(new Vinfo(obs_pos));
            obs_pos += 4;
            reportVar.addMemberVariable(s2);
            this.catStructures.add(new StructureCode(s2, code));
            break;
        }
        return obs_pos;
    }

    private Array readStation(Variable v, Section section) {
        Structure s2 = (Structure)v;
        StructureMembers members = s2.makeStructureMembers();
        for (Variable v2 : s2.getVariables()) {
            Vinfo vinfo = (Vinfo)v2.getSPobject();
            StructureMembers.Member m3 = members.findMember(v2.getShortName());
            if (vinfo == null) continue;
            m3.setDataParam(vinfo.offset);
        }
        int size = (int)section.computeSize();
        ArrayStructureBB abb = new ArrayStructureBB(members, new int[]{size});
        ByteBuffer bb = abb.getByteBuffer();
        Range range = section.getRange(0);
        for (int idx : range) {
            Station station = this.stations.get(idx);
            bb.put(station.r.stationId.getBytes(StandardCharsets.UTF_8));
            bb.putFloat(station.r.lat);
            bb.putFloat(station.r.lon);
            bb.putFloat(station.r.elevMeters);
            bb.putInt(station.nreports);
        }
        return abb;
    }

    public Array readReportIndex(Variable v, Section section) {
        Structure s2 = (Structure)v;
        StructureMembers members = s2.makeStructureMembers();
        for (Variable v2 : s2.getVariables()) {
            Vinfo vinfo = (Vinfo)v2.getSPobject();
            StructureMembers.Member m3 = members.findMember(v2.getShortName());
            m3.setDataParam(vinfo.offset);
        }
        int size = (int)section.computeSize();
        ArrayStructureBB abb = new ArrayStructureBB(members, new int[]{size});
        ByteBuffer bb = abb.getByteBuffer();
        Range range = section.getRange(0);
        for (int idx : range) {
            Report report = this.reports.get(idx);
            report.loadIndexData(bb);
        }
        return abb;
    }

    public Array readReport(Variable v, Section section) throws IOException {
        Structure s2 = (Structure)v;
        StructureMembers members = s2.makeStructureMembers();
        for (Variable v2 : s2.getVariables()) {
            Vinfo vinfo = (Vinfo)v2.getSPobject();
            StructureMembers.Member m3 = members.findMember(v2.getShortName());
            m3.setDataParam(vinfo.offset);
        }
        int size = (int)section.computeSize();
        ArrayStructureBB abb = new ArrayStructureBB(members, new int[]{size});
        ByteBuffer bb = abb.getByteBuffer();
        Range range = section.getRange(0);
        for (int idx : range) {
            Report report = this.reports.get(idx);
            report.loadStructureData(abb, bb);
        }
        return abb;
    }

    private void init() throws IOException {
        Report report;
        int badPos = 0;
        int badType = 0;
        short firstType = -1;
        this.raf.seek(0L);
        this.readHeader(this.raf);
        HashMap<String, Station> map = new HashMap<String, Station>();
        while ((report = new Report()).readId(this.raf)) {
            Station stn;
            if (this.firstReport == null) {
                this.firstReport = report;
                firstType = this.firstReport.reportType;
            }
            if (this.checkType && report.reportType != firstType) {
                System.out.println(report.stationId + " type: " + report.reportType + " not " + firstType);
                ++badType;
            }
            if ((stn = (Station)map.get(report.stationId)) == null) {
                stn = new Station(report);
                map.put(report.stationId, stn);
                this.stations.add(stn);
            } else {
                ++stn.nreports;
                if (this.checkPositions) {
                    Report first = this.reports.get(0);
                    if (first.lat != report.lat) {
                        System.out.println(report.stationId + " lat: " + first.lat + " !=" + report.lat);
                        ++badPos;
                    }
                    if (first.lon != report.lon) {
                        System.out.println(report.stationId + " lon: " + first.lon + " !=" + report.lon);
                    }
                    if (first.elevMeters != report.elevMeters) {
                        System.out.println(report.stationId + " elev: " + first.elevMeters + " !=" + report.elevMeters);
                    }
                }
            }
            this.reports.add(report);
        }
        Collections.sort(this.stations);
        if (this.checkPositions) {
            System.out.println("\nnon matching lats= " + badPos);
        }
        if (this.checkType) {
            System.out.println("\nnon matching reportTypes= " + badType);
        }
    }

    private int readIntWithOverflow(byte[] b, int offset, int len) {
        String s2 = new String(b, offset, len, StandardCharsets.UTF_8);
        try {
            return Integer.parseInt(s2);
        }
        catch (Exception e) {
            if (this.showOverflow) {
                System.out.println("OVERFLOW=" + s2);
            }
            return 0;
        }
    }

    private boolean endRecord(RandomAccessFile raf) throws IOException {
        if (this.showSkip) {
            System.out.print(" endRecord start at " + raf.getFilePointer());
        }
        int skipped = 0;
        String endRecord = raf.readString(10);
        while (endRecord.equals("END RECORD")) {
            endRecord = raf.readString(10);
            ++skipped;
        }
        if (this.showSkip) {
            System.out.println(" last 10 chars= " + endRecord + " skipped= " + skipped);
        }
        return true;
    }

    private boolean endFile(RandomAccessFile raf) throws IOException {
        if (this.showSkip) {
            System.out.println(" endFile start at " + raf.getFilePointer());
        }
        String endRecord = raf.readString(10);
        while (endRecord.equals("ENDOF FILE")) {
            endRecord = raf.readString(10);
        }
        try {
            while (raf.read() != 88) {
            }
            while (raf.read() == 88) {
            }
            raf.skipBytes(-1);
            this.readHeader(raf);
            return true;
        }
        catch (EOFException e) {
            return false;
        }
    }

    private void readHeader(RandomAccessFile raf) throws IOException {
        int b;
        int fullyear;
        byte[] h2 = raf.readBytes(60);
        short hour = Short.parseShort(new String(h2, 0, 2, StandardCharsets.UTF_8));
        short minute = Short.parseShort(new String(h2, 2, 2, StandardCharsets.UTF_8));
        short year = Short.parseShort(new String(h2, 4, 2, StandardCharsets.UTF_8));
        short month = Short.parseShort(new String(h2, 6, 2, StandardCharsets.UTF_8));
        short day = Short.parseShort(new String(h2, 8, 2, StandardCharsets.UTF_8));
        int n = fullyear = year > 30 ? 1900 + year : 2000 + year;
        if (this.cal == null) {
            this.cal = Calendar.getInstance();
            this.cal.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
        this.cal.clear();
        this.cal.set(fullyear, month - 1, day, hour, minute);
        this.refDate = this.cal.getTime();
        if (this.showHeader) {
            System.out.println("\nhead=" + new String(h2, StandardCharsets.UTF_8) + " date= " + this.dateFormatter.toDateTimeString(this.refDate));
        }
        int count = 0;
        while ((b = raf.read()) == 88) {
            ++count;
        }
        char c = (char)b;
        if (this.showSkip) {
            System.out.println(" b=" + b + " c=" + c + " at " + raf.getFilePointer() + " skipped= " + count);
        }
        raf.skipBytes(-1);
    }

    private class Cat52
    extends Entry {
        short snowDepth;
        short wavePeriod;
        short waveHeight;
        short waveSwellPeriod;
        short waveSwellHeight;
        float precip6hours;
        float precip24hours;
        float sst;
        float waterEquiv;
        byte precipDuration;
        byte shipCourse;
        byte[] waveDirection;
        byte[] special;
        byte[] special2;
        byte[] shipSpeed;

        Cat52(byte[] b, int offset) {
            this.waveDirection = new byte[2];
            this.special = new byte[2];
            this.special2 = new byte[2];
            this.shipSpeed = new byte[2];
            this.precip6hours = 0.01f * Float.parseFloat(new String(b, offset, 4, StandardCharsets.UTF_8));
            this.snowDepth = Short.parseShort(new String(b, offset + 4, 3, StandardCharsets.UTF_8));
            this.precip24hours = 0.01f * Float.parseFloat(new String(b, offset + 7, 4, StandardCharsets.UTF_8));
            this.precipDuration = b[offset + 11];
            this.wavePeriod = Short.parseShort(new String(b, offset + 12, 2, StandardCharsets.UTF_8));
            this.waveHeight = Short.parseShort(new String(b, offset + 14, 2, StandardCharsets.UTF_8));
            System.arraycopy(b, offset + 16, this.waveDirection, 0, 2);
            this.waveSwellPeriod = Short.parseShort(new String(b, offset + 18, 2, StandardCharsets.UTF_8));
            this.waveSwellHeight = Short.parseShort(new String(b, offset + 20, 2, StandardCharsets.UTF_8));
            this.sst = 0.1f * Float.parseFloat(new String(b, offset + 22, 4, StandardCharsets.UTF_8));
            System.arraycopy(b, offset + 26, this.special, 0, 2);
            System.arraycopy(b, offset + 28, this.special2, 0, 2);
            this.shipCourse = b[offset + 30];
            System.arraycopy(b, offset + 31, this.shipSpeed, 0, 2);
            this.waterEquiv = 0.001f * Float.parseFloat(new String(b, offset + 33, 7, StandardCharsets.UTF_8));
        }

        @Override
        void loadStructureData(ByteBuffer bb) {
            bb.putFloat(this.precip6hours);
            bb.putShort(this.snowDepth);
            bb.putFloat(this.precip24hours);
            bb.put(this.precipDuration);
            bb.putShort(this.wavePeriod);
            bb.putShort(this.waveHeight);
            bb.put(this.waveDirection);
            bb.putShort(this.waveSwellPeriod);
            bb.putShort(this.waveSwellHeight);
            bb.putFloat(this.sst);
            bb.put(this.special);
            bb.put(this.special2);
            bb.put(this.shipCourse);
            bb.put(this.shipSpeed);
            bb.putFloat(this.waterEquiv);
        }

        public String toString() {
            return "Cat52: precip6hours= " + this.precip6hours + " precip24hours=" + this.precip24hours + " sst= " + this.sst + " waterEquiv=" + this.waterEquiv + " snowDepth=" + this.snowDepth + " wavePeriod=" + this.wavePeriod + " waveHeight=" + this.waveHeight + " waveSwellPeriod=" + this.waveSwellPeriod + " waveSwellHeight=" + this.waveSwellHeight;
        }

        @Override
        Structure makeStructure(Structure parent) throws InvalidRangeException {
            Sequence seq = new Sequence(NmcObsLegacy.this.ncfile, null, parent, "surfaceData2");
            seq.addAttribute(new Attribute("long_name", NmcObsLegacy.this.catNames[12]));
            int pos = 0;
            Variable v = seq.addMemberVariable(new Variable(NmcObsLegacy.this.ncfile, null, parent, "precip6hours", DataType.FLOAT, ""));
            v.addAttribute(new Attribute("units", "inch"));
            v.addAttribute(new Attribute("long_name", "precipitation past 6 hours"));
            v.addAttribute(new Attribute("accuracy", "inch/100"));
            v.addAttribute(new Attribute("missing_value", Float.valueOf(99.99f)));
            v.setSPobject(new Vinfo(pos));
            pos += 4;
            v = seq.addMemberVariable(new Variable(NmcObsLegacy.this.ncfile, null, parent, "snowDepth", DataType.SHORT, ""));
            v.addAttribute(new Attribute("units", "inch"));
            v.addAttribute(new Attribute("long_name", "total depth of snow on ground"));
            v.addAttribute(new Attribute("missing_value", (short)999));
            v.setSPobject(new Vinfo(pos));
            pos += 2;
            v = seq.addMemberVariable(new Variable(NmcObsLegacy.this.ncfile, null, parent, "precip24hours", DataType.FLOAT, ""));
            v.addAttribute(new Attribute("units", "inch"));
            v.addAttribute(new Attribute("long_name", "precipitation past 24 hours"));
            v.addAttribute(new Attribute("accuracy", "inch/100"));
            v.addAttribute(new Attribute("missing_value", Float.valueOf(99.99f)));
            v.setSPobject(new Vinfo(pos));
            pos += 4;
            v = seq.addMemberVariable(new Variable(NmcObsLegacy.this.ncfile, null, parent, "precipDuration", DataType.BYTE, ""));
            v.addAttribute(new Attribute("units", "6 hours"));
            v.addAttribute(new Attribute("long_name", "duration of precipitation observation"));
            v.addAttribute(new Attribute("missing_value", 9));
            v.setSPobject(new Vinfo(pos));
            pos += 4;
            v = seq.addMemberVariable(new Variable(NmcObsLegacy.this.ncfile, null, parent, "wavePeriod", DataType.SHORT, ""));
            v.addAttribute(new Attribute("units", "second"));
            v.addAttribute(new Attribute("long_name", "period of waves"));
            v.addAttribute(new Attribute("missing_value", (short)99));
            v.setSPobject(new Vinfo(pos));
            pos += 2;
            v = seq.addMemberVariable(new Variable(NmcObsLegacy.this.ncfile, null, parent, "waveHeight", DataType.SHORT, ""));
            v.addAttribute(new Attribute("units", "meter/2"));
            v.addAttribute(new Attribute("long_name", "height of waves"));
            v.addAttribute(new Attribute("missing_value", (short)99));
            v.setSPobject(new Vinfo(pos));
            v = seq.addMemberVariable(new Variable(NmcObsLegacy.this.ncfile, null, parent, "swellWaveDir", DataType.CHAR, ""));
            v.setDimensionsAnonymous(new int[]{2});
            v.addAttribute(new Attribute("long_name", "direction from which swell waves are moving: WMO table 0877"));
            v.setSPobject(new Vinfo(pos += 2));
            pos += 2;
            v = seq.addMemberVariable(new Variable(NmcObsLegacy.this.ncfile, null, parent, "swellWavePeriod", DataType.SHORT, ""));
            v.addAttribute(new Attribute("units", "second"));
            v.addAttribute(new Attribute("long_name", "period of swell waves"));
            v.addAttribute(new Attribute("missing_value", (short)99));
            v.setSPobject(new Vinfo(pos));
            pos += 2;
            v = seq.addMemberVariable(new Variable(NmcObsLegacy.this.ncfile, null, parent, "swellWaveHeight", DataType.SHORT, ""));
            v.addAttribute(new Attribute("units", "meter/2"));
            v.addAttribute(new Attribute("long_name", "height of waves"));
            v.addAttribute(new Attribute("missing_value", (short)99));
            v.setSPobject(new Vinfo(pos));
            pos += 2;
            v = seq.addMemberVariable(new Variable(NmcObsLegacy.this.ncfile, null, parent, "sst", DataType.FLOAT, ""));
            v.addAttribute(new Attribute("units", "celsius"));
            v.addAttribute(new Attribute("long_name", "sea surface temperature"));
            v.addAttribute(new Attribute("accuracy", "celsius/10"));
            v.addAttribute(new Attribute("missing_value", Float.valueOf(999.9f)));
            v.setSPobject(new Vinfo(pos));
            v = seq.addMemberVariable(new Variable(NmcObsLegacy.this.ncfile, null, parent, "special", DataType.CHAR, ""));
            v.addAttribute(new Attribute("long_name", "special phenomena - general"));
            v.setSPobject(new Vinfo(pos += 4));
            v = seq.addMemberVariable(new Variable(NmcObsLegacy.this.ncfile, null, parent, "specialDetail", DataType.CHAR, ""));
            v.addAttribute(new Attribute("long_name", "special phenomena - detailed"));
            v.setSPobject(new Vinfo(pos += 2));
            v = seq.addMemberVariable(new Variable(NmcObsLegacy.this.ncfile, null, parent, "shipCourse", DataType.CHAR, ""));
            v.addAttribute(new Attribute("long_name", "ships course: WMO table 0700"));
            v.setSPobject(new Vinfo(pos += 2));
            v = seq.addMemberVariable(new Variable(NmcObsLegacy.this.ncfile, null, parent, "shipSpeed", DataType.CHAR, ""));
            v.addAttribute(new Attribute("long_name", "ships average speed: WMO table 4451"));
            v.setSPobject(new Vinfo(++pos));
            ++pos;
            v = seq.addMemberVariable(new Variable(NmcObsLegacy.this.ncfile, null, parent, "waterEquiv", DataType.SHORT, ""));
            v.addAttribute(new Attribute("units", "inch"));
            v.addAttribute(new Attribute("long_name", "water equivalent of snow and/or ice"));
            v.addAttribute(new Attribute("accuracy", "inch/100"));
            v.addAttribute(new Attribute("missing_value", Float.valueOf(99999.99f)));
            v.setSPobject(new Vinfo(pos));
            return seq;
        }
    }

    private class Cat51
    extends Entry {
        short windDir;
        short windSpeed;
        float pressSeaLevel;
        float pressStation;
        float geopot;
        float press;
        float temp;
        float dewp;
        float maxTemp;
        float minTemp;
        float pressureTendency;
        byte[] quality;
        byte pastWeatherW2;
        byte pressureTendencyChar;
        byte[] horizVis;
        byte[] presentWeather;
        byte[] pastWeatherW1;
        byte[] fracCloudN;
        byte[] fracCloudNh;
        byte[] cloudCl;
        byte[] cloudBaseHeight;
        byte[] cloudCm;
        byte[] cloudCh;

        Cat51(byte[] b, int offset) {
            this.quality = new byte[4];
            this.horizVis = new byte[3];
            this.presentWeather = new byte[3];
            this.pastWeatherW1 = new byte[2];
            this.fracCloudN = new byte[2];
            this.fracCloudNh = new byte[2];
            this.cloudCl = new byte[2];
            this.cloudBaseHeight = new byte[2];
            this.cloudCm = new byte[2];
            this.cloudCh = new byte[2];
            this.pressSeaLevel = Float.parseFloat(new String(b, offset, 5, StandardCharsets.UTF_8));
            this.pressStation = Float.parseFloat(new String(b, offset + 5, 5, StandardCharsets.UTF_8));
            this.windDir = Short.parseShort(new String(b, offset + 10, 3, StandardCharsets.UTF_8));
            this.windSpeed = Short.parseShort(new String(b, offset + 13, 3, StandardCharsets.UTF_8));
            this.temp = 0.1f * Float.parseFloat(new String(b, offset + 16, 4, StandardCharsets.UTF_8));
            this.dewp = 0.1f * Float.parseFloat(new String(b, offset + 20, 3, StandardCharsets.UTF_8));
            this.maxTemp = 0.1f * Float.parseFloat(new String(b, offset + 23, 4, StandardCharsets.UTF_8));
            this.minTemp = 0.1f * Float.parseFloat(new String(b, offset + 27, 4, StandardCharsets.UTF_8));
            System.arraycopy(b, offset + 31, this.quality, 0, 4);
            this.pastWeatherW2 = b[offset + 35];
            System.arraycopy(b, offset + 36, this.horizVis, 0, 3);
            System.arraycopy(b, offset + 39, this.presentWeather, 0, 3);
            System.arraycopy(b, offset + 42, this.pastWeatherW1, 0, 2);
            System.arraycopy(b, offset + 44, this.fracCloudN, 0, 2);
            System.arraycopy(b, offset + 46, this.fracCloudNh, 0, 2);
            System.arraycopy(b, offset + 48, this.cloudCl, 0, 2);
            System.arraycopy(b, offset + 50, this.cloudBaseHeight, 0, 2);
            System.arraycopy(b, offset + 52, this.cloudCm, 0, 2);
            System.arraycopy(b, offset + 54, this.cloudCh, 0, 2);
            this.pressureTendencyChar = b[offset + 56];
            this.pressureTendency = 0.1f * Float.parseFloat(new String(b, offset + 57, 3, StandardCharsets.UTF_8));
        }

        public String toString() {
            return "Cat51: press= " + this.press + " geopot=" + this.geopot + " temp= " + this.temp + " dewp=" + this.dewp + " windDir=" + this.windDir + " windSpeed=" + this.windSpeed + " qs=" + new String(this.quality, StandardCharsets.UTF_8) + " pressureTendency=" + this.pressureTendency;
        }

        @Override
        Structure makeStructure(Structure parent) throws InvalidRangeException {
            Sequence seq = new Sequence(NmcObsLegacy.this.ncfile, null, parent, "surfaceData");
            seq.addAttribute(new Attribute("long_name", NmcObsLegacy.this.catNames[11]));
            int pos = 0;
            Variable v = seq.addMemberVariable(new Variable(NmcObsLegacy.this.ncfile, null, parent, "pressureSeaLevel", DataType.FLOAT, ""));
            v.addAttribute(new Attribute("units", "mbars"));
            v.addAttribute(new Attribute("long_name", "sea level pressure"));
            v.addAttribute(new Attribute("accuracy", "mbars/10"));
            v.addAttribute(new Attribute("missing_value", Float.valueOf(9999.9f)));
            v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Pressure.toString()));
            v.setSPobject(new Vinfo(pos));
            pos += 4;
            v = seq.addMemberVariable(new Variable(NmcObsLegacy.this.ncfile, null, parent, "pressure", DataType.FLOAT, ""));
            v.addAttribute(new Attribute("units", "mbars"));
            v.addAttribute(new Attribute("long_name", "station pressure"));
            v.addAttribute(new Attribute("accuracy", "mbars/10"));
            v.addAttribute(new Attribute("missing_value", Float.valueOf(9999.9f)));
            v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Pressure.toString()));
            v.setSPobject(new Vinfo(pos));
            pos += 4;
            v = seq.addMemberVariable(new Variable(NmcObsLegacy.this.ncfile, null, parent, "windDir", DataType.SHORT, ""));
            v.addAttribute(new Attribute("units", "degrees"));
            v.addAttribute(new Attribute("long_name", "wind direction"));
            v.addAttribute(new Attribute("missing_value", (short)999));
            v.setSPobject(new Vinfo(pos));
            pos += 2;
            v = seq.addMemberVariable(new Variable(NmcObsLegacy.this.ncfile, null, parent, "windSpeed", DataType.SHORT, ""));
            v.addAttribute(new Attribute("units", "knots"));
            v.addAttribute(new Attribute("long_name", "wind speed"));
            v.addAttribute(new Attribute("missing_value", (short)999));
            v.setSPobject(new Vinfo(pos));
            pos += 2;
            v = seq.addMemberVariable(new Variable(NmcObsLegacy.this.ncfile, null, parent, "temperature", DataType.FLOAT, ""));
            v.addAttribute(new Attribute("units", "celsius"));
            v.addAttribute(new Attribute("long_name", "air temperature"));
            v.addAttribute(new Attribute("accuracy", "celsius/10"));
            v.addAttribute(new Attribute("missing_value", Float.valueOf(999.9f)));
            v.setSPobject(new Vinfo(pos));
            pos += 4;
            v = seq.addMemberVariable(new Variable(NmcObsLegacy.this.ncfile, null, parent, "dewpoint", DataType.FLOAT, ""));
            v.addAttribute(new Attribute("units", "celsius"));
            v.addAttribute(new Attribute("long_name", "dewpoint depression"));
            v.addAttribute(new Attribute("accuracy", "celsius/10"));
            v.addAttribute(new Attribute("missing_value", Float.valueOf(99.9f)));
            v.setSPobject(new Vinfo(pos));
            pos += 4;
            v = seq.addMemberVariable(new Variable(NmcObsLegacy.this.ncfile, null, parent, "temperatureMax", DataType.FLOAT, ""));
            v.addAttribute(new Attribute("units", "celsius"));
            v.addAttribute(new Attribute("long_name", "maximum temperature"));
            v.addAttribute(new Attribute("accuracy", "celsius/10"));
            v.addAttribute(new Attribute("missing_value", Float.valueOf(999.9f)));
            v.setSPobject(new Vinfo(pos));
            pos += 4;
            v = seq.addMemberVariable(new Variable(NmcObsLegacy.this.ncfile, null, parent, "temperatureMin", DataType.FLOAT, ""));
            v.addAttribute(new Attribute("units", "celsius"));
            v.addAttribute(new Attribute("long_name", "minimum temperature"));
            v.addAttribute(new Attribute("accuracy", "celsius/10"));
            v.addAttribute(new Attribute("missing_value", Float.valueOf(999.9f)));
            v.setSPobject(new Vinfo(pos));
            v = seq.addMemberVariable(new Variable(NmcObsLegacy.this.ncfile, null, parent, "qualityFlags", DataType.CHAR, ""));
            v.setDimensionsAnonymous(new int[]{4});
            v.addAttribute(new Attribute("long_name", "quality marks: 0=pressureSeaLevel, 1=pressure, 2=wind, 3=temperature"));
            v.setSPobject(new Vinfo(pos += 4));
            v = seq.addMemberVariable(new Variable(NmcObsLegacy.this.ncfile, null, parent, "pastWeatherW2", DataType.CHAR, ""));
            v.addAttribute(new Attribute("long_name", "past weather (W2): WMO table 4561"));
            v.setSPobject(new Vinfo(pos += 4));
            v = seq.addMemberVariable(new Variable(NmcObsLegacy.this.ncfile, null, parent, "horizViz", DataType.CHAR, ""));
            v.setDimensionsAnonymous(new int[]{3});
            v.addAttribute(new Attribute("long_name", "horizontal visibility: WMO table 4300"));
            v.setSPobject(new Vinfo(++pos));
            v = seq.addMemberVariable(new Variable(NmcObsLegacy.this.ncfile, null, parent, "presentWeatherWW", DataType.CHAR, ""));
            v.setDimensionsAnonymous(new int[]{3});
            v.addAttribute(new Attribute("long_name", "present weather (WW): WMO table 4677"));
            v.setSPobject(new Vinfo(pos += 3));
            v = seq.addMemberVariable(new Variable(NmcObsLegacy.this.ncfile, null, parent, "pastWeatherW1", DataType.CHAR, ""));
            v.setDimensionsAnonymous(new int[]{2});
            v.addAttribute(new Attribute("long_name", "past weather (WW): WMO table 4561"));
            v.setSPobject(new Vinfo(pos += 3));
            v = seq.addMemberVariable(new Variable(NmcObsLegacy.this.ncfile, null, parent, "cloudFractionN", DataType.CHAR, ""));
            v.setDimensionsAnonymous(new int[]{2});
            v.addAttribute(new Attribute("long_name", "cloud fraction (N): WMO table 2700"));
            v.setSPobject(new Vinfo(pos += 2));
            v = seq.addMemberVariable(new Variable(NmcObsLegacy.this.ncfile, null, parent, "cloudFractionNh", DataType.CHAR, ""));
            v.setDimensionsAnonymous(new int[]{2});
            v.addAttribute(new Attribute("long_name", "cloud fraction (Nh): WMO table 2700"));
            v.setSPobject(new Vinfo(pos += 2));
            v = seq.addMemberVariable(new Variable(NmcObsLegacy.this.ncfile, null, parent, "cloudFractionCL", DataType.CHAR, ""));
            v.setDimensionsAnonymous(new int[]{2});
            v.addAttribute(new Attribute("long_name", "cloud fraction (CL): WMO table 0513"));
            v.setSPobject(new Vinfo(pos += 2));
            v = seq.addMemberVariable(new Variable(NmcObsLegacy.this.ncfile, null, parent, "cloudHeightCL", DataType.CHAR, ""));
            v.setDimensionsAnonymous(new int[]{2});
            v.addAttribute(new Attribute("long_name", "cloud base height above ground (h): WMO table 1600"));
            v.setSPobject(new Vinfo(pos += 2));
            v = seq.addMemberVariable(new Variable(NmcObsLegacy.this.ncfile, null, parent, "cloudFractionCM", DataType.CHAR, ""));
            v.setDimensionsAnonymous(new int[]{2});
            v.addAttribute(new Attribute("long_name", "cloud fraction (CM): WMO table 0515"));
            v.setSPobject(new Vinfo(pos += 2));
            v = seq.addMemberVariable(new Variable(NmcObsLegacy.this.ncfile, null, parent, "cloudFractionCH", DataType.CHAR, ""));
            v.setDimensionsAnonymous(new int[]{2});
            v.addAttribute(new Attribute("long_name", "cloud fraction (CH): WMO table 0509"));
            v.setSPobject(new Vinfo(pos += 2));
            v = seq.addMemberVariable(new Variable(NmcObsLegacy.this.ncfile, null, parent, "pressureTendencyCharacteristic", DataType.CHAR, ""));
            v.addAttribute(new Attribute("long_name", "pressure tendency characteristic for 3 hours previous to obs time: WMO table 0200"));
            v.setSPobject(new Vinfo(pos += 2));
            ++pos;
            v = seq.addMemberVariable(new Variable(NmcObsLegacy.this.ncfile, null, parent, "pressureTendency", DataType.FLOAT, ""));
            v.addAttribute(new Attribute("units", "mbars"));
            v.addAttribute(new Attribute("long_name", "pressure tendency magnitude"));
            v.addAttribute(new Attribute("accuracy", "mbars/10"));
            v.addAttribute(new Attribute("missing_value", Float.valueOf(99.9f)));
            v.setSPobject(new Vinfo(pos));
            return seq;
        }

        @Override
        void loadStructureData(ByteBuffer bb) {
            bb.putFloat(this.pressSeaLevel);
            bb.putFloat(this.pressStation);
            bb.putShort(this.windDir);
            bb.putShort(this.windSpeed);
            bb.putFloat(this.temp);
            bb.putFloat(this.dewp);
            bb.putFloat(this.maxTemp);
            bb.putFloat(this.minTemp);
            bb.put(this.quality);
            bb.put(this.pastWeatherW2);
            bb.put(this.horizVis);
            bb.put(this.presentWeather);
            bb.put(this.pastWeatherW1);
            bb.put(this.fracCloudN);
            bb.put(this.fracCloudNh);
            bb.put(this.cloudCl);
            bb.put(this.cloudBaseHeight);
            bb.put(this.cloudCm);
            bb.put(this.cloudCh);
            bb.put(this.pressureTendencyChar);
            bb.putFloat(this.pressureTendency);
        }
    }

    private class Cat08
    extends Entry {
        int data;
        short table101code;
        byte[] quality;
        String qs;

        Cat08(byte[] b, int offset) {
            this.data = Integer.parseInt(new String(b, offset, 5, StandardCharsets.UTF_8));
            this.table101code = Short.parseShort(new String(b, offset + 5, 3, StandardCharsets.UTF_8));
            this.quality = new byte[2];
            System.arraycopy(b, offset + 8, this.quality, 0, 2);
            this.qs = new String(this.quality, StandardCharsets.UTF_8);
        }

        public String toString() {
            return "Cat08: data=" + this.data + " table101code=" + this.table101code + " qs=" + this.qs;
        }

        @Override
        Structure makeStructure(Structure parent) throws InvalidRangeException {
            Sequence seq = new Sequence(NmcObsLegacy.this.ncfile, null, parent, "otherData");
            seq.addAttribute(new Attribute("long_name", NmcObsLegacy.this.catNames[8]));
            int pos = 0;
            Variable v = seq.addMemberVariable(new Variable(NmcObsLegacy.this.ncfile, null, parent, "data", DataType.INT, ""));
            v.addAttribute(new Attribute("long_name", "additional data specified in table 101.1"));
            v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Pressure.toString()));
            v.setSPobject(new Vinfo(pos));
            pos += 4;
            v = seq.addMemberVariable(new Variable(NmcObsLegacy.this.ncfile, null, parent, "table101code", DataType.SHORT, ""));
            v.addAttribute(new Attribute("long_name", "code figure from table 101"));
            v.addAttribute(new Attribute("missing_value", (short)999));
            v.setSPobject(new Vinfo(pos));
            v = seq.addMemberVariable(new Variable(NmcObsLegacy.this.ncfile, null, parent, "indicatorFlags", DataType.CHAR, ""));
            v.setDimensionsAnonymous(new int[]{2});
            v.addAttribute(new Attribute("long_name", "quality marks: 0=data, 1=form"));
            v.setSPobject(new Vinfo(pos += 2));
            return seq;
        }

        @Override
        void loadStructureData(ByteBuffer bb) {
            bb.putInt(this.data);
            bb.putShort(this.table101code);
            bb.put(this.quality);
        }
    }

    private class Cat07
    extends Entry {
        float press;
        short percentClouds;
        byte[] quality;
        String qs;

        Cat07(byte[] b, int offset) {
            this.press = 0.1f * Float.parseFloat(new String(b, offset, 5, StandardCharsets.UTF_8));
            this.percentClouds = Short.parseShort(new String(b, offset + 5, 3, StandardCharsets.UTF_8));
            this.quality = new byte[2];
            System.arraycopy(b, offset + 8, this.quality, 0, 2);
            this.qs = new String(this.quality, StandardCharsets.UTF_8);
        }

        public String toString() {
            return "Cat07: press=" + this.press + " percentClouds=" + this.percentClouds + " qs=" + this.qs;
        }

        @Override
        Structure makeStructure(Structure parent) throws InvalidRangeException {
            Sequence seq = new Sequence(NmcObsLegacy.this.ncfile, null, parent, "clouds");
            seq.addAttribute(new Attribute("long_name", NmcObsLegacy.this.catNames[7]));
            int pos = 0;
            Variable v = seq.addMemberVariable(new Variable(NmcObsLegacy.this.ncfile, null, parent, "pressure", DataType.FLOAT, ""));
            v.addAttribute(new Attribute("units", "mbars"));
            v.addAttribute(new Attribute("long_name", "pressure level"));
            v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Pressure.toString()));
            v.setSPobject(new Vinfo(pos));
            pos += 4;
            v = seq.addMemberVariable(new Variable(NmcObsLegacy.this.ncfile, null, parent, "percentClouds", DataType.SHORT, ""));
            v.addAttribute(new Attribute("units", ""));
            v.addAttribute(new Attribute("long_name", "amount of cloudiness (%)"));
            v.addAttribute(new Attribute("missing_value", (short)999));
            v.setSPobject(new Vinfo(pos));
            v = seq.addMemberVariable(new Variable(NmcObsLegacy.this.ncfile, null, parent, "qualityFlags", DataType.CHAR, ""));
            v.setDimensionsAnonymous(new int[]{2});
            v.addAttribute(new Attribute("long_name", "quality marks: 0=pressure, 1=percentClouds"));
            v.setSPobject(new Vinfo(pos += 2));
            return seq;
        }

        @Override
        void loadStructureData(ByteBuffer bb) {
            bb.putFloat(this.press);
            bb.putShort(this.percentClouds);
            bb.put(this.quality);
        }
    }

    private class Cat05
    extends Entry {
        float press;
        float temp;
        float dewp;
        short windDir;
        short windSpeed;
        byte[] quality;
        String qs;

        Cat05(byte[] b, int offset) {
            this.press = 0.1f * Float.parseFloat(new String(b, offset, 5, StandardCharsets.UTF_8));
            this.temp = 0.1f * Float.parseFloat(new String(b, offset + 5, 4, StandardCharsets.UTF_8));
            this.dewp = 0.1f * Float.parseFloat(new String(b, offset + 9, 3, StandardCharsets.UTF_8));
            this.windDir = Short.parseShort(new String(b, offset + 12, 3, StandardCharsets.UTF_8));
            this.windSpeed = Short.parseShort(new String(b, offset + 15, 3, StandardCharsets.UTF_8));
            this.quality = new byte[4];
            System.arraycopy(b, offset + 18, this.quality, 0, 4);
            this.qs = new String(this.quality, StandardCharsets.UTF_8);
        }

        public String toString() {
            return "Cat05: press= " + this.press + " temp= " + this.temp + " dewp=" + this.dewp + " windDir=" + this.windDir + " windSpeed=" + this.windSpeed + " qs=" + this.qs;
        }

        @Override
        Structure makeStructure(Structure parent) throws InvalidRangeException {
            Sequence seq = new Sequence(NmcObsLegacy.this.ncfile, null, parent, "tropopause");
            seq.addAttribute(new Attribute("long_name", NmcObsLegacy.this.catNames[5]));
            int pos = 0;
            Variable v = seq.addMemberVariable(new Variable(NmcObsLegacy.this.ncfile, null, parent, "pressure", DataType.FLOAT, ""));
            v.addAttribute(new Attribute("units", "mbars"));
            v.addAttribute(new Attribute("long_name", "pressure level"));
            v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Pressure.toString()));
            v.setSPobject(new Vinfo(pos));
            pos += 4;
            v = seq.addMemberVariable(new Variable(NmcObsLegacy.this.ncfile, null, parent, "temperature", DataType.FLOAT, ""));
            v.addAttribute(new Attribute("units", "celsius"));
            v.addAttribute(new Attribute("long_name", "temperature"));
            v.addAttribute(new Attribute("accuracy", "celsius/10"));
            v.addAttribute(new Attribute("missing_value", Float.valueOf(999.9f)));
            v.setSPobject(new Vinfo(pos));
            pos += 4;
            v = seq.addMemberVariable(new Variable(NmcObsLegacy.this.ncfile, null, parent, "dewpoint", DataType.FLOAT, ""));
            v.addAttribute(new Attribute("units", "celsius"));
            v.addAttribute(new Attribute("long_name", "dewpoint depression"));
            v.addAttribute(new Attribute("accuracy", "celsius/10"));
            v.addAttribute(new Attribute("missing_value", Float.valueOf(99.9f)));
            v.setSPobject(new Vinfo(pos));
            pos += 4;
            v = seq.addMemberVariable(new Variable(NmcObsLegacy.this.ncfile, null, parent, "windDir", DataType.SHORT, ""));
            v.addAttribute(new Attribute("units", "degrees"));
            v.addAttribute(new Attribute("long_name", "wind direction"));
            v.addAttribute(new Attribute("missing_value", (short)999));
            v.setSPobject(new Vinfo(pos));
            pos += 2;
            v = seq.addMemberVariable(new Variable(NmcObsLegacy.this.ncfile, null, parent, "windSpeed", DataType.SHORT, ""));
            v.addAttribute(new Attribute("units", "knots"));
            v.addAttribute(new Attribute("long_name", "wind speed"));
            v.addAttribute(new Attribute("missing_value", (short)999));
            v.setSPobject(new Vinfo(pos));
            v = seq.addMemberVariable(new Variable(NmcObsLegacy.this.ncfile, null, parent, "qualityFlags", DataType.CHAR, ""));
            v.setDimensionsAnonymous(new int[]{4});
            v.addAttribute(new Attribute("long_name", "quality marks: 0=pressure, 1=temp, 2=dewpoint, 3=wind"));
            v.setSPobject(new Vinfo(pos += 2));
            return seq;
        }

        @Override
        void loadStructureData(ByteBuffer bb) {
            bb.putFloat(this.press);
            bb.putFloat(this.temp);
            bb.putFloat(this.dewp);
            bb.putShort(this.windDir);
            bb.putShort(this.windSpeed);
            bb.put(this.quality);
        }
    }

    private class Cat04
    extends Entry {
        float geopot;
        short windDir;
        short windSpeed;
        byte[] quality;
        String qs;

        Cat04(byte[] b, int offset) {
            this.geopot = Float.parseFloat(new String(b, offset, 5, StandardCharsets.UTF_8));
            this.windDir = Short.parseShort(new String(b, offset + 5, 3, StandardCharsets.UTF_8));
            this.windSpeed = Short.parseShort(new String(b, offset + 8, 3, StandardCharsets.UTF_8));
            this.quality = new byte[2];
            System.arraycopy(b, offset + 11, this.quality, 0, 2);
            this.qs = new String(this.quality, StandardCharsets.UTF_8);
        }

        public String toString() {
            return "Cat04: geopot=" + this.geopot + " windDir=" + this.windDir + " windSpeed=" + this.windSpeed + " qs=" + this.qs;
        }

        @Override
        Structure makeStructure(Structure parent) throws InvalidRangeException {
            Sequence seq = new Sequence(NmcObsLegacy.this.ncfile, null, parent, "windHeightLevels");
            seq.addAttribute(new Attribute("long_name", NmcObsLegacy.this.catNames[4]));
            int pos = 0;
            Variable v = seq.addMemberVariable(new Variable(NmcObsLegacy.this.ncfile, null, parent, "geopotential", DataType.FLOAT, ""));
            v.addAttribute(new Attribute("units", "meter"));
            v.addAttribute(new Attribute("long_name", "geopotential"));
            v.addAttribute(new Attribute("missing_value", Float.valueOf(99999.0f)));
            v.setSPobject(new Vinfo(pos));
            pos += 4;
            v = seq.addMemberVariable(new Variable(NmcObsLegacy.this.ncfile, null, parent, "windDir", DataType.SHORT, ""));
            v.addAttribute(new Attribute("units", "degrees"));
            v.addAttribute(new Attribute("long_name", "wind direction"));
            v.addAttribute(new Attribute("missing_value", (short)999));
            v.setSPobject(new Vinfo(pos));
            pos += 2;
            v = seq.addMemberVariable(new Variable(NmcObsLegacy.this.ncfile, null, parent, "windSpeed", DataType.SHORT, ""));
            v.addAttribute(new Attribute("units", "knots"));
            v.addAttribute(new Attribute("long_name", "wind speed"));
            v.addAttribute(new Attribute("missing_value", (short)999));
            v.setSPobject(new Vinfo(pos));
            v = seq.addMemberVariable(new Variable(NmcObsLegacy.this.ncfile, null, parent, "qualityFlags", DataType.CHAR, ""));
            v.setDimensionsAnonymous(new int[]{2});
            v.addAttribute(new Attribute("long_name", "quality marks: 0=geopot, 1=wind"));
            v.setSPobject(new Vinfo(pos += 2));
            return seq;
        }

        @Override
        void loadStructureData(ByteBuffer bb) {
            bb.putFloat(this.geopot);
            bb.putShort(this.windDir);
            bb.putShort(this.windSpeed);
            bb.put(this.quality);
        }
    }

    private class Cat03
    extends Entry {
        float press;
        short windDir;
        short windSpeed;
        byte[] quality;
        String qs;

        Cat03(byte[] b, int offset) {
            this.press = 0.1f * Float.parseFloat(new String(b, offset, 5, StandardCharsets.UTF_8));
            this.windDir = Short.parseShort(new String(b, offset + 5, 3, StandardCharsets.UTF_8));
            this.windSpeed = Short.parseShort(new String(b, offset + 8, 3, StandardCharsets.UTF_8));
            this.quality = new byte[2];
            System.arraycopy(b, offset + 11, this.quality, 0, 2);
            this.qs = new String(this.quality, StandardCharsets.UTF_8);
        }

        public String toString() {
            return "Cat03: press=" + this.press + " windDir=" + this.windDir + " windSpeed=" + this.windSpeed + " qs=" + this.qs;
        }

        @Override
        Structure makeStructure(Structure parent) throws InvalidRangeException {
            Sequence seq = new Sequence(NmcObsLegacy.this.ncfile, null, parent, "windPressureLevels");
            seq.addAttribute(new Attribute("long_name", NmcObsLegacy.this.catNames[3]));
            int pos = 0;
            Variable v = seq.addMemberVariable(new Variable(NmcObsLegacy.this.ncfile, null, parent, "pressure", DataType.FLOAT, ""));
            v.addAttribute(new Attribute("units", "mbars"));
            v.addAttribute(new Attribute("long_name", "pressure level"));
            v.addAttribute(new Attribute("accuracy", "mbar/10"));
            v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Pressure.toString()));
            v.setSPobject(new Vinfo(pos));
            pos += 4;
            v = seq.addMemberVariable(new Variable(NmcObsLegacy.this.ncfile, null, parent, "windDir", DataType.SHORT, ""));
            v.addAttribute(new Attribute("units", "degrees"));
            v.addAttribute(new Attribute("long_name", "wind direction"));
            v.addAttribute(new Attribute("missing_value", (short)999));
            v.setSPobject(new Vinfo(pos));
            pos += 2;
            v = seq.addMemberVariable(new Variable(NmcObsLegacy.this.ncfile, null, parent, "windSpeed", DataType.SHORT, ""));
            v.addAttribute(new Attribute("units", "knots"));
            v.addAttribute(new Attribute("long_name", "wind speed"));
            v.addAttribute(new Attribute("missing_value", (short)999));
            v.setSPobject(new Vinfo(pos));
            v = seq.addMemberVariable(new Variable(NmcObsLegacy.this.ncfile, null, parent, "qualityFlags", DataType.CHAR, ""));
            v.setDimensionsAnonymous(new int[]{2});
            v.addAttribute(new Attribute("long_name", "quality marks: 0=pressure, 1=wind"));
            v.setSPobject(new Vinfo(pos += 2));
            return seq;
        }

        @Override
        void loadStructureData(ByteBuffer bb) {
            bb.putFloat(this.press);
            bb.putShort(this.windDir);
            bb.putShort(this.windSpeed);
            bb.put(this.quality);
        }
    }

    private class Cat02
    extends Entry {
        float press;
        float temp;
        float dewp;
        byte[] quality;
        String qs;

        Cat02(byte[] b, int offset) {
            this.quality = new byte[3];
            this.press = 0.1f * Float.parseFloat(new String(b, offset, 5, StandardCharsets.UTF_8));
            this.temp = 0.1f * Float.parseFloat(new String(b, offset + 5, 4, StandardCharsets.UTF_8));
            this.dewp = 0.1f * Float.parseFloat(new String(b, offset + 9, 3, StandardCharsets.UTF_8));
            System.arraycopy(b, offset + 12, this.quality, 0, 3);
            this.qs = new String(this.quality, StandardCharsets.UTF_8);
        }

        public String toString() {
            return "Cat02: press=" + this.press + " temp= " + this.temp + " dewp=" + this.dewp + " qs=" + this.qs;
        }

        @Override
        Structure makeStructure(Structure parent) throws InvalidRangeException {
            Sequence seq = new Sequence(NmcObsLegacy.this.ncfile, null, parent, "tempPressureLevels");
            seq.addAttribute(new Attribute("long_name", NmcObsLegacy.this.catNames[2]));
            int pos = 0;
            Variable v = seq.addMemberVariable(new Variable(NmcObsLegacy.this.ncfile, null, parent, "pressure", DataType.FLOAT, ""));
            v.addAttribute(new Attribute("units", "mbars"));
            v.addAttribute(new Attribute("long_name", "pressure level"));
            v.addAttribute(new Attribute("accuracy", "mbar/10"));
            v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Pressure.toString()));
            v.setSPobject(new Vinfo(pos));
            pos += 4;
            v = seq.addMemberVariable(new Variable(NmcObsLegacy.this.ncfile, null, parent, "temperature", DataType.FLOAT, ""));
            v.addAttribute(new Attribute("units", "celsius"));
            v.addAttribute(new Attribute("long_name", "temperature"));
            v.addAttribute(new Attribute("accuracy", "celsius/10"));
            v.addAttribute(new Attribute("missing_value", Float.valueOf(999.9f)));
            v.setSPobject(new Vinfo(pos));
            pos += 4;
            v = seq.addMemberVariable(new Variable(NmcObsLegacy.this.ncfile, null, parent, "dewpoint", DataType.FLOAT, ""));
            v.addAttribute(new Attribute("units", "celsius"));
            v.addAttribute(new Attribute("long_name", "dewpoint depression"));
            v.addAttribute(new Attribute("accuracy", "celsius/10"));
            v.addAttribute(new Attribute("missing_value", Float.valueOf(99.9f)));
            v.setSPobject(new Vinfo(pos));
            v = seq.addMemberVariable(new Variable(NmcObsLegacy.this.ncfile, null, parent, "qualityFlags", DataType.CHAR, ""));
            v.setDimensionsAnonymous(new int[]{3});
            v.addAttribute(new Attribute("long_name", "quality marks: 0=pressure, 1=temp, 2=dewpoint"));
            v.setSPobject(new Vinfo(pos += 4));
            return seq;
        }

        @Override
        void loadStructureData(ByteBuffer bb) {
            bb.putFloat(this.press);
            bb.putFloat(this.temp);
            bb.putFloat(this.dewp);
            bb.put(this.quality);
        }
    }

    private class Cat01
    extends Entry {
        short windDir;
        short windSpeed;
        float geopot;
        float press;
        float temp;
        float dewp;
        byte[] quality;

        Cat01(byte[] b, int offset, int level) {
            this.quality = new byte[4];
            this.press = mandPressureLevel[level];
            this.geopot = Float.parseFloat(new String(b, offset, 5, StandardCharsets.UTF_8));
            this.temp = 0.1f * Float.parseFloat(new String(b, offset + 5, 4, StandardCharsets.UTF_8));
            this.dewp = 0.1f * Float.parseFloat(new String(b, offset + 9, 3, StandardCharsets.UTF_8));
            this.windDir = Short.parseShort(new String(b, offset + 12, 3, StandardCharsets.UTF_8));
            this.windSpeed = Short.parseShort(new String(b, offset + 15, 3, StandardCharsets.UTF_8));
            System.arraycopy(b, offset + 18, this.quality, 0, 4);
        }

        public String toString() {
            return "Cat01: press= " + this.press + " geopot=" + this.geopot + " temp= " + this.temp + " dewp=" + this.dewp + " windDir=" + this.windDir + " windSpeed=" + this.windSpeed + " qs=" + new String(this.quality, StandardCharsets.UTF_8);
        }

        @Override
        Structure makeStructure(Structure parent) throws InvalidRangeException {
            Sequence seq = new Sequence(NmcObsLegacy.this.ncfile, null, parent, "mandatoryLevels");
            seq.addAttribute(new Attribute("long_name", NmcObsLegacy.this.catNames[1]));
            int pos = 0;
            Variable v = seq.addMemberVariable(new Variable(NmcObsLegacy.this.ncfile, null, parent, "pressure", DataType.FLOAT, ""));
            v.addAttribute(new Attribute("units", "mbars"));
            v.addAttribute(new Attribute("long_name", "pressure level"));
            v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Pressure.toString()));
            v.setSPobject(new Vinfo(pos));
            pos += 4;
            v = seq.addMemberVariable(new Variable(NmcObsLegacy.this.ncfile, null, parent, "geopotential", DataType.FLOAT, ""));
            v.addAttribute(new Attribute("units", "meter"));
            v.addAttribute(new Attribute("long_name", "geopotential"));
            v.addAttribute(new Attribute("missing_value", Float.valueOf(99999.0f)));
            v.setSPobject(new Vinfo(pos));
            pos += 4;
            v = seq.addMemberVariable(new Variable(NmcObsLegacy.this.ncfile, null, parent, "temperature", DataType.FLOAT, ""));
            v.addAttribute(new Attribute("units", "celsius"));
            v.addAttribute(new Attribute("long_name", "temperature"));
            v.addAttribute(new Attribute("accuracy", "celsius/10"));
            v.addAttribute(new Attribute("missing_value", Float.valueOf(999.9f)));
            v.setSPobject(new Vinfo(pos));
            pos += 4;
            v = seq.addMemberVariable(new Variable(NmcObsLegacy.this.ncfile, null, parent, "dewpoint", DataType.FLOAT, ""));
            v.addAttribute(new Attribute("units", "celsius"));
            v.addAttribute(new Attribute("long_name", "dewpoint depression"));
            v.addAttribute(new Attribute("accuracy", "celsius/10"));
            v.addAttribute(new Attribute("missing_value", Float.valueOf(99.9f)));
            v.setSPobject(new Vinfo(pos));
            pos += 4;
            v = seq.addMemberVariable(new Variable(NmcObsLegacy.this.ncfile, null, parent, "windDir", DataType.SHORT, ""));
            v.addAttribute(new Attribute("units", "degrees"));
            v.addAttribute(new Attribute("long_name", "wind direction"));
            v.addAttribute(new Attribute("missing_value", (short)999));
            v.setSPobject(new Vinfo(pos));
            pos += 2;
            v = seq.addMemberVariable(new Variable(NmcObsLegacy.this.ncfile, null, parent, "windSpeed", DataType.SHORT, ""));
            v.addAttribute(new Attribute("units", "knots"));
            v.addAttribute(new Attribute("long_name", "wind speed"));
            v.addAttribute(new Attribute("missing_value", (short)999));
            v.setSPobject(new Vinfo(pos));
            v = seq.addMemberVariable(new Variable(NmcObsLegacy.this.ncfile, null, parent, "qualityFlags", DataType.CHAR, ""));
            v.setDimensionsAnonymous(new int[]{4});
            v.addAttribute(new Attribute("long_name", "quality marks: 0=geopot, 1=temp, 2=dewpoint, 3=wind"));
            v.setSPobject(new Vinfo(pos += 2));
            return seq;
        }

        @Override
        void loadStructureData(ByteBuffer bb) {
            bb.putFloat(this.press);
            bb.putFloat(this.geopot);
            bb.putFloat(this.temp);
            bb.putFloat(this.dewp);
            bb.putShort(this.windDir);
            bb.putShort(this.windSpeed);
            bb.put(this.quality);
        }
    }

    private static abstract class Entry {
        private Entry() {
        }

        abstract Structure makeStructure(Structure var1) throws InvalidRangeException;

        abstract void loadStructureData(ByteBuffer var1);
    }

    private class Record {
        int code;
        int next;
        int nlevels;
        int nbytes;
        Entry[] entries;

        private Record() {
        }

        int read(byte[] b, int offset) {
            int skip;
            int i;
            this.code = Integer.parseInt(new String(b, offset, 2, StandardCharsets.UTF_8));
            this.next = Integer.parseInt(new String(b, offset + 2, 3, StandardCharsets.UTF_8));
            this.nlevels = Integer.parseInt(new String(b, offset + 5, 2, StandardCharsets.UTF_8));
            this.nbytes = NmcObsLegacy.this.readIntWithOverflow(b, offset + 7, 3);
            if (NmcObsLegacy.this.showData) {
                System.out.println("\n" + this);
            }
            offset += 10;
            if (this.code == 1) {
                if (NmcObsLegacy.this.showData) {
                    System.out.println(NmcObsLegacy.this.catNames[1] + ":");
                }
                this.entries = new Cat01[this.nlevels];
                for (i = 0; i < this.nlevels; ++i) {
                    this.entries[i] = new Cat01(b, offset, i);
                    if (NmcObsLegacy.this.showData) {
                        System.out.println(" " + i + ": " + this.entries[i]);
                    }
                    offset += 22;
                }
            } else if (this.code == 2) {
                if (NmcObsLegacy.this.showData) {
                    System.out.println(NmcObsLegacy.this.catNames[2] + ":");
                }
                this.entries = new Cat02[this.nlevels];
                for (i = 0; i < this.nlevels; ++i) {
                    this.entries[i] = new Cat02(b, offset);
                    if (NmcObsLegacy.this.showData) {
                        System.out.println(" " + i + ": " + this.entries[i]);
                    }
                    offset += 15;
                }
            } else if (this.code == 3) {
                if (NmcObsLegacy.this.showData) {
                    System.out.println(NmcObsLegacy.this.catNames[3] + ":");
                }
                this.entries = new Cat03[this.nlevels];
                for (i = 0; i < this.nlevels; ++i) {
                    this.entries[i] = new Cat03(b, offset);
                    if (NmcObsLegacy.this.showData) {
                        System.out.println(" " + i + ": " + this.entries[i]);
                    }
                    offset += 13;
                }
            } else if (this.code == 4) {
                if (NmcObsLegacy.this.showData) {
                    System.out.println(NmcObsLegacy.this.catNames[4] + ":");
                }
                this.entries = new Cat04[this.nlevels];
                for (i = 0; i < this.nlevels; ++i) {
                    this.entries[i] = new Cat04(b, offset);
                    if (NmcObsLegacy.this.showData) {
                        System.out.println(" " + i + ": " + this.entries[i]);
                    }
                    offset += 13;
                }
            } else if (this.code == 5) {
                if (NmcObsLegacy.this.showData) {
                    System.out.println(NmcObsLegacy.this.catNames[5] + ":");
                }
                this.entries = new Cat05[this.nlevels];
                for (i = 0; i < this.nlevels; ++i) {
                    this.entries[i] = new Cat05(b, offset);
                    if (NmcObsLegacy.this.showData) {
                        System.out.println(" " + i + ": " + this.entries[i]);
                    }
                    offset += 22;
                }
            } else if (this.code == 7) {
                if (NmcObsLegacy.this.showData) {
                    System.out.println(NmcObsLegacy.this.catNames[7] + ":");
                }
                this.entries = new Cat07[this.nlevels];
                for (i = 0; i < this.nlevels; ++i) {
                    this.entries[i] = new Cat07(b, offset);
                    if (NmcObsLegacy.this.showData) {
                        System.out.println(" " + i + ": " + this.entries[i]);
                    }
                    offset += 10;
                }
            } else if (this.code == 8) {
                if (NmcObsLegacy.this.showData) {
                    System.out.println(NmcObsLegacy.this.catNames[8] + ":");
                }
                this.entries = new Cat08[this.nlevels];
                for (i = 0; i < this.nlevels; ++i) {
                    this.entries[i] = new Cat08(b, offset);
                    if (NmcObsLegacy.this.showData) {
                        System.out.println(" " + i + ": " + this.entries[i]);
                    }
                    offset += 10;
                }
            } else if (this.code == 51) {
                if (NmcObsLegacy.this.showData) {
                    System.out.println(NmcObsLegacy.this.catNames[10] + ":");
                }
                this.entries = new Cat51[this.nlevels];
                for (i = 0; i < this.nlevels; ++i) {
                    this.entries[i] = new Cat51(b, offset);
                    if (NmcObsLegacy.this.showData) {
                        System.out.println(" " + i + ": " + this.entries[i]);
                    }
                    offset += 60;
                }
            } else if (this.code == 52) {
                if (NmcObsLegacy.this.showData) {
                    System.out.println(NmcObsLegacy.this.catNames[10] + ":");
                }
                this.entries = new Cat52[this.nlevels];
                for (i = 0; i < this.nlevels; ++i) {
                    this.entries[i] = new Cat52(b, offset);
                    if (NmcObsLegacy.this.showData) {
                        System.out.println(" " + i + ": " + this.entries[i]);
                    }
                    offset += 40;
                }
            } else {
                throw new UnsupportedOperationException("code= " + this.code);
            }
            if ((skip = offset % 10) > 0) {
                offset += 10 - skip;
            }
            return offset;
        }

        public String toString() {
            return "Category/Group  code=" + this.code + " next= " + this.next + " nlevels=" + this.nlevels + " nbytes=" + this.nbytes;
        }
    }

    private class Report {
        float lat;
        float lon;
        float elevMeters;
        String stationId;
        byte[] reserved = new byte[7];
        short reportType;
        short instType;
        short obsTime;
        int reportLen;
        long filePos;
        Date date;

        private Report() {
        }

        boolean readId(RandomAccessFile raf) throws IOException {
            this.filePos = raf.getFilePointer();
            byte[] reportId = raf.readBytes(40);
            String latS = new String(reportId, 0, 5, StandardCharsets.UTF_8);
            if (latS.equals("END R")) {
                raf.skipBytes(-40);
                NmcObsLegacy.this.endRecord(raf);
                this.filePos = raf.getFilePointer();
                reportId = raf.readBytes(40);
                latS = new String(reportId, 0, 5, StandardCharsets.UTF_8);
            }
            if (latS.equals("ENDOF")) {
                raf.skipBytes(-40);
                if (!NmcObsLegacy.this.endFile(raf)) {
                    return false;
                }
                this.filePos = raf.getFilePointer();
                reportId = raf.readBytes(40);
                latS = new String(reportId, 0, 5, StandardCharsets.UTF_8);
            }
            try {
                this.lat = (float)(0.01 * (double)Float.parseFloat(latS));
                this.lon = (float)(360.0 - 0.01 * (double)Float.parseFloat(new String(reportId, 5, 5, StandardCharsets.UTF_8)));
                this.stationId = new String(reportId, 10, 6, StandardCharsets.UTF_8);
                this.obsTime = Short.parseShort(new String(reportId, 16, 4, StandardCharsets.UTF_8));
                System.arraycopy(reportId, 20, this.reserved, 0, 7);
                this.reportType = Short.parseShort(new String(reportId, 27, 3, StandardCharsets.UTF_8));
                this.elevMeters = Float.parseFloat(new String(reportId, 30, 5, StandardCharsets.UTF_8));
                this.instType = Short.parseShort(new String(reportId, 35, 2, StandardCharsets.UTF_8));
                this.reportLen = 10 * Integer.parseInt(new String(reportId, 37, 3, StandardCharsets.UTF_8));
                NmcObsLegacy.this.cal.setTime(NmcObsLegacy.this.refDate);
                int hour = NmcObsLegacy.this.cal.get(11);
                if (this.obsTime / 100 > hour + 4) {
                    NmcObsLegacy.this.cal.add(5, -1);
                }
                NmcObsLegacy.this.cal.set(11, this.obsTime / 100);
                NmcObsLegacy.this.cal.set(12, 6 * (this.obsTime % 100));
                this.date = NmcObsLegacy.this.cal.getTime();
                if (NmcObsLegacy.this.showObs) {
                    System.out.println(this);
                } else if (NmcObsLegacy.this.showTime) {
                    System.out.print("  time=" + this.obsTime + " date= " + NmcObsLegacy.this.dateFormatter.toDateTimeString(this.date));
                }
                raf.skipBytes(this.reportLen - 40);
                return this.reportLen < 30000;
            }
            catch (IOException e) {
                throw new IOException("BAD reportId=" + new String(reportId, StandardCharsets.UTF_8) + " starts at " + this.filePos);
            }
        }

        public String toString() {
            return "Report  stationId=" + this.stationId + " lat=" + this.lat + " lon=" + this.lon + " obsTime=" + this.obsTime + " date= " + NmcObsLegacy.this.dateFormatter.toDateTimeStringISO(this.date) + " reportType=" + this.reportType + " elevMeters=" + this.elevMeters + " instType=" + this.instType + " reserved=" + new String(this.reserved, StandardCharsets.UTF_8) + " start=" + this.filePos + " reportLen=" + this.reportLen;
        }

        List<Record> readData() throws IOException {
            Record record;
            ArrayList<Record> records = new ArrayList<Record>();
            NmcObsLegacy.this.raf.seek(this.filePos + 40L);
            byte[] b = NmcObsLegacy.this.raf.readBytes(this.reportLen - 40);
            if (NmcObsLegacy.this.showData) {
                System.out.println("\n" + new String(b, StandardCharsets.UTF_8));
            }
            if (NmcObsLegacy.this.showData) {
                System.out.println(this);
            }
            int offset = 0;
            do {
                record = new Record();
                offset = record.read(b, offset);
                records.add(record);
            } while (record.next < this.reportLen / 10);
            return records;
        }

        void show(RandomAccessFile raf) throws IOException {
            raf.seek(this.filePos);
            byte[] b = raf.readBytes(40);
            System.out.println(new String(b, StandardCharsets.UTF_8));
        }

        void loadIndexData(ByteBuffer bb) {
            bb.put(this.stationId.getBytes(StandardCharsets.UTF_8));
            bb.putInt((int)(this.date.getTime() / 1000L));
        }

        void loadStructureData(ArrayStructureBB abb, ByteBuffer bb) throws IOException {
            bb.putInt((int)(this.date.getTime() / 1000L));
            bb.put(NmcObsLegacy.this.dateFormatter.toDateTimeStringISO(this.date).getBytes(StandardCharsets.UTF_8));
            bb.putShort(this.reportType);
            bb.putShort(this.instType);
            bb.put(this.reserved);
            List<Record> records = this.readData();
            for (StructureCode sc : NmcObsLegacy.this.catStructures) {
                this.loadInnerSequence(abb, bb, records, sc.s, sc.code);
            }
        }

        private void loadInnerSequence(ArrayStructureBB abb, ByteBuffer bb, List<Record> records, Structure useStructure, int code) {
            for (Record record : records) {
                if (record.code != code) continue;
                CatIterator iter = new CatIterator(record.entries, useStructure);
                ArraySequence seq = new ArraySequence(iter.members, iter, record.entries.length);
                int index = abb.addObjectToHeap(seq);
                bb.putInt(index);
                return;
            }
            CatIterator iter = new CatIterator(new Entry[0], useStructure);
            ArraySequence seq = new ArraySequence(iter.members, iter, -1);
            int index = abb.addObjectToHeap(seq);
            bb.putInt(index);
        }

        private class CatIterator
        implements StructureDataIterator {
            Entry[] entries;
            int count;
            StructureMembers members;

            CatIterator(Entry[] entries, Structure useStructure) {
                this.entries = entries;
                this.members = useStructure.makeStructureMembers();
                for (Variable v2 : useStructure.getVariables()) {
                    Vinfo vinfo = (Vinfo)v2.getSPobject();
                    StructureMembers.Member m3 = this.members.findMember(v2.getShortName());
                    m3.setDataParam(vinfo.offset);
                }
            }

            @Override
            public boolean hasNext() {
                return this.count < this.entries.length;
            }

            @Override
            public StructureData next() {
                Entry entry = this.entries[this.count++];
                ArrayStructureBB abb = new ArrayStructureBB(this.members, new int[]{1});
                ByteBuffer bb = abb.getByteBuffer();
                bb.position(0);
                entry.loadStructureData(bb);
                return abb.getStructureData(0);
            }

            @Override
            public StructureDataIterator reset() {
                this.count = 0;
                return this;
            }

            @Override
            public int getCurrentRecno() {
                return this.count - 1;
            }
        }
    }

    private static class Station
    implements Comparable<Station> {
        String name;
        Report r;
        int nreports;

        Station(Report r) {
            this.name = r.stationId;
            this.r = r;
            this.nreports = 1;
        }

        @Override
        public int compareTo(Station o) {
            return this.name.compareTo(o.name);
        }
    }

    private static class StructureCode {
        Structure s;
        int code;

        StructureCode(Structure s2, int code) {
            this.s = s2;
            this.code = code;
        }
    }

    private static class Vinfo {
        int offset;

        Vinfo(int offset) {
            this.offset = offset;
        }
    }
}

